/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfString;
import java.util.AbstractList;
import java.util.Iterator;

public class PdfOutline
extends PdfDictionary {
    private PdfIndirectReference reference;
    private PdfNumber count = new PdfNumber(0);
    private PdfOutline parent;
    private PdfDestination destination;

    PdfOutline() {
        super(PdfDictionary.OUTLINES);
        this.put(PdfName.COUNT, this.count);
        this.parent = null;
    }

    PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, PdfString pdfString) {
        this.put(PdfName.COUNT, this.count);
        this.parent = pdfOutline;
        pdfOutline.add();
        this.destination = pdfDestination;
        this.put(PdfName.TITLE, pdfString);
    }

    PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, Paragraph paragraph) {
        this.put(PdfName.COUNT, this.count);
        this.parent = pdfOutline;
        pdfOutline.add();
        this.destination = pdfDestination;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)paragraph.getChunks()).iterator();
        while (iterator.hasNext()) {
            Chunk chunk = (Chunk)iterator.next();
            stringBuffer.append(chunk.content());
        }
        this.put(PdfName.TITLE, new PdfString(stringBuffer.toString()));
    }

    void setIndirectReference(PdfIndirectReference pdfIndirectReference) {
        this.reference = pdfIndirectReference;
    }

    PdfIndirectReference indirectReference() {
        return this.reference;
    }

    PdfOutline parent() {
        return this.parent;
    }

    boolean setDestinationPage(PdfIndirectReference pdfIndirectReference) {
        if (this.destination == null) {
            return false;
        }
        return this.destination.addPage(pdfIndirectReference);
    }

    boolean isParent() {
        return this.count.intValue() > 0;
    }

    void add() {
        if (this.parent != null) {
            this.parent.add();
        }
        this.count.increment();
        this.put(PdfName.COUNT, this.count);
    }

    int level() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.level() + 1;
    }

    final byte[] toPdf() {
        if (this.parent != null) {
            this.put(PdfName.PARENT, this.parent.indirectReference());
        }
        if (this.destination != null && this.destination.hasPage()) {
            this.put(PdfName.DEST, this.destination);
        }
        if (!this.isParent()) {
            this.remove(PdfName.COUNT);
        }
        return super.toPdf();
    }
}

