/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class PdfIndirectObject {
    protected int number;
    protected int generation = 0;
    protected PdfObject object;

    PdfIndirectObject(int n, PdfObject pdfObject) {
        this.number = n;
        this.object = pdfObject;
    }

    PdfIndirectObject(int n, int n2, PdfObject pdfObject) {
        this.number = n;
        this.generation = n2;
        this.object = pdfObject;
    }

    public final int length() {
        return this.toPdf().length;
    }

    final PdfObject getObject() {
        return this.object;
    }

    final PdfIndirectReference getIndirectReference() {
        return new PdfIndirectReference(this.object.type(), this.number, this.generation);
    }

    final byte[] toPdf() {
        ByteArrayOutputStream byteArrayOutputStream;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(String.valueOf(this.number).getBytes());
            byteArrayOutputStream.write(" ".getBytes());
            byteArrayOutputStream.write(String.valueOf(this.generation).getBytes());
            byteArrayOutputStream.write(" obj\n".getBytes());
            byteArrayOutputStream.write(this.object.toPdf());
            byteArrayOutputStream.write("\nendobj\n".getBytes());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }
}

