/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Graphic;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.Watermark;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfCell;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfContent;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfFontDictionary;
import com.lowagie.text.pdf.PdfImage;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLine;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfProcSet;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfResources;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTable;
import com.lowagie.text.pdf.PdfText;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.PdfXObjectDictionary;
import java.awt.Color;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class PdfDocument
extends Document
implements DocListener {
    private PdfWriter writer;
    private PdfInfo info = new PdfInfo();
    private PdfLine line = null;
    private int indentLeft = 0;
    private int indentRight = 0;
    private int listIndentLeft = 0;
    private int alignment = 0;
    private PdfText text;
    private PdfContent graphics;
    private ArrayList lines = new ArrayList();
    private int leading = 0;
    private int currentHeight = 0;
    private int indentTop = 0;
    private int indentBottom = 0;
    private boolean pageEmpty = true;
    protected Rectangle thisPageSize = null;
    protected PdfFontDictionary fontDictionary;
    protected PdfXObjectDictionary xObjectDictionary;
    private HashMap images = new HashMap();
    private Image imageWait = null;
    private int imageEnd = -1;
    private int imageIndentLeft = 0;
    private int imageIndentRight = 0;
    private PdfArray annotations;
    private ArrayList outlines;
    private PdfOutline currentOutline;

    public PdfDocument() throws DocumentException {
        this.addProducer();
        this.addCreationDate();
    }

    public final void addWriter(PdfWriter pdfWriter) throws DocumentException {
        if (this.writer == null) {
            this.writer = pdfWriter;
            pdfWriter.setDocument(this);
            return;
        }
        throw new DocumentException("You can only add a writer to a PdfDocument once.");
    }

    public boolean setPageSize(Rectangle rectangle) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.pageSize = rectangle;
        return true;
    }

    public void setHeader(HeaderFooter headerFooter) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setHeader(headerFooter);
    }

    public void resetHeader() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetHeader();
    }

    public void setFooter(HeaderFooter headerFooter) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setFooter(headerFooter);
    }

    public void resetFooter() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetFooter();
    }

    public void resetPageCount() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetPageCount();
    }

    public void setPageCount(int n) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setPageCount(n);
    }

    public boolean add(Watermark watermark) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.watermark = watermark;
        return true;
    }

    public void removeWatermark() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        this.watermark = null;
    }

    public boolean setMargins(int n, int n2, int n3, int n4) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.marginLeft = n;
        this.marginRight = n2;
        this.marginTop = n3;
        this.marginBottom = n4;
        return true;
    }

    public boolean newPage() throws DocumentException {
        if (this.writer.getDirectContent().size() == 0 && (this.pageEmpty || this.writer != null && this.writer.isPaused())) {
            return false;
        }
        super.newPage();
        this.flushLines();
        PdfResources pdfResources = new PdfResources();
        int n = 1;
        if (this.fontDictionary.containsFont()) {
            pdfResources.add(this.fontDictionary);
            n |= 2;
        }
        if (this.xObjectDictionary.containsXObject()) {
            pdfResources.add(this.xObjectDictionary);
            n |= 8;
        }
        pdfResources.add(new PdfProcSet(n));
        PdfPage pdfPage = new PdfPage(new PdfRectangle(this.thisPageSize), pdfResources);
        if (this.annotations.size() > 0) {
            pdfPage.put(PdfName.ANNOTS, this.annotations);
        }
        if (!this.open || this.close) {
            throw new PdfException("The document isn't open.");
        }
        PdfIndirectReference pdfIndirectReference = this.writer.add(pdfPage, new PdfContents(this.graphics, this.text, this.writer.getDirectContent().toPdf()));
        Iterator iterator = ((AbstractList)this.outlines).iterator();
        while (iterator.hasNext()) {
            PdfOutline pdfOutline = (PdfOutline)iterator.next();
            pdfOutline.setDestinationPage(pdfIndirectReference);
        }
        this.initPage();
        return true;
    }

    public void open() {
        if (!this.open) {
            super.open();
            this.writer.open();
            this.outlines = new ArrayList();
            PdfOutline pdfOutline = new PdfOutline();
            this.outlines.add(pdfOutline);
            this.currentOutline = pdfOutline;
        }
        try {
            this.initPage();
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }

    public void close() {
        if (this.close) {
            return;
        }
        try {
            this.newPage();
            this.newPage();
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
        super.close();
        if (this.outlines.size() > 1) {
            Object object;
            int n = this.writer.size();
            int n2 = 0;
            Iterator iterator = ((AbstractList)this.outlines).iterator();
            while (iterator.hasNext()) {
                PdfOutline pdfOutline = (PdfOutline)iterator.next();
                if (pdfOutline.level() > n2) {
                    n2 = pdfOutline.level();
                }
                object = new PdfIndirectReference(6, n);
                pdfOutline.setIndirectReference((PdfIndirectReference)object);
                ++n;
            }
            int n3 = 0;
            while (n3 <= n2) {
                object = null;
                Iterator iterator2 = ((AbstractList)this.outlines).iterator();
                while (iterator2.hasNext()) {
                    PdfOutline pdfOutline = (PdfOutline)iterator2.next();
                    if (pdfOutline.level() == n3) {
                        if (object == null) {
                            object = pdfOutline;
                            continue;
                        }
                        if (pdfOutline.parent().indirectReference().getNumber() == ((PdfOutline)object).parent().indirectReference().getNumber()) {
                            ((PdfDictionary)object).put(PdfName.NEXT, pdfOutline.indirectReference());
                            pdfOutline.put(PdfName.PREV, ((PdfOutline)object).indirectReference());
                        }
                        object = pdfOutline;
                        continue;
                    }
                    if (pdfOutline.level() != n3 + 1) continue;
                    if (pdfOutline.parent().get(PdfName.FIRST) == null) {
                        pdfOutline.parent().put(PdfName.FIRST, pdfOutline.indirectReference());
                    }
                    pdfOutline.parent().put(PdfName.LAST, pdfOutline.indirectReference());
                }
                ++n3;
            }
            try {
                object = ((AbstractList)this.outlines).iterator();
                while (object.hasNext()) {
                    this.writer.add((PdfOutline)object.next());
                }
            }
            catch (PdfException pdfException) {
                System.err.println(pdfException.getMessage());
            }
        }
        this.writer.close();
    }

    private void add(PdfFont pdfFont) throws PdfException {
        if (!this.open || this.close) {
            throw new PdfException("The document isn't open.");
        }
        this.fontDictionary.put(pdfFont.getName(), this.writer.add(pdfFont));
    }

    public void addFont(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        this.fontDictionary.put(pdfName, pdfIndirectReference);
    }

    public boolean add(Element element) throws DocumentException {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        try {
            switch (element.type()) {
                case 0: {
                    return false;
                }
                case 1: {
                    this.info.addTitle(((Meta)element).content());
                    break;
                }
                case 2: {
                    this.info.addSubject(((Meta)element).content());
                    break;
                }
                case 3: {
                    this.info.addKeywords(((Meta)element).content());
                    break;
                }
                case 4: {
                    this.info.addAuthor(((Meta)element).content());
                    break;
                }
                case 5: {
                    this.info.addProducer();
                    break;
                }
                case 6: {
                    this.info.addCreationDate();
                    break;
                }
                case 10: {
                    PdfChunk pdfChunk;
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    PdfChunk pdfChunk2 = new PdfChunk((Chunk)element);
                    int n = this.indentRight() - this.line.widthLeft();
                    float f = (float)(this.indentTop() - this.currentHeight) - this.line.height() - (float)(pdfChunk2.font().size() / 3);
                    while ((pdfChunk = this.line.add(pdfChunk2)) != null) {
                        this.carriageReturn();
                        if (pdfChunk2.isUnderlined() || pdfChunk2.isStrikethru()) {
                            if (pdfChunk2.isStrikethru()) {
                                f = (float)((double)f + (double)pdfChunk2.font().size() / 1.5);
                            }
                            this.graphics.moveTo((float)n, f);
                            this.graphics.lineTo((float)this.indentRight(), f);
                            this.graphics.stroke();
                            n = this.indentLeft();
                            f = (float)(this.indentTop() - this.currentHeight) - this.line.height() - (float)(pdfChunk2.font().size() / 3);
                        }
                        pdfChunk2 = pdfChunk;
                    }
                    if (pdfChunk2.isUnderlined() || pdfChunk2.isStrikethru()) {
                        if (pdfChunk2.isStrikethru()) {
                            f = (float)((double)f + (double)pdfChunk2.font().size() / 1.5);
                        }
                        this.graphics.moveTo((float)n, f);
                        this.graphics.lineTo((float)(this.indentRight() - this.line.widthLeft()), f);
                        this.graphics.stroke();
                    }
                    this.pageEmpty = false;
                    break;
                }
                case 17: {
                    Anchor anchor = (Anchor)element;
                    URL uRL = anchor.url();
                    this.leading = anchor.leading();
                    PdfAction pdfAction = null;
                    if (uRL != null) {
                        pdfAction = new PdfAction(uRL);
                    }
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    int n = this.indentRight() - this.line.widthLeft();
                    Iterator iterator = ((AbstractList)anchor.getChunks()).iterator();
                    while (iterator.hasNext()) {
                        int n2;
                        PdfChunk pdfChunk;
                        PdfChunk pdfChunk3 = new PdfChunk((Chunk)iterator.next());
                        int n3 = this.indentRight() - this.line.widthLeft();
                        float f = (float)(this.indentTop() - this.currentHeight) - this.line.height() - (float)(pdfChunk3.font().size() / 3);
                        while ((pdfChunk = this.line.add(pdfChunk3)) != null) {
                            if (pdfAction != null) {
                                n2 = this.indentRight();
                                if (this.alignment == 2 || this.alignment == 1) {
                                    n += this.line.indentLeft();
                                    n2 += this.line.indentLeft();
                                }
                                this.annotations.add(new PdfAnnotation(n, (float)(this.indentTop() - this.currentHeight) - this.line.height() - (float)(pdfChunk3.font().size() / 3), n2, (float)(this.indentTop() - this.currentHeight) - this.line.height() - (float)(pdfChunk3.font().size() / 3) + (float)pdfChunk3.font().size(), pdfAction));
                            }
                            n = this.indentLeft();
                            this.carriageReturn();
                            if (pdfChunk3.isUnderlined() || pdfChunk3.isStrikethru()) {
                                if (pdfChunk3.isStrikethru()) {
                                    f = (float)((double)f + (double)pdfChunk3.font().size() / 1.5);
                                }
                                this.graphics.moveTo((float)n3, f);
                                this.graphics.lineTo((float)this.indentRight(), f);
                                this.graphics.stroke();
                                n3 = this.indentLeft();
                                f = (float)(this.indentTop() - this.currentHeight) - this.line.height() - (float)(pdfChunk3.font().size() / 3);
                            }
                            pdfChunk3 = pdfChunk;
                        }
                        if (pdfChunk3.isUnderlined() || pdfChunk3.isStrikethru()) {
                            if (pdfChunk3.isStrikethru()) {
                                f = (float)((double)f + (double)pdfChunk3.font().size() / 1.5);
                            }
                            this.graphics.moveTo((float)n3, f);
                            this.graphics.lineTo((float)(this.indentRight() - this.line.widthLeft()), f);
                            this.graphics.stroke();
                        }
                        if (pdfAction == null) continue;
                        n2 = this.indentRight();
                        if (this.alignment == 2 || this.alignment == 1) {
                            n += this.line.indentLeft();
                            n2 += this.line.indentLeft();
                        }
                        this.annotations.add(new PdfAnnotation(n, (float)(this.indentTop() - this.currentHeight) - this.line.height() - (float)(pdfChunk3.font().size() / 3), n2 - this.line.widthLeft(), (float)(this.indentTop() - this.currentHeight) - this.line.height() - (float)(pdfChunk3.font().size() / 3) + (float)pdfChunk3.font().size(), pdfAction));
                    }
                    this.pageEmpty = false;
                    break;
                }
                case 29: {
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    Annotation annotation = (Annotation)element;
                    this.annotations.add(new PdfAnnotation(this.indentRight() - this.line.widthLeft(), this.indentTop() - this.currentHeight, this.indentRight() - this.line.widthLeft() + 20, this.indentTop() - this.currentHeight - 20, new PdfString(annotation.title()), new PdfString(annotation.content())));
                    this.pageEmpty = false;
                    break;
                }
                case 11: {
                    this.leading = ((Phrase)element).leading();
                    element.process(this);
                    break;
                }
                case 12: {
                    Paragraph paragraph = (Paragraph)element;
                    this.alignment = paragraph.alignment();
                    this.indentLeft += paragraph.indentationLeft();
                    this.indentRight += paragraph.indentationRight();
                    this.leading = paragraph.leading();
                    this.carriageReturn();
                    if ((float)this.currentHeight + this.line.height() + (float)this.leading > (float)(this.indentTop() - this.indentBottom())) {
                        this.newPage();
                    }
                    element.process(this);
                    if (this.line.hasToBeJustified()) {
                        this.line.resetAlignment();
                    }
                    this.carriageReturn();
                    this.alignment = 0;
                    this.indentLeft -= paragraph.indentationLeft();
                    this.indentRight -= paragraph.indentationRight();
                    break;
                }
                case 13: 
                case 16: {
                    Section section = (Section)element;
                    PdfDestination pdfDestination = new PdfDestination(2, this.indentTop() - this.currentHeight);
                    while (this.currentOutline.level() >= section.depth()) {
                        this.currentOutline = this.currentOutline.parent();
                    }
                    PdfOutline pdfOutline = new PdfOutline(this.currentOutline, pdfDestination, section.title());
                    this.outlines.add(pdfOutline);
                    this.currentOutline = pdfOutline;
                    this.carriageReturn();
                    this.indentLeft += section.indentationLeft();
                    this.indentRight += section.indentationRight();
                    if (section.title() != null) {
                        this.add(section.title());
                    }
                    this.indentLeft += section.indentation();
                    element.process(this);
                    this.indentLeft -= section.indentationLeft() + section.indentation();
                    this.indentRight -= section.indentationRight();
                    if (section.isChapter()) {
                        this.newPage();
                        break;
                    }
                    this.newLine();
                    break;
                }
                case 14: {
                    List list = (List)element;
                    this.listIndentLeft += list.indentationLeft();
                    this.indentRight += list.indentationRight();
                    element.process(this);
                    this.listIndentLeft -= list.indentationLeft();
                    this.indentRight -= list.indentationRight();
                    break;
                }
                case 15: {
                    ListItem listItem = (ListItem)element;
                    this.alignment = listItem.alignment();
                    this.listIndentLeft += listItem.indentationLeft();
                    this.indentRight += listItem.indentationRight();
                    this.leading = listItem.leading();
                    this.carriageReturn();
                    this.line.setListItem(listItem);
                    element.process(this);
                    if (this.line.hasToBeJustified()) {
                        this.line.resetAlignment();
                    }
                    this.carriageReturn();
                    this.listIndentLeft -= listItem.indentationLeft();
                    this.indentRight -= listItem.indentationRight();
                    break;
                }
                case 30: {
                    Rectangle rectangle = (Rectangle)element;
                    this.graphics.rectangle(rectangle);
                    this.pageEmpty = false;
                    break;
                }
                case 22: {
                    this.newLine();
                    this.flushLines();
                    boolean bl = false;
                    int n = this.indentTop();
                    int n4 = this.currentHeight;
                    PdfTable pdfTable = new PdfTable((Table)element, this.indentLeft(), this.indentRight(), this.currentHeight > 0 ? n - this.currentHeight : n);
                    ArrayList arrayList = pdfTable.getCells();
                    ArrayList arrayList2 = null;
                    while (!arrayList.isEmpty()) {
                        int n5;
                        int n6;
                        int n7;
                        float f;
                        int n8;
                        PdfCell pdfCell;
                        bl = false;
                        if (pdfTable.bottom() < this.indentBottom()) {
                            bl = true;
                        }
                        if (pdfTable.hasHeader()) {
                            this.graphics.rectangle(pdfTable.rectangle(this.top(), this.indentBottom()));
                        } else {
                            this.graphics.rectangle(pdfTable.rectangle(this.indentTop(), this.indentBottom()));
                        }
                        Iterator iterator = ((AbstractList)arrayList).iterator();
                        while (iterator.hasNext()) {
                            pdfCell = (PdfCell)iterator.next();
                            this.lines = pdfCell.getLines(n, this.indentBottom());
                            if (this.lines != null && this.lines.size() > 0) {
                                if (n == this.indentTop()) {
                                    this.graphics.rectangle(pdfCell.rectangle(n - this.leading / 2, this.indentBottom()));
                                } else {
                                    this.graphics.rectangle(pdfCell.rectangle(n, this.indentBottom()));
                                }
                                n8 = pdfCell.top(n - n4);
                                this.text.move(0, n8);
                                f = this.flushLines() - (float)n8;
                                this.text.move(0.0f, f);
                                if ((float)n4 + f > (float)this.currentHeight) {
                                    this.currentHeight = n4 + (int)f;
                                }
                            }
                            if (!pdfCell.mayBeRemoved()) continue;
                            iterator.remove();
                        }
                        if (!bl || arrayList.isEmpty()) continue;
                        n8 = this.indentBottom() + this.leading;
                        this.pageEmpty = false;
                        this.newPage();
                        this.flushLines();
                        arrayList2 = pdfTable.getHeaderCells();
                        int n9 = arrayList2.size();
                        if (n9 > 0) {
                            pdfCell = (PdfCell)arrayList2.get(0);
                            n7 = pdfCell.top(-pdfTable.cellpadding());
                            int n10 = 0;
                            while (n10 < n9) {
                                pdfCell = (PdfCell)arrayList2.get(n10);
                                n6 = this.indentTop() + pdfCell.top(-pdfTable.cellpadding()) - n7;
                                pdfCell.setTop(n6);
                                n5 = this.indentTop() + pdfCell.bottom() - n7;
                                pdfCell.setBottom(n5);
                                n = pdfCell.bottom();
                                this.graphics.rectangle(pdfCell.rectangle(this.indentTop() - this.leading / 2, this.indentBottom()));
                                this.lines = pdfCell.getLines(this.indentTop(), this.indentBottom());
                                int n11 = pdfCell.top(this.indentTop());
                                this.text.move(0, n11);
                                f = this.flushLines() - (float)n11;
                                this.text.move(0.0f, f);
                                ++n10;
                            }
                            this.currentHeight = this.indentTop() - n - pdfTable.cellpadding();
                            this.text.move(0, n - this.indentTop() + pdfTable.cellpadding() - this.currentHeight);
                        }
                        n4 = this.currentHeight;
                        pdfTable.setTop(this.indentTop());
                        pdfTable.setBottom(n - n8 + pdfTable.bottom(pdfTable.cellpadding()));
                        n9 = arrayList.size();
                        n7 = 0;
                        while (n7 < n9) {
                            pdfCell = (PdfCell)arrayList.get(n7);
                            n6 = n - n8 + pdfCell.top(-pdfTable.cellpadding());
                            n5 = n - n8 + pdfCell.bottom();
                            pdfCell.setTop(n6);
                            pdfCell.setBottom(n5);
                            ++n7;
                        }
                    }
                    this.text.move(0, n4 - this.currentHeight);
                    this.lines.add(this.line);
                    this.currentHeight = (int)((float)this.currentHeight + (this.line.height() - (float)n + (float)this.indentTop()));
                    this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
                    this.pageEmpty = false;
                    break;
                }
                case 31: 
                case 32: 
                case 33: 
                case 34: {
                    this.carriageReturn();
                    this.add((Image)element);
                    this.pageEmpty = false;
                    break;
                }
                case 39: {
                    this.graphics.add((Graphic)element);
                    this.pageEmpty = false;
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            throw new DocumentException(exception.getMessage());
        }
    }

    private void add(Image image) throws PdfException, DocumentException {
        PdfName pdfName;
        if (this.images.containsKey(image)) {
            pdfName = (PdfName)this.images.get(image);
        } else {
            PdfImage pdfImage = new PdfImage(image, "img" + this.images.size());
            this.writer.add(pdfImage);
            pdfName = pdfImage.name();
            this.images.put(image, pdfName);
        }
        if (image.hasAbsolutePosition()) {
            this.graphics.doImage(pdfName, image.matrix(), image.absoluteX(), image.absoluteY());
            this.xObjectDictionary.put(pdfName, this.writer.getImageReference(pdfName));
            return;
        }
        if (this.currentHeight != 0 && this.indentTop() - this.currentHeight - image.scaledHeight() < this.indentBottom()) {
            if (this.imageWait == null) {
                this.imageWait = image;
                return;
            }
            this.newPage();
            if (this.currentHeight != 0 && this.indentTop() - this.currentHeight - image.scaledHeight() < this.indentBottom()) {
                this.imageWait = image;
                return;
            }
        }
        this.xObjectDictionary.put(pdfName, this.writer.getImageReference(pdfName));
        boolean bl = (image.alignment() & 4) == 4 && (image.alignment() & 3) != 3;
        boolean bl2 = (image.alignment() & 8) == 8;
        int n = this.leading / 2;
        if (bl) {
            n += this.leading;
        }
        int n2 = this.indentTop() - this.currentHeight - image.scaledHeight() - n;
        switch (image.alignment() & 3) {
            case 1: {
                this.graphics.doImage(pdfName, image.matrix(), this.indentRight() - image.scaledWidth(), n2);
                break;
            }
            case 3: {
                int n3 = this.indentRight() - this.indentLeft() - image.scaledWidth();
                this.graphics.doImage(pdfName, image.matrix(), this.indentLeft() + n3 / 2, n2);
                break;
            }
            default: {
                this.graphics.doImage(pdfName, image.matrix(), this.indentLeft(), n2);
            }
        }
        if (bl) {
            if (this.imageEnd < 0 || this.imageEnd < this.currentHeight + image.scaledHeight() + n) {
                this.imageEnd = this.currentHeight + image.scaledHeight() + n;
            }
            if ((image.alignment() & 1) == 1) {
                this.imageIndentRight += image.scaledWidth();
            } else {
                this.imageIndentLeft += image.scaledWidth();
            }
        }
        if (!bl && !bl2) {
            this.currentHeight += image.scaledHeight() + n;
            this.flushLines();
            this.text.move(0, -(image.scaledHeight() + n));
            this.newLine();
        }
    }

    private void initPage() throws DocumentException {
        this.annotations = new PdfArray();
        this.fontDictionary = new PdfFontDictionary();
        this.xObjectDictionary = new PdfXObjectDictionary();
        this.writer.resetContent();
        ++this.pageN;
        int n = this.leading;
        int n2 = this.alignment;
        this.imageEnd = -1;
        this.imageIndentRight = 0;
        this.imageIndentLeft = 0;
        this.graphics = new PdfContent();
        this.text = new PdfText();
        this.leading = 16;
        this.indentBottom = 0;
        this.indentTop = 0;
        this.currentHeight = 0;
        this.thisPageSize = this.pageSize;
        if (this.pageSize.backgroundColor() != null || this.pageSize.hasBorders() || this.pageSize.borderColor() != null || this.pageSize.grayFill() > 0.0) {
            this.add(this.pageSize);
        }
        if (this.watermark != null) {
            PdfName pdfName;
            if (this.images.containsKey(this.watermark)) {
                pdfName = (PdfName)this.images.get(this.watermark);
            } else {
                PdfImage pdfImage = new PdfImage(this.watermark, "img" + this.images.size());
                this.writer.add(pdfImage);
                pdfName = pdfImage.name();
                this.images.put(this.watermark, pdfName);
            }
            this.xObjectDictionary.put(pdfName, this.writer.getImageReference(pdfName));
            this.graphics.doImage(pdfName, this.watermark.matrix(), this.watermark.offsetX(), this.watermark.offsetY());
        }
        if (this.footer != null) {
            this.footer.setPageNumber(this.pageN);
            this.leading = this.footer.paragraph().leading();
            this.add(this.footer.paragraph());
            this.indentBottom = this.currentHeight;
            this.text.move(this.left(), this.indentBottom());
            this.flushLines();
            this.text.move(-this.left(), -this.bottom());
            this.footer.setTop(this.bottom(this.currentHeight));
            this.footer.setBottom(this.bottom() - (int)(0.75 * (double)this.leading));
            this.footer.setLeft(this.left());
            this.footer.setRight(this.right());
            this.graphics.rectangle(this.footer);
            this.indentBottom = this.currentHeight + this.leading * 3 / 2;
            this.currentHeight = 0;
        }
        this.text.move(this.left(), this.top());
        if (this.header != null) {
            this.header.setPageNumber(this.pageN);
            this.leading = this.header.paragraph().leading();
            this.text.move(0, this.leading);
            this.add(this.header.paragraph());
            this.newLine();
            this.indentTop = this.currentHeight - this.leading;
            this.header.setTop(this.top() + this.leading);
            this.header.setBottom(this.indentTop() + this.leading * 2 / 3);
            this.header.setLeft(this.left());
            this.header.setRight(this.right());
            this.graphics.rectangle(this.header);
            this.flushLines();
            this.currentHeight = 0;
        }
        this.pageEmpty = true;
        try {
            if (this.imageWait != null) {
                this.add(this.imageWait);
                this.imageWait = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.leading = n;
        this.alignment = n2;
        this.carriageReturn();
    }

    private void carriageReturn() throws DocumentException {
        if (this.lines == null) {
            this.lines = new ArrayList();
        }
        if (this.line != null) {
            if ((float)this.currentHeight + this.line.height() < (float)(this.indentTop() - this.indentBottom())) {
                if (this.line.size() > 0) {
                    this.currentHeight = (int)((float)this.currentHeight + this.line.height());
                    this.lines.add(this.line);
                }
            } else {
                this.newPage();
            }
        }
        if (this.imageEnd > -1 && this.currentHeight > this.imageEnd) {
            this.imageEnd = -1;
            this.imageIndentRight = 0;
            this.imageIndentLeft = 0;
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    private void newLine() throws DocumentException {
        this.carriageReturn();
        if (this.lines != null && this.lines.size() > 0) {
            this.lines.add(this.line);
            this.currentHeight = (int)((float)this.currentHeight + this.line.height());
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    private float flushLines() throws DocumentException {
        if (this.lines == null) {
            return 0.0f;
        }
        if (this.line != null && this.line.size() > 0) {
            this.lines.add(this.line);
            this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
        }
        if (this.lines.size() == 0) {
            return 0.0f;
        }
        PdfFont pdfFont = null;
        boolean bl = false;
        float f = 0.0f;
        Iterator iterator = ((AbstractList)this.lines).iterator();
        while (iterator.hasNext()) {
            Object object;
            PdfChunk pdfChunk;
            PdfLine pdfLine = (PdfLine)iterator.next();
            this.text.move((float)(pdfLine.indentLeft() - this.indentLeft() + this.listIndentLeft), -pdfLine.height());
            if (pdfLine.listSymbol() != null) {
                pdfChunk = pdfLine.listSymbol();
                this.text.move(-pdfLine.listIndent(), 0);
                if (pdfChunk.font().compareTo(pdfFont) != 0) {
                    pdfFont = pdfChunk.font();
                    this.add(pdfFont);
                    this.text.setFont(pdfFont);
                }
                if (pdfChunk.color() != null) {
                    object = pdfChunk.color();
                    this.text.setRGBColorFill(((Color)object).getRed(), ((Color)object).getGreen(), ((Color)object).getBlue());
                    this.text.show(pdfChunk);
                    this.text.resetRGBColorFill();
                } else {
                    this.text.show(pdfChunk);
                }
                this.text.move(pdfLine.listIndent(), 0);
            }
            int n = pdfLine.numberOfSpaces();
            if (pdfLine.hasToBeJustified() && n != 0) {
                this.text.setWordSpacing((double)(100 * pdfLine.widthLeft() / n) / 100.0);
            }
            object = pdfLine.iterator();
            while (object.hasNext()) {
                pdfChunk = (PdfChunk)object.next();
                if (pdfChunk.font().compareTo(pdfFont) != 0) {
                    pdfFont = pdfChunk.font();
                    this.add(pdfFont);
                    this.text.setFont(pdfFont);
                }
                if (pdfChunk.color() != null) {
                    Color color = pdfChunk.color();
                    this.text.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
                    this.text.show(pdfChunk);
                    this.text.resetRGBColorFill();
                    continue;
                }
                this.text.show(pdfChunk);
            }
            this.text.newLine();
            f += pdfLine.height();
            if (this.indentLeft() - this.listIndentLeft != pdfLine.indentLeft()) {
                this.text.move(this.indentLeft() - pdfLine.indentLeft() - this.listIndentLeft, 0);
            }
            if (!pdfLine.hasToBeJustified() || n == 0) continue;
            this.text.setWordSpacing(0);
        }
        this.lines = new ArrayList();
        return f;
    }

    PdfInfo getInfo() {
        return this.info;
    }

    PdfCatalog getCatalog(PdfIndirectReference pdfIndirectReference) {
        if (this.outlines.size() > 1) {
            PdfOutline pdfOutline = (PdfOutline)this.outlines.get(0);
            return new PdfCatalog(pdfIndirectReference, pdfOutline.indirectReference());
        }
        return new PdfCatalog(pdfIndirectReference);
    }

    int bottom(Table table) {
        PdfTable pdfTable = new PdfTable(table, this.indentLeft(), this.indentRight(), this.currentHeight > 0 ? this.indentTop() - this.currentHeight : this.indentTop());
        return pdfTable.bottom();
    }

    private int indentLeft() {
        return this.left(this.indentLeft + this.listIndentLeft + this.imageIndentLeft);
    }

    private int indentRight() {
        return this.right(this.indentRight + this.imageIndentRight);
    }

    private int indentTop() {
        return this.top(this.indentTop);
    }

    int indentBottom() {
        return this.bottom(this.indentBottom);
    }

    class PdfCatalog
    extends PdfDictionary {
        PdfCatalog(PdfIndirectReference pdfIndirectReference) {
            super(PdfDictionary.CATALOG);
            this.put(PdfName.PAGES, pdfIndirectReference);
        }

        PdfCatalog(PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2) {
            super(PdfDictionary.CATALOG);
            this.put(PdfName.PAGES, pdfIndirectReference);
            this.put(PdfName.PAGEMODE, PdfName.USEOUTLINES);
            this.put(PdfName.OUTLINES, pdfIndirectReference2);
        }
    }

    public class PdfInfo
    extends PdfDictionary {
        PdfInfo() {
            this.addProducer();
            this.addCreationDate();
        }

        PdfInfo(String string, String string2, String string3) {
            this();
            this.addTitle(string2);
            this.addSubject(string3);
            this.addAuthor(string);
        }

        void addTitle(String string) {
            this.put(PdfName.TITLE, new PdfString(string));
        }

        void addSubject(String string) {
            this.put(PdfName.SUBJECT, new PdfString(string));
        }

        void addKeywords(String string) {
            this.put(PdfName.KEYWORDS, new PdfString(string));
        }

        void addAuthor(String string) {
            this.put(PdfName.AUTHOR, new PdfString(string));
        }

        void addProducer() {
            this.put(PdfName.PRODUCER, new PdfString("iText by lowagie.com"));
        }

        void addCreationDate() {
            this.put(PdfName.CREATIONDATE, new PdfDate());
        }
    }
}

