/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.UnsupportedEncodingException;

public class PdfContentByte {
    protected ByteBuffer content = new ByteBuffer();
    protected PdfWriter writer;
    protected BaseFont lastFontUsed;

    public PdfContentByte(PdfWriter pdfWriter) {
        this.writer = pdfWriter;
    }

    public String toString() {
        return this.content.toString();
    }

    public byte[] toPdf() {
        return this.content.toByteArray();
    }

    public final void add(PdfContentByte pdfContentByte) {
        this.content.append(pdfContentByte.toPdf());
    }

    public final void setFlatness(int n) {
        if (n > -1 && n < 101) {
            this.content.append(n).append(" i\n");
        }
    }

    public final void setLineCap(int n) {
        if (n == 1 || n == 2 || n == 3) {
            this.content.append(n).append(" J\n");
        }
    }

    public final void setLineDash(int n) {
        PdfArray pdfArray = new PdfArray();
        this.content.append(pdfArray.toPdf()).append(" ").append(n).append(" d\n");
    }

    public final void setLineDash(int n, int n2) {
        PdfArray pdfArray = new PdfArray();
        pdfArray.add(new PdfNumber(n));
        this.content.append(pdfArray.toPdf()).append(" ").append(n2).append(" d\n");
    }

    public final void setLineDash(int n, int n2, int n3) {
        PdfArray pdfArray = new PdfArray();
        pdfArray.add(new PdfNumber(n));
        pdfArray.add(new PdfNumber(n2));
        this.content.append(pdfArray.toPdf()).append(" ").append(n3).append(" d\n");
    }

    public final void setLineJoin(int n) {
        if (n == 1 || n == 2 || n == 3) {
            this.content.append(n).append(" j\n");
        }
    }

    public final void setLineWidth(double d) {
        this.content.append(d).append(" w\n");
    }

    public final void setMiterLimit(double d) {
        if (d > 1.0) {
            this.content.append(d).append(" M\n");
        }
    }

    public final void setGrayFill(double d) {
        this.content.append(d);
        this.content.append(" g\n");
    }

    public final void resetGrayFill() {
        this.content.append("0 g\n");
    }

    public final void setGrayStroke(double d) {
        this.content.append(d);
        this.content.append(" G\n");
    }

    public final void resetGrayStroke() {
        this.content.append("0 G\n");
    }

    public final void setRGBColorFill(int n, int n2, int n3) {
        this.content.append((double)(n & 0xFF) / 255.0);
        this.content.append(32);
        this.content.append((double)(n2 & 0xFF) / 255.0);
        this.content.append(32);
        this.content.append((double)(n3 & 0xFF) / 255.0);
        this.content.append(" rg\n");
    }

    public final void resetRGBColorFill() {
        this.content.append("0 0 0 rg\n");
    }

    public final void setRGBColorStroke(int n, int n2, int n3) {
        this.content.append((double)(n & 0xFF) / 255.0);
        this.content.append(32);
        this.content.append((double)(n2 & 0xFF) / 255.0);
        this.content.append(32);
        this.content.append((double)(n3 & 0xFF) / 255.0);
        this.content.append(" RG\n");
    }

    public final void resetRGBColorStroke() {
        this.content.append("0 0 0 RG\n");
    }

    public final void setCMYKColorFill(int n, int n2, int n3, int n4) {
        this.content.append((double)(n & 0xFF) / 255.0);
        this.content.append(32);
        this.content.append((double)(n2 & 0xFF) / 255.0);
        this.content.append(32);
        this.content.append((double)(n3 & 0xFF) / 255.0);
        this.content.append(32);
        this.content.append((double)(n4 & 0xFF) / 255.0);
        this.content.append(" k\n");
    }

    public final void resetCMYKColorFill() {
        this.content.append("0 0 0 1 k\n");
    }

    public final void setCMYKColorStroke(int n, int n2, int n3, int n4) {
        this.content.append((double)(n & 0xFF) / 255.0);
        this.content.append(32);
        this.content.append((double)(n2 & 0xFF) / 255.0);
        this.content.append(32);
        this.content.append((double)(n3 & 0xFF) / 255.0);
        this.content.append(32);
        this.content.append((double)(n4 & 0xFF) / 255.0);
        this.content.append(" K\n");
    }

    public final void resetCMYKColorStroke() {
        this.content.append("0 0 0 1 K\n");
    }

    public final void moveTo(int n, int n2) {
        this.content.append(n).append(" ").append(n2).append(" m\n");
    }

    public final void lineTo(int n, int n2) {
        this.content.append(n).append(" ").append(n2).append(" l\n");
    }

    public final void curveTo(int n, int n2, int n3, int n4, int n5, int n6) {
        this.content.append(n).append(32).append(n2).append(32).append(n3).append(32).append(n4).append(32).append(n5).append(32).append(n6).append(" c\n");
    }

    public final void curveTo(int n, int n2, int n3, int n4) {
        this.content.append(n).append(32).append(n2).append(32).append(n3).append(32).append(n4).append(" v\n");
    }

    public final void curveFromTo(int n, int n2, int n3, int n4) {
        this.content.append(n).append(32).append(n2).append(32).append(n3).append(32).append(n4).append(" y\n");
    }

    public final void rectangle(int n, int n2, int n3, int n4) {
        this.content.append(n).append(32).append(n2).append(32).append(n3).append(32).append(n4).append(" re\n");
    }

    public final void rectangle(Rectangle rectangle) {
        Color color;
        int n = rectangle.left();
        int n2 = rectangle.top();
        int n3 = rectangle.right();
        int n4 = rectangle.bottom();
        Color color2 = rectangle.backgroundColor();
        if (color2 != null) {
            this.setRGBColorStroke(color2.getRed(), color2.getGreen(), color2.getBlue());
            this.setRGBColorFill(color2.getRed(), color2.getGreen(), color2.getBlue());
            this.rectangle(n, n2, n3 - n, n4 - n2);
            this.closePathFillStroke();
            this.resetRGBColorFill();
            this.resetRGBColorStroke();
        } else if (rectangle.grayFill() > 0.0) {
            this.setGrayStroke(rectangle.grayFill());
            this.setGrayFill(rectangle.grayFill());
            this.rectangle(n, n2, n3 - n, n4 - n2);
            this.closePathFillStroke();
            this.resetGrayFill();
            this.resetGrayStroke();
        }
        if (!rectangle.hasBorders()) {
            return;
        }
        if (rectangle.borderWidth() != -1.0) {
            this.setLineWidth(rectangle.borderWidth());
        }
        if ((color = rectangle.borderColor()) != null) {
            this.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
        }
        if (rectangle.hasBorder(15)) {
            this.rectangle(n, n2, n3 - n, n4 - n2);
        } else {
            if (rectangle.hasBorder(8)) {
                this.moveTo(n3, n2);
                this.lineTo(n3, n4);
            }
            if (rectangle.hasBorder(4)) {
                this.moveTo(n, n2);
                this.lineTo(n, n4);
            }
            if (rectangle.hasBorder(2)) {
                this.moveTo(n, n4);
                this.lineTo(n3, n4);
            }
            if (rectangle.hasBorder(1)) {
                this.moveTo(n, n2);
                this.lineTo(n3, n2);
            }
        }
        this.stroke();
        if (color != null) {
            this.resetRGBColorStroke();
        }
    }

    public final void closePath() {
        this.content.append("h\n");
    }

    public final void newPath() {
        this.content.append("n\n");
    }

    public final void stroke() {
        this.content.append("S\n");
    }

    public final void closePathStroke() {
        this.content.append("s\n");
    }

    public final void fill() {
        this.content.append("f\n");
    }

    public final void eoFill() {
        this.content.append("f*\n");
    }

    public final void fillStroke() {
        this.content.append("B\n");
    }

    public final void closePathFillStroke() {
        this.content.append("b\n");
    }

    public final void eoFillStroke() {
        this.content.append("B*\n");
    }

    public final void closePathEoFillStroke() {
        this.content.append("b*\n");
    }

    final void doImage(PdfName pdfName, double[] dArray, int n, int n2) {
        this.content.append("q ");
        this.content.append(dArray[0]).append(" ");
        this.content.append(dArray[1]).append(" ");
        this.content.append(dArray[2]).append(" ");
        this.content.append(dArray[3]).append(" ");
        this.content.append((double)n - dArray[4]).append(" ");
        this.content.append((double)n2 - dArray[5]).append(" cm ");
        this.content.append(pdfName.toString()).append(" Do Q\n");
    }

    public void reset() {
        this.content.reset();
        this.lastFontUsed = null;
    }

    public void beginText() {
        this.content.append("BT\n");
    }

    public void endText() {
        this.lastFontUsed = null;
        this.content.append("ET\n");
    }

    public void saveState() {
        this.content.append("q\n");
    }

    public void restoreState() {
        this.content.append("Q\n");
    }

    public void setCharacterSpacing(float f) {
        this.content.append(f).append(" Tc\n");
    }

    public void setWordSpacing(float f) {
        this.content.append(f).append(" Tw\n");
    }

    public void setHorizontalScaling(float f) {
        this.content.append(f).append(" Tz\n");
    }

    public void setLeading(float f) {
        this.content.append(f).append(" TL\n");
    }

    public void setFontSize(BaseFont baseFont, float f) {
        this.lastFontUsed = baseFont;
        PdfName pdfName = this.writer.add(baseFont);
        this.content.append(pdfName.toPdf()).append(" ").append(f).append(" Tf\n");
    }

    public void setTextRenderingMode(int n) {
        this.content.append(n).append(" Tr\n");
    }

    public void setTextRise(float f) {
        this.content.append(f).append(" Ts\n");
    }

    private void showText2(String string) throws NullPointerException, UnsupportedEncodingException {
        if (this.lastFontUsed == null) {
            throw new NullPointerException("Font size must be set before writing any text");
        }
        byte[] byArray = this.lastFontUsed.convertToBytes(string);
        this.content.append_i(40);
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            switch (by) {
                case 13: {
                    this.content.append("\\r");
                    break;
                }
                case 10: {
                    this.content.append("\\n");
                    break;
                }
                case 40: 
                case 41: 
                case 92: {
                    this.content.append_i(92).append_i(by);
                    break;
                }
                default: {
                    this.content.append_i(by);
                }
            }
            ++n;
        }
        this.content.append(")");
    }

    public void showText(String string) throws NullPointerException, UnsupportedEncodingException {
        this.showText2(string);
        this.content.append("Tj\n");
    }

    public void newlineShowText(String string) throws NullPointerException, UnsupportedEncodingException {
        this.showText2(string);
        this.content.append("'\n");
    }

    public void newlineShowText(float f, float f2, String string) throws NullPointerException, UnsupportedEncodingException {
        this.content.append(f).append(" ").append(f2);
        this.showText2(string);
        this.content.append("\"\n");
    }

    public void setTextMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.content.append(f).append_i(32).append(f2).append_i(32).append(f3).append_i(32).append(f4).append_i(32).append(f5).append_i(32).append(f6).append(" Tm\n");
    }

    public void moveText(float f, float f2) {
        this.content.append(f).append(" ").append(f2).append(" Td\n");
    }

    public void moveTextWithLeading(float f, float f2) {
        this.content.append(f).append(" ").append(f2).append(" TD\n");
    }

    public void newlineText() {
        this.content.append("T*\n");
    }

    int size() {
        return this.content.size();
    }
}

