/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Element;
import com.lowagie.text.Gif;
import com.lowagie.text.ImgRaw;
import com.lowagie.text.Jpeg;
import com.lowagie.text.Png;
import com.lowagie.text.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class Image
extends Rectangle
implements Element {
    public static final int DEFAULT = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int MIDDLE = 3;
    public static final int TEXTWRAP = 4;
    public static final int UNDERLYING = 8;
    public static final int AX = 0;
    public static final int AY = 1;
    public static final int BX = 2;
    public static final int BY = 3;
    public static final int CX = 4;
    public static final int CY = 5;
    public static final int DX = 6;
    public static final int DY = 7;
    protected int type;
    protected URL url;
    protected byte[] rawData;
    protected int alignment;
    protected String alt;
    protected int absoluteX = Integer.MIN_VALUE;
    protected int absoluteY = Integer.MIN_VALUE;
    protected double plainWidth;
    protected double plainHeight;
    protected double scaledWidth;
    protected double scaledHeight;
    protected double rotation;
    protected int colorspace = -1;
    protected int bpc = 1;

    public Image(URL uRL) {
        super(0, 0);
        this.url = uRL;
        this.alignment = 0;
        this.rotation = 0.0;
    }

    protected Image(Image image) {
        super(image);
        this.type = image.type;
        this.url = image.url;
        this.alignment = image.alignment;
        this.alt = image.alt;
        this.absoluteX = image.absoluteX;
        this.absoluteY = image.absoluteY;
        this.plainWidth = image.plainWidth;
        this.plainHeight = image.plainHeight;
        this.scaledWidth = image.scaledWidth;
        this.scaledHeight = image.scaledHeight;
        this.rotation = image.rotation;
        this.colorspace = image.colorspace;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getInstance(URL uRL) throws BadElementException, MalformedURLException, IOException {
        Png png;
        InputStream inputStream;
        block6: {
            Jpeg jpeg;
            block5: {
                Gif gif;
                block4: {
                    inputStream = null;
                    try {
                        inputStream = uRL.openStream();
                        int n = inputStream.read();
                        int n2 = inputStream.read();
                        inputStream.close();
                        inputStream = null;
                        if (n == 71 && n2 == 73) {
                            gif = new Gif(uRL);
                            Object var6_7 = null;
                            if (inputStream == null) return gif;
                            break block4;
                        }
                        if (n == 255 && n2 == 216) {
                            jpeg = new Jpeg(uRL);
                            break block5;
                        }
                        if (n != Png.PNGID[0]) throw new IOException(uRL.toString() + " is not a recognized imageformat.");
                        if (n2 != Png.PNGID[1]) throw new IOException(uRL.toString() + " is not a recognized imageformat.");
                        png = new Png(uRL);
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                }
                inputStream.close();
                return gif;
            }
            Object var6_8 = null;
            if (inputStream == null) return jpeg;
            inputStream.close();
            return jpeg;
        }
        Object var6_9 = null;
        if (inputStream == null) return png;
        inputStream.close();
        return png;
    }

    public static Image getInstance(String string) throws BadElementException, MalformedURLException, IOException {
        return Image.getInstance(Image.toURL(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getInstance(byte[] byArray) throws BadElementException, MalformedURLException, IOException {
        Png png;
        ByteArrayInputStream byteArrayInputStream;
        block6: {
            Jpeg jpeg;
            block5: {
                Gif gif;
                block4: {
                    byteArrayInputStream = null;
                    try {
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        int n = ((InputStream)byteArrayInputStream).read();
                        int n2 = ((InputStream)byteArrayInputStream).read();
                        ((InputStream)byteArrayInputStream).close();
                        byteArrayInputStream = null;
                        if (n == 71 && n2 == 73) {
                            gif = new Gif(byArray);
                            Object var6_7 = null;
                            if (byteArrayInputStream == null) return gif;
                            break block4;
                        }
                        if (n == 255 && n2 == 216) {
                            jpeg = new Jpeg(byArray);
                            break block5;
                        }
                        if (n != Png.PNGID[0]) throw new IOException("Could not find a recognized imageformat.");
                        if (n2 != Png.PNGID[1]) throw new IOException("Could not find a recognized imageformat.");
                        png = new Png(byArray);
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        if (byteArrayInputStream == null) throw throwable;
                        ((InputStream)byteArrayInputStream).close();
                        throw throwable;
                    }
                }
                ((InputStream)byteArrayInputStream).close();
                return gif;
            }
            Object var6_8 = null;
            if (byteArrayInputStream == null) return jpeg;
            ((InputStream)byteArrayInputStream).close();
            return jpeg;
        }
        Object var6_9 = null;
        if (byteArrayInputStream == null) return png;
        ((InputStream)byteArrayInputStream).close();
        return png;
    }

    public static Image getInstance(int n, int n2, int n3, int n4, byte[] byArray) throws BadElementException, MalformedURLException, IOException {
        return new ImgRaw(n, n2, n3, n4, byArray);
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setAlt(String string) {
        this.alt = string;
    }

    public void setAbsolutePosition(int n, int n2) {
        this.absoluteX = n;
        this.absoluteY = n2;
    }

    public void scaleAbsolute(int n, int n2) {
        this.plainWidth = n;
        this.plainHeight = n2;
        double[] dArray = this.matrix();
        this.scaledWidth = (int)(dArray[6] - dArray[4]);
        this.scaledHeight = (int)(dArray[7] - dArray[5]);
    }

    public void scalePercent(int n) {
        this.scalePercent(n, n);
    }

    public void scalePercent(int n, int n2) {
        this.plainWidth = (double)(this.width() * n) / 100.0;
        this.plainHeight = (double)(this.height() * n2) / 100.0;
        double[] dArray = this.matrix();
        this.scaledWidth = (int)(dArray[6] - dArray[4]);
        this.scaledHeight = (int)(dArray[7] - dArray[5]);
    }

    public void scaleToFit(int n, int n2) {
        int n3;
        int n4 = n * 100 / this.width();
        this.scalePercent(n4 < (n3 = n2 * 100 / this.height()) ? n4 : n3);
    }

    public void setRotation(double d) {
        this.rotation = d % (Math.PI * 2);
        if (this.rotation < 0.0) {
            this.rotation += Math.PI * 2;
        }
        double[] dArray = this.matrix();
        this.scaledWidth = (int)(dArray[6] - dArray[4]);
        this.scaledHeight = (int)(dArray[7] - dArray[5]);
    }

    public int bpc() {
        return this.bpc;
    }

    public byte[] rawData() {
        return this.rawData;
    }

    public boolean hasAbsolutePosition() {
        return this.absoluteX > Integer.MIN_VALUE && this.absoluteY > Integer.MIN_VALUE;
    }

    public int absoluteX() {
        return this.absoluteX;
    }

    public int absoluteY() {
        return this.absoluteY;
    }

    public int type() {
        return this.type;
    }

    public boolean isGif() {
        return this.type == 31;
    }

    public boolean isJpeg() {
        return this.type == 32;
    }

    public boolean isPng() {
        return this.type == 33;
    }

    public boolean isImgRaw() {
        return this.type == 34;
    }

    public URL url() {
        return this.url;
    }

    public int alignment() {
        return this.alignment;
    }

    public String alt() {
        return this.alt;
    }

    public int scaledWidth() {
        return (int)this.scaledWidth;
    }

    public int scaledHeight() {
        return (int)this.scaledHeight;
    }

    public int colorspace() {
        return this.colorspace;
    }

    public double[] matrix() {
        double[] dArray = new double[8];
        double d = Math.cos(this.rotation);
        double d2 = Math.sin(this.rotation);
        dArray[0] = this.plainWidth * d;
        dArray[1] = this.plainWidth * d2;
        dArray[2] = -this.plainHeight * d2;
        dArray[3] = this.plainHeight * d;
        if (this.rotation < 1.5707963267948966) {
            dArray[4] = dArray[2];
            dArray[5] = 0.0;
            dArray[6] = dArray[0];
            dArray[7] = dArray[1] + dArray[3];
        } else if (this.rotation < Math.PI) {
            dArray[4] = dArray[0] + dArray[2];
            dArray[5] = dArray[3];
            dArray[6] = 0.0;
            dArray[7] = dArray[1];
        } else if (this.rotation < 2.0943951023931953) {
            dArray[4] = dArray[0];
            dArray[5] = dArray[1] + dArray[3];
            dArray[6] = dArray[2];
            dArray[7] = 0.0;
        } else if (this.rotation < 1.5707963267948966) {
            dArray[4] = 0.0;
            dArray[5] = dArray[1];
            dArray[6] = dArray[0] + dArray[2];
            dArray[7] = dArray[3];
        }
        return dArray;
    }

    public void skip(InputStream inputStream, int n) throws IOException {
        while (n > 0) {
            n = (int)((long)n - inputStream.skip(n));
        }
    }

    public static URL toURL(String string) throws MalformedURLException {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && file.isDirectory()) {
            string2 = string2 + "/";
        }
        return new URL("file", "", string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<IMG>");
        stringBuffer.append(super.toString());
        stringBuffer.append("</IMG>");
        return stringBuffer.toString();
    }
}

