/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Header;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Meta;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Watermark;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class Document
implements DocListener {
    private ArrayList listeners = new ArrayList();
    protected boolean open;
    protected boolean close;
    protected Rectangle pageSize;
    protected Watermark watermark = null;
    protected int marginLeft = 0;
    protected int marginRight = 0;
    protected int marginTop = 0;
    protected int marginBottom = 0;
    protected int pageN = 0;
    protected HeaderFooter header = null;
    protected HeaderFooter footer = null;

    public Document() {
        this(PageSize.A4);
    }

    public Document(Rectangle rectangle) {
        this(rectangle, 36, 36, 36, 36);
    }

    public Document(Rectangle rectangle, int n, int n2, int n3, int n4) {
        this.pageSize = rectangle;
        this.marginLeft = n;
        this.marginRight = n2;
        this.marginTop = n3;
        this.marginBottom = n4;
    }

    public void finalize() {
        this.close();
    }

    public final void addDocListener(DocListener docListener) {
        this.listeners.add(docListener);
    }

    public final void removeDocListener(DocListener docListener) {
        ((AbstractCollection)this.listeners).remove(docListener);
    }

    public boolean add(Element element) throws DocumentException {
        if (this.close) {
            throw new DocumentException("The document has been closed. You can't add any Elements.");
        }
        int n = element.type();
        if (this.open) {
            if (n != 10 && n != 11 && n != 12 && n != 22 && n != 17 && n != 29 && n != 16 && n != 13 && n != 14 && n != 15 && n != 30 && n != 33 && n != 32 && n != 31 && n != 34 && n != 39) {
                throw new DocumentException("The document is open; you can only add Elements with content.");
            }
        } else if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4 && n != 5 && n != 6) {
            throw new DocumentException("The document is not open yet; you can only add Meta information.");
        }
        boolean bl = false;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            bl |= docListener.add(element);
        }
        return bl;
    }

    public void open() {
        if (!this.close) {
            this.open = true;
        }
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.setPageSize(this.pageSize);
            docListener.setMargins(this.marginLeft, this.marginRight, this.marginTop, this.marginBottom);
            docListener.open();
        }
    }

    public boolean setPageSize(Rectangle rectangle) {
        this.pageSize = rectangle;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.setPageSize(rectangle);
        }
        return true;
    }

    public boolean add(Watermark watermark) {
        this.watermark = watermark;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.add(watermark);
        }
        return true;
    }

    public void removeWatermark() {
        this.watermark = null;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.removeWatermark();
        }
    }

    public boolean setMargins(int n, int n2, int n3, int n4) {
        this.marginLeft = n;
        this.marginRight = n2;
        this.marginTop = n3;
        this.marginBottom = n4;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.setMargins(n, n2, n3, n4);
        }
        return true;
    }

    public boolean newPage() throws DocumentException {
        if (!this.open || this.close) {
            return false;
        }
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.newPage();
        }
        return true;
    }

    public void setHeader(HeaderFooter headerFooter) {
        this.header = headerFooter;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.setHeader(headerFooter);
        }
    }

    public void resetHeader() {
        this.header = null;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.resetHeader();
        }
    }

    public void setFooter(HeaderFooter headerFooter) {
        this.footer = headerFooter;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.setFooter(headerFooter);
        }
    }

    public void resetFooter() {
        this.footer = this.footer;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.resetFooter();
        }
    }

    public void resetPageCount() {
        this.pageN = 0;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.resetPageCount();
        }
    }

    public void setPageCount(int n) {
        this.pageN = n;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.setPageCount(n);
        }
    }

    public int getPageNumber() {
        return this.pageN;
    }

    public void close() {
        if (!this.close) {
            this.open = false;
            this.close = true;
        }
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.close();
        }
    }

    public boolean addHeader(String string, String string2) {
        try {
            return this.add(new Header(string, string2));
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public boolean addTitle(String string) {
        try {
            return this.add(new Meta(1, string));
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public boolean addSubject(String string) {
        try {
            return this.add(new Meta(2, string));
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public boolean addKeywords(String string) {
        try {
            return this.add(new Meta(3, string));
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public boolean addAuthor(String string) {
        try {
            return this.add(new Meta(4, string));
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public boolean addProducer() {
        try {
            return this.add(new Meta(5, "iText by lowagie.com"));
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public boolean addCreationDate() {
        try {
            return this.add(new Meta(6, new Date().toString()));
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int leftMargin() {
        return this.marginLeft;
    }

    public int rightMargin() {
        return this.marginRight;
    }

    public int topMargin() {
        return this.marginTop;
    }

    public int bottomMargin() {
        return this.marginBottom;
    }

    public int left() {
        return this.pageSize.left(this.marginLeft);
    }

    public int right() {
        return this.pageSize.right(this.marginRight);
    }

    public int top() {
        return this.pageSize.top(this.marginTop);
    }

    public int bottom() {
        return this.pageSize.bottom(this.marginBottom);
    }

    public int left(int n) {
        return this.pageSize.left(this.marginLeft + n);
    }

    public int right(int n) {
        return this.pageSize.right(this.marginRight + n);
    }

    public int top(int n) {
        return this.pageSize.top(this.marginTop + n);
    }

    public int bottom(int n) {
        return this.pageSize.bottom(this.marginBottom + n);
    }
}

