/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module.action;

import com.elluminate.engine.command.LoadCommand;
import com.elluminate.groupware.agenda.module.action.ActionDependency;
import com.elluminate.groupware.agenda.module.action.ActionParameter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;

public class ActionInfo {
    private Class commandInterface;
    private Icon icon;
    private String displayName;
    private String defaultDescription;
    private String tokenDescription;
    private ArrayList extensions;
    private ArrayList parameters;
    private HashMap dependencies;
    private boolean requiresActivation = false;
    private boolean requiresEnabling = false;
    private boolean defaultEnabled = true;

    public ActionInfo(Class commandInterface, Icon icon, String displayName) {
        this.commandInterface = commandInterface;
        this.icon = icon;
        this.displayName = displayName;
    }

    public Class getCommandInterface() {
        return this.commandInterface;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isLoadAction() {
        return LoadCommand.class.isAssignableFrom(this.commandInterface);
    }

    public void setDefaultDescription(String defaultDescription) {
        this.defaultDescription = defaultDescription;
    }

    public String getDefaultDescription() {
        return this.defaultDescription != null ? this.defaultDescription : this.getDisplayName();
    }

    public void setTokenDescription(String tokenDescription) {
        this.tokenDescription = tokenDescription;
    }

    public String getTokenDescription() {
        return this.tokenDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtension(String extension) {
        ActionInfo actionInfo = this;
        synchronized (actionInfo) {
            if (this.extensions == null) {
                this.extensions = new ArrayList();
            }
        }
        this.extensions.add(extension);
    }

    public boolean containsExtension(String extension) {
        if (this.extensions != null) {
            return this.extensions.contains(extension);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(ActionParameter parameter) {
        ActionInfo actionInfo = this;
        synchronized (actionInfo) {
            if (this.parameters == null) {
                this.parameters = new ArrayList();
            }
        }
        this.parameters.add(parameter);
    }

    public synchronized ActionParameter getParameter(String parameterName) {
        if (this.parameters != null) {
            for (ActionParameter param : this.parameters) {
                if (!param.getName().equals(parameterName)) continue;
                return param;
            }
        }
        return null;
    }

    public synchronized ActionParameter[] getParameters() {
        if (this.parameters != null) {
            return this.parameters.toArray(new ActionParameter[0]);
        }
        return new ActionParameter[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependency(ActionDependency dependency) {
        ActionInfo actionInfo = this;
        synchronized (actionInfo) {
            if (this.dependencies == null) {
                this.dependencies = new HashMap();
            }
        }
        this.dependencies.put(dependency.getOtherCommand(), dependency);
        switch (dependency.getRelationship()) {
            case 1: 
            case 2: {
                this.requiresActivation = true;
                break;
            }
            case 3: 
            case 4: {
                this.requiresEnabling = true;
            }
        }
    }

    public ActionDependency getDependency(Class commandInterface) {
        return (ActionDependency)this.dependencies.get(commandInterface);
    }

    public ActionDependency[] getDependencies(int relationship) {
        ArrayList<ActionDependency> deps = new ArrayList<ActionDependency>();
        if (this.dependencies != null) {
            for (Class cmd : this.dependencies.keySet()) {
                ActionDependency dep = (ActionDependency)this.dependencies.get(cmd);
                if (dep.getRelationship() != relationship) continue;
                deps.add(dep);
            }
        }
        return deps.toArray(new ActionDependency[0]);
    }

    public boolean requiresActivation() {
        return this.requiresActivation;
    }

    public boolean requiresEnabling() {
        return this.requiresEnabling;
    }

    public void setDefaultEnabled(boolean defaultEnabled) {
        this.defaultEnabled = defaultEnabled;
    }

    public boolean isDefaultEnabled() {
        return this.defaultEnabled;
    }
}

