/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.LoadFeature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaFile;
import com.elluminate.groupware.agenda.AgendaItem;
import com.elluminate.groupware.agenda.AgendaLibrary;
import com.elluminate.groupware.agenda.event.AgendaEvent;
import com.elluminate.groupware.agenda.event.AgendaLibraryEvent;
import com.elluminate.groupware.agenda.event.AgendaLibraryListener;
import com.elluminate.groupware.agenda.event.AgendaListener;
import com.elluminate.groupware.agenda.module.AgendaBean;
import com.elluminate.groupware.agenda.module.AgendaModule;
import com.elluminate.groupware.agenda.module.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.CCheckBoxMenuItem;
import com.elluminate.gui.swing.CMenu;
import com.elluminate.gui.swing.CMenuItem;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JSeparator;

@Singleton
public class MenuBar
implements PropertyChangeListener,
AgendaLibraryListener,
AgendaListener,
ClientListener,
HierarchyListener {
    public static final String FILENAME_EXTENSION = "elpx";
    public static final String FILENAME_EXTENSION_V1 = "elp";
    public static final String DEFINITION_EXTENSION = "ead";
    private AgendaModule module;
    private AgendaBean bean;
    private AgendaLibrary library;
    private I18n i18n;
    private CMenuItem newAgendaItem;
    private CMenuItem openAgendaItem;
    private CMenuItem saveAgendaItem;
    private CMenuItem saveAsAgendaItem;
    private CMenuItem printAgendaItem;
    private CMenuItem goToPreviousItem;
    private CMenuItem goToNextItem;
    private JSeparator optionSeparator;
    private CCheckBoxMenuItem autoTimeTrackingItem;
    private CCheckBoxMenuItem showIconsItem;
    private CMenu labelsMenu;
    private CCheckBoxMenuItem labelNoneItem;
    private CCheckBoxMenuItem labelLeaderItem;
    private CCheckBoxMenuItem labelBulletItem;
    private CCheckBoxMenuItem labelNumberItem;
    private CCheckBoxMenuItem labelLegalItem;
    private CCheckBoxMenuItem labelLowercaseItem;
    private CCheckBoxMenuItem labelUppercaseItem;
    private JSeparator viewabilitySeparator;
    private CCheckBoxMenuItem showToModeratorsItem;
    private CCheckBoxMenuItem showToEveryoneItem;
    private JSeparator editingSeparator;
    private CMenuItem addFileItem;
    private CMenuItem addTopicItem;
    private CMenuItem addActionItem;
    private CMenuItem addTextItem;
    private CMenuItem removeItemItem;
    private CMenuItem saveEmbeddedFileItem;
    private JSeparator movingSeparator;
    private CMenuItem moveUpItem;
    private CMenuItem moveDownItem;
    private CMenuItem moveLeftItem;
    private CMenuItem moveRightItem;
    private JSeparator protectedSeparator;
    private CCheckBoxMenuItem protectedItem;
    private CCheckBoxMenuItem showAgendaItem;
    private CCheckBoxMenuItem showActionsItem;
    private ActionFeature newAgendaFeature;
    private ActionFeature openAgendaFeature;
    private ActionFeature saveAgendaFeature;
    private ActionFeature saveAsAgendaFeature;
    private ActionFeature saveEmbeddedFileFeature;
    private ActionFeature printAgendaFeature;
    private ActionFeature goToPreviousFeature;
    private ActionFeature goToNextFeature;
    private BooleanFeature autoTimeTrackingFeature;
    private BooleanFeature showIconsFeature;
    private BooleanFeature showToModeratorsFeature;
    private BooleanFeature showToEveryoneFeature;
    private EnumeratedFeature<Integer> labelsFeature;
    private FeatureBroker broker;
    private BooleanFeature showAgendeFeature;
    private ComponentFeature agendaPanelFeature;
    private LoadFeature agendaLoadFile;

    @Inject
    public MenuBar(AgendaModule module, AgendaLibrary library, I18n i18n, FeatureBroker broker) {
        this.broker = broker;
        this.module = module;
        this.library = library;
        this.i18n = i18n;
        this.library.addAgendaLibraryListener((AgendaLibraryListener)this);
        int mod = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    public void initListener() {
        this.bean = this.module.getBean();
        this.bean.addPropertyChangeListener("targetedAgendas", this);
        this.bean.addPropertyChangeListener("targetedItems", this);
        this.bean.addPropertyChangeListener("moderator", this);
        this.bean.addPropertyChangeListener("view", this);
        this.bean.addPropertyChangeListener("actionPaletteVisible", this);
        this.bean.getClientList().addPropertyChangeListener("agenda.viewability", (PropertyChangeListener)this);
        this.bean.getClientList().addPropertyChangeListener("agenda.protected", (PropertyChangeListener)this);
        this.bean.getClientList().addClientListener((ClientListener)this);
        this.bean.addHierarchyListener(this);
    }

    public void createFeatures() {
        this.newAgendaFeature = this.broker.createActionFeature((Object)this, "/agenda/newAgenda", this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_FILENEWAGENDAITEM), null);
        this.newAgendaFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                MenuBar.this.bean.doNewAgenda();
            }
        });
        this.openAgendaFeature = this.broker.createActionFeature((Object)this, "/agenda/openAgenda", this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_FILEOPENAGENDAITEM), null);
        this.openAgendaFeature.setEnabled(false);
        this.openAgendaFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                MenuBar.this.bean.doOpenAgenda();
            }
        });
        this.saveAgendaFeature = this.broker.createActionFeature((Object)this, "/agenda/saveAgenda", this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_FILESAVEAGENDAITEM), null);
        this.saveAgendaFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                MenuBar.this.bean.doSaveAgenda(false);
            }
        });
        this.printAgendaFeature = this.broker.createActionFeature((Object)this, "/agenda/printAgenda", this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_FILEPRINTAGENDAITEM), null);
        this.printAgendaFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                MenuBar.this.bean.doPrintAgenda();
            }
        });
        this.goToPreviousFeature = this.broker.createActionFeature((Object)this, "/agenda/goToPrevious", this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_TOOLSGOTOPREVIOUS), null);
        this.goToPreviousFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                MenuBar.this.bean.doPreviousNode();
            }
        });
        this.goToNextFeature = this.broker.createActionFeature((Object)this, "/agenda/goToNext", this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_TOOLSGOTONEXT), null);
        this.goToNextFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                MenuBar.this.bean.doNextNode();
            }
        });
        this.autoTimeTrackingFeature = this.broker.createBooleanFeature((Object)this, "/agenda/autoTimeTracking", true, false, this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_TOOLSTRACKTIMEAUTOMATICALLY), null);
        this.autoTimeTrackingFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                boolean newValue = Boolean.parseBoolean(ev.getNewValue().toString());
                MenuBar.this.bean.doTimeTracking(newValue);
            }
        });
        this.autoTimeTrackingFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_TOOLSTRACKTIMEAUTOMATICALLY));
        this.autoTimeTrackingFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_TOOLSTRACKTIMEAUTOMATICALLY));
        this.showIconsFeature = this.broker.createBooleanFeature((Object)this, "/agenda/showIcons", true, true, this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_TOOLSSHOWICONS), null);
        this.showIconsFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                boolean newValue = Boolean.parseBoolean(ev.getNewValue().toString());
                MenuBar.this.bean.doShowIcons(newValue);
            }
        });
        this.showIconsFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_TOOLSSHOWICONS));
        this.showIconsFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_TOOLSSHOWICONS));
        ClientList clients = this.bean.getClientList();
        clients.addPropertyChangeListener("Label.Moderators", (PropertyChangeListener)this);
        this.showToModeratorsFeature = this.broker.createBooleanFeature((Object)this, "/agenda/showToModerators", true, true, this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_TOOLSSHOWTOMODERATORS, new Object[]{LabelProps.get((PropertyAccessAPI)clients, (String)"Label.Moderators")}), null);
        this.showToModeratorsFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                boolean newValue = Boolean.parseBoolean(ev.getNewValue().toString());
                MenuBar.this.bean.doViewability(!newValue);
            }
        });
        this.showToModeratorsFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_TOOLSSHOWTOMODERATORS, new Object[]{LabelProps.get((PropertyAccessAPI)clients, (String)"Label.Moderators")}));
        this.showToModeratorsFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_TOOLSSHOWTOMODERATORS, new Object[]{LabelProps.get((PropertyAccessAPI)clients, (String)"Label.Moderators")}));
        Object[] labels = new Integer[]{0, 1, 2, 3, 4, 5, 6};
        this.labelsFeature = this.broker.createEnumeratedFeature((Object)this, "/agenda/labels", Integer.class, true, (Object)0, labels, this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_TOOLSLABELS), this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_TOOLSLABELS));
        this.labelsFeature.setValueText((Object)0, this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_LABELTYPENONE));
        this.labelsFeature.setValueText((Object)1, this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_LABELTYPELEADER));
        this.labelsFeature.setValueText((Object)2, this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_LABELTYPEBULLET));
        this.labelsFeature.setValueText((Object)3, this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_LABELTYPENUMBER));
        this.labelsFeature.setValueText((Object)4, this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_LABELTYPELEGAL));
        this.labelsFeature.setValueText((Object)5, this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_LABELTYPELOWERCASELETTER));
        this.labelsFeature.setValueText((Object)6, this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_LABELTYPEUPPERCASELETTER));
        this.labelsFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                MenuBar.this.bean.doSetLabelType((Integer)ev.getNewValue());
            }
        });
        this.saveEmbeddedFileFeature = this.broker.createActionFeature((Object)this, "/agenda/saveEmbeddedFile", this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_TOOLSSAVEEMBEDDEDFILE), null);
        this.saveEmbeddedFileFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                MenuBar.this.bean.doSaveFiles();
            }
        });
        this.showAgendeFeature = this.broker.createBooleanFeature((Object)this, "/agenda/showAgenda", true, false, this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_WINDOWAGENDAITEM), null);
        this.showAgendeFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                boolean newValue = Boolean.parseBoolean(ev.getNewValue().toString());
                MenuBar.this.broker.setFeaturePublished((Feature)MenuBar.this.agendaPanelFeature, newValue);
            }
        });
        this.showAgendeFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_WINDOWAGENDAITEM));
        this.showAgendeFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMENUBAR_WINDOWAGENDAITEM));
        this.agendaPanelFeature = this.broker.createComponentFeature((Object)this, "/agenda/agendaPanel", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return MenuBar.this.bean;
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMODULE_NAME), this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMODULE_NAME));
        ArrayList<String> fileTypes = new ArrayList<String>();
        fileTypes.add(FILENAME_EXTENSION);
        fileTypes.add(FILENAME_EXTENSION_V1);
        this.agendaLoadFile = this.broker.createLoadFeature((Object)this, "/agenda/loadFile", "Load Session Plan", null);
        this.agendaLoadFile.setFileTypes(fileTypes);
        this.agendaLoadFile.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.AGENDAMODULE_LOADFEATUREICON));
        this.agendaLoadFile.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                try {
                    ArrayList files = (ArrayList)event.getParameter("files");
                    if (files != null) {
                        MenuBar.this.showAgendeFeature.setValue((Object)true);
                        for (File file : files) {
                            MenuBar.this.bean.openAgenda(file, false);
                        }
                    }
                }
                catch (IOException e) {
                    ModalDialog.showMessageDialog((Component)MenuBar.this.bean, (Object)MenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_OPENAGENDAFAILEDMESSAGE), (String)MenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_OPENAGENDAFAILEDTITLE), (int)0);
                }
            }
        });
        this.updateItemsEnabled();
        this.updateItemsVisible();
        this.updateItemsSelected();
    }

    private void updateItemsEnabled() {
        Agenda[] ags = this.bean.getTargetedAgendas();
        AgendaItem[] its = this.bean.getTargetedItems();
        boolean visible = this.agendaPanelFeature.isEnabled();
        boolean viewing = this.bean.getView() != 1 && ags != null && ags.length == 1;
        boolean online = this.bean.isOnline();
        boolean editor = true;
        if (online) {
            short editorAddress = ags != null && ags.length == 1 ? (short)ags[0].getEditor() : (short)-32767;
            editor = editorAddress != -32767 && this.bean.isMe(editorAddress);
        }
        boolean saveable = true;
        if (!online) {
            saveable = ags != null && ags.length == 1 && ags[0].isModified();
        }
        boolean active = ags != null && ags.length == 1 && this.library.isActiveAgenda(ags[0]);
        this.saveAgendaFeature.setEnabled(visible && viewing && saveable);
        this.printAgendaFeature.setEnabled(visible && viewing);
        boolean en = visible && viewing && editor;
        this.autoTimeTrackingFeature.setEnabled(en);
        this.showIconsFeature.setEnabled(en);
        this.labelsFeature.setEnabled(en);
        this.goToPreviousFeature.setEnabled(visible && viewing && editor && active);
        this.goToNextFeature.setEnabled(visible && viewing && editor && active);
        boolean filesSelected = its != null && its.length != 0 && its[0] instanceof AgendaFile;
        this.saveEmbeddedFileFeature.setEnabled(filesSelected);
    }

    private void updateItemsVisible() {
        boolean plan = this.module.isStandalone();
        boolean chair = this.bean.isChair();
        boolean viewable = this.bean.isViewableByEveryone();
        boolean protect = this.bean.isProtected();
        Agenda[] ags = this.bean.getTargetedAgendas();
        short editorAddress = ags != null && ags.length == 1 ? (short)ags[0].getEditor() : (short)-32767;
        boolean editor = editorAddress != -32767 && this.bean.isMe(editorAddress);
        this.broker.setFeaturePublished((Feature)this.agendaLoadFile, chair);
        this.broker.setFeaturePublished((Feature)this.saveAgendaFeature, protect && editor || !protect && (plan || chair || viewable));
        this.openAgendaFeature.setEnabled(chair);
        this.broker.setFeaturePublished((Feature)this.openAgendaFeature, true);
        this.broker.setFeaturePublished((Feature)this.printAgendaFeature, protect && editor || !protect && (plan || chair || viewable));
        this.broker.setFeaturePublished((Feature)this.goToPreviousFeature, chair);
        this.broker.setFeaturePublished((Feature)this.goToNextFeature, chair);
        this.broker.setFeaturePublished((Feature)this.autoTimeTrackingFeature, chair);
        this.broker.setFeaturePublished((Feature)this.showIconsFeature, chair);
        this.broker.setFeaturePublished(this.labelsFeature, chair);
        this.broker.setFeaturePublished((Feature)this.showToModeratorsFeature, chair);
        this.broker.setFeaturePublished((Feature)this.saveEmbeddedFileFeature, plan || chair);
        this.broker.setFeaturePublished((Feature)this.showAgendeFeature, !plan && (chair || viewable));
        if (!chair && this.agendaPanelFeature.isEnabled() && !viewable) {
            this.broker.setFeaturePublished((Feature)this.agendaPanelFeature, false);
            this.showAgendeFeature.setValue((Object)false);
        }
    }

    private void updateItemsSelected() {
        Agenda[] ags;
        if (this.bean.isViewableByEveryone()) {
            this.showToModeratorsFeature.setValue((Object)false);
        } else {
            this.showToModeratorsFeature.setValue((Object)true);
        }
        boolean auto = false;
        int labelType = 0;
        boolean showing = false;
        int view = this.bean.getView();
        if ((view == 2 || view == 3) && (ags = this.bean.getTargetedAgendas()) != null && ags.length == 1) {
            auto = ags[0].isTimeTrackingAutomatic();
            labelType = ags[0].getLabelType();
            showing = ags[0].isShowingIcons();
        }
        this.autoTimeTrackingFeature.setValue((Object)auto);
        this.showIconsFeature.setValue((Object)showing);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("targetedAgendas")) {
            int i;
            Agenda[] ags = (Agenda[])e.getOldValue();
            if (ags != null) {
                for (i = 0; i < ags.length; ++i) {
                    ags[i].removeAgendaListener((AgendaListener)this);
                    ags[i].removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
            if ((ags = (Agenda[])e.getNewValue()) != null) {
                for (i = 0; i < ags.length; ++i) {
                    ags[i].addAgendaListener((AgendaListener)this);
                    ags[i].addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
            this.updateItemsEnabled();
        } else if (prop.equals("targetedItems")) {
            this.updateItemsEnabled();
        } else if (prop.equals("moderator")) {
            this.updateItemsVisible();
        } else if (prop.equals("view")) {
            this.updateItemsEnabled();
            this.updateItemsSelected();
        } else if (prop.equals("actionPaletteVisible")) {
            this.updateItemsSelected();
        } else if (prop.equals("agenda.viewability")) {
            this.updateItemsVisible();
        } else if (prop.equals("agenda.protected")) {
            this.updateItemsVisible();
            this.updateItemsSelected();
        } else if (prop.equals("modified")) {
            this.updateItemsEnabled();
        } else if (prop.equals("Label.Moderators")) {
            // empty if block
        }
    }

    public void agendaActivated(AgendaLibraryEvent e) {
        this.updateItemsEnabled();
    }

    public void agendaDeactivated(AgendaLibraryEvent e) {
        this.updateItemsEnabled();
    }

    public void agendaAdded(AgendaLibraryEvent e) {
        this.showAgendeFeature.setValue((Object)true);
    }

    public void agendaRemoved(AgendaLibraryEvent e) {
    }

    public void agendaAutoloaded(AgendaLibraryEvent e) {
    }

    public void editorChanged(AgendaEvent e) {
        this.updateItemsEnabled();
    }

    public void agendaPropertyChanged(AgendaEvent e) {
        this.updateItemsSelected();
    }

    public void itemAdded(AgendaEvent e) {
    }

    public void itemRemoved(AgendaEvent e) {
    }

    public void itemPropertyChanged(AgendaEvent e) {
    }

    public void timerStarted(AgendaEvent e) {
    }

    public void timerStopped(AgendaEvent e) {
    }

    public void transferAdded(AgendaEvent e) {
    }

    public void transferRemoved(AgendaEvent e) {
    }

    public void onAddClient(ClientEvent e) {
        if (e.isMe()) {
            this.updateItemsVisible();
        }
    }

    public void onRemoveClient(ClientEvent e) {
        if (e.isMe()) {
            this.updateItemsVisible();
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) != 0L) {
            this.updateItemsSelected();
            this.updateItemsEnabled();
        }
    }
}

