/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.groupware.agenda.module.AgendaPreferences;
import com.elluminate.groupware.agenda.module.StringsProperties;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;

@Singleton
public class DisplaySettingsPrefsPanel
extends AbstractPreferencesPanel {
    private static final String FONT_SIZES = "8,9,10,11,12,13,14,16,18,20,24";
    private I18n i18n;
    private boolean standalone;
    private String regularStyle;
    private String boldStyle;
    private String italicStyle;
    private String boldItalicStyle;
    private JComboBox topicFontFamilyPopup;
    private JComboBox topicFontStylePopup;
    private JComboBox topicFontSizePopup;
    private JComboBox actionFontFamilyPopup;
    private JComboBox actionFontStylePopup;
    private JComboBox actionFontSizePopup;
    private JComboBox textFontFamilyPopup;
    private JComboBox textFontStylePopup;
    private JComboBox textFontSizePopup;
    private JComboBox noteFontFamilyPopup;
    private JComboBox noteFontStylePopup;
    private JComboBox noteFontSizePopup;

    @Inject
    public DisplaySettingsPrefsPanel(PreferencesPanelOwner owner, I18n i18n) {
        super(owner, i18n.getString((PropertiesEnum)StringsProperties.DISPLAYSETTINGS_TITLE));
        this.i18n = i18n;
        this.standalone = true;
        this.regularStyle = i18n.getString((PropertiesEnum)StringsProperties.DISPLAYSETTINGS_FONTSTYLEPLAIN);
        this.boldStyle = i18n.getString((PropertiesEnum)StringsProperties.DISPLAYSETTINGS_FONTSTYLEBOLD);
        this.italicStyle = i18n.getString((PropertiesEnum)StringsProperties.DISPLAYSETTINGS_FONTSTYLEITALIC);
        this.boldItalicStyle = i18n.getString((PropertiesEnum)StringsProperties.DISPLAYSETTINGS_FONTSTYLEBOLDITALIC);
    }

    protected void createContent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        this.add(new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.DISPLAYSETTINGS_TOPICFONTLABEL)), gbc);
        gbc.weightx = 100.0;
        gbc.insets.left = 6;
        this.topicFontFamilyPopup = new JComboBox();
        this.topicFontFamilyPopup.setMaximumRowCount(20);
        this.topicFontFamilyPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplaySettingsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.topicFontFamilyPopup, gbc);
        gbc.weightx = 0.0;
        gbc.insets.left = 6;
        this.topicFontStylePopup = new JComboBox();
        this.topicFontStylePopup.setMaximumRowCount(20);
        this.topicFontStylePopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplaySettingsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.topicFontStylePopup, gbc);
        gbc.weightx = 0.0;
        gbc.insets.left = 6;
        this.topicFontSizePopup = new JComboBox();
        this.topicFontSizePopup.setEditable(true);
        this.topicFontSizePopup.setMaximumRowCount(20);
        Dimension ms = new Dimension(50, this.topicFontSizePopup.getMinimumSize().height);
        this.topicFontSizePopup.setMinimumSize(ms);
        this.topicFontSizePopup.setPreferredSize(ms);
        this.topicFontSizePopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplaySettingsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.topicFontSizePopup, gbc);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        this.add(new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.DISPLAYSETTINGS_ACTIONFONTLABEL)), gbc);
        gbc.weightx = 100.0;
        gbc.insets.left = 6;
        this.actionFontFamilyPopup = new JComboBox();
        this.actionFontFamilyPopup.setMaximumRowCount(20);
        this.actionFontFamilyPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplaySettingsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.actionFontFamilyPopup, gbc);
        gbc.weightx = 0.0;
        gbc.insets.left = 6;
        this.actionFontStylePopup = new JComboBox();
        this.actionFontStylePopup.setMaximumRowCount(20);
        this.actionFontStylePopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplaySettingsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.actionFontStylePopup, gbc);
        gbc.weightx = 0.0;
        gbc.insets.left = 6;
        this.actionFontSizePopup = new JComboBox();
        this.actionFontSizePopup.setEditable(true);
        this.actionFontSizePopup.setMaximumRowCount(20);
        ms = new Dimension(50, this.actionFontSizePopup.getMinimumSize().height);
        this.actionFontSizePopup.setMinimumSize(ms);
        this.actionFontSizePopup.setPreferredSize(ms);
        this.actionFontSizePopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplaySettingsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.actionFontSizePopup, gbc);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        this.add(new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.DISPLAYSETTINGS_TEXTFONTLABEL)), gbc);
        gbc.weightx = 100.0;
        gbc.insets.left = 6;
        this.textFontFamilyPopup = new JComboBox();
        this.textFontFamilyPopup.setMaximumRowCount(20);
        this.textFontFamilyPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplaySettingsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.textFontFamilyPopup, gbc);
        gbc.weightx = 0.0;
        gbc.insets.left = 6;
        this.textFontStylePopup = new JComboBox();
        this.textFontStylePopup.setMaximumRowCount(20);
        this.textFontStylePopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplaySettingsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.textFontStylePopup, gbc);
        gbc.weightx = 0.0;
        gbc.insets.left = 6;
        this.textFontSizePopup = new JComboBox();
        this.textFontSizePopup.setEditable(true);
        this.textFontSizePopup.setMaximumRowCount(20);
        ms = new Dimension(50, this.textFontSizePopup.getMinimumSize().height);
        this.textFontSizePopup.setMinimumSize(ms);
        this.textFontSizePopup.setPreferredSize(ms);
        this.textFontSizePopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplaySettingsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.textFontSizePopup, gbc);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        if (!this.standalone) {
            this.add(new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.DISPLAYSETTINGS_NOTEFONTLABEL)), gbc);
        }
        gbc.weightx = 100.0;
        gbc.insets.left = 6;
        this.noteFontFamilyPopup = new JComboBox();
        this.noteFontFamilyPopup.setMaximumRowCount(20);
        this.noteFontFamilyPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplaySettingsPrefsPanel.this.setModified(true);
            }
        });
        if (!this.standalone) {
            this.add(this.noteFontFamilyPopup, gbc);
        }
        gbc.weightx = 0.0;
        gbc.insets.left = 6;
        this.noteFontStylePopup = new JComboBox();
        this.noteFontStylePopup.setMaximumRowCount(20);
        this.noteFontStylePopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplaySettingsPrefsPanel.this.setModified(true);
            }
        });
        if (!this.standalone) {
            this.add(this.noteFontStylePopup, gbc);
        }
        gbc.weightx = 0.0;
        gbc.insets.left = 6;
        this.noteFontSizePopup = new JComboBox();
        this.noteFontSizePopup.setEditable(true);
        this.noteFontSizePopup.setMaximumRowCount(20);
        ms = new Dimension(50, this.noteFontSizePopup.getMinimumSize().height);
        this.noteFontSizePopup.setMinimumSize(ms);
        this.noteFontSizePopup.setPreferredSize(ms);
        this.noteFontSizePopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplaySettingsPrefsPanel.this.setModified(true);
            }
        });
        if (!this.standalone) {
            this.add(this.noteFontSizePopup, gbc);
        }
        this.populateFontFamilies(this.topicFontFamilyPopup);
        this.populateFontFamilies(this.actionFontFamilyPopup);
        this.populateFontFamilies(this.textFontFamilyPopup);
        this.populateFontFamilies(this.noteFontFamilyPopup);
        this.populateFontStyles(this.topicFontStylePopup);
        this.populateFontStyles(this.actionFontStylePopup);
        this.populateFontStyles(this.textFontStylePopup);
        this.populateFontStyles(this.noteFontStylePopup);
        this.populateFontSizes(this.topicFontSizePopup);
        this.populateFontSizes(this.actionFontSizePopup);
        this.populateFontSizes(this.textFontSizePopup);
        this.populateFontSizes(this.noteFontSizePopup);
    }

    private void populateFontFamilies(JComboBox familyPopup) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] families = env.getAvailableFontFamilyNames();
        for (int i = 0; i < families.length; ++i) {
            familyPopup.addItem(families[i]);
        }
    }

    private void populateFontStyles(JComboBox stylePopup) {
        stylePopup.addItem(this.regularStyle);
        stylePopup.addItem(this.italicStyle);
        stylePopup.addItem(this.boldStyle);
        stylePopup.addItem(this.boldItalicStyle);
    }

    private void populateFontSizes(JComboBox sizePopup) {
        StringTokenizer st = new StringTokenizer(FONT_SIZES, ",");
        while (st.hasMoreTokens()) {
            sizePopup.addItem(st.nextToken());
        }
    }

    protected void populate(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        Font f = AgendaPreferences.getTopicFont(prefix, preferences);
        this.topicFontFamilyPopup.setSelectedItem(f.getFamily());
        if (f.isBold() && f.isItalic()) {
            this.topicFontStylePopup.setSelectedItem(this.boldItalicStyle);
        } else if (f.isBold()) {
            this.topicFontStylePopup.setSelectedItem(this.boldStyle);
        } else if (f.isItalic()) {
            this.topicFontStylePopup.setSelectedItem(this.italicStyle);
        } else {
            this.topicFontStylePopup.setSelectedItem(this.regularStyle);
        }
        this.topicFontSizePopup.setSelectedItem(String.valueOf(f.getSize()));
        f = AgendaPreferences.getActionFont(prefix, preferences);
        this.actionFontFamilyPopup.setSelectedItem(f.getFamily());
        if (f.isBold() && f.isItalic()) {
            this.actionFontStylePopup.setSelectedItem(this.boldItalicStyle);
        } else if (f.isBold()) {
            this.actionFontStylePopup.setSelectedItem(this.boldStyle);
        } else if (f.isItalic()) {
            this.actionFontStylePopup.setSelectedItem(this.italicStyle);
        } else {
            this.actionFontStylePopup.setSelectedItem(this.regularStyle);
        }
        this.actionFontSizePopup.setSelectedItem(String.valueOf(f.getSize()));
        f = AgendaPreferences.getTextFont(prefix, preferences);
        this.textFontFamilyPopup.setSelectedItem(f.getFamily());
        if (f.isBold() && f.isItalic()) {
            this.textFontStylePopup.setSelectedItem(this.boldItalicStyle);
        } else if (f.isBold()) {
            this.textFontStylePopup.setSelectedItem(this.boldStyle);
        } else if (f.isItalic()) {
            this.textFontStylePopup.setSelectedItem(this.italicStyle);
        } else {
            this.textFontStylePopup.setSelectedItem(this.regularStyle);
        }
        this.textFontSizePopup.setSelectedItem(String.valueOf(f.getSize()));
        f = AgendaPreferences.getNoteFont(prefix, preferences);
        this.noteFontFamilyPopup.setSelectedItem(f.getFamily());
        if (f.isBold() && f.isItalic()) {
            this.noteFontStylePopup.setSelectedItem(this.boldItalicStyle);
        } else if (f.isBold()) {
            this.noteFontStylePopup.setSelectedItem(this.boldStyle);
        } else if (f.isItalic()) {
            this.noteFontStylePopup.setSelectedItem(this.italicStyle);
        } else {
            this.noteFontStylePopup.setSelectedItem(this.regularStyle);
        }
        this.noteFontSizePopup.setSelectedItem(String.valueOf(f.getSize()));
    }

    protected void apply(Preferences preferences) {
        Font f;
        String prefix = this.getOwnerPrefix();
        String sel = (String)this.topicFontStylePopup.getSelectedItem();
        boolean bold = sel.indexOf(this.boldStyle) != -1;
        boolean italic = sel.indexOf(this.italicStyle) != -1;
        int style = 0;
        if (bold && italic) {
            style = 3;
        } else if (bold) {
            style = 1;
        } else if (italic) {
            style = 2;
        }
        try {
            f = new Font((String)this.topicFontFamilyPopup.getSelectedItem(), style, Integer.parseInt((String)this.topicFontSizePopup.getSelectedItem()));
            AgendaPreferences.setTopicFont(prefix, preferences, f);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        sel = (String)this.actionFontStylePopup.getSelectedItem();
        bold = sel.indexOf(this.boldStyle) != -1;
        italic = sel.indexOf(this.italicStyle) != -1;
        style = 0;
        if (bold && italic) {
            style = 3;
        } else if (bold) {
            style = 1;
        } else if (italic) {
            style = 2;
        }
        try {
            f = new Font((String)this.actionFontFamilyPopup.getSelectedItem(), style, Integer.parseInt((String)this.actionFontSizePopup.getSelectedItem()));
            AgendaPreferences.setActionFont(prefix, preferences, f);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        sel = (String)this.textFontStylePopup.getSelectedItem();
        bold = sel.indexOf(this.boldStyle) != -1;
        italic = sel.indexOf(this.italicStyle) != -1;
        style = 0;
        if (bold && italic) {
            style = 3;
        } else if (bold) {
            style = 1;
        } else if (italic) {
            style = 2;
        }
        try {
            f = new Font((String)this.textFontFamilyPopup.getSelectedItem(), style, Integer.parseInt((String)this.textFontSizePopup.getSelectedItem()));
            AgendaPreferences.setTextFont(prefix, preferences, f);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        sel = (String)this.noteFontStylePopup.getSelectedItem();
        bold = sel.indexOf(this.boldStyle) != -1;
        italic = sel.indexOf(this.italicStyle) != -1;
        style = 0;
        if (bold && italic) {
            style = 3;
        } else if (bold) {
            style = 1;
        } else if (italic) {
            style = 2;
        }
        try {
            f = new Font((String)this.noteFontFamilyPopup.getSelectedItem(), style, Integer.parseInt((String)this.noteFontSizePopup.getSelectedItem()));
            AgendaPreferences.setNoteFont(prefix, preferences, f);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
    }

    protected void reset(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        AgendaPreferences.setTopicFont(prefix, preferences, AgendaPreferences.TOPIC_FONT_DEFAULT);
        AgendaPreferences.setActionFont(prefix, preferences, AgendaPreferences.ACTION_FONT_DEFAULT);
        AgendaPreferences.setTextFont(prefix, preferences, AgendaPreferences.TEXT_FONT_DEFAULT);
        AgendaPreferences.setNoteFont(prefix, preferences, AgendaPreferences.NOTE_FONT_DEFAULT);
    }
}

