/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.util.Preferences;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.File;
import javax.swing.UIManager;

class AgendaPreferences {
    static final String OPEN_FUNCTION_DISPLAYS_AGENDA_PREF = ".openDisplaysAgenda";
    static final boolean OPEN_FUNCTION_DISPLAYS_AGENDA_DEFAULT = true;
    static final String VIEW_FUNCTION_ACTIVATES_AGENDA_PREF = ".viewActivatesAgenda";
    static final boolean VIEW_FUNCTION_ACTIVATES_AGENDA_DEFAULT = true;
    static final String PROGRESSING_BACKWARD_EXECUTES_NODES_PREF = ".progressingBackwardExecutesNodes";
    static final boolean PROGRESSING_BACKWARD_EXECUTES_NODES_DEFAULT = true;
    static final String PROGRESSING_RANDOMLY_EXECUTES_NODES_PREF = ".progressingRandomlyExecutesNodes";
    static final boolean PROGRESSING_RANDOMLY_EXECUTES_NODES_DEFAULT = false;
    static final String CLICKING_NODE_MARKS_AS_CURRENT_PREF = ".nodeClickMarksAsCurrent";
    static final boolean CLICKING_NODE_MARKS_AS_CURRENT_DEFAULT = true;
    static final String SUPPRESS_ACTION_ERRORS_PREF = ".suppressActionErrors";
    static final boolean SUPPRESS_ACTION_ERRORS_DEFAULT = false;
    static final String COVERED_NODE_COLOR_PREF = ".coveredNodeColor";
    static final Color COVERED_NODE_COLOR_DEFAULT = new Color(85, 26, 139);
    static final String ACTION_HYPERLINK_COLOR_PREF = ".actionHyperlinkColor";
    static final Color ACTION_HYPERLINK_COLOR_DEFAULT = Color.BLUE;
    static final String PROBLEM_COLOR_PREF = ".problemColor";
    static final Color PROBLEM_COLOR_DEFAULT = Color.RED;
    static final String TOPIC_FONT_PREF = ".topicFont";
    static final Font TOPIC_FONT_DEFAULT = null;
    static final String ACTION_FONT_PREF = ".actionFont";
    static final Font ACTION_FONT_DEFAULT = null;
    static final String TEXT_FONT_PREF = ".textFont";
    static final Font TEXT_FONT_DEFAULT = null;
    static final String NOTE_FONT_PREF = ".noteFont";
    static final Font NOTE_FONT_DEFAULT = UIManager.getFont("List.font");
    static final String LAST_DIRECTORY_PREF = ".lastDirectory";
    static final String LAST_DIRECTORY_DEFAULT = null;
    static final String BOUNDS_PREF = ".bounds";
    static final Rectangle BOUNDS_DEFAULT = new Rectangle(100, 100, 500, 500);
    static final String FILES_DIVIDER_POSITION_PREF = ".filesDividerLocation";
    static final int FILES_DIVIDER_POSITION_DEFAULT = 50;
    static final String NOTES_DIVIDER_POSITION_PREF = ".notesDividerLocation";
    static final int NOTES_DIVIDER_POSITION_DEFAULT = 44;
    static final String PROPERTIES_DIVIDER_POSITION_PREF = ".propertiesDividerLocation";
    static final int PROPERTIES_DIVIDER_POSITION_DEFAULT = 175;
    static final String TRANSFER_QUOTA_PREF = ".transferQuota";
    static final int TRANSFER_QUOTA_DEFAULT = 10;
    static final String MULTIMEDIA_QUOTA_PREF = ".multimediaQuota";
    static final int MULTIMEDIA_QUOTA_DEFAULT = 100;
    static final String WHITEBOARD_QUOTA_PREF = ".whiteboardQuota";
    static final int WHITEBOARD_QUOTA_DEFAULT = 20;
    static final String MAX_PLAN_SIZE_PREF = ".maxPlanSize";
    static final int MAX_PLAN_SIZE_DEFAULT = 100;
    static final String MAX_TALKER_COUNT_PREF = ".maxTalkerCount";
    static final int MAX_TALKER_COUNT_DEFAULT = 6;
    static final String MAX_CAMERA_COUNT_PREF = ".maxCameraCount";
    static final int MAX_CAMERA_COUNT_DEFAULT = 6;
    static final String ACTION_PALETTE_BOUNDS_PREF = ".actionPaletteBounds";
    static final Rectangle ACTION_PALETTE_BOUNDS_DEFAULT = new Rectangle(10, 150, 210, 340);
    static final String ACTION_PALETTE_VISIBLE_PREF = ".actionPaletteVisible";
    static final boolean ACTION_PALETTE_VISIBLE_DEFAULT = false;

    private AgendaPreferences() {
    }

    static boolean isOpenFunctionDisplaysAgenda(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + OPEN_FUNCTION_DISPLAYS_AGENDA_PREF, true);
    }

    static void setOpenFunctionDisplaysAgenda(String prefix, Preferences preferences, boolean selected) {
        preferences.setSetting(prefix + OPEN_FUNCTION_DISPLAYS_AGENDA_PREF, selected);
    }

    static boolean isViewFunctionActivatesAgenda(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + VIEW_FUNCTION_ACTIVATES_AGENDA_PREF, true);
    }

    static void setViewFunctionActivatesAgenda(String prefix, Preferences preferences, boolean selected) {
        preferences.setSetting(prefix + VIEW_FUNCTION_ACTIVATES_AGENDA_PREF, selected);
    }

    static boolean isProgressingBackwardExecutesNodes(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + PROGRESSING_BACKWARD_EXECUTES_NODES_PREF, true);
    }

    static void setProgressingBackwardExecutesNodes(String prefix, Preferences preferences, boolean selected) {
        preferences.setSetting(prefix + PROGRESSING_BACKWARD_EXECUTES_NODES_PREF, selected);
    }

    static boolean isProgressingRandomlyExecutesNodes(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + PROGRESSING_RANDOMLY_EXECUTES_NODES_PREF, false);
    }

    static void setProgressingRandomlyExecutesNodes(String prefix, Preferences preferences, boolean selected) {
        preferences.setSetting(prefix + PROGRESSING_RANDOMLY_EXECUTES_NODES_PREF, selected);
    }

    static boolean isClickingNodeMarksAsCurrent(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + CLICKING_NODE_MARKS_AS_CURRENT_PREF, true);
    }

    static void setClickingNodeMarksAsCurrent(String prefix, Preferences preferences, boolean selected) {
        preferences.setSetting(prefix + CLICKING_NODE_MARKS_AS_CURRENT_PREF, selected);
    }

    static boolean isSuppressActionErrors(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + SUPPRESS_ACTION_ERRORS_PREF, false);
    }

    static void setSuppressActionErrors(String prefix, Preferences preferences, boolean selected) {
        preferences.setSetting(prefix + SUPPRESS_ACTION_ERRORS_PREF, selected);
    }

    static Color getCoveredNodeColor(String prefix, Preferences preferences) {
        return preferences.getColorSetting(prefix + COVERED_NODE_COLOR_PREF, COVERED_NODE_COLOR_DEFAULT);
    }

    static void setCoveredNodeColor(String prefix, Preferences preferences, Color color) {
        preferences.setSetting(prefix + COVERED_NODE_COLOR_PREF, color);
    }

    static Color getActionHyperlinkColor(String prefix, Preferences preferences) {
        return preferences.getColorSetting(prefix + ACTION_HYPERLINK_COLOR_PREF, ACTION_HYPERLINK_COLOR_DEFAULT);
    }

    static void setActionHyperlinkColor(String prefix, Preferences preferences, Color color) {
        preferences.setSetting(prefix + ACTION_HYPERLINK_COLOR_PREF, color);
    }

    static Color getProblemColor(String prefix, Preferences preferences) {
        return preferences.getColorSetting(prefix + PROBLEM_COLOR_PREF, PROBLEM_COLOR_DEFAULT);
    }

    static void setProblemColor(String prefix, Preferences preferences, Color color) {
        preferences.setSetting(prefix + PROBLEM_COLOR_PREF, color);
    }

    static Font getTopicFont(String prefix, Preferences preferences) {
        Font f = AgendaPreferences.getFontSetting(prefix + TOPIC_FONT_PREF, preferences, TOPIC_FONT_DEFAULT);
        if (f == null) {
            f = UIManager.getFont("List.font").deriveFont(1);
        }
        return f;
    }

    static void setTopicFont(String prefix, Preferences preferences, Font font) {
        AgendaPreferences.setFontSetting(prefix + TOPIC_FONT_PREF, preferences, font);
    }

    static Font getActionFont(String prefix, Preferences preferences) {
        Font f = AgendaPreferences.getFontSetting(prefix + ACTION_FONT_PREF, preferences, ACTION_FONT_DEFAULT);
        if (f == null) {
            f = UIManager.getFont("List.font").deriveFont(0);
        }
        return f;
    }

    static void setActionFont(String prefix, Preferences preferences, Font font) {
        AgendaPreferences.setFontSetting(prefix + ACTION_FONT_PREF, preferences, font);
    }

    static Font getTextFont(String prefix, Preferences preferences) {
        Font f = AgendaPreferences.getFontSetting(prefix + TEXT_FONT_PREF, preferences, TEXT_FONT_DEFAULT);
        if (f == null) {
            f = UIManager.getFont("List.font").deriveFont(2);
        }
        return f;
    }

    static void setTextFont(String prefix, Preferences preferences, Font font) {
        AgendaPreferences.setFontSetting(prefix + TEXT_FONT_PREF, preferences, font);
    }

    static Font getNoteFont(String prefix, Preferences preferences) {
        Font f = AgendaPreferences.getFontSetting(prefix + NOTE_FONT_PREF, preferences, NOTE_FONT_DEFAULT);
        if (f == null) {
            f = UIManager.getFont("List.font").deriveFont(2);
        }
        return f;
    }

    static void setNoteFont(String prefix, Preferences preferences, Font font) {
        AgendaPreferences.setFontSetting(prefix + NOTE_FONT_PREF, preferences, font);
    }

    static File getLastDirectory(String prefix, Preferences preferences) {
        File dir;
        String path = preferences.getSetting(prefix + LAST_DIRECTORY_PREF, LAST_DIRECTORY_DEFAULT);
        if (path != null && (dir = new File(path)).exists() && dir.isDirectory()) {
            return dir;
        }
        return null;
    }

    static void setLastDirectory(String prefix, Preferences preferences, File directory) {
        preferences.setSetting(prefix + LAST_DIRECTORY_PREF, directory != null ? directory.getAbsolutePath() : null);
    }

    static Rectangle getBounds(String prefix, Preferences preferences) {
        return preferences.getRectangleSetting(prefix + BOUNDS_PREF, BOUNDS_DEFAULT);
    }

    static void setBounds(String prefix, Preferences preferences, Rectangle bounds) {
        preferences.setSetting(prefix + BOUNDS_PREF, bounds);
    }

    static int getFilesDividerPosition(String prefix, Preferences preferences) {
        return preferences.getIntegerSetting(prefix + FILES_DIVIDER_POSITION_PREF, 50);
    }

    static void setFilesDividerPosition(String prefix, Preferences preferences, int filesDividerPosition) {
        preferences.setSetting(prefix + FILES_DIVIDER_POSITION_PREF, filesDividerPosition);
    }

    static int getNotesDividerPosition(String prefix, Preferences preferences) {
        return preferences.getIntegerSetting(prefix + NOTES_DIVIDER_POSITION_PREF, 44);
    }

    static void setNotesDividerPosition(String prefix, Preferences preferences, int notesDividerPosition) {
        preferences.setSetting(prefix + NOTES_DIVIDER_POSITION_PREF, notesDividerPosition);
    }

    static int getPropertiesDividerPosition(String prefix, Preferences preferences) {
        return preferences.getIntegerSetting(prefix + PROPERTIES_DIVIDER_POSITION_PREF, 175);
    }

    static void setPropertiesDividerPosition(String prefix, Preferences preferences, int propertiesDividerPosition) {
        preferences.setSetting(prefix + PROPERTIES_DIVIDER_POSITION_PREF, propertiesDividerPosition);
    }

    static int getTransferQuota(String prefix, Preferences preferences) {
        return preferences.getIntegerSetting(prefix + TRANSFER_QUOTA_PREF, 10);
    }

    static void setTransferQuota(String prefix, Preferences preferences, int size) {
        preferences.setSetting(prefix + TRANSFER_QUOTA_PREF, size);
    }

    static int getMultimediaQuota(String prefix, Preferences preferences) {
        return preferences.getIntegerSetting(prefix + MULTIMEDIA_QUOTA_PREF, 100);
    }

    static void setMultimediaQuota(String prefix, Preferences preferences, int size) {
        preferences.setSetting(prefix + MULTIMEDIA_QUOTA_PREF, size);
    }

    static int getWhiteboardQuota(String prefix, Preferences preferences) {
        return preferences.getIntegerSetting(prefix + WHITEBOARD_QUOTA_PREF, 20);
    }

    static void setWhiteboardQuota(String prefix, Preferences preferences, int size) {
        preferences.setSetting(prefix + WHITEBOARD_QUOTA_PREF, size);
    }

    static int getMaxPlanSize(String prefix, Preferences preferences) {
        return preferences.getIntegerSetting(prefix + MAX_PLAN_SIZE_PREF, 100);
    }

    static void setMaxPlanSize(String prefix, Preferences preferences, int size) {
        preferences.setSetting(prefix + MAX_PLAN_SIZE_PREF, size);
    }

    static int getMaxTalkerCount(String prefix, Preferences preferences) {
        return preferences.getIntegerSetting(prefix + MAX_TALKER_COUNT_PREF, 6);
    }

    static void setMaxTalkerCount(String prefix, Preferences preferences, int count) {
        preferences.setSetting(prefix + MAX_TALKER_COUNT_PREF, count);
    }

    static int getMaxCameraCount(String prefix, Preferences preferences) {
        return preferences.getIntegerSetting(prefix + MAX_CAMERA_COUNT_PREF, 6);
    }

    static void setMaxCameraCount(String prefix, Preferences preferences, int count) {
        preferences.setSetting(prefix + MAX_CAMERA_COUNT_PREF, count);
    }

    static Rectangle getActionPaletteBounds(String prefix, Preferences preferences) {
        return preferences.getRectangleSetting(prefix + ACTION_PALETTE_BOUNDS_PREF, ACTION_PALETTE_BOUNDS_DEFAULT);
    }

    static void setActionPaletteBounds(String prefix, Preferences preferences, Rectangle bounds) {
        preferences.setSetting(prefix + ACTION_PALETTE_BOUNDS_PREF, bounds);
    }

    static boolean isActionPaletteVisible(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + ACTION_PALETTE_VISIBLE_PREF, false);
    }

    static void setActionPaletteVisible(String prefix, Preferences preferences, boolean visible) {
        preferences.setSetting(prefix + ACTION_PALETTE_VISIBLE_PREF, visible);
    }

    private static Font getFontSetting(String key, Preferences preferences, Font defaultFont) {
        String fontID = preferences.getSetting(key);
        if (fontID == null) {
            return defaultFont;
        }
        return Font.decode(fontID);
    }

    private static void setFontSetting(String key, Preferences preferences, Font font) {
        StringBuilder fontID = null;
        if (font != null) {
            fontID = new StringBuilder();
            fontID.append(font.getFamily());
            fontID.append("-");
            if (font.isBold() && font.isItalic()) {
                fontID.append("BOLDITALIC");
            } else if (font.isBold()) {
                fontID.append("BOLD");
            } else if (font.isItalic()) {
                fontID.append("ITALIC");
            } else {
                fontID.append("PLAIN");
            }
            fontID.append("-");
            fontID.append(font.getSize());
        }
        if (fontID != null) {
            preferences.setSetting(key, fontID.toString());
        } else {
            preferences.clearSetting(key);
        }
    }
}

