/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.engine.ConferencingEngine;
import com.elluminate.engine.command.ChangeWhiteboardScreenCommand;
import com.elluminate.engine.command.LoadFileCommand;
import com.elluminate.engine.command.LoadMultimediaCommand;
import com.elluminate.engine.command.LoadQuizCommand;
import com.elluminate.engine.command.LoadWhiteboardCommand;
import com.elluminate.engine.command.PlayMultimediaCommand;
import com.elluminate.engine.command.PromptToSaveFileCommand;
import com.elluminate.engine.command.SetMaximumCamerasCommand;
import com.elluminate.engine.command.SetMaximumTalkersCommand;
import com.elluminate.engine.command.StartQuizCommand;
import com.elluminate.engine.command.StopMultimediaCommand;
import com.elluminate.engine.command.StopQuizCommand;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaAction;
import com.elluminate.groupware.agenda.AgendaExecutable;
import com.elluminate.groupware.agenda.AgendaFile;
import com.elluminate.groupware.agenda.AgendaFlags;
import com.elluminate.groupware.agenda.AgendaItem;
import com.elluminate.groupware.agenda.AgendaLibrary;
import com.elluminate.groupware.agenda.AgendaNode;
import com.elluminate.groupware.agenda.AgendaProtocol;
import com.elluminate.groupware.agenda.AgendaText;
import com.elluminate.groupware.agenda.AgendaTopic;
import com.elluminate.groupware.agenda.AgendaUtils;
import com.elluminate.groupware.agenda.ChairEventSupport;
import com.elluminate.groupware.agenda.LoadAgendaOperation;
import com.elluminate.groupware.agenda.QuotaExceededException;
import com.elluminate.groupware.agenda.SaveAgendaOperation;
import com.elluminate.groupware.agenda.SaveAgendaTextOperation;
import com.elluminate.groupware.agenda.Transfer;
import com.elluminate.groupware.agenda.event.AgendaLibraryEvent;
import com.elluminate.groupware.agenda.event.AgendaLibraryListener;
import com.elluminate.groupware.agenda.event.ChairEvent;
import com.elluminate.groupware.agenda.event.ChairListener;
import com.elluminate.groupware.agenda.module.Actions;
import com.elluminate.groupware.agenda.module.AgendaModule;
import com.elluminate.groupware.agenda.module.AgendaPreferences;
import com.elluminate.groupware.agenda.module.AgendaValidator;
import com.elluminate.groupware.agenda.module.DisplaySettingsPrefsPanel;
import com.elluminate.groupware.agenda.module.EditorOptionsPrefsPanel;
import com.elluminate.groupware.agenda.module.EditorPanel;
import com.elluminate.groupware.agenda.module.ExecutableTask;
import com.elluminate.groupware.agenda.module.LibraryPanel;
import com.elluminate.groupware.agenda.module.PropertyEditor;
import com.elluminate.groupware.agenda.module.StringsProperties;
import com.elluminate.groupware.agenda.module.ToolBar;
import com.elluminate.groupware.agenda.module.ViewerOptionsPrefsPanel;
import com.elluminate.groupware.agenda.module.action.ActionGroup;
import com.elluminate.groupware.agenda.module.action.ActionInfo;
import com.elluminate.groupware.agenda.module.action.ActionParameter;
import com.elluminate.groupware.imps.FileConversionAPI;
import com.elluminate.groupware.imps.OpenDocumentAPI;
import com.elluminate.groupware.imps.QuizModelAPI;
import com.elluminate.groupware.imps.WhiteboardFilePreviewAPI;
import com.elluminate.groupware.imps.quiz.Quiz;
import com.elluminate.groupware.imps.whiteboard.WhiteboardScreenNode;
import com.elluminate.groupware.module.JinxTerminal;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.OperationDialog;
import com.elluminate.gui.swing.CDialog;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.gui.swing.CFrame;
import com.elluminate.gui.swing.CTree;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.event.Operation;
import com.elluminate.util.event.OperationAdapter;
import com.elluminate.util.event.OperationEvent;
import com.elluminate.util.event.OperationListener;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

@Singleton
public class AgendaBean
extends JPanel
implements ChannelListener,
ChannelDataListener,
ChairListener,
PropertyChangeListener {
    final KeyStroke newAccelerator = KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    final KeyStroke openAccelerator = KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    final KeyStroke saveAccelerator = KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    final KeyStroke printAccelerator = KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    final KeyStroke goToPreviousAccelerator = KeyStroke.getKeyStroke(91, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    final KeyStroke goToNextAccelerator = KeyStroke.getKeyStroke(93, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    public static final String PROP_TARGETED_AGENDAS = "targetedAgendas";
    public static final String PROP_TARGETED_ITEMS = "targetedItems";
    public static final String PROP_MODERATOR = "moderator";
    public static final String PROP_VIEW = "view";
    public static final String PROP_ACTION_PALETTE_VISIBLE = "actionPaletteVisible";
    public static final int VIEW_LIBRARY = 1;
    public static final int VIEW_EDITOR = 2;
    public static final int VIEW_CONTROLLER = 3;
    private static final String PROP_WINDOW_TITLE = "title";
    private static final String CARD_LIBRARY = "library";
    private static final String CARD_EDITOR = "editor";
    private AgendaModule module;
    private I18n i18n;
    private AgendaProtocol agendaProtocol;
    private CRSession session;
    private AgendaLibrary library;
    private AgendaLibraryListener libraryListener = new AgendaLibraryListener(){

        public void agendaAdded(AgendaLibraryEvent e) {
            try {
                String prefix = AgendaBean.this.module.getPrefix();
                Preferences prefs = AgendaBean.this.module.getPreferences();
                if (AgendaPreferences.isOpenFunctionDisplaysAgenda(prefix, prefs)) {
                    Agenda ag = e.getAgenda();
                    if (!AgendaBean.this.terminal.getClient().isConnected()) {
                        AgendaBean.this.performDefineAgenda(ag);
                    } else if (e.getRequester() == AgendaBean.this.terminal.getClient().getAddress() && !ag.isTransferring(1)) {
                        AgendaBean.this.sendDownloadDefinitionRequestMessage(AgendaBean.newDownloadID(), ag);
                    }
                }
            }
            catch (IOException ex) {
                ModalDialog.showMessageDialog((Component)AgendaBean.this, (Object)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DEFINEAGENDAFAILEDMESSAGE), (String)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DEFINEAGENDAFAILEDTITLE), (int)0);
            }
        }

        public void agendaRemoved(AgendaLibraryEvent e) {
            Agenda ag = e.getAgenda();
            if (ag == AgendaBean.this.editorPanel.getAgenda()) {
                if (AgendaBean.this.canViewLibrary()) {
                    AgendaBean.this.setView(1);
                }
                AgendaBean.this.editorPanel.setAgenda(null);
            }
            ag.unload();
            File f = ag.getFile();
            if (f != null && f.getAbsolutePath().startsWith(System.getProperty("java.io.tmpdir"))) {
                f.delete();
            }
        }

        public void agendaActivated(AgendaLibraryEvent e) {
            try {
                if (AgendaBean.this.terminal.getClient().isConnected()) {
                    Agenda ag = e.getAgenda();
                    if (!ag.isLoaded()) {
                        AgendaBean.this.sendDownloadDefinitionRequestMessage(AgendaBean.newDownloadID(), ag);
                    } else {
                        AgendaBean.this.performEditAgenda(ag);
                    }
                }
            }
            catch (IOException ex) {
                ModalDialog.showMessageDialog((Component)AgendaBean.this, (Object)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DEFINEAGENDAFAILEDMESSAGE), (String)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DEFINEAGENDAFAILEDTITLE), (int)0);
            }
        }

        public void agendaDeactivated(AgendaLibraryEvent e) {
        }

        public void agendaAutoloaded(AgendaLibraryEvent e) {
            if (e.getRequester() == AgendaBean.this.terminal.getClient().getAddress()) {
                String prefix = AgendaBean.this.module.getPrefix();
                Preferences prefs = AgendaBean.this.module.getPreferences();
                Agenda ag = e.getAgenda();
                for (int i = 0; i < ag.getFileCount(); ++i) {
                    AgendaFile file = ag.getFile(i);
                    if (!file.isAutoload()) continue;
                    new ExecutableTask(AgendaBean.this.module, AgendaBean.this.i18n, ag, (AgendaExecutable)file, AgendaPreferences.isSuppressActionErrors(prefix, prefs)).run();
                }
            }
        }
    };
    private HashMap uploads = new HashMap();
    private long nextUploadID = 1L;
    private HashMap downloads = new HashMap();
    private ChairEventSupport chairSupport;
    private ViewerOptionsPrefsPanel viewerOptionsPrefsPanel;
    private EditorOptionsPrefsPanel editorOptionsPrefsPanel;
    private DisplaySettingsPrefsPanel displaySettingsPrefsPanel;
    private ActionDialog actionPalette;
    private int view;
    private ToolBar toolBar;
    private JPanel center;
    private CardLayout cardLayout;
    private LibraryPanel libraryPanel;
    private EditorPanel editorPanel;
    private Dimension normalSize;
    private boolean settingWindowTitle;
    private Agenda[] targetedAgendas;
    private AgendaItem[] targetedItems;
    private File lastDirectory;
    private HashMap cachedIcons = new HashMap();
    private EmbeddedContentCache contentCache = new EmbeddedContentCache();
    private OpenAgendaDocumentFilter openAgendaDocumentFilter = new OpenAgendaDocumentFilter();
    private SaveAgendaDocumentFilter saveAgendaDocumentFilter = new SaveAgendaDocumentFilter();
    private TextFileFilter textFileFilter = new TextFileFilter();
    private FileFilter lastSaveFilter = this.saveAgendaDocumentFilter;
    private JinxTerminal terminal;
    private ClientList clients;
    private Imps imps;
    private DialogParentProvider parentProvider;

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    CRSession getSession() {
        return this.session;
    }

    public AgendaLibrary getLibrary() {
        return this.library;
    }

    public void setLibrary(AgendaLibrary library) {
        this.library = library;
    }

    @Inject
    public AgendaBean(JinxTerminal terminal, AgendaModule module, I18n i18n, AgendaLibrary agendaLibrary, PropertyEditor propertyEditor) {
        this.i18n = i18n;
        this.library = agendaLibrary;
        this.module = module;
        this.agendaProtocol = new AgendaProtocol();
        this.terminal = terminal;
        this.clients = this.terminal.getClientList();
        this.terminal.setProtocolAndListeners((JinxProtocol)this.agendaProtocol, (ChannelListener)this, (ChannelDataListener)this, null);
        InputMap imap = this.getInputMap(2);
        ActionMap amap = this.getActionMap();
        if (!module.isStandalone()) {
            String newAction = "new-agenda";
            imap.put(this.newAccelerator, "new-agenda");
            amap.put("new-agenda", new AbstractAction("new-agenda"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AgendaBean.this.doNewAgenda();
                }
            });
            String openAction = "open-agenda";
            imap.put(this.openAccelerator, "open-agenda");
            amap.put("open-agenda", new AbstractAction("open-agenda"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AgendaBean.this.doOpenAgenda();
                }
            });
            String saveAction = "save-agenda";
            imap.put(this.saveAccelerator, "save-agenda");
            amap.put("save-agenda", new AbstractAction("save-agenda"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AgendaBean.this.doSaveAgenda(false);
                }
            });
            String printAction = "print-agenda";
            imap.put(this.printAccelerator, "print-agenda");
            amap.put("print-agenda", new AbstractAction("print-agenda"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AgendaBean.this.doPrintAgenda();
                }
            });
        }
        String goToPreviousAction = "go-to-previous-node";
        imap.put(this.goToPreviousAccelerator, "go-to-previous-node");
        amap.put("go-to-previous-node", new AbstractAction("go-to-previous-node"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgendaBean.this.doPreviousNode();
            }
        });
        String goToNextAction = "go-to-next-node";
        imap.put(this.goToNextAccelerator, "go-to-next-node");
        amap.put("go-to-next-node", new AbstractAction("go-to-next-node"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgendaBean.this.doNextNode();
            }
        });
        this.library.addAgendaLibraryListener(this.libraryListener);
        this.chairSupport = new ChairEventSupport(this.terminal.getClient());
        this.chairSupport.addChairListener((ChairListener)this);
        this.clients.addPropertyChangeListener("agenda.viewability", (PropertyChangeListener)this);
        this.setLayout(new BorderLayout());
        this.toolBar = new ToolBar(this, this.library, i18n);
        this.add((Component)((Object)this.toolBar), "North");
        this.cardLayout = new CardLayout();
        this.center = new JPanel(this.cardLayout);
        this.add((Component)this.center, "Center");
        this.libraryPanel = new LibraryPanel(this, this.library, i18n);
        this.center.add((Component)this.libraryPanel, CARD_LIBRARY);
        this.editorPanel = new EditorPanel(this, this.library, i18n, propertyEditor);
        this.center.add((Component)this.editorPanel, CARD_EDITOR);
        ConferencingEngine eng = module.getConfEngine();
        if (eng != null) {
            this.editorPanel.setCommandEngine(eng);
        }
        this.setView(1);
    }

    @Inject
    protected void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    protected void initParentProvider(DialogParentProvider dpp) {
        this.parentProvider = dpp;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateWindowTitle();
        Window w = SwingUtilities.getWindowAncestor(this);
        if (w instanceof JDialog) {
            ((JDialog)w).addPropertyChangeListener(PROP_WINDOW_TITLE, this);
        } else if (w instanceof JFrame) {
            ((JFrame)w).addPropertyChangeListener(PROP_WINDOW_TITLE, this);
        }
        String prefix = this.module.getPrefix();
        Preferences prefs = this.module.getPreferences();
        if (AgendaPreferences.isActionPaletteVisible(prefix, prefs)) {
            this.setActionPaletteVisible(true);
        }
    }

    @Override
    public void removeNotify() {
        Window w = SwingUtilities.getWindowAncestor(this);
        if (w instanceof JDialog) {
            ((JDialog)w).removePropertyChangeListener(PROP_WINDOW_TITLE, this);
        } else if (w instanceof JFrame) {
            ((JFrame)w).removePropertyChangeListener(PROP_WINDOW_TITLE, this);
        }
        super.removeNotify();
    }

    public void loadPreferences(String prefix, Preferences preferences) {
        this.editorPanel.loadPreferences(preferences, prefix);
        this.lastDirectory = AgendaPreferences.getLastDirectory(prefix, preferences);
        ActionInfo act = Actions.getAction(SetMaximumTalkersCommand.class.getName());
        ActionParameter param = act.getParameter("talkerCount");
        param.setMaximumValue(AgendaPreferences.getMaxTalkerCount(prefix, preferences));
        act = Actions.getAction(SetMaximumCamerasCommand.class.getName());
        param = act.getParameter("cameraCount");
        param.setMaximumValue(AgendaPreferences.getMaxCameraCount(prefix, preferences));
        Rectangle b = preferences.getRectangleSetting(prefix + ".bounds", null);
        if (b == null) {
            AgendaPreferences.setBounds(prefix, preferences, AgendaPreferences.BOUNDS_DEFAULT);
        }
        preferences.addSettingChangeListener(prefix + ".maxTalkerCount", (PropertyChangeListener)this);
        preferences.addSettingChangeListener(prefix + ".maxCameraCount", (PropertyChangeListener)this);
    }

    public void savePreferences(String prefix, Preferences preferences) {
        Rectangle b;
        this.editorPanel.savePreferences(preferences, prefix);
        AgendaPreferences.setLastDirectory(prefix, preferences, this.lastDirectory);
        if (this.actionPalette != null) {
            AgendaPreferences.setActionPaletteBounds(prefix, preferences, this.actionPalette.getBounds());
        }
        if (this.normalSize != null && (b = preferences.getRectangleSetting(prefix + ".bounds", null)) != null) {
            b = b.getBounds();
            b.setSize(this.normalSize);
            AgendaPreferences.setBounds(prefix, preferences, b);
        }
    }

    void openAgenda(File file, boolean suppressEdit) throws IOException {
        if (!file.getName().endsWith(".elpx") && !file.getName().endsWith(".elp")) {
            throw new IOException("Unsupported file type: " + file.getName());
        }
        if (this.terminal.getClient().isConnected()) {
            this.performUploadAgenda(file, suppressEdit);
        } else if (!suppressEdit) {
            this.performOpenAgenda(file);
        }
    }

    void doNewAgenda() {
        if (this.isOnline() && !this.isChair()) {
            return;
        }
        if (!this.doCloseAgenda(true)) {
            return;
        }
        try {
            String baseName;
            int index = 1;
            String name = baseName = this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_UNTITLEDNAME);
            while (this.library.getAgenda(name) != null) {
                name = baseName + " " + ++index;
            }
            if (this.terminal.getClient().isConnected()) {
                this.sendNewAgendaMessage(name);
            } else {
                this.performNewAgenda(-1, name, (short)-32767);
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_NEWAGENDAFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_NEWAGENDAFAILEDTITLE), (int)0);
        }
    }

    void doOpenAgenda() {
        if (this.isOnline() && !this.isChair()) {
            return;
        }
        if (!this.canCloseAgenda()) {
            return;
        }
        CFileChooser ch = new CFileChooser();
        ch.removeChoosableFileFilter(ch.getAcceptAllFileFilter());
        ch.addChoosableFileFilter((FileFilter)this.openAgendaDocumentFilter);
        ch.setMultiSelectionEnabled(true);
        ch.setCurrentDirectory(this.lastDirectory);
        if (ch.showOpenDialog((Component)this.parentProvider.getDialogParent()) != 0) {
            return;
        }
        this.closeAgenda();
        this.lastDirectory = ch.getCurrentDirectory();
        try {
            File[] fs = ch.getSelectedFiles();
            for (int i = 0; i < fs.length; ++i) {
                this.openAgenda(fs[i], i != 0);
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_OPENAGENDAFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_OPENAGENDAFAILEDTITLE), (int)0);
        }
    }

    boolean doSaveAgenda(boolean newFile) {
        return this.doSaveAgenda(newFile, true);
    }

    boolean doSaveAgenda(boolean newFile, boolean asynchronous) {
        if (this.view != 2 && this.view != 3) {
            return true;
        }
        Agenda ag = this.editorPanel.getAgenda();
        if (this.isProtected() && !this.isMe(ag.getEditor())) {
            return true;
        }
        File f = ag.getFile();
        boolean extChange = false;
        if (f != null) {
            boolean bl = extChange = !f.getName().endsWith(".elpx");
        }
        if (newFile || this.terminal.getClient().isConnected() || f == null || extChange) {
            int answer;
            if (extChange && (answer = ModalDialog.showConfirmDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SAVEAGENDAREQUIREDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SAVEAGENDATITLE), (int)0, (int)2)) != 0) {
                return true;
            }
            f = this.getSaveFile(ag);
            if (f == null) {
                return false;
            }
        }
        if (this.terminal.getClient().isConnected() && this.lastSaveFilter == this.saveAgendaDocumentFilter) {
            try {
                this.sendDownloadAgendaRequestMessage(AgendaBean.newDownloadID(), ag, f);
            }
            catch (IOException ex) {
                ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DOWNLOADAGENDAFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DOWNLOADAGENDAFAILEDTITLE), (int)0);
                return false;
            }
        } else {
            SaveAgendaOperation op = null;
            if (this.lastSaveFilter == this.saveAgendaDocumentFilter) {
                op = new SaveAgendaOperation(ag, f, this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SAVEOPERATIONNAME, new Object[]{f.getName()}));
            } else if (this.lastSaveFilter == this.textFileFilter) {
                SaveAgendaTextOperation sop = new SaveAgendaTextOperation(ag, f, this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SAVEOPERATIONNAME, new Object[]{f.getName()}));
                sop.setExpandCompoundActions(!this.terminal.getClient().isConnected() || this.isChair());
                op = sop;
            }
            if (asynchronous) {
                op.addOperationListener((OperationListener)new OperationAdapter(){

                    public void progressFinished(OperationEvent e) {
                        OpenDocumentAPI api;
                        String prefix = AgendaBean.this.module.getPrefix();
                        Preferences prefs = AgendaBean.this.module.getPreferences();
                        int maxPlanSize = AgendaPreferences.getMaxPlanSize(prefix, prefs);
                        Operation op = e.getOperation();
                        Agenda ag = (Agenda)op.getObject();
                        File f = ag.getFile();
                        if (f != null && f.length() >= (long)(maxPlanSize * 1024 * 1024)) {
                            ModalDialog.showMessageDialog((Component)AgendaBean.this, (Object)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SAFESIZEEXCEEDEDMESSAGE, new Object[]{maxPlanSize}), (String)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SAFESIZEEXCEEDEDTITLE), (int)2);
                        }
                        if ((api = (OpenDocumentAPI)AgendaBean.this.imps.findBest(OpenDocumentAPI.class)) != null && f != null) {
                            api.documentOpened(f);
                        }
                    }

                    public void progressError(OperationEvent e) {
                        ModalDialog.showMessageDialog((Component)AgendaBean.this, (Object)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SAVEAGENDAFAILEDMESSAGE), (String)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SAVEAGENDAFAILEDTITLE), (int)0);
                    }
                });
                op.start();
                OperationDialog.trackProgress((Operation)op, (Component)this);
            } else {
                op.run();
                OpenDocumentAPI api = (OpenDocumentAPI)this.imps.findBest(OpenDocumentAPI.class);
                if (api != null) {
                    api.documentOpened(f);
                }
            }
        }
        return true;
    }

    private File getSaveFile(Agenda agenda) {
        File f = new File(this.lastDirectory, agenda.getName());
        CFileChooser ch = new CFileChooser(this.lastDirectory);
        ch.setDialogTitle(this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SAVEAGENDATITLE));
        ch.removeChoosableFileFilter(ch.getAcceptAllFileFilter());
        boolean canSaveNative = false;
        if (!this.terminal.getClient().isConnected() || this.isChair()) {
            ch.addChoosableFileFilter((FileFilter)this.saveAgendaDocumentFilter);
            canSaveNative = true;
        }
        ch.addChoosableFileFilter((FileFilter)this.textFileFilter);
        if (canSaveNative) {
            ch.setFileFilter(this.lastSaveFilter);
        }
        ch.setSelectedFile(f);
        if (ch.showSaveDialog((Component)this.parentProvider.getDialogParent()) != 0) {
            return null;
        }
        this.lastDirectory = ch.getCurrentDirectory();
        this.lastSaveFilter = ch.getFileFilter();
        f = ch.getSelectedFile();
        String name = f.getName();
        if (this.lastSaveFilter == this.saveAgendaDocumentFilter && !name.endsWith(".elpx")) {
            f = new File(f.getParentFile(), name + ".elpx");
        } else if (this.lastSaveFilter == this.textFileFilter && !name.endsWith(".txt")) {
            f = new File(f.getParentFile(), name + ".txt");
        }
        if (f.exists()) {
            int answer = ModalDialog.showConfirmDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_AGENDAFILEEXISTSQUESTION, new Object[]{f.getName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_AGENDAFILEEXISTSTITLE), (int)0, (int)3);
            switch (answer) {
                case 0: {
                    if (f.delete()) break;
                    ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_REPLACEAGENDAFILEFAILEDMESSAGE, new Object[]{f.getName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_REPLACEAGENDAFILEFAILEDTITLE), (int)0);
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return f;
    }

    void doPrintAgenda() {
        if (this.view != 2 && this.view != 3) {
            return;
        }
        Agenda ag = this.editorPanel.getAgenda();
        if (this.isProtected() && !this.isMe(ag.getEditor())) {
            return;
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat format = job.defaultPage();
        Book bk = this.editorPanel.getPrintingView(format);
        job.setPageable(bk);
        if (!job.printDialog()) {
            return;
        }
        try {
            job.print();
        }
        catch (PrinterException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_PRINTAGENDAFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_PRINTAGENDAFAILEDTITLE), (int)0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    void doDeleteAgenda() {
        if (this.view != 1) {
            return;
        }
        Agenda[] ags = this.getTargetedAgendas();
        if (ags == null) return;
        if (ags.length == 0) {
            return;
        }
        String agendaQuestion = ags.length > 1 ? this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONFIRMDELETEAGENDASQUESTION) : this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONFIRMDELETEAGENDAQUESTION);
        int answer = ModalDialog.showConfirmDialog((Component)this, (Object)agendaQuestion, (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONFIRMDELETEAGENDATITLE), (int)0, (int)3);
        if (answer != 0) {
            return;
        }
        try {
            int i = 0;
            while (i < ags.length) {
                Transfer[] tfrs = ags[i].getTransfers(1);
                if (tfrs != null && tfrs.length != 0) {
                    for (int j = 0; j < tfrs.length; ++j) {
                        tfrs[j].cancel();
                    }
                } else if (this.terminal.getClient().isConnected()) {
                    this.sendDeleteAgendaMessage(ags[i]);
                } else {
                    this.performDeleteAgenda(ags[i].getID(), (short)-32767);
                }
                ++i;
            }
            return;
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DELETEAGENDAFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DELETEAGENDAFAILEDTITLE), (int)0);
        }
    }

    void doRenameAgenda() {
        if (this.view != 1) {
            return;
        }
        try {
            Agenda[] ags = this.getTargetedAgendas();
            if (ags != null && ags.length == 1) {
                Agenda ag = ags[0];
                String name = ModalDialog.showInputDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_RENAMEAGENDAPROMPT), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_RENAMEAGENDATITLE), (int)3, (String)ag.getName());
                if (name != null && name.length() != 0) {
                    if (this.terminal.getClient().isConnected()) {
                        this.sendChangeAgendaMessage(ag, "filename", name);
                    } else {
                        this.performChangeAgenda(ag, "filename", name);
                    }
                }
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_RENAMEAGENDAFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_RENAMEAGENDAFAILEDTITLE), (int)0);
        }
    }

    void doActivateAgenda() {
        try {
            int answer;
            if (!this.terminal.getClient().isConnected()) {
                return;
            }
            Agenda[] ags = this.getTargetedAgendas();
            if (ags == null || ags.length != 1) {
                return;
            }
            Agenda ag = this.library.getActiveAgenda();
            if (ag != null && (answer = ModalDialog.showConfirmDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONFIRMACTIVATEAGENDAQUESTION, new Object[]{ag.getName(), ags[0].getName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONFIRMACTIVATEAGENDATITLE), (int)0, (int)3)) != 0) {
                return;
            }
            this.sendActivateAgendaMessage(ags[0]);
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ACTIVATEAGENDAFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ACTIVATEAGENDAFAILEDTITLE), (int)0);
        }
    }

    void doDeactivateAgenda() {
        try {
            if (!this.terminal.getClient().isConnected()) {
                return;
            }
            Agenda[] ags = this.getTargetedAgendas();
            if (ags == null || ags.length != 1) {
                return;
            }
            if (!this.library.isActiveAgenda(ags[0])) {
                return;
            }
            this.sendDeactivateAgendaMessage(ags[0]);
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DEACTIVATEAGENDAFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DEACTIVATEAGENDAFAILEDTITLE), (int)0);
        }
    }

    void doViewAgenda() {
        if (this.view != 1) {
            return;
        }
        try {
            Agenda[] ags = this.libraryPanel.getSelectedAgendas();
            if (ags.length != 1) {
                return;
            }
            Agenda ag = ags[0];
            if (this.terminal.getClient().isConnected()) {
                if (!ag.isTransferring(1)) {
                    this.sendDownloadDefinitionRequestMessage(AgendaBean.newDownloadID(), ag);
                }
            } else {
                this.performDefineAgenda(ag);
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DEFINEAGENDAFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DEFINEAGENDAFAILEDTITLE), (int)0);
        }
    }

    void doEditAgenda() {
        if (this.view != 2 && this.view != 3) {
            return;
        }
        try {
            Agenda ag = this.editorPanel.getAgenda();
            if (ag == null) {
                return;
            }
            if (this.terminal.getClient().isConnected()) {
                this.sendRequestEditAgendaMessage(ag);
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_EDITAGENDAFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_EDITAGENDAFAILEDTITLE), (int)0);
        }
    }

    void doUneditAgenda() {
        if (this.view != 2 && this.view != 3) {
            return;
        }
        try {
            Agenda ag = this.editorPanel.getAgenda();
            if (ag == null) {
                return;
            }
            int answer = ModalDialog.showConfirmDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONFIRMUNEDITAGENDAQUESTION, new Object[]{ag.getName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONFIRMUNEDITAGENDATITLE), (int)0, (int)3);
            if (answer != 0) {
                return;
            }
            if (this.terminal.getClient().isConnected()) {
                this.sendEditAgendaMessage(ag, (short)-32767);
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_UNEDITAGENDAFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_UNEDITAGENDAFAILEDTITLE), (int)0);
        }
    }

    boolean doCloseAgenda(boolean unload) {
        if (!this.canCloseAgenda()) {
            return false;
        }
        if (unload) {
            this.closeAgenda();
        }
        return true;
    }

    private boolean canCloseAgenda() {
        if (this.view != 2 && this.view != 3) {
            return true;
        }
        Agenda ag = this.editorPanel.getAgenda();
        if (ag == null) {
            return true;
        }
        if (!this.terminal.getClient().isConnected() && ag.isModified()) {
            int answer = ModalDialog.showConfirmDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SAVEAGENDAQUESTION, new Object[]{ag.getName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SAVEAGENDATITLE), (int)1, (int)3);
            switch (answer) {
                case 0: {
                    if (this.doSaveAgenda(false, false)) break;
                    return false;
                }
                case 1: {
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private void closeAgenda() {
        if (this.view != 2 && this.view != 3) {
            return;
        }
        try {
            Agenda ag = this.editorPanel.getAgenda();
            if (ag == null) {
                return;
            }
            if (!this.terminal.getClient().isConnected() && ag.isNew()) {
                this.library.removeAgenda(ag, (short)-32767);
            }
            if (this.canViewLibrary()) {
                this.setView(1);
            }
            this.editorPanel.setAgenda(null);
            if (this.terminal.getClient().isConnected()) {
                if (ag.getEditor() == this.terminal.getClient().getAddress()) {
                    this.sendEditAgendaMessage(ag, (short)-32767);
                }
                this.sendReleaseDefinitionMessage(ag);
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CLOSEAGENDAFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CLOSEAGENDAFAILEDTITLE), (int)0);
        }
    }

    void doEditFiles() {
        Agenda ag = this.editorPanel.getAgenda();
        if (ag == null) {
            return;
        }
        AgendaItem[] its = this.editorPanel.getSelectedItems();
        if (its == null || its.length == 0 || !(its[0] instanceof AgendaFile)) {
            return;
        }
        OpenDocumentAPI api = (OpenDocumentAPI)this.imps.findBest(OpenDocumentAPI.class);
        if (api == null) {
            return;
        }
        for (int i = 0; i < its.length; ++i) {
            AgendaFile file = (AgendaFile)its[i];
            File f = new File(file.getPath());
            if (!f.exists()) continue;
            api.openDocument(f);
        }
    }

    void doAddTopic() {
        AgendaTopic top = new AgendaTopic();
        top.setName(this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DEFAULTTOPICNAME));
        this.doAddTopic(top);
    }

    void doAddTopic(AgendaTopic topic) {
        if (this.view != 2) {
            return;
        }
        Agenda ag = this.editorPanel.getAgenda();
        InsertionLocation loc = this.getInsertionLocation(ag, (AgendaNode)topic);
        this.editorPanel.clearNodeSelection();
        this.editorPanel.requestFocusInAgenda();
        this.addItem(ag, (AgendaItem)topic, loc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActionPaletteVisible(boolean visible) {
        AgendaBean agendaBean = this;
        synchronized (agendaBean) {
            if (this.actionPalette == null) {
                if (!visible) {
                    return;
                }
                this.actionPalette = new ActionDialog(true);
                this.actionPalette.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentShown(ComponentEvent e) {
                        AgendaPreferences.setActionPaletteVisible(AgendaBean.this.module.getPrefix(), AgendaBean.this.module.getPreferences(), true);
                        AgendaBean.this.firePropertyChange(AgendaBean.PROP_ACTION_PALETTE_VISIBLE, false, true);
                    }

                    @Override
                    public void componentHidden(ComponentEvent e) {
                        AgendaPreferences.setActionPaletteVisible(AgendaBean.this.module.getPrefix(), AgendaBean.this.module.getPreferences(), false);
                        AgendaBean.this.firePropertyChange(AgendaBean.PROP_ACTION_PALETTE_VISIBLE, true, false);
                    }
                });
                String prefix = this.module.getPrefix();
                Preferences prefs = this.module.getPreferences();
                Rectangle b = AgendaPreferences.getActionPaletteBounds(prefix, prefs);
                if (b != null) {
                    this.actionPalette.setBounds(b);
                }
            }
        }
        this.actionPalette.setVisible(visible);
    }

    boolean isActionPaletteVisible() {
        return this.actionPalette != null && this.actionPalette.isVisible();
    }

    void doAddAction() {
        new ActionDialog(false).show();
    }

    void doAddAction(Class commandInterface) {
        if (this.view != 2) {
            return;
        }
        AgendaAction act = new AgendaAction();
        act.setDescription(commandInterface == null ? this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DEFAULTCOMPOUNDACTIONDESCRIPTION) : this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DEFAULTACTIONDESCRIPTION));
        if (commandInterface != null) {
            Actions.setupExecutable((AgendaExecutable)act, commandInterface);
            Actions.setupActionDescription(act);
        }
        this.doAddAction(act);
    }

    void doAddFileActions(AgendaFile file, AgendaNode referenceNode) {
        Agenda ag = this.editorPanel.getAgenda();
        if (!file.isAutoload()) {
            File f = new File(file.getPath());
            String[] parts = AgendaUtils.parseFileName((File)f);
            ActionInfo info = Actions.getBestLoadAction(parts[1]);
            AgendaAction act = new AgendaAction();
            Actions.setupExecutable((AgendaExecutable)act, info.getCommandInterface());
            Actions.setupActionDescription(act, file.getName());
            act.setCommandParameter("file", file.getName());
            this.addItem(ag, (AgendaItem)act, this.getFollowingLocation(ag, (AgendaItem)act, (AgendaItem)referenceNode));
        } else {
            String cmdName = file.getCommandName();
            ActionInfo info = Actions.getAction(cmdName);
            Class cmd = info.getCommandInterface();
            if (cmd == LoadMultimediaCommand.class) {
                this.addMultimediaActions(file, ag, referenceNode);
            } else if (cmd == LoadQuizCommand.class) {
                try {
                    Quiz[] qzs = this.getQuizzes(new File(file.getPath()));
                    AgendaNode node = referenceNode;
                    for (int i = 0; i < qzs.length; ++i) {
                        node = this.addQuizActions(qzs[i], ag, node);
                    }
                }
                catch (IOException ex) {
                    ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ADDQUIZACTIONSFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ADDQUIZACTIONSFAILEDTITLE), (int)0);
                }
            } else if (cmd == LoadFileCommand.class) {
                AgendaAction act = new AgendaAction();
                Actions.setupExecutable((AgendaExecutable)act, PromptToSaveFileCommand.class);
                Actions.setupActionDescription(act, file.getName());
                act.setCommandParameter("fileName", file.getName());
                this.addItem(ag, (AgendaItem)act, this.getFollowingLocation(ag, (AgendaItem)act, (AgendaItem)referenceNode));
                file.setCommandParameter("promptParticipants", "false");
            } else if (cmd == LoadWhiteboardCommand.class) {
                AgendaTopic top = new AgendaTopic();
                top.setName(AgendaUtils.parseFileName((String)file.getName())[0]);
                this.addItem(ag, (AgendaItem)top, this.getFollowingLocation(ag, (AgendaItem)top, (AgendaItem)referenceNode));
                try {
                    WhiteboardScreenNode root = this.getWhiteboard(new File(file.getPath()));
                    if (root != null) {
                        AgendaTopic node = top;
                        for (int i = 0; i < root.getChildCount(); ++i) {
                            node = this.addWhiteboardScreenActions(root.getChild(i), ag, (AgendaNode)node);
                        }
                    }
                }
                catch (IOException ex) {
                    ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ADDWHITEBOARDSCREENACTIONSFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ADDWHITEBOARDSCREENACTIONSFAILEDTITLE), (int)0);
                }
            }
        }
    }

    private void addMultimediaActions(AgendaFile file, Agenda agenda, AgendaNode referenceNode) {
        AgendaAction act1 = new AgendaAction();
        Actions.setupExecutable((AgendaExecutable)act1, PlayMultimediaCommand.class);
        String name = file.getName();
        act1.setCommandParameter("fileName", name);
        Actions.setupActionDescription(act1, name);
        this.addItem(agenda, (AgendaItem)act1, this.getFollowingLocation(agenda, (AgendaItem)act1, (AgendaItem)referenceNode));
        AgendaAction act2 = new AgendaAction();
        Actions.setupExecutable((AgendaExecutable)act2, StopMultimediaCommand.class);
        Actions.setupActionDescription(act2);
        this.addItem(agenda, (AgendaItem)act2, this.getFollowingLocation(agenda, (AgendaItem)act2, (AgendaItem)act1));
    }

    private AgendaAction addQuizActions(Quiz quiz, Agenda agenda, AgendaNode referenceNode) {
        AgendaAction act1 = new AgendaAction();
        Actions.setupExecutable((AgendaExecutable)act1, StartQuizCommand.class);
        String name = quiz.getName();
        act1.setCommandParameter("quizName", name);
        Actions.setupActionDescription(act1, name);
        this.addItem(agenda, (AgendaItem)act1, this.getFollowingLocation(agenda, (AgendaItem)act1, (AgendaItem)referenceNode));
        AgendaAction act2 = new AgendaAction();
        Actions.setupExecutable((AgendaExecutable)act2, StopQuizCommand.class);
        Actions.setupActionDescription(act2);
        this.addItem(agenda, (AgendaItem)act2, this.getFollowingLocation(agenda, (AgendaItem)act2, (AgendaItem)act1));
        return act2;
    }

    private AgendaAction addWhiteboardScreenActions(WhiteboardScreenNode screenNode, Agenda agenda, AgendaNode referenceNode) {
        AgendaAction act = new AgendaAction();
        Actions.setupExecutable((AgendaExecutable)act, ChangeWhiteboardScreenCommand.class);
        String screenName = screenNode.getName();
        act.setCommandParameter("screen", screenName);
        act.setNote(screenNode.getPresenterNotes());
        Actions.setupActionDescription(act, screenName);
        this.addItem(agenda, (AgendaItem)act, this.getFollowingLocation(agenda, (AgendaItem)act, (AgendaItem)referenceNode));
        for (int i = 0; i < screenNode.getChildCount(); ++i) {
            act = this.addWhiteboardScreenActions(screenNode.getChild(i), agenda, (AgendaNode)act);
        }
        return act;
    }

    void doAddAction(AgendaAction action) {
        Agenda ag = this.editorPanel.getAgenda();
        InsertionLocation loc = this.getInsertionLocation(ag, (AgendaNode)action);
        this.editorPanel.clearNodeSelection();
        this.editorPanel.requestFocusInAgenda();
        this.addItem(ag, (AgendaItem)action, loc);
    }

    void doAddText() {
        AgendaText txt = new AgendaText();
        txt.setText(this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DEFAULTTEXTITEM));
        this.doAddText(txt);
    }

    void doAddText(AgendaText text) {
        if (this.view != 2) {
            return;
        }
        Agenda ag = this.editorPanel.getAgenda();
        InsertionLocation loc = this.getInsertionLocation(ag, (AgendaNode)text);
        this.editorPanel.clearNodeSelection();
        this.editorPanel.requestFocusInAgenda();
        this.addItem(ag, (AgendaItem)text, loc);
    }

    void doAddFile() {
        if (this.view != 2) {
            return;
        }
        CFileChooser ch = new CFileChooser();
        ch.setMultiSelectionEnabled(true);
        ch.setCurrentDirectory(this.lastDirectory);
        if (ch.showOpenDialog((Component)this.parentProvider.getDialogParent()) != 0) {
            return;
        }
        this.lastDirectory = ch.getCurrentDirectory();
        this.doAddFiles(ch.getSelectedFiles());
    }

    void doAddFiles(File[] files) {
        this.doAddFiles(files, false, null);
    }

    void doAddFiles(File[] files, AgendaNode referenceNode) {
        this.doAddFiles(files, true, referenceNode);
    }

    private void doAddFiles(File[] files, boolean withActions, AgendaNode referenceNode) {
        Agenda ag = this.editorPanel.getAgenda();
        this.editorPanel.clearFileSelection();
        for (int i = 0; i < files.length; ++i) {
            int j;
            File file = files[i];
            String ext = AgendaUtils.parseFileName((File)file)[1];
            if (ext != null) {
                FileConversionAPI api;
                FileConversionAPI converter = null;
                List apis = this.imps.findAll(FileConversionAPI.class);
                for (j = 0; j < apis.size(); ++j) {
                    FileConversionAPI api2 = (FileConversionAPI)apis.get(j);
                    if (!api2.canConvert(ext)) continue;
                    converter = api2;
                    break;
                }
                if (converter == null && (api = (FileConversionAPI)this.imps.findBest(FileConversionAPI.class)) != null && api.canConvert(ext)) {
                    converter = api;
                }
                if (converter != null) {
                    int optionType = i == files.length - 1 ? 0 : 1;
                    optionType = 0;
                    int answer = ModalDialog.showConfirmDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONVERTFILETOWHITEBOARDQUESTION, new Object[]{file.getName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONVERTFILETOWHITEBOARDTITLE), (int)optionType, (int)3);
                    switch (answer) {
                        case 2: {
                            return;
                        }
                        case 0: {
                            try {
                                File wbd = converter.convert(file, "wbd", null);
                                if (wbd == null) {
                                    return;
                                }
                                file = wbd;
                                ext = AgendaUtils.parseFileName((File)file)[1];
                            }
                            catch (IOException ex) {
                                ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONVERTFILETOWHITEBOARDFAILEDMESSAGE, new Object[]{file.getName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONVERTFILETOWHITEBOARDFAILEDTITLE), (int)0);
                            }
                            break;
                        }
                    }
                }
            }
            AgendaFile af = null;
            boolean alreadyEmbedded = false;
            for (j = 0; j < ag.getFileCount(); ++j) {
                AgendaFile af2 = ag.getFile(j);
                File f2 = new File(af2.getPath());
                if (f2.equals(file)) {
                    alreadyEmbedded = true;
                    break;
                }
                if (!f2.getName().equalsIgnoreCase(file.getName())) continue;
                af = af2;
                break;
            }
            if (alreadyEmbedded) continue;
            boolean replace = false;
            if (af != null) {
                int optionType = i == files.length - 1 ? 0 : 1;
                optionType = 0;
                int answer = ModalDialog.showConfirmDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ADDREPLACEFILEQUESTION, new Object[]{new File(af.getPath()).getName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ADDREPLACEFILETITLE), (int)optionType, (int)3);
                switch (answer) {
                    case 2: {
                        return;
                    }
                    case 0: {
                        replace = true;
                        break;
                    }
                }
            }
            if (af == null) {
                af = new AgendaFile();
                af.setName(file.getName());
                af.setPath(file.getAbsolutePath());
                af.setSize(file.length());
                ActionInfo act = Actions.getBestLoadAction(ext);
                Actions.setupExecutable((AgendaExecutable)af, act.getCommandInterface());
                if (!withActions) {
                    this.editorPanel.requestFocusInFiles();
                }
                if (!this.addItem(ag, (AgendaItem)af, null)) {
                    break;
                }
            } else if (replace) {
                File f = new File(af.getPath());
                if (f.exists() && f.getAbsolutePath().startsWith(System.getProperty("java.io.tmpdir")) && !f.delete()) {
                    ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ADDREPLACEFILEFAILEDMESSAGE, new Object[]{new File(af.getPath()).getName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ADDREPLACEFILEFAILEDTITLE), (int)0);
                }
                af.setPath(file.getAbsolutePath());
                af.setSize(file.length());
            }
            if (!withActions) continue;
            this.doAddFileActions(af, referenceNode);
        }
    }

    private boolean addItem(Agenda agenda, AgendaItem item, InsertionLocation location) {
        try {
            AgendaItem parent;
            if (location != null && location.nodeLosingChildren != null) {
                parent = item;
                AgendaNode[] children = null;
                AgendaNode grievingNode = location.nodeLosingChildren;
                if (grievingNode instanceof AgendaTopic) {
                    children = ((AgendaTopic)grievingNode).getNodes();
                } else if (grievingNode instanceof AgendaAction) {
                    children = ((AgendaAction)grievingNode).getActions();
                }
                for (int i = location.firstReparentedChildIndex; i < children.length; ++i) {
                    AgendaNode child = children[i];
                    if (this.terminal.getClient().isConnected()) {
                        this.sendNewItemMessage(agenda, (AgendaItem)child, parent, -1);
                        continue;
                    }
                    this.performNewItem(agenda, (AgendaItem)child, parent, -1);
                }
            }
            parent = null;
            int index = -1;
            if (location != null) {
                parent = location.parent;
                index = location.index;
            }
            if (this.terminal.getClient().isConnected()) {
                this.sendNewItemMessage(agenda, item, parent, index);
            } else {
                this.performNewItem(agenda, item, parent, index);
            }
            return true;
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_NEWITEMFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_NEWITEMFAILEDTITLE), (int)0);
            return false;
        }
    }

    void doRemoveItems() {
        if (this.view != 2) {
            return;
        }
        AgendaItem[] its = this.editorPanel.getSelectedItems();
        if (its == null || its.length == 0) {
            return;
        }
        int answer = ModalDialog.showConfirmDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONFIRMDELETEITEMQUESTION), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONFIRMDELETEITEMTITLE), (int)0, (int)3);
        if (answer != 0) {
            return;
        }
        this.doRemoveItems(its);
    }

    void doRemoveItems(AgendaItem[] items) {
        try {
            Agenda ag = this.editorPanel.getAgenda();
            if (this.terminal.getClient().isConnected()) {
                for (int i = items.length - 1; i >= 0; --i) {
                    this.sendDeleteItemMessage(ag, items[i]);
                }
            } else {
                for (int i = items.length - 1; i >= 0; --i) {
                    this.performDeleteItem(ag, items[i]);
                }
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DELETEITEMFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DELETEITEMFAILEDTITLE), (int)0);
        }
    }

    void doSaveFiles() {
        if (this.view != 2) {
            return;
        }
        AgendaItem[] its = this.editorPanel.getSelectedItems();
        if (its == null) {
            return;
        }
        ArrayList<AgendaItem> list = new ArrayList<AgendaItem>();
        for (int i = 0; i < its.length; ++i) {
            AgendaItem it = its[i];
            if (!(it instanceof AgendaFile)) continue;
            list.add(it);
        }
        if (list.size() == 0) {
            return;
        }
        AgendaFile[] files = list.toArray(new AgendaFile[0]);
        String[] names = new String[files.length];
        for (int i = files.length - 1; i >= 0; --i) {
            AgendaFile af = files[i];
            String[] pair = AgendaUtils.parseFileName((String)af.getName());
            String ext = AgendaUtils.parseFileName((File)new File(af.getPath()))[1];
            if (ext != null) {
                pair[1] = ext;
            }
            names[i] = pair[0] + "." + pair[1];
        }
        File[] fs = this.getSaveFolder(names);
        if (fs == null) {
            return;
        }
        try {
            File f;
            Agenda ag = this.editorPanel.getAgenda();
            if (this.terminal.getClient().isConnected()) {
                for (int i = fs.length - 1; i >= 0; --i) {
                    f = fs[i];
                    if (f == null) continue;
                    this.sendDownloadFileRequestMessage(AgendaBean.newDownloadID(), ag, files[i], f);
                }
            } else {
                for (int i = fs.length - 1; i >= 0; --i) {
                    f = fs[i];
                    if (f == null) continue;
                    this.performSaveFile(ag, files[i], f);
                }
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DOWNLOADFILEFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DOWNLOADFILEFAILEDTITLE), (int)0);
        }
    }

    private File[] getSaveFolder(String[] fileNames) {
        CFileChooser ch = new CFileChooser(this.lastDirectory);
        ch.setDialogTitle(this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SAVEFILESTITLE));
        ch.setApproveButtonText(this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SAVEFILESCHOOSEBUTTON));
        ch.setFileSelectionMode(1);
        ch.removeChoosableFileFilter(ch.getAcceptAllFileFilter());
        ch.addChoosableFileFilter((FileFilter)new FolderFilter((JFileChooser)ch));
        if (ch.showOpenDialog((Component)this.parentProvider.getDialogParent()) != 0) {
            return null;
        }
        this.lastDirectory = ch.getCurrentDirectory();
        File fo = ch.getSelectedFile();
        ArrayList<File> files = new ArrayList<File>();
        for (String fileName : fileNames) {
            files.add(new File(fo, fileName));
        }
        ArrayList<File> existingFiles = new ArrayList<File>();
        for (int i = 0; i < files.size(); ++i) {
            File f = (File)files.get(i);
            if (!f.exists()) continue;
            existingFiles.add(f);
        }
        if (existingFiles.size() != 0) {
            StringBuffer list = new StringBuffer();
            for (File f : existingFiles) {
                if (list.length() != 0) {
                    list.append("\n");
                }
                list.append("- ");
                list.append(f.getName());
            }
            int answer = ModalDialog.showConfirmDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_FILESEXISTQUESTION, new Object[]{fo.getName(), list.toString()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_FILESEXISTTITLE), (int)1, (int)3);
            switch (answer) {
                case 0: {
                    for (File f : existingFiles) {
                        if (f.delete()) continue;
                        ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SAVEREPLACEFILEFAILEDMESSAGE, new Object[]{f.getName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SAVEREPLACEFILEFAILEDTITLE), (int)0);
                        return null;
                    }
                    break;
                }
                case 1: {
                    for (File f : existingFiles) {
                        files.remove(f);
                    }
                    if (files.size() != 0) break;
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return files.toArray(new File[0]);
    }

    void doMoveItemUp() {
        AgendaNode node;
        InsertionLocation loc;
        AgendaFile file;
        AgendaFile prev;
        AgendaItem it;
        if (this.view != 2) {
            return;
        }
        Agenda ag = this.editorPanel.getAgenda();
        AgendaItem[] its = this.getTargetedItems();
        if (its == null) {
            return;
        }
        List list = AgendaBean.pruneDescendants(its);
        while (list.size() != 0 && !((it = (AgendaItem)list.remove(0)) instanceof AgendaFile ? (prev = ag.getFileBefore(file = (AgendaFile)it)) == null || !this.addItem(ag, (AgendaItem)file, loc = this.getPrecedingLocation(ag, (AgendaItem)file, (AgendaItem)prev)) : it instanceof AgendaNode && ((prev = ag.getNodeBefore(node = (AgendaNode)it, node instanceof AgendaAction)) == null || !this.addItem(ag, (AgendaItem)node, loc = this.getPrecedingLocation(ag, (AgendaItem)node, (AgendaItem)prev))))) {
        }
    }

    void doMoveItemDown() {
        if (this.view != 2) {
            return;
        }
        Agenda ag = this.editorPanel.getAgenda();
        AgendaItem[] its = this.getTargetedItems();
        if (its == null) {
            return;
        }
        List list = AgendaBean.pruneDescendants(its);
        while (list.size() != 0) {
            InsertionLocation loc;
            AgendaItem it = (AgendaItem)list.remove(list.size() - 1);
            if (it instanceof AgendaFile) {
                InsertionLocation loc2;
                AgendaFile file = (AgendaFile)it;
                AgendaFile next = ag.getFileAfter(file);
                if (next != null && this.addItem(ag, (AgendaItem)file, loc2 = this.getFollowingLocation(ag, (AgendaItem)file, (AgendaItem)next))) continue;
                break;
            }
            if (!(it instanceof AgendaNode)) continue;
            AgendaNode node = (AgendaNode)it;
            boolean intoCompound = node instanceof AgendaAction;
            AgendaNode next = ag.getNodeAfter(node, intoCompound);
            while (next != null && node.isAncestorOf(next)) {
                next = ag.getNodeAfter(next, intoCompound);
            }
            if (next != null && this.addItem(ag, (AgendaItem)node, loc = this.getFollowingLocation(ag, (AgendaItem)node, (AgendaItem)next))) continue;
            break;
        }
    }

    void doMoveItemLeft() {
        AgendaNode node;
        InsertionLocation loc;
        AgendaItem it;
        if (this.view != 2) {
            return;
        }
        Agenda ag = this.editorPanel.getAgenda();
        AgendaItem[] its = this.getTargetedItems();
        if (its == null) {
            return;
        }
        List list = AgendaBean.pruneDescendants(its);
        while (list.size() != 0 && (!((it = (AgendaItem)list.remove(list.size() - 1)) instanceof AgendaNode) || (loc = this.getDemotedLocation(ag, node = (AgendaNode)it)) == null || this.addItem(ag, (AgendaItem)node, loc))) {
        }
    }

    void doMoveItemRight() {
        AgendaNode node;
        InsertionLocation loc;
        AgendaItem it;
        if (this.view != 2) {
            return;
        }
        Agenda ag = this.editorPanel.getAgenda();
        AgendaItem[] its = this.getTargetedItems();
        if (its == null) {
            return;
        }
        List list = AgendaBean.pruneDescendants(its);
        while (list.size() != 0 && (!((it = (AgendaItem)list.remove(0)) instanceof AgendaNode) || (loc = this.getPromotedLocation(ag, node = (AgendaNode)it)) == null || this.addItem(ag, (AgendaItem)node, loc))) {
        }
    }

    static List pruneDescendants(AgendaItem[] items) {
        ArrayList<AgendaItem> list = new ArrayList<AgendaItem>();
        for (int i = 0; i < items.length; ++i) {
            AgendaItem it = items[i];
            boolean descendant = false;
            if (it instanceof AgendaNode) {
                for (AgendaItem p : list) {
                    if (!(p instanceof AgendaNode) || !((AgendaNode)p).isAncestorOf((AgendaNode)it)) continue;
                    descendant = true;
                    break;
                }
            }
            if (descendant) continue;
            list.add(it);
        }
        return list;
    }

    void doPreviousNode() {
        if (this.view != 2 && this.view != 3) {
            return;
        }
        Agenda ag = this.editorPanel.getAgenda();
        AgendaNode prev = ag.getPreviousNode(false);
        if (prev instanceof AgendaAction && !((AgendaAction)prev).isCommandAvailable()) {
            prev = ag.getNodeBefore(prev, false);
        }
        try {
            if (this.terminal.getClient().isConnected() && this.isMe(ag.getEditor())) {
                int id = prev != null ? prev.getID() : -1;
                this.sendChangeAgendaMessage(ag, "currentitem", String.valueOf(id));
                String prefix = this.module.getPrefix();
                Preferences prefs = this.module.getPreferences();
                if (AgendaPreferences.isProgressingBackwardExecutesNodes(prefix, prefs) && prev != null) {
                    if (!(prev.isCovered() || prev instanceof AgendaTopic && ((AgendaTopic)prev).getNodeCount() != 0)) {
                        this.sendChangeItemMessage(ag, (AgendaItem)prev, "covered", "true");
                    }
                    if (prev instanceof AgendaAction) {
                        SwingRunnerSupport.invokeLater((Runnable)new ExecutableTask(this.module, this.i18n, ag, (AgendaExecutable)((AgendaAction)prev), AgendaPreferences.isSuppressActionErrors(prefix, prefs)));
                    }
                }
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_PREVIOUSNODEFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_PREVIOUSNODEFAILEDTITLE), (int)0);
        }
    }

    void doNextNode() {
        if (this.view != 2 && this.view != 3) {
            return;
        }
        Agenda ag = this.editorPanel.getAgenda();
        AgendaNode next = ag.getNextNode(false);
        boolean tryAgain = false;
        do {
            if (next instanceof AgendaAction && !((AgendaAction)next).isCommandAvailable()) {
                next = ag.getNodeAfter(next, false);
                tryAgain = true;
                continue;
            }
            tryAgain = false;
        } while (tryAgain);
        try {
            if (this.terminal.getClient().isConnected() && this.isMe(ag.getEditor())) {
                int id = next != null ? next.getID() : -1;
                this.sendChangeAgendaMessage(ag, "currentitem", String.valueOf(id));
                AgendaNode rnode = ag.getRunningNode();
                if (!(rnode == null || next != null && rnode.isAncestorOf(next))) {
                    this.sendStopTimerMessage(ag, rnode);
                }
                if (next != null) {
                    if (!(next.isCovered() || next instanceof AgendaTopic && ((AgendaTopic)next).getNodeCount() != 0)) {
                        this.sendChangeItemMessage(ag, (AgendaItem)next, "covered", "true");
                    }
                    if (ag.isTimeTrackingAutomatic() && next.getDuration() != 0 && (rnode == null || !rnode.isAncestorOf(next))) {
                        this.sendStartTimerMessage(ag, next);
                    }
                    if (next instanceof AgendaAction) {
                        String prefix = this.module.getPrefix();
                        Preferences prefs = this.module.getPreferences();
                        SwingRunnerSupport.invokeLater((Runnable)new ExecutableTask(this.module, this.i18n, ag, (AgendaExecutable)((AgendaAction)next), AgendaPreferences.isSuppressActionErrors(prefix, prefs)));
                    }
                } else {
                    ModalDialog.showMessageDialogTimeout((int)30, (Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_NEXTNODEENDREACHEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_NEXTNODEENDREACHEDTITLE), (int)1);
                }
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_NEXTNODEFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_NEXTNODEFAILEDTITLE), (int)0);
        }
    }

    void doCurrentNode(Agenda agenda, AgendaNode node) {
        String prefix = this.module.getPrefix();
        Preferences prefs = this.module.getPreferences();
        boolean execute = AgendaPreferences.isProgressingRandomlyExecutesNodes(prefix, prefs);
        this.makeNodeCurrent(agenda, node, execute);
    }

    private void makeNodeCurrent(Agenda agenda, AgendaNode node, boolean execute) {
        if (this.view != 2 && this.view != 3) {
            return;
        }
        try {
            if (this.terminal.getClient().isConnected()) {
                int id;
                int n = id = node != null ? node.getID() : -1;
                if (node instanceof AgendaAction && !((AgendaAction)node).isCommandAvailable()) {
                    return;
                }
                this.sendChangeAgendaMessage(agenda, "currentitem", String.valueOf(id));
                AgendaNode rnode = agenda.getRunningNode();
                if (!(rnode == null || node != null && rnode.isAncestorOf(node))) {
                    this.sendStopTimerMessage(agenda, rnode);
                }
                if (execute && node != null) {
                    if (!(node.isCovered() || node instanceof AgendaTopic && ((AgendaTopic)node).getNodeCount() != 0)) {
                        this.sendChangeItemMessage(agenda, (AgendaItem)node, "covered", "true");
                    }
                    if (agenda.isTimeTrackingAutomatic() && node.getDuration() != 0 && (rnode == null || !rnode.isAncestorOf(node))) {
                        this.sendStartTimerMessage(agenda, node);
                    }
                    if (node instanceof AgendaAction) {
                        String prefix = this.module.getPrefix();
                        Preferences prefs = this.module.getPreferences();
                        SwingRunnerSupport.invokeLater((Runnable)new ExecutableTask(this.module, this.i18n, agenda, (AgendaExecutable)((AgendaAction)node), AgendaPreferences.isSuppressActionErrors(prefix, prefs)));
                    }
                }
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CURRENTNODEFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CURRENTNODEFAILEDTITLE), (int)0);
        }
    }

    void doNodeClick(Agenda agenda, AgendaNode node) {
        Preferences prefs;
        String prefix = this.module.getPrefix();
        if (AgendaPreferences.isClickingNodeMarksAsCurrent(prefix, prefs = this.module.getPreferences())) {
            this.makeNodeCurrent(agenda, node, true);
        } else if (node instanceof AgendaAction) {
            this.clickAction(agenda, (AgendaAction)node);
        }
    }

    private void clickAction(Agenda agenda, AgendaAction action) {
        try {
            String prefix = this.module.getPrefix();
            Preferences prefs = this.module.getPreferences();
            if (action.isCommandAvailable()) {
                SwingRunnerSupport.invokeLater((Runnable)new ExecutableTask(this.module, this.i18n, agenda, (AgendaExecutable)action, AgendaPreferences.isSuppressActionErrors(prefix, prefs)));
            }
            this.sendChangeItemMessage(agenda, (AgendaItem)action, "covered", "true");
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ITEMCOVEREDFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ITEMCOVEREDFAILEDTITLE), (int)0);
        }
    }

    void doDurationClick(Agenda agenda, AgendaNode node) {
        try {
            if (this.terminal.getClient().isConnected()) {
                AgendaNode rnode = agenda.getRunningNode();
                if (node == rnode) {
                    this.sendStopTimerMessage(agenda, node);
                } else if (rnode == null || !rnode.isAncestorOf(node)) {
                    if (rnode != null) {
                        this.sendStopTimerMessage(agenda, rnode);
                    }
                    this.sendStartTimerMessage(agenda, node);
                }
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_TIMERFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_TIMERFAILEDTITLE), (int)0);
        }
    }

    void doToggleCovered(Agenda agenda, AgendaNode node, boolean toggleAll) {
        try {
            if (this.terminal.getClient().isConnected()) {
                boolean covered;
                boolean bl = covered = !node.isCovered();
                if (toggleAll) {
                    for (int i = 0; i < agenda.getNodeCount(); ++i) {
                        this.changeCovered(agenda, agenda.getNode(i), covered);
                    }
                } else {
                    String value = covered ? "true" : "false";
                    this.sendChangeItemMessage(agenda, (AgendaItem)node, "covered", value);
                }
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ITEMCOVEREDFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ITEMCOVEREDFAILEDTITLE), (int)0);
        }
    }

    private void changeCovered(Agenda agenda, AgendaNode node, boolean covered) throws IOException {
        if (node.isCovered() != covered) {
            String value = covered ? "true" : "false";
            this.sendChangeItemMessage(agenda, (AgendaItem)node, "covered", value);
        } else {
            AgendaNode[] nodes = null;
            if (node instanceof AgendaTopic) {
                nodes = ((AgendaTopic)node).getNodes();
            } else if (node instanceof AgendaAction) {
                nodes = ((AgendaAction)node).getActions();
            }
            if (nodes != null) {
                for (int i = 0; i < nodes.length; ++i) {
                    this.changeCovered(agenda, nodes[i], covered);
                }
            }
        }
    }

    void doViewability(boolean viewableByEveryone) {
        if (!this.isChair()) {
            return;
        }
        byte view = this.clients.getProperty("agenda.viewability", (byte)-1);
        if (viewableByEveryone && view != 2) {
            this.clients.setProperty("agenda.viewability", (byte)2);
        } else if (!viewableByEveryone && view != 1) {
            this.clients.setProperty("agenda.viewability", (byte)1);
        }
    }

    void doProtected(boolean protect) {
        if (!this.isChair()) {
            return;
        }
        boolean pro = this.clients.getProperty("agenda.protected", false);
        if (protect != pro) {
            this.clients.setProperty("agenda.protected", new Boolean(protect).booleanValue());
        }
    }

    void doTimeTracking(boolean automatic) {
        if (this.view != 2 && this.view != 3) {
            return;
        }
        if (this.terminal.getClient().isConnected() && !this.isChair()) {
            return;
        }
        Agenda[] ags = this.getTargetedAgendas();
        if (ags == null || ags.length != 1) {
            return;
        }
        if (this.terminal.getClient().isConnected() && ags[0].getEditor() != this.terminal.getClient().getAddress()) {
            return;
        }
        try {
            if (this.terminal.getClient().isConnected()) {
                this.sendChangeAgendaMessage(ags[0], "autotimetracking", automatic ? "true" : "false");
            } else {
                ags[0].setTimeTrackingAutomatic(automatic);
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_AGENDATIMETRACKINGFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_AGENDATIMETRACKINGFAILEDTITLE), (int)0);
        }
    }

    void doSetLabelType(int labelType) {
        if (this.view != 2 && this.view != 3) {
            return;
        }
        if (this.terminal.getClient().isConnected() && !this.isChair()) {
            return;
        }
        Agenda[] ags = this.getTargetedAgendas();
        if (ags == null || ags.length != 1) {
            return;
        }
        if (this.terminal.getClient().isConnected() && ags[0].getEditor() != this.terminal.getClient().getAddress()) {
            return;
        }
        try {
            if (this.terminal.getClient().isConnected()) {
                String type;
                switch (labelType) {
                    case 6: {
                        type = "uppercaseletter";
                        break;
                    }
                    case 5: {
                        type = "lowercaseletter";
                        break;
                    }
                    case 4: {
                        type = "legal";
                        break;
                    }
                    case 3: {
                        type = "number";
                        break;
                    }
                    case 2: {
                        type = "bullet";
                        break;
                    }
                    case 1: {
                        type = "leader";
                        break;
                    }
                    default: {
                        type = "none";
                    }
                }
                this.sendChangeAgendaMessage(ags[0], "labeltype", type);
            } else {
                ags[0].setLabelType(labelType);
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_AGENDALABELTYPEFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_AGENDALABELTYPEFAILEDTITLE), (int)0);
        }
    }

    void doShowIcons(boolean visible) {
        if (this.view != 2 && this.view != 3) {
            return;
        }
        if (this.terminal.getClient().isConnected() && !this.isChair()) {
            return;
        }
        Agenda[] ags = this.getTargetedAgendas();
        if (ags == null || ags.length != 1) {
            return;
        }
        if (this.terminal.getClient().isConnected() && ags[0].getEditor() != this.terminal.getClient().getAddress()) {
            return;
        }
        try {
            if (this.terminal.getClient().isConnected()) {
                this.sendChangeAgendaMessage(ags[0], "showicons", visible ? "true" : "false");
            } else {
                ags[0].setShowingIcons(visible);
            }
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_AGENDASHOWICONSFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_AGENDASHOWICONSFAILEDTITLE), (int)0);
        }
    }

    void updateWindowTitle() {
        Agenda ag;
        if (this.settingWindowTitle) {
            return;
        }
        this.settingWindowTitle = true;
        String title = null;
        if (this.libraryPanel.isVisible()) {
            title = this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_LIBRARYWINDOWTITLE);
        } else if (this.toolBar.getView() != 3) {
            title = this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_AGENDAWINDOWTITLE);
            ag = this.editorPanel.getAgenda();
            if (ag != null) {
                title = title + " - " + ag.getName();
            }
        } else {
            ag = this.editorPanel.getAgenda();
            if (ag != null) {
                title = ag.getName();
            }
        }
        if (title != null) {
            Window w = SwingUtilities.getWindowAncestor(this);
            if (w instanceof JDialog) {
                ((JDialog)w).setTitle(title);
            } else if (w instanceof JFrame) {
                ((JFrame)w).setTitle(title);
            }
        }
        this.settingWindowTitle = false;
    }

    void updateWindowModified() {
        Window w;
        if (this.terminal.getClient().isConnected()) {
            return;
        }
        boolean mod = false;
        if (this.view != 1) {
            Agenda ag = this.editorPanel.getAgenda();
            boolean bl = mod = ag != null && ag.isModified();
        }
        if ((w = SwingUtilities.getWindowAncestor(this)) instanceof CDialog) {
            ((CDialog)w).setModified(mod);
        } else if (w instanceof CFrame) {
            ((CFrame)w).setModified(mod);
        } else if (w instanceof RootPaneContainer) {
            JRootPane root = ((RootPaneContainer)((Object)w)).getRootPane();
            root.putClientProperty("windowModified", mod);
        }
    }

    private InsertionLocation getDemotedLocation(Agenda agenda, AgendaNode node) {
        AgendaAction action;
        int idx;
        AgendaNode p = node.getParent();
        if (p == null) {
            return null;
        }
        int nodeIndex = -1;
        int nodeCount = 0;
        if (p instanceof AgendaTopic) {
            nodeIndex = ((AgendaTopic)p).getNodeIndex(node);
            nodeCount = ((AgendaTopic)p).getNodeCount();
        } else if (p instanceof AgendaAction && ((AgendaAction)p).isCompoundAction() && node instanceof AgendaAction) {
            nodeIndex = ((AgendaAction)p).getActionIndex((AgendaAction)node);
            nodeCount = ((AgendaAction)p).getActionCount();
        }
        if (nodeIndex < nodeCount - 1) {
            boolean canDemote = false;
            if (node instanceof AgendaTopic) {
                canDemote = true;
            } else if (node instanceof AgendaAction && ((AgendaAction)node).isCompoundAction()) {
                boolean allActions = true;
                if (p instanceof AgendaTopic) {
                    AgendaTopic top = (AgendaTopic)p;
                    for (int i = nodeIndex + 1; i < nodeCount; ++i) {
                        if (top.getNode(i) instanceof AgendaAction) continue;
                        allActions = false;
                        break;
                    }
                }
                canDemote = allActions;
            }
            if (!canDemote) {
                return null;
            }
        }
        InsertionLocation loc = new InsertionLocation();
        loc.parent = p.getParent();
        if (loc.parent == null) {
            int idx2 = agenda.getNodeIndex(p) + 1;
            if (idx2 < agenda.getNodeCount()) {
                loc.index = idx2;
            }
        } else if (loc.parent instanceof AgendaTopic) {
            AgendaTopic topic = (AgendaTopic)loc.parent;
            int idx3 = topic.getNodeIndex(p) + 1;
            if (idx3 < topic.getNodeCount()) {
                loc.index = idx3;
            }
        } else if (loc.parent instanceof AgendaAction && p instanceof AgendaAction && (idx = (action = (AgendaAction)loc.parent).getActionIndex((AgendaAction)p) + 1) < action.getActionCount()) {
            loc.index = idx;
        }
        if (nodeIndex < nodeCount - 1) {
            loc.nodeLosingChildren = p;
            loc.firstReparentedChildIndex = nodeIndex + 1;
        }
        return loc;
    }

    private InsertionLocation getPromotedLocation(Agenda agenda, AgendaNode node) {
        AgendaAction action;
        int idx;
        AgendaNode sibling = null;
        AgendaNode p = node.getParent();
        if (p == null) {
            int idx2 = agenda.getNodeIndex(node);
            if (idx2 > 0) {
                sibling = agenda.getNode(idx2 - 1);
            }
        } else if (p instanceof AgendaTopic) {
            AgendaTopic topic = (AgendaTopic)p;
            idx = topic.getNodeIndex(node);
            if (idx > 0) {
                sibling = topic.getNode(idx - 1);
            }
        } else if (p instanceof AgendaAction && node instanceof AgendaAction && (idx = (action = (AgendaAction)p).getActionIndex((AgendaAction)node)) > 0) {
            sibling = action.getAction(idx - 1);
        }
        if (sibling instanceof AgendaAction && node instanceof AgendaAction && !((AgendaAction)sibling).isCompoundAction()) {
            sibling = null;
        }
        if (sibling == null) {
            return null;
        }
        InsertionLocation loc = new InsertionLocation();
        loc.parent = sibling;
        AgendaNode prev = agenda.getNodeBefore(node, true);
        while (prev != sibling) {
            p = prev.getParent();
            if (p == sibling) {
                AgendaAction action2;
                int idx3;
                if (sibling instanceof AgendaTopic) {
                    AgendaTopic topic = (AgendaTopic)sibling;
                    int idx4 = topic.getNodeIndex(prev) + 1;
                    if (idx4 >= topic.getNodeCount()) break;
                    loc.index = idx4;
                    break;
                }
                if (!(sibling instanceof AgendaAction) || !(prev instanceof AgendaAction) || (idx3 = (action2 = (AgendaAction)sibling).getActionIndex((AgendaAction)prev) + 1) >= action2.getActionCount()) break;
                loc.index = idx3;
                break;
            }
            prev = p;
        }
        return loc;
    }

    private InsertionLocation getPrecedingLocation(Agenda agenda, AgendaItem item, AgendaItem referenceItem) {
        if (referenceItem == null) {
            return null;
        }
        InsertionLocation loc = new InsertionLocation();
        if (item instanceof AgendaFile && referenceItem instanceof AgendaFile) {
            AgendaFile referenceFile = (AgendaFile)referenceItem;
            loc.index = agenda.getFileIndex(referenceFile);
        } else if (item instanceof AgendaNode && referenceItem instanceof AgendaNode) {
            AgendaNode referenceNode = (AgendaNode)referenceItem;
            loc.parent = referenceNode.getParent();
            if (loc.parent == null) {
                loc.index = agenda.getNodeIndex(referenceNode);
            } else if (loc.parent instanceof AgendaTopic) {
                loc.index = ((AgendaTopic)loc.parent).getNodeIndex(referenceNode);
            } else if (loc.parent instanceof AgendaAction && referenceNode instanceof AgendaAction) {
                loc.index = ((AgendaAction)loc.parent).getActionIndex((AgendaAction)referenceNode);
            }
        }
        return loc;
    }

    private InsertionLocation getFollowingLocation(Agenda agenda, AgendaItem item, AgendaItem referenceItem) {
        if (referenceItem == null) {
            return null;
        }
        InsertionLocation loc = new InsertionLocation();
        if (item instanceof AgendaFile && referenceItem instanceof AgendaFile) {
            AgendaFile referenceFile = (AgendaFile)referenceItem;
            int index = agenda.getFileIndex(referenceFile);
            loc.index = index >= agenda.getFileCount() - 1 ? -1 : index;
        } else if (item instanceof AgendaNode && referenceItem instanceof AgendaNode) {
            AgendaNode parent;
            AgendaNode sibling;
            AgendaNode node = (AgendaNode)item;
            AgendaNode referenceNode = (AgendaNode)referenceItem;
            AgendaTopic grievingTopic = null;
            if (referenceNode instanceof AgendaAction && ((AgendaAction)referenceNode).isCompoundAction() && node instanceof AgendaAction) {
                sibling = null;
                parent = referenceNode;
            } else if (referenceNode instanceof AgendaTopic && ((AgendaTopic)referenceNode).getNodeCount() != 0) {
                sibling = null;
                parent = referenceNode;
            } else {
                sibling = referenceNode;
                parent = referenceNode.getParent();
                if (referenceNode instanceof AgendaTopic && node instanceof AgendaTopic) {
                    grievingTopic = (AgendaTopic)referenceNode;
                }
            }
            loc.nodeLosingChildren = grievingTopic;
            while (true) {
                if (parent == null || parent instanceof AgendaTopic || parent instanceof AgendaAction && ((AgendaAction)parent).isCompoundAction() && node instanceof AgendaAction) break;
                sibling = parent;
                parent = parent.getParent();
            }
            loc.parent = parent;
            if (loc.parent == null) {
                int index = agenda.getNodeIndex(sibling);
                loc.index = index >= agenda.getNodeCount() - 1 ? -1 : index + 1;
            } else if (loc.parent instanceof AgendaTopic) {
                int index;
                loc.index = loc.parent == referenceNode ? (((AgendaTopic)loc.parent).getNodeCount() == 0 ? -1 : 0) : ((index = ((AgendaTopic)loc.parent).getNodeIndex(sibling)) >= ((AgendaTopic)loc.parent).getNodeCount() - 1 ? -1 : index + 1);
            } else if (loc.parent instanceof AgendaAction && referenceNode instanceof AgendaAction) {
                int index;
                loc.index = loc.parent == referenceNode ? (((AgendaAction)loc.parent).getActionCount() == 0 ? -1 : 0) : ((index = ((AgendaAction)loc.parent).getActionIndex((AgendaAction)referenceNode)) >= ((AgendaAction)loc.parent).getActionCount() - 1 ? -1 : index + 1);
            }
            if (node.getParentAgenda() == agenda && loc.parent == node.getParent() && (loc.parent == null && agenda.getNodeIndex(node) < loc.index || loc.parent instanceof AgendaTopic && ((AgendaTopic)loc.parent).getNodeIndex(node) < loc.index || loc.parent instanceof AgendaAction && ((AgendaAction)loc.parent).getActionIndex((AgendaAction)node) < loc.index)) {
                --loc.index;
            }
        }
        return loc;
    }

    private InsertionLocation getInsertionLocation(Agenda agenda, AgendaNode node) {
        AgendaNode selectedNode = null;
        AgendaItem[] its = this.getTargetedItems();
        if (its != null && its.length != 0 && its[0] instanceof AgendaNode) {
            selectedNode = (AgendaNode)its[0];
        }
        if (selectedNode == null) {
            return new InsertionLocation();
        }
        return this.getFollowingLocation(agenda, (AgendaItem)node, (AgendaItem)selectedNode);
    }

    private boolean canViewLibrary() {
        return this.isChair();
    }

    private boolean canEditAgenda() {
        return !this.terminal.getClient().isConnected() || this.isChair();
    }

    boolean isViewableByEveryone() {
        if (this.clients == null) {
            return false;
        }
        byte view = this.clients.getProperty("agenda.viewability", (byte)1);
        return view == 2;
    }

    boolean isProtected() {
        if (this.clients == null) {
            return false;
        }
        return this.clients.getProperty("agenda.protected", false);
    }

    private static long newDownloadID() {
        return System.currentTimeMillis();
    }

    private synchronized long newUploadID() {
        long id = this.nextUploadID++;
        return id;
    }

    private static Object makeDownloadKey(long downloadID) {
        return String.valueOf(downloadID);
    }

    String getClientName(short address) {
        ClientInfo ci = this.clients.get(address);
        return ci != null ? ci.getDisplayName() : null;
    }

    boolean isOnline() {
        return this.terminal.getClient().isConnected();
    }

    boolean isMe(short address) {
        return !this.terminal.getClient().isConnected() || this.terminal.getClient().getAddress() == address;
    }

    boolean isChair() {
        return ChairProtocol.getChair((ClientList)this.clients).isMe();
    }

    Icon getIcon(AgendaItem item) {
        if (item instanceof AgendaAction) {
            AgendaAction act = (AgendaAction)item;
            String cmdName = act.getCommandName();
            Icon icon = (Icon)this.cachedIcons.get(cmdName);
            if (icon != null) {
                return icon;
            }
            if (act.isCompoundAction()) {
                icon = this.i18n.getIcon((PropertiesEnum)StringsProperties.AGENDABEAN_COMPOUNDACTIONICON);
            } else {
                ActionInfo info = Actions.getAction(cmdName);
                if (info != null) {
                    icon = info.getIcon();
                }
            }
            this.cachedIcons.put(cmdName, icon);
            return icon;
        }
        return null;
    }

    void setView(int view) {
        int oldView = this.view;
        this.view = view;
        switch (view) {
            case 1: {
                this.showLibrary();
                break;
            }
            case 2: {
                this.showEditor();
                break;
            }
            case 3: {
                this.showController();
            }
        }
        this.updateWindowModified();
        this.firePropertyChange(PROP_VIEW, oldView, view);
    }

    int getView() {
        return this.view;
    }

    private void showLibrary() {
        if (this.editorPanel.isVisible()) {
            this.editorPanel.removePropertyChangeListener("agenda", this);
            this.editorPanel.removePropertyChangeListener("selectedItems", this);
        }
        if (!this.libraryPanel.isVisible()) {
            this.cardLayout.show(this.center, CARD_LIBRARY);
        }
        if (this.toolBar.getView() != 1) {
            this.toolBar.setView(1);
        }
        if (!this.center.isVisible()) {
            this.center.setVisible(true);
            Window w = SwingUtilities.getWindowAncestor(this);
            if (w != null) {
                w.setSize(this.normalSize);
                this.normalSize = null;
            }
            if (w instanceof JDialog) {
                ((JDialog)w).setResizable(true);
            } else if (w instanceof JFrame) {
                ((JFrame)w).setResizable(true);
            }
        }
        this.libraryPanel.addPropertyChangeListener("selectedAgendas", this);
        this.setTargetedAgendas(this.libraryPanel.getSelectedAgendas());
        this.updateWindowTitle();
    }

    private void showEditor() {
        boolean switchingToEditor = false;
        if (this.libraryPanel.isVisible()) {
            this.libraryPanel.removePropertyChangeListener("selectedAgendas", this);
            switchingToEditor = true;
        }
        if (!this.editorPanel.isVisible()) {
            this.cardLayout.show(this.center, CARD_EDITOR);
        }
        if (this.toolBar.getView() != 2) {
            this.toolBar.setView(2);
        }
        if (!this.center.isVisible()) {
            this.center.setVisible(true);
            Window w = SwingUtilities.getWindowAncestor(this);
            if (w instanceof JDialog) {
                ((JDialog)w).setResizable(true);
            } else if (w instanceof JFrame) {
                ((JFrame)w).setResizable(true);
            }
            if (w != null) {
                if (this.normalSize != null) {
                    w.setSize(this.normalSize);
                }
                this.normalSize = null;
            }
        }
        if (switchingToEditor) {
            Agenda[] agendaArray;
            this.editorPanel.addPropertyChangeListener("agenda", this);
            this.editorPanel.addPropertyChangeListener("selectedItems", this);
            Agenda ag = this.editorPanel.getAgenda();
            if (ag != null) {
                Agenda[] agendaArray2 = new Agenda[1];
                agendaArray = agendaArray2;
                agendaArray2[0] = ag;
            } else {
                agendaArray = null;
            }
            Agenda[] ags = agendaArray;
            this.setTargetedAgendas(ags);
        }
        this.updateWindowTitle();
    }

    private void showController() {
        boolean switchingToEditor = false;
        if (this.libraryPanel.isVisible()) {
            this.libraryPanel.removePropertyChangeListener("selectedAgendas", this);
            switchingToEditor = true;
        }
        if (!this.editorPanel.isVisible()) {
            this.cardLayout.show(this.center, CARD_EDITOR);
        }
        if (this.toolBar.getView() != 3) {
            this.toolBar.setView(3);
        }
        if (this.center.isVisible()) {
            this.center.setVisible(false);
            Window w = SwingUtilities.getWindowAncestor(this);
            if (w instanceof JDialog) {
                ((JDialog)w).setResizable(false);
            } else if (w instanceof JFrame) {
                ((JFrame)w).setResizable(false);
            }
            if (w != null) {
                this.normalSize = w.getSize();
                w.pack();
            }
        }
        if (switchingToEditor) {
            Agenda[] agendaArray;
            this.editorPanel.addPropertyChangeListener("agenda", this);
            this.editorPanel.addPropertyChangeListener("selectedItems", this);
            Agenda ag = this.editorPanel.getAgenda();
            if (ag != null) {
                Agenda[] agendaArray2 = new Agenda[1];
                agendaArray = agendaArray2;
                agendaArray2[0] = ag;
            } else {
                agendaArray = null;
            }
            Agenda[] ags = agendaArray;
            this.setTargetedAgendas(ags);
        }
        this.updateWindowTitle();
    }

    Agenda[] getTargetedAgendas() {
        Agenda ag;
        if (this.libraryPanel != null && this.libraryPanel.isVisible()) {
            return this.libraryPanel.getSelectedAgendas();
        }
        if (this.editorPanel != null && (ag = this.editorPanel.getAgenda()) != null) {
            return new Agenda[]{ag};
        }
        return null;
    }

    private void setTargetedAgendas(Agenda[] agendas) {
        boolean same = true;
        if (agendas != null || this.targetedAgendas != null) {
            if (agendas == null && this.targetedAgendas != null || agendas != null && this.targetedAgendas == null || agendas.length != this.targetedAgendas.length) {
                same = false;
            } else {
                block0: for (int i = 0; i < agendas.length; ++i) {
                    for (int j = 0; j < this.targetedAgendas.length; ++j) {
                        if (agendas[i] == this.targetedAgendas[j]) continue;
                        same = false;
                        continue block0;
                    }
                }
            }
        }
        if (!same) {
            Agenda[] oldAgendas = this.targetedAgendas;
            this.targetedAgendas = agendas;
            this.firePropertyChange(PROP_TARGETED_AGENDAS, oldAgendas, agendas);
        }
    }

    AgendaItem[] getTargetedItems() {
        if (this.editorPanel != null && this.editorPanel.isVisible()) {
            return this.editorPanel.getSelectedItems();
        }
        return null;
    }

    private void setTargetedItems(AgendaItem[] targetedItems) {
        AgendaItem[] oldItems = this.targetedItems;
        this.targetedItems = targetedItems;
        this.firePropertyChange(PROP_TARGETED_ITEMS, oldItems, targetedItems);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("agenda")) {
            Agenda[] agendaArray;
            Agenda ag = (Agenda)e.getNewValue();
            if (ag != null) {
                Agenda[] agendaArray2 = new Agenda[1];
                agendaArray = agendaArray2;
                agendaArray2[0] = ag;
            } else {
                agendaArray = null;
            }
            Agenda[] ags = agendaArray;
            this.setTargetedAgendas(ags);
        } else if (prop.equals("selectedItems")) {
            this.setTargetedItems((AgendaItem[])e.getNewValue());
        } else if (prop.equals("selectedAgendas")) {
            this.setTargetedAgendas((Agenda[])e.getNewValue());
        } else if (prop.equals(PROP_WINDOW_TITLE)) {
            this.updateWindowTitle();
        } else if (prop.equals("agenda.viewability")) {
            Agenda ag;
            if (this.terminal.getClient().isPlayback() && this.isViewableByEveryone() && (ag = this.library.getActiveAgenda()) != null) {
                this.performEditAgenda(ag);
            }
        } else if (prop.endsWith(".maxTalkerCount")) {
            ActionInfo act = Actions.getAction(SetMaximumTalkersCommand.class.getName());
            ActionParameter param = act.getParameter("talkerCount");
            param.setMaximumValue(Integer.parseInt((String)e.getNewValue()));
        } else if (prop.endsWith(".maxCameraCount")) {
            ActionInfo act = Actions.getAction(SetMaximumCamerasCommand.class.getName());
            ActionParameter param = act.getParameter("cameraCount");
            param.setMaximumValue(Integer.parseInt((String)e.getNewValue()));
        }
    }

    public void chairAdded(ChairEvent e) {
        if (e.clientIsMe()) {
            if (this.editorPanel.getAgenda() == null) {
                this.setView(1);
            }
            this.firePropertyChange(PROP_MODERATOR, false, true);
        }
    }

    public void chairRemoved(ChairEvent e) {
        if (e.clientIsMe()) {
            if (this.isViewableByEveryone()) {
                Agenda ag = this.library.getActiveAgenda();
                if (this.editorPanel.getAgenda() != ag) {
                    try {
                        this.sendDownloadDefinitionRequestMessage(AgendaBean.newDownloadID(), ag);
                    }
                    catch (IOException ex) {
                        ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DEFINEAGENDAFAILEDMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DEFINEAGENDAFAILEDTITLE), (int)0);
                    }
                }
            }
            this.firePropertyChange(PROP_MODERATOR, true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelStateChanged(ChannelEvent e) {
        HashMap hashMap = this.uploads;
        synchronized (hashMap) {
            for (Long id : this.uploads.keySet()) {
                AgendaUpload ul = (AgendaUpload)((Object)this.uploads.get(id));
                ul.cancel();
            }
            this.uploads.clear();
        }
        hashMap = this.downloads;
        synchronized (hashMap) {
            Iterator<Object> itr = this.downloads.values().iterator();
            while (itr.hasNext()) {
                Download dl = (Download)itr.next();
                dl.halt();
                itr.remove();
            }
        }
        this.library.removeAllAgendas((short)-32767);
        if (e.getState() == 1) {
            try {
                SwingRunnerSupport.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!AgendaBean.this.isChair()) {
                            AgendaBean.this.setView(2);
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onChannelData(ChannelDataEvent e) {
        DataInputStream in = null;
        byte cmd = -1;
        try {
            in = e.read();
            cmd = e.getCommand();
            if (AgendaFlags.MESSAGE_DECODE.show()) {
                LogSupport.message((Object)this, (String)"onChannelData", (String)("MsgRecv = " + this.agendaProtocol.commandToString(cmd) + " Size of the input stream = " + in.available()));
            }
            switch (cmd) {
                case 0: {
                    this.receiveErrorMessage(in);
                    return;
                }
                case 1: {
                    this.receiveNewAgendaMessage(in);
                    return;
                }
                case 2: {
                    this.receiveChangeAgendaMessage(in);
                    return;
                }
                case 3: {
                    this.receiveDeleteAgendaMessage(in);
                    return;
                }
                case 4: {
                    this.receiveNewItemMessage(in);
                    return;
                }
                case 5: {
                    this.receiveChangeItemMessage(in);
                    return;
                }
                case 6: {
                    this.receiveDeleteItemMessage(in);
                    return;
                }
                case 7: {
                    this.receiveUploadAgendaMessage(in);
                    return;
                }
                case 8: {
                    this.receiveDownloadAgendaMessage(in);
                    return;
                }
                case 11: {
                    this.receiveActivateAgendaMessage(in);
                    return;
                }
                case 12: {
                    this.receiveDeactivateAgendaMessage(in);
                    return;
                }
                case 13: {
                    this.receiveAutoloadAgendaMessage(in);
                    return;
                }
                case 14: {
                    this.receiveRequestEditAgendaMessage(in);
                    return;
                }
                case 15: {
                    this.receiveRespondEditAgendaMessage(in);
                    return;
                }
                case 16: {
                    this.receiveEditAgendaMessage(in);
                    return;
                }
                case 17: {
                    this.receiveStartTimerMessage(in);
                    return;
                }
                case 18: {
                    this.receiveStopTimerMessage(in);
                    return;
                }
                case 19: {
                    this.receiveDownloadFileMessage(in);
                    return;
                }
                case 20: {
                    this.receiveDownloadDefinitionMessage(in);
                    return;
                }
            }
            return;
        }
        catch (IOException ex) {
            LogSupport.error((Object)this, (String)"onChannelData", (String)ex.toString());
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNewAgendaMessage(String agendaName) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)1);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeUTF(agendaName);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChangeAgendaMessage(Agenda agenda, String property, String value) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)2);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeInt(agenda.getID());
            out.writeUTF(AgendaProtocol.formatProperty((String)property, (String)value));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDeleteAgendaMessage(Agenda agenda) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)3);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeInt(agenda.getID());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNewItemMessage(Agenda agenda, AgendaItem item, AgendaItem parent, int index) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)4);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeInt(agenda.getID());
            out.writeInt(parent != null ? parent.getID() : -1);
            out.writeInt(index);
            if (item instanceof AgendaFile) {
                out.writeUTF("file");
            } else if (item instanceof AgendaTopic) {
                out.writeUTF("topic");
            } else if (item instanceof AgendaText) {
                out.writeUTF("text");
            } else if (item instanceof AgendaAction) {
                out.writeUTF("action");
            }
            if (item instanceof AgendaFile) {
                this.sendNewItemProperty(item, "autoload", out);
                this.sendNewItemProperty(item, "autoload", out);
                this.sendNewItemProperty(item, "command", out);
                this.sendNewItemProperty(item, "name", out);
                this.sendNewItemProperty(item, "path", out);
                this.sendNewItemProperty(item, "size", out);
                String[] names = ((AgendaFile)item).getCommandParameterNames();
                for (int i = 0; i < names.length; ++i) {
                    String prop = AgendaProtocol.formatParameterName((String)"parameter", (String)names[i]);
                    this.sendNewItemProperty(item, prop, out);
                }
            } else if (item instanceof AgendaTopic) {
                this.sendNewItemProperty(item, "name", out);
                this.sendNewItemProperty(item, "covered", out);
                this.sendNewItemProperty(item, "note", out);
                this.sendNewItemProperty(item, "duration", out);
            } else if (item instanceof AgendaAction) {
                this.sendNewItemProperty(item, "command", out);
                this.sendNewItemProperty(item, "covered", out);
                this.sendNewItemProperty(item, "description", out);
                this.sendNewItemProperty(item, "note", out);
                this.sendNewItemProperty(item, "duration", out);
                String[] names = ((AgendaAction)item).getCommandParameterNames();
                for (int i = 0; i < names.length; ++i) {
                    String prop = AgendaProtocol.formatParameterName((String)"parameter", (String)names[i]);
                    this.sendNewItemProperty(item, prop, out);
                }
            } else if (item instanceof AgendaText) {
                this.sendNewItemProperty(item, "covered", out);
                this.sendNewItemProperty(item, "duration", out);
                this.sendNewItemProperty(item, "text", out);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    private void sendNewItemProperty(AgendaItem item, String property, DataOutputStream out) throws IOException {
        String value = AgendaProtocol.getProperty((AgendaItem)item, (String)property);
        if (value != null && value.length() != 0) {
            out.writeUTF(AgendaProtocol.formatProperty((String)property, (String)value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChangeItemMessage(Agenda agenda, AgendaItem item, String property, String value) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)5);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeInt(agenda.getID());
            out.writeInt(item.getID());
            out.writeUTF(AgendaProtocol.formatProperty((String)property, (String)value));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDeleteItemMessage(Agenda agenda, AgendaItem item) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)6);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeInt(agenda.getID());
            out.writeInt(item.getID());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUploadAgendaRequestMessage(long uploadID, String agendaName, long size) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)7);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeLong(uploadID);
            out.writeByte(1);
            out.writeUTF(agendaName);
            out.writeLong(size);
            out.flush();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUploadAgendaDataMessage(long uploadID, byte[] buffer, int offset, int length) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)7);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeLong(uploadID);
            out.writeByte(3);
            out.write(buffer, offset, length);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(0, e, true, (byte)-2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUploadAgendaAckMessage(long uploadID) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)7);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeLong(uploadID);
            out.writeByte(4);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(0, e, true, (byte)-2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUploadAgendaCompleteMessage(long uploadID, long crc32) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)7);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeLong(uploadID);
            out.writeByte(5);
            out.writeLong(crc32);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(0, e, true, (byte)-2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUploadAgendaCancelMessage(long uploadID) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)7);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeLong(uploadID);
            out.writeByte(6);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(0, e, true, (byte)-2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDownloadAgendaRequestMessage(long downloadID, Agenda agenda, File destination) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)8);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeLong(downloadID);
            out.writeByte(1);
            out.writeInt(agenda.getID());
            out.writeUTF(destination.getAbsolutePath());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDownloadAgendaCancelMessage(long downloadID) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)8);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeLong(downloadID);
            out.writeByte(6);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDownloadFileRequestMessage(long downloadID, Agenda agenda, AgendaFile file, File destination) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)19);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeLong(downloadID);
            out.writeByte(1);
            out.writeInt(agenda.getID());
            out.writeInt(file.getID());
            out.writeUTF(destination.getAbsolutePath());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDownloadFileCancelMessage(long downloadID) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)19);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeLong(downloadID);
            out.writeByte(6);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDownloadDefinitionRequestMessage(long downloadID, Agenda agenda) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)20);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeLong(downloadID);
            out.writeByte(1);
            out.writeInt(agenda.getID());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDownloadDefinitionCancelMessage(long downloadID) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)20);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeLong(downloadID);
            out.writeByte(6);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReleaseDefinitionMessage(Agenda agenda) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)10);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeInt(agenda.getID());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendActivateAgendaMessage(Agenda agenda) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)11);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeInt(agenda.getID());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDeactivateAgendaMessage(Agenda agenda) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)12);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeInt(agenda.getID());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAutoloadAgendaMessage(Agenda agenda) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)13);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeInt(agenda.getID());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequestEditAgendaMessage(Agenda agenda) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)14);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeInt(agenda.getID());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRespondEditAgendaMessage(Agenda agenda, boolean granted, short requester) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)15);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeInt(agenda.getID());
            out.writeBoolean(granted);
            out.writeShort(requester);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStartTimerMessage(Agenda agenda, AgendaNode node) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)17);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeInt(agenda.getID());
            out.writeInt(node.getID());
            out.writeInt(node.getDuration());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStopTimerMessage(Agenda agenda, AgendaNode node) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)18);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeInt(agenda.getID());
            out.writeInt(node.getID());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEditAgendaMessage(Agenda agenda, short editor) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)16);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeInt(agenda.getID());
            out.writeShort(editor);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.terminal.fireChannelData(e);
    }

    private void receiveErrorMessage(DataInputStream in) throws IOException {
        byte command = in.readByte();
        String className = in.readUTF();
        String message = in.readUTF();
        this.displayServiceError(command, className, message);
    }

    private void receiveNewAgendaMessage(DataInputStream in) throws IOException {
        int agendaID = in.readInt();
        String agendaName = in.readUTF();
        short requester = in.readShort();
        this.performNewAgenda(agendaID, agendaName, requester);
    }

    private void receiveChangeAgendaMessage(DataInputStream in) throws IOException {
        int agendaID = in.readInt();
        String property = in.readUTF();
        Agenda ag = this.library.getAgendaByID(agendaID);
        if (ag == null) {
            return;
        }
        String[] pair = AgendaProtocol.parseProperty((String)property);
        if (pair == null) {
            return;
        }
        String name = pair[0];
        String value = pair[1];
        this.performChangeAgenda(ag, name, value);
    }

    private void receiveDeleteAgendaMessage(DataInputStream in) throws IOException {
        int agendaID = in.readInt();
        short requester = in.readShort();
        this.performDeleteAgenda(agendaID, requester);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveNewItemMessage(DataInputStream in) throws IOException {
        int agendaID = in.readInt();
        int parentID = in.readInt();
        int index = in.readInt();
        String itemType = in.readUTF();
        ArrayList<String> properties = new ArrayList<String>();
        try {
            while (true) {
                String property = in.readUTF();
                properties.add(property);
            }
        }
        catch (EOFException ex) {
            Agenda ag = this.library.getAgendaByID(agendaID);
            if (ag == null) {
                return;
            }
            AgendaItem parent = null;
            if (parentID != -1 && (parent = ag.getItemByID(parentID)) == null) {
                return;
            }
            Agenda agenda = ag;
            synchronized (agenda) {
                AgendaFile it;
                if (itemType.equals("file")) {
                    it = new AgendaFile();
                } else if (itemType.equals("topic")) {
                    it = new AgendaTopic();
                } else if (itemType.equals("text")) {
                    it = new AgendaText();
                } else if (itemType.equals("action")) {
                    it = new AgendaAction();
                } else {
                    return;
                }
                for (String property : properties) {
                    String[] pair = AgendaProtocol.parseProperty((String)property);
                    if (pair == null) continue;
                    AgendaProtocol.setProperty((AgendaItem)it, (String)pair[0], (String)pair[1]);
                }
                this.performNewItem(ag, (AgendaItem)it, parent, index);
            }
            return;
        }
    }

    private void receiveChangeItemMessage(DataInputStream in) throws IOException {
        int agendaID = in.readInt();
        int itemID = in.readInt();
        String property = in.readUTF();
        String[] pair = AgendaProtocol.parseProperty((String)property);
        if (pair == null) {
            return;
        }
        String name = pair[0];
        String value = pair[1];
        this.performChangeItem(agendaID, itemID, name, value);
    }

    private void receiveDeleteItemMessage(DataInputStream in) throws IOException {
        int agendaID = in.readInt();
        int itemID = in.readInt();
        Agenda ag = this.library.getAgendaByID(agendaID);
        if (ag == null) {
            return;
        }
        AgendaItem it = ag.getItemByID(itemID);
        if (it == null) {
            return;
        }
        this.performDeleteItem(ag, it);
    }

    private void receiveUploadAgendaMessage(DataInputStream in) throws IOException {
        long uploadID = in.readLong();
        byte messageType = in.readByte();
        Long key = new Long(uploadID);
        switch (messageType) {
            case 2: {
                int agendaID = in.readInt();
                AgendaUpload ul = (AgendaUpload)((Object)this.uploads.get(key));
                if (ul == null) break;
                ul.start(agendaID);
                break;
            }
            case 4: {
                long receivedSize = in.readLong();
                AgendaUpload ul = (AgendaUpload)((Object)this.uploads.get(key));
                if (ul == null) break;
                ul.ack(receivedSize);
            }
        }
    }

    private void receiveDownloadAgendaMessage(DataInputStream in) throws IOException {
        long downloadID = in.readLong();
        byte messageType = in.readByte();
        Object key = AgendaBean.makeDownloadKey(downloadID);
        switch (messageType) {
            case 1: {
                int agendaID = in.readInt();
                String path = in.readUTF();
                long size = in.readLong();
                Agenda ag = this.library.getAgendaByID(agendaID);
                if (ag == null) {
                    return;
                }
                Download dl = new Download(ag, new File(path), size);
                this.downloads.put(key, dl);
                break;
            }
            case 3: {
                Download dl = (Download)this.downloads.get(key);
                if (dl == null) break;
                dl.receive(in);
                break;
            }
            case 5: {
                Download dl = (Download)this.downloads.remove(key);
                if (dl == null) break;
                long crc32 = in.readLong();
                dl.finish(crc32);
                break;
            }
            case 6: {
                Download dl = (Download)this.downloads.remove(key);
                if (dl == null) break;
                dl.halt();
            }
        }
    }

    private void receiveDownloadFileMessage(DataInputStream in) throws IOException {
        long downloadID = in.readLong();
        byte messageType = in.readByte();
        Object key = AgendaBean.makeDownloadKey(downloadID);
        switch (messageType) {
            case 1: {
                int agendaID = in.readInt();
                int fileID = in.readInt();
                String path = in.readUTF();
                long size = in.readLong();
                Agenda ag = this.library.getAgendaByID(agendaID);
                if (ag == null) {
                    return;
                }
                AgendaItem it = ag.getItemByID(fileID);
                if (it == null || !(it instanceof AgendaFile)) {
                    return;
                }
                Download dl = new Download(ag, (AgendaFile)it, new File(path), size);
                this.downloads.put(key, dl);
                break;
            }
            case 3: {
                Download dl = (Download)this.downloads.get(key);
                if (dl == null) break;
                dl.receive(in);
                break;
            }
            case 5: {
                Download dl = (Download)this.downloads.remove(key);
                if (dl == null) break;
                long crc32 = in.readLong();
                dl.finish(crc32);
                break;
            }
            case 6: {
                Download dl = (Download)this.downloads.remove(key);
                if (dl == null) break;
                dl.halt();
            }
        }
    }

    private void receiveDownloadDefinitionMessage(DataInputStream in) throws IOException {
        long downloadID = in.readLong();
        byte messageType = in.readByte();
        Object key = AgendaBean.makeDownloadKey(downloadID);
        switch (messageType) {
            case 1: {
                int agendaID = in.readInt();
                long size = in.readLong();
                Agenda ag = this.library.getAgendaByID(agendaID);
                if (ag == null) {
                    return;
                }
                Download dl = new Download(ag, size);
                this.downloads.put(key, dl);
                break;
            }
            case 3: {
                Download dl = (Download)this.downloads.get(key);
                if (dl == null) break;
                dl.receive(in);
                break;
            }
            case 5: {
                Download dl = (Download)this.downloads.remove(key);
                if (dl == null) break;
                long crc32 = in.readLong();
                dl.finish(crc32);
                this.performDefineAgenda(dl.getAgenda(), new ByteArrayInputStream(dl.getReceivedData()));
                break;
            }
            case 6: {
                Download dl = (Download)this.downloads.remove(key);
                if (dl == null) break;
                dl.halt();
            }
        }
    }

    private void receiveActivateAgendaMessage(DataInputStream in) throws IOException {
        int agendaID = in.readInt();
        short requester = in.readShort();
        Agenda ag = this.library.getAgendaByID(agendaID);
        if (ag == null) {
            return;
        }
        if (this.library.isActiveAgenda(ag)) {
            return;
        }
        this.library.activateAgenda(ag, requester);
    }

    private void receiveDeactivateAgendaMessage(DataInputStream in) throws IOException {
        int agendaID = in.readInt();
        short requester = in.readShort();
        Agenda ag = this.library.getAgendaByID(agendaID);
        if (ag == null) {
            return;
        }
        this.library.deactivateAgenda(ag, requester);
    }

    private void receiveAutoloadAgendaMessage(DataInputStream in) throws IOException {
        int agendaID = in.readInt();
        short requester = in.readShort();
        Agenda ag = this.library.getAgendaByID(agendaID);
        if (ag == null) {
            return;
        }
        if (this.library.isAgendaAutoloaded(ag)) {
            return;
        }
        this.library.autoloadAgenda(ag, requester);
    }

    private void receiveRequestEditAgendaMessage(DataInputStream in) throws IOException {
        int resp;
        int agendaID = in.readInt();
        short requester = in.readShort();
        Agenda ag = this.library.getAgendaByID(agendaID);
        if (ag == null) {
            return;
        }
        ClientInfo ci = this.clients.get(requester);
        if (ci == null) {
            return;
        }
        boolean granted = false;
        if (this.isMe(ag.getEditor()) && (resp = ModalDialog.showConfirmDialogTimeout((int)10, (Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONTROLREQUESTQUESTION, new Object[]{ci.getDisplayName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONTROLREQUESTTITLE), (int)0, (int)3, null)) != 1) {
            granted = true;
        }
        this.sendRespondEditAgendaMessage(ag, granted, requester);
    }

    private void receiveRespondEditAgendaMessage(DataInputStream in) throws IOException {
        boolean granted = in.readBoolean();
        short editor = in.readShort();
        if (!granted && !this.isMe(editor)) {
            ClientInfo ci = this.clients.get(editor);
            if (ci == null) {
                return;
            }
            ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONTROLREQUESTREFUSEDMESSAGE, new Object[]{ci.getDisplayName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CONTROLREQUESTREFUSEDTITLE), (int)2);
        }
    }

    private void receiveEditAgendaMessage(DataInputStream in) throws IOException {
        int agendaID = in.readInt();
        short editor = in.readShort();
        Agenda ag = this.library.getAgendaByID(agendaID);
        if (ag == null) {
            return;
        }
        ag.setEditor(editor);
    }

    private void receiveStartTimerMessage(DataInputStream in) throws IOException {
        int agendaID = in.readInt();
        int nodeID = in.readInt();
        int duration = in.readInt();
        Agenda ag = this.library.getAgendaByID(agendaID);
        if (ag == null) {
            return;
        }
        AgendaItem it = ag.getItemByID(nodeID);
        if (!(it instanceof AgendaNode)) {
            return;
        }
        ag.startTimer((AgendaNode)it, duration);
    }

    private void receiveStopTimerMessage(DataInputStream in) throws IOException {
        int agendaID = in.readInt();
        int nodeID = in.readInt();
        Agenda ag = this.library.getAgendaByID(agendaID);
        if (ag == null) {
            return;
        }
        AgendaItem it = ag.getItemByID(nodeID);
        if (!(it instanceof AgendaNode)) {
            return;
        }
        ag.stopTimer((AgendaNode)it);
    }

    private void performNewAgenda(int agendaID, String agendaName, short requester) throws IOException {
        if (agendaID != -1 && this.library.getAgendaByID(agendaID) != null) {
            return;
        }
        Agenda ag = new Agenda(agendaName);
        ag.setID(agendaID);
        try {
            this.library.addAgenda(ag, requester);
        }
        catch (QuotaExceededException ex) {
            // empty catch block
        }
    }

    private void performUploadAgenda(File file, boolean suppressEdit) throws IOException {
        String[] parts = AgendaUtils.parseFileName((File)file);
        Agenda ag = new Agenda(parts[0]);
        AgendaUpload ul = new AgendaUpload(ag, file, suppressEdit);
        this.uploads.put(new Long(ul.getID()), ul);
        this.sendUploadAgendaRequestMessage(ul.getID(), ag.getName(), file.length());
    }

    private void performOpenAgenda(File file) {
        try {
            String[] parts = AgendaUtils.parseFileName((File)file);
            Agenda ag = new Agenda(parts[0], file);
            this.library.addAgenda(ag, (short)-32767);
        }
        catch (QuotaExceededException quotaExceededException) {
            // empty catch block
        }
    }

    private void performChangeAgenda(Agenda agenda, String propertyName, String propertyValue) {
        AgendaProtocol.setProperty((Agenda)agenda, (String)propertyName, (String)propertyValue);
    }

    private void performDeleteAgenda(int agendaID, short requester) {
        Agenda ag = this.library.getAgendaByID(agendaID);
        if (ag == null) {
            return;
        }
        this.library.removeAgenda(ag, requester);
    }

    private void performNewItem(Agenda agenda, AgendaItem item, AgendaItem parent, int index) {
        if (item instanceof AgendaFile) {
            agenda.addFile((AgendaFile)item, index);
        } else if (item instanceof AgendaNode) {
            AgendaNode node = (AgendaNode)item;
            if (parent != null) {
                if (parent instanceof AgendaTopic) {
                    ((AgendaTopic)parent).addNode(node, index);
                } else if (parent instanceof AgendaAction && node instanceof AgendaAction) {
                    ((AgendaAction)parent).addAction((AgendaAction)node, index);
                }
            } else {
                agenda.addNode(node, index);
            }
        }
    }

    private void performChangeItem(int agendaID, int itemID, String propertyName, String propertyValue) {
        Agenda ag = this.library.getAgendaByID(agendaID);
        if (ag == null) {
            return;
        }
        AgendaItem it = ag.getItemByID(itemID);
        if (it == null) {
            return;
        }
        AgendaProtocol.setProperty((AgendaItem)it, (String)propertyName, (String)propertyValue);
    }

    private void performDeleteItem(Agenda agenda, AgendaItem item) {
        if (item instanceof AgendaFile) {
            agenda.removeFile((AgendaFile)item);
        } else if (item instanceof AgendaNode) {
            AgendaNode node = (AgendaNode)item;
            AgendaNode parent = node.getParent();
            if (parent != null) {
                if (parent instanceof AgendaTopic) {
                    ((AgendaTopic)parent).removeNode(node);
                } else if (parent instanceof AgendaAction && node instanceof AgendaAction) {
                    ((AgendaAction)parent).removeAction((AgendaAction)node);
                }
            } else {
                agenda.removeNode(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSaveFile(Agenda agenda, AgendaFile file, File destination) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            int bytesRead;
            out = new BufferedOutputStream(new FileOutputStream(destination));
            in = new BufferedInputStream(new FileInputStream(new File(file.getPath())));
            byte[] buf = new byte[1024];
            while ((bytesRead = in.read(buf)) != -1) {
                out.write(buf, 0, bytesRead);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private void performDefineAgenda(Agenda agenda) {
        LoadAgendaOperation op = new LoadAgendaOperation(agenda, this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_OPENOPERATIONNAME, new Object[]{agenda.getName()}));
        op.addOperationListener((OperationListener)new OperationAdapter(){

            public void progressFinished(OperationEvent e) {
                Operation op = e.getOperation();
                AgendaBean.this.performEditAgenda((Agenda)op.getObject());
            }

            public void progressError(OperationEvent e) {
                ModalDialog.showMessageDialog((Component)AgendaBean.this, (Object)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_OPENAGENDAFAILEDMESSAGE), (String)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_OPENAGENDAFAILEDTITLE), (int)0);
            }
        });
        op.start();
        OperationDialog.trackProgress((Operation)op, (Component)this);
    }

    private void performDefineAgenda(Agenda agenda, InputStream in) throws IOException {
        agenda.load(in);
        if (!this.terminal.getClient().isPlayback() || this.isViewableByEveryone()) {
            this.performEditAgenda(agenda);
        }
    }

    private void performEditAgenda(final Agenda agenda) {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                OpenDocumentAPI api;
                File f;
                Agenda ag = AgendaBean.this.editorPanel.getAgenda();
                if (ag != agenda) {
                    AgendaBean.this.editorPanel.setAgenda(agenda);
                    AgendaBean.this.updateWindowTitle();
                    if (ag != null && AgendaBean.this.terminal.getClient().isConnected()) {
                        try {
                            if (ag.getEditor() == AgendaBean.this.terminal.getClient().getAddress()) {
                                AgendaBean.this.sendEditAgendaMessage(ag, (short)-32767);
                            }
                            AgendaBean.this.sendReleaseDefinitionMessage(ag);
                        }
                        catch (IOException ex) {
                            ModalDialog.showMessageDialogAsync((int)-1, (Component)AgendaBean.this, (Object)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CLOSEAGENDAFAILEDMESSAGE), (String)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_CLOSEAGENDAFAILEDTITLE), (int)0);
                        }
                    }
                }
                if (AgendaBean.this.getView() == 1) {
                    AgendaBean.this.setView(2);
                }
                if (ag != agenda && AgendaBean.this.isMe(agenda.getEditor())) {
                    AgendaValidator.CompatibilityReport rep = AgendaValidator.checkCompatibility(agenda);
                    StringBuffer msg = new StringBuffer();
                    if (rep.isUnsupportedVersion()) {
                        msg.append(AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_AGENDACOMPATIBILITYUNSUPPORTEDVERSIONMESSAGE));
                    }
                    if (rep.hasUnknownCommands()) {
                        if (msg.length() != 0) {
                            msg.append("\n\n");
                        }
                        msg.append(AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_AGENDACOMPATIBILITYUNKNOWNCOMMANDMESSAGE));
                    }
                    if (msg.length() != 0) {
                        ModalDialog.showMessageDialogAsync((int)-1, (Component)AgendaBean.this, (Object)msg.toString(), (String)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_AGENDACOMPATIBILITYISSUETITLE), (int)2);
                    }
                }
                if ((f = agenda.getFile()) != null && (api = (OpenDocumentAPI)AgendaBean.this.imps.findBest(OpenDocumentAPI.class)) != null) {
                    api.documentOpened(f);
                }
                String prefix = AgendaBean.this.module.getPrefix();
                Preferences prefs = AgendaBean.this.module.getPreferences();
                if (AgendaBean.this.terminal.getClient().isConnected() && AgendaPreferences.isViewFunctionActivatesAgenda(prefix, prefs) && AgendaBean.this.canActivateAgenda(agenda)) {
                    try {
                        AgendaBean.this.sendActivateAgendaMessage(agenda);
                    }
                    catch (IOException ex) {
                        ModalDialog.showMessageDialog((Component)AgendaBean.this, (Object)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ACTIVATEAGENDAFAILEDMESSAGE), (String)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ACTIVATEAGENDAFAILEDTITLE), (int)0);
                    }
                }
            }
        });
    }

    private void displayServiceError(byte command, String exceptionClassName, String exceptionMessage) {
        LogSupport.log((String)exceptionMessage);
        String msg = exceptionClassName.equals(QuotaExceededException.class.getName()) ? this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_QUOTAEXCEEDEDMESSAGE) : (exceptionClassName.equals(ZipException.class.getName()) ? this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_BADZIPFILEMESSAGE) : this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SERVICEERRORMESSAGE));
        ModalDialog.showMessageDialog((Component)this, (Object)msg, (String)this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SERVICEERRORTITLE), (int)0);
    }

    private boolean canActivateAgenda(Agenda agenda) {
        Agenda ag = this.library.getActiveAgenda();
        if (ag == null) {
            return true;
        }
        if (ag == agenda) {
            return false;
        }
        short editor = ag.getEditor();
        return editor == -32767 || this.isMe(editor);
    }

    Quiz[] getQuizzes(File file) throws IOException {
        return this.contentCache.getQuizzes(file);
    }

    WhiteboardScreenNode getWhiteboard(File file) throws IOException {
        return this.contentCache.getWhiteboard(file);
    }

    public ClientList getClientList() {
        return this.terminal.getClientList();
    }

    public Client getClient() {
        return this.terminal.getClient();
    }

    private class ActionDialog
    extends EasyDialog {
        private boolean palette;
        private CTree actionList;
        private JButton cancelButton;
        private JButton addButton;

        public ActionDialog(boolean palette) {
            super((Component)AgendaBean.this, "", !palette);
            this.palette = false;
            this.setResizable(true);
            this.setDefaultCloseOperation(palette ? 1 : 2);
            this.setInsets(null);
            if (palette) {
                this.getRootPane().putClientProperty("Window.style", "small");
            }
            this.palette = palette;
            this.setTitle(AgendaBean.this.i18n.getString((PropertiesEnum)(palette ? StringsProperties.AGENDABEAN_ADDACTIONPALETTETITLE : StringsProperties.AGENDABEAN_ADDACTIONDIALOGTITLE)));
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            ActionGroup[] grps = Actions.getGroups();
            for (int i = 0; i < grps.length; ++i) {
                ActionGroup grp = grps[i];
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(grp);
                root.add(node);
                ActionInfo[] acts = grp.getActions();
                for (int j = 0; j < acts.length; ++j) {
                    ActionInfo act = acts[j];
                    node.add(new DefaultMutableTreeNode(act));
                }
            }
            root.add(new DefaultMutableTreeNode(null));
            this.actionList = new CTree((TreeNode)root);
            this.actionList.setRootVisible(false);
            this.actionList.setShowsRootHandles(true);
            this.actionList.setRowHeight(18);
            this.actionList.setCellRenderer((TreeCellRenderer)new ActionRenderer());
            this.actionList.getSelectionModel().setSelectionMode(1);
            this.actionList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ActionDialog.this.doAdd();
                    }
                }
            });
            if (palette) {
                this.actionList.setDragEnabled(true);
                this.actionList.setTransferHandler(new TransferHandler(){

                    @Override
                    public int getSourceActions(JComponent component) {
                        return 1;
                    }

                    @Override
                    protected Transferable createTransferable(JComponent component) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)ActionDialog.this.actionList.getLastSelectedPathComponent();
                        if (node != null) {
                            Object obj = node.getUserObject();
                            if (obj instanceof ActionInfo) {
                                Class cmd = ((ActionInfo)obj).getCommandInterface();
                                return new CommandTransferable(cmd);
                            }
                            if (obj == null) {
                                return new CommandTransferable(null);
                            }
                        }
                        return null;
                    }
                });
            }
            JScrollPane sp = new JScrollPane((Component)this.actionList, 22, 31);
            sp.setPreferredSize(new Dimension(250, 320));
            int bottom = palette ? 0 : 1;
            sp.setBorder(BorderFactory.createMatteBorder(0, 0, bottom, 0, Color.LIGHT_GRAY));
            this.setContent(sp);
            if (!palette) {
                this.cancelButton = this.makeButton(0);
                this.addCancelButton(this.cancelButton);
                this.addButton = new JButton(AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_ADDACTIONDIALOGBUTTON));
                this.addButton.setEnabled(false);
                this.addActionButton(this.addButton, true);
                this.actionList.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent e) {
                        boolean en = false;
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)ActionDialog.this.actionList.getLastSelectedPathComponent();
                        if (node != null) {
                            Object obj = node.getUserObject();
                            en = obj == null || obj instanceof ActionInfo;
                        }
                        ActionDialog.this.addButton.setEnabled(en);
                    }
                });
                this.addButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ActionDialog.this.setVisible(false);
                        if (!ActionDialog.this.palette) {
                            ActionDialog.this.dispose();
                        }
                        ActionDialog.this.doAdd();
                    }
                });
            }
        }

        private void doAdd() {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.actionList.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Class cmd = null;
            Object obj = node.getUserObject();
            if (obj == null) {
                cmd = null;
            } else if (obj instanceof ActionInfo) {
                cmd = ((ActionInfo)obj).getCommandInterface();
            } else {
                return;
            }
            if (!this.palette) {
                this.setVisible(false);
            }
            AgendaBean.this.doAddAction(cmd);
        }

        private class ActionRenderer
        extends DefaultTreeCellRenderer {
            private ActionRenderer() {
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focused) {
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, focused);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object obj = node.getUserObject();
                if (obj == null) {
                    this.setText(AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_COMPOUNDACTIONITEM));
                    this.setIcon(AgendaBean.this.i18n.getIcon((PropertiesEnum)StringsProperties.AGENDABEAN_COMPOUNDACTIONICON));
                } else if (obj instanceof ActionGroup) {
                    ActionGroup grp = (ActionGroup)obj;
                    this.setText(grp.getDisplayName());
                    this.setIcon(grp.getIcon());
                } else if (obj instanceof ActionInfo) {
                    ActionInfo act = (ActionInfo)obj;
                    this.setText(act.getDisplayName());
                    this.setIcon(null);
                }
                return this;
            }
        }
    }

    private class AgendaUpload
    extends Transfer {
        private File file;
        private long id;
        private boolean suppressEdit;
        private InputStream inputStream;
        private long ackSize;

        public AgendaUpload(Agenda agenda, File file, boolean suppressEdit) {
            super((Object)agenda, 1);
            this.file = file;
            this.id = AgendaBean.this.newUploadID();
            this.suppressEdit = suppressEdit;
            this.setBufferSize(400);
            this.setTransferSize(file.length());
        }

        public long getID() {
            return this.id;
        }

        public Agenda getAgenda() {
            return (Agenda)this.getObject();
        }

        public void start(int agendaID) throws IOException {
            this.inputStream = new BufferedInputStream(new FileInputStream(this.file));
            try {
                Agenda ag = this.getAgenda();
                ag.setID(agendaID);
                ag.addTransfer((Transfer)this);
                AgendaBean.this.library.addAgenda(ag, AgendaBean.this.terminal.getClient().getAddress());
                this.start();
            }
            catch (QuotaExceededException quotaExceededException) {
                // empty catch block
            }
        }

        public int read(byte[] buffer) throws IOException {
            this.setTransferSize(this.file.length());
            return this.inputStream.read(buffer);
        }

        public void write(byte[] buffer, int offset, int length) throws IOException {
            AgendaBean.this.sendUploadAgendaDataMessage(this.id, buffer, offset, length);
        }

        public synchronized long waitFor() {
            try {
                this.ackSize = 0L;
                AgendaBean.this.sendUploadAgendaAckMessage(this.id);
                ((Object)((Object)this)).wait();
            }
            catch (IOException ex) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.ackSize;
        }

        public synchronized void ack(long ackSize) {
            this.ackSize = ackSize;
            ((Object)((Object)this)).notifyAll();
        }

        public void close() throws IOException {
            this.inputStream.close();
        }

        public void completed(long crc32) throws IOException {
            AgendaBean.this.sendUploadAgendaCompleteMessage(this.id, crc32);
            try {
                String prefix = AgendaBean.this.module.getPrefix();
                Preferences prefs = AgendaBean.this.module.getPreferences();
                if (!this.suppressEdit && AgendaPreferences.isOpenFunctionDisplaysAgenda(prefix, prefs)) {
                    Agenda ag = this.getAgenda();
                    AgendaBean.this.sendDownloadDefinitionRequestMessage(AgendaBean.newDownloadID(), ag);
                }
            }
            catch (IOException ex) {
                ModalDialog.showMessageDialog((Component)AgendaBean.this, (Object)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DEFINEAGENDAFAILEDMESSAGE), (String)AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_DEFINEAGENDAFAILEDTITLE), (int)0);
            }
        }

        public void canceled() throws IOException {
            AgendaBean.this.sendUploadAgendaCancelMessage(this.id);
            Agenda ag = this.getAgenda();
            ag.removeTransfer((Transfer)this);
            AgendaBean.this.library.removeAgenda(ag, AgendaBean.this.terminal.getClient().getAddress());
        }

        public void error(IOException exception) {
        }

        public void cleanup() {
            this.getAgenda().removeTransfer((Transfer)this);
            AgendaBean.this.uploads.remove(new Long(this.id));
        }
    }

    private class CommandTransferable
    implements Transferable {
        private DataFlavor[] flavors = new DataFlavor[]{EditorPanel.commandFlavor};
        private Class commandInterface;

        public CommandTransferable(Class commandInterface) {
            this.commandInterface = commandInterface;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return (DataFlavor[])this.flavors.clone();
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (int i = 0; i < this.flavors.length; ++i) {
                if (!this.flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(EditorPanel.commandFlavor)) {
                return new EditorPanel.CommandSelection(this.commandInterface);
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    private static class Download {
        private Agenda agenda;
        private AgendaFile file;
        private File destination;
        private long size;
        private OutputStream outputStream;
        private CRC32 crc32 = new CRC32();
        private long bytesReceived;

        public Download(Agenda agenda, long size) throws IOException {
            this(agenda, null, null, size);
        }

        public Download(Agenda agenda, File destination, long size) throws IOException {
            this(agenda, null, destination, size);
        }

        public Download(AgendaFile file, File destination, long size) throws IOException {
            this(null, file, destination, size);
        }

        private Download(Agenda agenda, AgendaFile file, File destination, long size) throws IOException {
            this.agenda = agenda;
            this.file = file;
            this.destination = destination;
            this.size = size;
            try {
                this.outputStream = destination != null ? new BufferedOutputStream(new FileOutputStream(destination)) : new ByteArrayOutputStream((int)size);
            }
            catch (IOException ex) {
                if (this.outputStream != null) {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (destination != null && destination.exists()) {
                    destination.delete();
                }
                throw ex;
            }
        }

        public Agenda getAgenda() {
            return this.agenda;
        }

        public byte[] getReceivedData() {
            if (this.outputStream instanceof ByteArrayOutputStream) {
                return ((ByteArrayOutputStream)this.outputStream).toByteArray();
            }
            return null;
        }

        public void receive(InputStream inputStream) throws IOException {
            int bytesRead;
            byte[] buf = new byte[1024];
            while ((bytesRead = inputStream.read(buf)) != -1) {
                this.outputStream.write(buf, 0, bytesRead);
                this.crc32.update(buf, 0, bytesRead);
                this.bytesReceived += (long)bytesRead;
            }
        }

        public void finish(long crc32Value) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (crc32Value == 0L) {
                LogSupport.log((String)"No checksum to check against");
            } else if (this.crc32.getValue() != crc32Value) {
                if (this.file != null) {
                    LogSupport.log((String)("Checksums do not match for downloaded file: " + this.file.getName()));
                } else {
                    LogSupport.log((String)("Checksums do not match for downloaded agenda: " + this.agenda.getName()));
                }
                this.outputStream = null;
                if (this.destination != null) {
                    this.destination.delete();
                }
            }
        }

        public void halt() {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputStream = null;
            if (this.destination != null) {
                this.destination.delete();
            }
        }
    }

    private class EmbeddedContentCache {
        private HashMap quizLists = new HashMap();
        private HashMap screenModels = new HashMap();
        private HashMap modificationDates = new HashMap();

        private EmbeddedContentCache() {
        }

        public Quiz[] getQuizzes(File file) throws IOException {
            List<Quiz> list = (List<Quiz>)this.quizLists.get(file);
            Long mod = (Long)this.modificationDates.get(file);
            if (mod == null || file.lastModified() < mod) {
                Quiz[] qzs;
                QuizModelAPI api = (QuizModelAPI)AgendaBean.this.imps.findBest(QuizModelAPI.class);
                if (api != null && (qzs = api.readQuizLibrary(file)) != null && qzs.length != 0) {
                    list = Arrays.asList(qzs);
                    this.quizLists.put(file, list);
                }
                this.modificationDates.put(file, new Long(file.lastModified()));
            }
            if (list != null) {
                return list.toArray(new Quiz[0]);
            }
            return new Quiz[0];
        }

        public WhiteboardScreenNode getWhiteboard(File file) throws IOException {
            WhiteboardScreenNode root = (WhiteboardScreenNode)this.screenModels.get(file);
            Long mod = (Long)this.modificationDates.get(file);
            if (mod == null || file.lastModified() < mod) {
                WhiteboardFilePreviewAPI api = (WhiteboardFilePreviewAPI)AgendaBean.this.imps.findBest(WhiteboardFilePreviewAPI.class);
                if (api != null) {
                    root = api.readWhiteboard(file);
                    this.screenModels.put(file, root);
                }
                this.modificationDates.put(file, new Long(file.lastModified()));
            }
            return root;
        }
    }

    private class FolderFilter
    extends FileFilter {
        private JFileChooser chooser;

        public FolderFilter(JFileChooser chooser) {
            this.chooser = chooser;
        }

        @Override
        public String getDescription() {
            return AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_FOLDERFILTER);
        }

        @Override
        public boolean accept(File file) {
            return this.chooser.isTraversable(file);
        }
    }

    private static class InsertionLocation {
        public AgendaNode parent = null;
        public int index = -1;
        public AgendaNode nodeLosingChildren = null;
        public int firstReparentedChildIndex = 0;

        private InsertionLocation() {
        }
    }

    private class OpenAgendaDocumentFilter
    extends FileFilter {
        private OpenAgendaDocumentFilter() {
        }

        @Override
        public String getDescription() {
            return AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_OPENAGENDADOCUMENTFILTER);
        }

        @Override
        public boolean accept(File file) {
            if (FileSysUtils.isTraversableDirectory((File)file)) {
                return true;
            }
            String filename = file.getName();
            int pos = filename.lastIndexOf(46);
            if (pos == -1) {
                return false;
            }
            String ext = filename.substring(pos);
            return ext.equalsIgnoreCase(".elpx") || ext.equalsIgnoreCase(".elp");
        }
    }

    private class SaveAgendaDocumentFilter
    extends FileFilter {
        private SaveAgendaDocumentFilter() {
        }

        @Override
        public String getDescription() {
            return AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_SAVEAGENDADOCUMENTFILTER);
        }

        @Override
        public boolean accept(File file) {
            if (FileSysUtils.isTraversableDirectory((File)file)) {
                return true;
            }
            String filename = file.getName();
            int pos = filename.lastIndexOf(46);
            if (pos == -1) {
                return false;
            }
            String ext = filename.substring(pos);
            return ext.equalsIgnoreCase(".elpx");
        }
    }

    private class TextFileFilter
    extends FileFilter {
        private TextFileFilter() {
        }

        @Override
        public String getDescription() {
            return AgendaBean.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_TEXTFILEFILTER);
        }

        @Override
        public boolean accept(File file) {
            if (FileSysUtils.isTraversableDirectory((File)file)) {
                return true;
            }
            String filename = file.getName();
            int pos = filename.lastIndexOf(46);
            if (pos == -1) {
                return false;
            }
            String ext = filename.substring(pos);
            return ext.equalsIgnoreCase(".txt");
        }
    }
}

