/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.activity.module.model;

import com.elluminate.classroom.client.messaging.Message;
import com.elluminate.groupware.activity.module.ActivityMessage;
import com.elluminate.util.Preferences;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ActivityTypeConfig {
    public static final String MINIMUM_VOLUME = "minimumVolume";
    public static final String INCLUDED_MESSAGES = "includedMessages";
    public static final String EXCLUDED_MESSAGES = "excludedMessages";
    public static final String DISABLED_MODULES = "disabledModules";
    public static final String MY_MESSAGES_ENABLED = "myMessagesEnabled";
    public static final String NOTIFICATIONS_ENABLED = "notificationsEnabled";
    public static final String TIMESTAMPS_DISPLAYED = "timestampsDisplayed";
    public static final String DELIM = "|";
    private int minimumVolume = 1;
    private List<String> includedMessages = new ArrayList<String>();
    private List<String> excludedMessages = new ArrayList<String>();
    private List<String> disabledModules = new ArrayList<String>();
    private boolean myMessagesEnabled = false;
    private boolean notificationsEnabled = true;
    private boolean timestampsDisplayed = true;
    private final Lock lock = new ReentrantLock();
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinimumVolume(int minimumVolume) {
        try {
            this.lock.lock();
            int old = this.minimumVolume;
            if (minimumVolume >= 1 && minimumVolume <= 10) {
                this.minimumVolume = minimumVolume;
            }
            this.changeSupport.firePropertyChange(MINIMUM_VOLUME, old, minimumVolume);
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getMinimumVolume() {
        return this.minimumVolume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void includeType(String type) {
        if (type == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.excludedMessages.contains(type)) {
                this.excludedMessages.remove(type);
                this.changeSupport.firePropertyChange(EXCLUDED_MESSAGES, type, null);
            }
            if (!this.includedMessages.contains(type)) {
                this.includedMessages.add(type);
                this.changeSupport.firePropertyChange(INCLUDED_MESSAGES, null, type);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isMessageIncluded(String messageName) {
        return this.includedMessages.contains(messageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getIncludes() {
        try {
            this.lock.lock();
            ArrayList<String> arrayList = new ArrayList<String>(this.includedMessages);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excludeType(String type) {
        if (type == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.includedMessages.contains(type)) {
                this.includedMessages.remove(type);
                this.changeSupport.firePropertyChange(INCLUDED_MESSAGES, type, null);
            }
            if (!this.excludedMessages.contains(type)) {
                this.excludedMessages.add(type);
                this.changeSupport.firePropertyChange(EXCLUDED_MESSAGES, null, type);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isMessageExcluded(String messageName) {
        return this.excludedMessages.contains(messageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getExcludes() {
        try {
            this.lock.lock();
            ArrayList<String> arrayList = new ArrayList<String>(this.excludedMessages);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeType(String type) {
        if (type == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.excludedMessages.contains(type)) {
                this.excludedMessages.remove(type);
                this.changeSupport.firePropertyChange(EXCLUDED_MESSAGES, type, null);
            }
            if (this.includedMessages.contains(type)) {
                this.includedMessages.remove(type);
                this.changeSupport.firePropertyChange(INCLUDED_MESSAGES, type, null);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModuleEnabled(String moduleName, boolean enabled) {
        try {
            this.lock.lock();
            if (enabled && this.disabledModules.contains(moduleName)) {
                this.disabledModules.remove(moduleName);
                this.changeSupport.firePropertyChange(DISABLED_MODULES, moduleName, null);
            } else if (!enabled && !this.disabledModules.contains(moduleName)) {
                this.disabledModules.add(moduleName);
                this.changeSupport.firePropertyChange(DISABLED_MODULES, null, moduleName);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModuleEnabled(String moduleName) {
        try {
            this.lock.lock();
            boolean bl = !this.disabledModules.contains(moduleName);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMyMessagesEnabled(boolean myMessagesEnabled) {
        try {
            this.lock.lock();
            boolean old = this.myMessagesEnabled;
            this.myMessagesEnabled = myMessagesEnabled;
            this.changeSupport.firePropertyChange(MY_MESSAGES_ENABLED, old, myMessagesEnabled);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isMyMessagesEnabled() {
        return this.myMessagesEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotificationsEnabled(boolean notificationsEnabled) {
        try {
            this.lock.lock();
            boolean old = this.notificationsEnabled;
            this.notificationsEnabled = notificationsEnabled;
            this.changeSupport.firePropertyChange(NOTIFICATIONS_ENABLED, old, notificationsEnabled);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isNotificationsEnabled() {
        return this.notificationsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestampsDisplayed(boolean timestampsDisplayed) {
        try {
            this.lock.lock();
            boolean old = this.timestampsDisplayed;
            this.timestampsDisplayed = timestampsDisplayed;
            this.changeSupport.firePropertyChange(TIMESTAMPS_DISPLAYED, old, timestampsDisplayed);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isTimestampsDisplayed() {
        return this.timestampsDisplayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeFromPreferences(String prefix, Preferences prefs) {
        if (prefs == null) {
            throw new IllegalArgumentException("Preferences can not be null");
        }
        try {
            this.lock.lock();
            this.minimumVolume = prefs.getIntegerSetting(prefix + "." + MINIMUM_VOLUME, this.minimumVolume);
            ActivityTypeConfig.populateList(prefs.getSetting(prefix + "." + DISABLED_MODULES), "\\|", this.disabledModules);
            this.myMessagesEnabled = prefs.getBooleanSetting(prefix + "." + MY_MESSAGES_ENABLED, this.myMessagesEnabled);
            this.notificationsEnabled = prefs.getBooleanSetting(prefix + "." + NOTIFICATIONS_ENABLED, this.notificationsEnabled);
            this.timestampsDisplayed = prefs.getBooleanSetting(prefix + "." + TIMESTAMPS_DISPLAYED, this.timestampsDisplayed);
            this.initializeOverridesFromPreferences(prefix, prefs);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void initializeOverridesFromPreferences(String prefix, Preferences prefs) {
        this.includedMessages.clear();
        this.excludedMessages.clear();
        ActivityTypeConfig.populateList(prefs.getSetting(prefix + "." + INCLUDED_MESSAGES), "\\|", this.includedMessages);
        ActivityTypeConfig.populateList(prefs.getSetting(prefix + "." + EXCLUDED_MESSAGES), "\\|", this.excludedMessages);
    }

    public void listenToPreferences(final String prefix, final Preferences prefs) {
        PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ActivityTypeConfig.this.initializeOverridesFromPreferences(prefix, prefs);
                ActivityTypeConfig.this.changeSupport.firePropertyChange(ActivityTypeConfig.EXCLUDED_MESSAGES, null, null);
            }
        };
        prefs.addSettingChangeListener(prefix + "." + EXCLUDED_MESSAGES, l);
        prefs.addSettingChangeListener(prefix + "." + INCLUDED_MESSAGES, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToPreferences(String prefix, Preferences prefs) {
        if (prefs == null) {
            throw new IllegalArgumentException("Preferences can not be null");
        }
        try {
            this.lock.lock();
            prefs.setSetting(prefix + "." + MINIMUM_VOLUME, this.minimumVolume);
            if (!this.includedMessages.isEmpty()) {
                prefs.setSetting(prefix + "." + INCLUDED_MESSAGES, ActivityTypeConfig.listAsString(this.includedMessages, DELIM));
            }
            if (!this.excludedMessages.isEmpty()) {
                prefs.setSetting(prefix + "." + EXCLUDED_MESSAGES, ActivityTypeConfig.listAsString(this.excludedMessages, DELIM));
            }
            if (!this.disabledModules.isEmpty()) {
                prefs.setSetting(prefix + "." + DISABLED_MODULES, ActivityTypeConfig.listAsString(this.disabledModules, DELIM));
            }
            prefs.setSetting(prefix + "." + MY_MESSAGES_ENABLED, this.myMessagesEnabled);
            prefs.setSetting(prefix + "." + NOTIFICATIONS_ENABLED, this.notificationsEnabled);
            prefs.setSetting(prefix + "." + TIMESTAMPS_DISPLAYED, this.timestampsDisplayed);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isDisplayMessage(ActivityMessage msg) {
        if (msg == null) {
            return false;
        }
        Message originalMessage = msg.getOriginalMessage();
        if (originalMessage != null) {
            if (this.isMessageExcluded(originalMessage.getMessageType().getUniqueName())) {
                return false;
            }
            if (this.isMessageIncluded(originalMessage.getMessageType().getUniqueName())) {
                return true;
            }
        }
        if (!this.isNotificationsEnabled() && msg.getVolume() == 11) {
            return false;
        }
        if (!this.isModuleEnabled(msg.getOrigModuleName())) {
            return false;
        }
        if (!this.isMyMessagesEnabled() && msg.isFromMe()) {
            return false;
        }
        return msg.getVolume() >= this.minimumVolume;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(property, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(property, l);
    }

    public static void setIncludedMessages(String prefix, Preferences preferences, List<String> list) {
        preferences.setSetting(prefix + "." + INCLUDED_MESSAGES, ActivityTypeConfig.listAsString(list, DELIM));
    }

    public static List<String> getIncludedMessages(String prefix, Preferences preferences) {
        ArrayList<String> list = new ArrayList<String>();
        ActivityTypeConfig.populateList(preferences.getSetting(prefix + "." + INCLUDED_MESSAGES), "\\|", list);
        return list;
    }

    public static void setExcludedMessages(String prefix, Preferences preferences, List<String> list) {
        preferences.setSetting(prefix + "." + EXCLUDED_MESSAGES, ActivityTypeConfig.listAsString(list, DELIM));
    }

    public static List<String> getExcludedMessages(String prefix, Preferences preferences) {
        ArrayList<String> list = new ArrayList<String>();
        ActivityTypeConfig.populateList(preferences.getSetting(prefix + "." + EXCLUDED_MESSAGES), "\\|", list);
        return list;
    }

    private static String listAsString(List<String> orig, String delim) {
        StringBuffer reply = new StringBuffer();
        if (orig != null) {
            for (String item : orig) {
                if (orig.indexOf(item) > 0) {
                    item = DELIM + item;
                }
                reply.append(item);
            }
        }
        return reply.toString();
    }

    private static void populateList(String orig, String delim, List<String> toPopulate) {
        if (orig != null) {
            for (String value : orig.split(delim)) {
                toPopulate.add(value);
            }
        }
    }
}

