/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.activity.module.model;

import com.elluminate.classroom.client.messaging.Message;
import com.elluminate.classroom.client.messaging.MessageListener;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.groupware.activity.ActivityDebug;
import com.elluminate.groupware.activity.module.ActivityMessage;
import com.elluminate.groupware.activity.module.ActivityTypeConfigProvider;
import com.elluminate.groupware.activity.module.listener.ActivityConfigAvailableListener;
import com.elluminate.groupware.activity.module.listener.ActivityDataListener;
import com.elluminate.groupware.activity.module.listener.ActivityUIListener;
import com.elluminate.groupware.activity.module.model.ActivityTypeConfig;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@Singleton
public class ActivityDisplayStateModel
implements MessageListener {
    private final Lock lock = new ReentrantLock();
    private Provider<ActivityTypeConfig> configProvider;
    private MessageRouter msgRouter;
    private List<MessagePublisherMetadata> publishers = new ArrayList<MessagePublisherMetadata>();
    private boolean visible = false;
    private ArrayList<ActivityMessage> allMessages = new ArrayList();
    private ArrayList<ActivityMessage> displayMessages = new ArrayList();
    private List<ActivityDataListener> registeredDataListeners = new ArrayList<ActivityDataListener>();
    private List<ActivityUIListener> registeredUIListeners = new ArrayList<ActivityUIListener>();
    private Logger log;

    @Inject
    public ActivityDisplayStateModel(MessageRouter router, Provider<ActivityTypeConfig> confProvider) {
        this.configProvider = confProvider;
        this.msgRouter = router;
    }

    @Inject
    public void initActivityTypeConfigProvider(ActivityTypeConfigProvider provider) {
        provider.addConfigAvailableListener(new ActivityConfigAvailableListener(){

            @Override
            public void available() {
                ActivityDisplayStateModel.this.registerConfigInstance();
            }
        });
    }

    @Inject
    public void initLogger(Logger logger) {
        this.log = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityMessage getMessageAtIndex(int index) {
        try {
            this.lock.lock();
            ActivityMessage activityMessage = this.displayMessages.get(index);
            return activityMessage;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<ActivityMessage> getAllDisplayMessages() {
        return new ArrayList<ActivityMessage>(this.displayMessages);
    }

    public boolean isVisible() {
        return this.visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean vis) {
        this.lock.lock();
        try {
            this.visible = vis;
            for (ActivityUIListener listener : this.registeredUIListeners) {
                listener.visibilityChange(this.visible);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataListener(ActivityDataListener listener) {
        if (listener == null) {
            return;
        }
        this.lock.lock();
        try {
            this.removeDataListener(listener);
            this.registeredDataListeners.add(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUIListener(ActivityUIListener listener) {
        if (listener == null) {
            return;
        }
        this.lock.lock();
        try {
            this.removeUIListener(listener);
            this.registeredUIListeners.add(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataListener(ActivityDataListener listener) {
        if (listener == null) {
            return;
        }
        this.lock.lock();
        try {
            this.registeredDataListeners.remove(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUIListener(ActivityUIListener listener) {
        if (listener == null) {
            return;
        }
        this.lock.lock();
        try {
            this.registeredUIListeners.remove(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(ActivityMessage incoming) {
        if (incoming == null) {
            return;
        }
        try {
            this.lock.lock();
            this.displayMessages.add(incoming);
            int index = this.displayMessages.indexOf(incoming);
            for (ActivityDataListener listener : this.registeredDataListeners) {
                listener.newMessageAvailable(index);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<MessagePublisherMetadata> getAllPublishers() {
        return new ArrayList<MessagePublisherMetadata>(this.publishers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMessages() {
        try {
            this.lock.lock();
            this.displayMessages.clear();
            for (ActivityDataListener listener : this.registeredDataListeners) {
                listener.clearMessages();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void registerConfigInstance() {
        ActivityTypeConfig config = (ActivityTypeConfig)this.configProvider.get();
        config.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ActivityDisplayStateModel.this.updateMessages();
            }
        });
        this.msgRouter.registerListener((MessageListener)this);
        this.updateMessages();
    }

    private void updateMessages() {
        this.clearMessages();
        ActivityTypeConfig config = (ActivityTypeConfig)this.configProvider.get();
        for (ActivityMessage msg : this.allMessages) {
            if (!config.isDisplayMessage(msg)) continue;
            this.addMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newPublisherAvailable(MessagePublisherMetadata publisherInfo) {
        if (ActivityDebug.NOTIFY.show()) {
            this.log.log("new publisher available: " + publisherInfo.getPublisherUniqueName() + "[" + publisherInfo.getPublisherDisplayName() + "]");
        }
        try {
            this.lock.lock();
            this.publishers.add(publisherInfo);
            this.msgRouter.addListener((MessageListener)this, publisherInfo.getMessageTypes());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void receiveMessage(Message msg) {
        if (msg == null) {
            return;
        }
        ActivityMessage aMsg = new ActivityMessage(msg);
        this.allMessages.add(aMsg);
        if (((ActivityTypeConfig)this.configProvider.get()).isDisplayMessage(aMsg)) {
            this.addMessage(aMsg);
        }
    }
}

