/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.activity.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.groupware.activity.accessibility.AccessibleCLI;
import com.elluminate.groupware.activity.module.ActivityBean;
import com.elluminate.groupware.activity.module.ActivityTypeConfigProvider;
import com.elluminate.groupware.activity.module.MessageFilterPrefsPanel;
import com.elluminate.groupware.activity.module.StringsProperties;
import com.elluminate.groupware.activity.module.listener.ActivityUIListener;
import com.elluminate.groupware.activity.module.model.ActivityDisplayStateModel;
import com.elluminate.groupware.activity.module.model.ActivityTypeConfig;
import com.elluminate.groupware.imps.AccessibilityCLIAPI;
import com.elluminate.groupware.imps.PlaybackTimeAPI;
import com.elluminate.groupware.imps.PlaybackTimeListener;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import javax.swing.Icon;

@Singleton
public class ActivityModule
extends AbstractClientModule
implements ModulePublisherInfo,
PreferencesPanelOwner,
PlaybackTimeListener {
    private I18n i18n;
    private static final String MODULE_NAME = "Activity";
    private String prefix = ((Object)((Object)this)).getClass().getName();
    private Provider<ActivityBean> beanProvider;
    private ActivityBean activityBean;
    private ActivityDisplayStateModel activityModel;
    private ActivityTypeConfigProvider activityProvider;
    private Provider<MessageFilterPrefsPanel> prefsProvider;
    private Preferences preferences;
    private FeatureBroker broker;
    private BooleanFeature showBtnFeature;
    private ComponentFeature activityPanelFeature;
    private ComponentFeature prefsFeature;
    private ClientProvider clientProvider;
    private Imps imps;
    private ConferencingEngine conferencingEngine;

    @Inject
    public ActivityModule() {
    }

    @Inject
    protected void initVersionManager(ComponentRegistrar cr) {
        cr.registerComponent((Object)this);
    }

    @Inject
    public void initActivityBeanProvider(Provider<ActivityBean> bp) {
        this.beanProvider = bp;
    }

    @Inject
    public void initActivityTypeConfigProvider(ActivityTypeConfigProvider ap) {
        this.activityProvider = ap;
    }

    @Inject
    public void initPrefsPanel(Provider<MessageFilterPrefsPanel> prefsProv) {
        this.prefsProvider = prefsProv;
    }

    @Inject
    public void initActivityModel(ActivityDisplayStateModel model) {
        this.activityModel = model;
        this.activityModel.addUIListener(new ActivityUIListener(){

            @Override
            public void visibilityChange(boolean change) {
                ActivityModule.this.broker.setFeaturePublished((Feature)ActivityModule.this.activityPanelFeature, change);
            }
        });
    }

    @Inject
    public void initPreferences(Preferences prefs) {
        this.preferences = prefs;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initI18n(I18n i18n) {
        this.i18n = i18n;
    }

    @Inject
    public void initClientProvider(ClientProvider prov) {
        this.clientProvider = prov;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine conferencingEngine) {
        this.conferencingEngine = conferencingEngine;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYMODULE_NAME);
    }

    public Icon getModuleIcon() {
        return this.i18n.getIcon((PropertiesEnum)StringsProperties.ACTIVITYMODULE_ICON);
    }

    private void createFeatures() {
        this.activityPanelFeature = this.broker.createComponentFeature((Object)this, "/activity/activityPanel", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return ActivityModule.this.activityBean;
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYMODULE_NAME), this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYMODULE_NAME));
        this.showBtnFeature = this.broker.createBooleanFeature((Object)this, "/activity/showMenu", true, false, "activity_showMenu", null);
        this.showBtnFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYMODULE_SHOWACTIVITYITEM));
        this.showBtnFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYMODULE_SHOWACTIVITYITEM));
        this.showBtnFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                boolean newValue = Boolean.parseBoolean(ev.getNewValue().toString());
                ActivityModule.this.activityModel.setVisible(newValue);
            }
        });
        this.prefsFeature = this.broker.createComponentFeature((Object)this, "/activity/prefs", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return (Component)ActivityModule.this.prefsProvider.get();
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.MESSAGEFILTERPREFS_TITLE), this.i18n.getString((PropertiesEnum)StringsProperties.MESSAGEFILTERPREFS_TITLE));
        this.prefsFeature.setEnabled(true);
        this.broker.addFeature((Feature)this.showBtnFeature);
        this.broker.addFeature((Feature)this.prefsFeature);
    }

    public void start() {
    }

    public void attach() {
        this.registerAccessibleCLI();
        this.activityBean = (ActivityBean)this.beanProvider.get();
        ActivityTypeConfig conf = this.activityProvider.get();
        conf.initializeFromPreferences(this.prefix, this.preferences);
        this.activityBean.loadPreferences(this.prefix, this.preferences);
        conf.listenToPreferences(this.prefix, this.preferences);
        PlaybackTimeAPI playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (playbackTimeApi != null) {
            playbackTimeApi.addPlaybackTimeListener((PlaybackTimeListener)this);
        }
        this.activityProvider.configIsReady();
    }

    public void detach() {
        PlaybackTimeAPI playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (playbackTimeApi != null) {
            playbackTimeApi.removePlaybackTimeListener((PlaybackTimeListener)this);
        }
        this.activityBean.savePreferences(this.prefix, this.preferences);
        this.activityBean = null;
    }

    public void setupUI() {
        this.createFeatures();
    }

    public void cleanupUI() {
    }

    public void stop() {
    }

    private void registerAccessibleCLI() {
        Client client = this.clientProvider.get();
        AccessibleCLI accessibleCLI = new AccessibleCLI(client.isPlayback(), this.conferencingEngine);
        this.imps.provideAPI(AccessibilityCLIAPI.class, (ImpsAPI)accessibleCLI);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getTitle() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYMODULE_NAME);
    }

    public Icon getIcon() {
        return this.i18n.getIcon((PropertiesEnum)StringsProperties.ACTIVITYMODULE_ICON);
    }

    public void resetSession() {
        this.activityModel.clearMessages();
    }

    public void setLinearity(PlaybackTimeListener.Linearity linearity) {
    }
}

