/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer.module;

import com.elluminate.groupware.transfer.AbstractTransferClient;
import com.elluminate.groupware.transfer.TransferProtocol;
import com.elluminate.groupware.transfer.module.ClientAPIImpl;
import com.elluminate.groupware.transfer.module.ClientTransferLibrary;
import com.elluminate.groupware.transfer.module.FIDClient;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.JinxChannelException;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.util.log.LogSupport;

public class TransferClient
extends AbstractTransferClient {
    private String instanceName = null;
    private ClientAPIImpl ftcImpl = null;
    private int refCount = 0;
    private Channel chnl = null;
    private FIDClient fidClient = null;

    public TransferClient(Client client, ClientAPIImpl impl, String name, TransferProtocol transferProtocol) {
        this.instanceName = name;
        this.ftcImpl = impl;
        ChannelDataListener dataListener = null;
        dataListener = new ChannelDataListener(){

            public void onChannelData(ChannelDataEvent e) {
                TransferClient.this.processChannelData(e);
            }
        };
        ChannelListener chnlListener = null;
        chnlListener = new ChannelListener(){

            public void channelStateChanged(ChannelEvent e) {
                TransferClient.this.processChannelState(e);
            }
        };
        try {
            this.chnl = client.acquireChannel("transfer." + name, (byte)2, chnlListener, dataListener);
        }
        catch (JinxChannelException cx) {
            throw new RuntimeException("Duplicate transfer channel.");
        }
        this.chnl.setProtocol((JinxProtocol)transferProtocol);
        this.fidClient = new FIDClient(this.chnl);
        this.lib = new ClientTransferLibrary(this.chnl, this.fidClient);
        if (this.chnl.isUp()) {
            this.lib.addProxy((short)0);
        }
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void dispose() {
        if (this.chnl != null) {
            this.chnl.getConnection().releaseChannel(this.chnl);
            this.chnl = null;
        }
        if (this.lib != null) {
            this.lib.dispose();
            this.lib = null;
        }
    }

    private void processChannelData(ChannelDataEvent e) {
        switch (e.getCommand() & 0x60) {
            case 32: {
                this.fidClient.onChannelData(e);
                break;
            }
            case 0: {
                this.lib.onChannelData(e);
                break;
            }
            default: {
                LogSupport.error((Object)((Object)this), (String)"processChannelData", (String)("Unexpected command " + e.getCommand() + " received from " + e.getSourceAddress()));
            }
        }
    }

    private void processChannelState(ChannelEvent e) {
        switch (e.getState()) {
            case 1: {
                if (this.lib == null) break;
                this.lib.addProxy((short)0);
                break;
            }
            case 2: {
                if (this.lib == null) break;
                this.lib.removeProxy((short)0);
            }
        }
    }
}

