/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer.module;

import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.session.CRPermissionDelegate;
import com.elluminate.framework.session.CRPermissionFactory;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.imps.FileTransferClientAPI;
import com.elluminate.groupware.imps.filetransfer.FileTransferClient;
import com.elluminate.groupware.imps.filetransfer.FileTransferException;
import com.elluminate.groupware.imps.filetransfer.FileTransferItem;
import com.elluminate.groupware.imps.filetransfer.FileTransferListener;
import com.elluminate.groupware.imps.filetransfer.FileTransferProgressListener;
import com.elluminate.groupware.imps.filetransfer.FileTransferRequestListener;
import com.elluminate.groupware.module.JinxTerminal;
import com.elluminate.groupware.transfer.XferDebug;
import com.elluminate.groupware.transfer.module.FileCellRenderer;
import com.elluminate.groupware.transfer.module.LengthCellRenderer;
import com.elluminate.groupware.transfer.module.LoadDialog;
import com.elluminate.groupware.transfer.module.Percentage;
import com.elluminate.groupware.transfer.module.ProgressCellRenderer;
import com.elluminate.groupware.transfer.module.ServerCellRenderer;
import com.elluminate.groupware.transfer.module.StringsProperties;
import com.elluminate.groupware.transfer.module.TransferPermissionDelegate;
import com.elluminate.groupware.transfer.module.TransferPublisher;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.AccessibleToolBar;
import com.elluminate.gui.component.CToolBarButton;
import com.elluminate.gui.component.VariableRenderer;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.gui.swing.CTable;
import com.elluminate.gui.swing.CTableHeader;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ConnectionEvent;
import com.elluminate.jinx.ConnectionListener;
import com.elluminate.jinx.JinxConnectionException;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SerializerThread;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

@Singleton
public class TransferBean
extends JPanel
implements FileTransferListener,
FileTransferRequestListener,
ConnectionListener,
PropertyChangeListener {
    private static final I18n i18n = I18n.create(TransferBean.class);
    public static final int COL_NAME = 0;
    public static final int COL_OWNER = 1;
    public static final int COL_SIZE = 2;
    public static final int COL_SERVER = 3;
    public static final int COL_HIST = 4;
    public static final int COL_SAVE = 5;
    public static final int COL_UID = 6;
    public static final Object[] COLUMN_NAMES = new Object[]{i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_FILENAMECOL), i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_OWNERCOL), i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_SIZECOL), i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_SERVERCOL), i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_STATUSCOL), i18n.getIcon("TransferBean.saveCol"), "hidden"};
    public static final Color[] COLORS = new Color[]{new Color(255, 40, 0), Color.orange, new Color(255, 205, 0), Color.cyan, new Color(40, 169, 64)};
    public static final ImageIcon savingIcon = i18n.getIcon("TransferBean.savingIcon");
    public static final ImageIcon savedIcon = i18n.getIcon("TransferBean.savedIcon");
    private JScrollPane fileScroller = new JScrollPane();
    private JTable files = null;
    private BorderLayout borderLayout1 = new BorderLayout();
    private FileTransferClientAPI impl = null;
    private FileTransferClient xfer = null;
    private TableColumnModel cModel = null;
    private DefaultTableModel model = null;
    private JTableHeader header = null;
    private HashMap savingIDs = new HashMap();
    private HashSet savedIDs = new HashSet();
    private LightweightTimer updateTimer;
    private boolean amChair = false;
    private LoadDialog loadDialog = null;
    private File loadWorkingDir = null;
    private File saveWorkingDir = null;
    private URL lastURL = null;
    private boolean lastPushSelected = true;
    private SerializerThread queryThread = new SerializerThread();
    private TransferPublisher msgPublisher;
    private CToolBarButton addFileButton = new CToolBarButton();
    private CToolBarButton addURLButton = new CToolBarButton();
    private JToolBar.Separator fileOperationSeparator = new JToolBar.Separator();
    private CToolBarButton saveFileButton = new CToolBarButton();
    private CToolBarButton deleteFileButton = new CToolBarButton();
    private JToolBar.Separator promptSeparator = new JToolBar.Separator();
    private CToolBarButton promptButton = new CToolBarButton();
    private JinxTerminal terminal;
    private ClientList clients;
    private Imps imps;
    private DialogParentProvider parentProv;
    private ClientProvider clientProvider;
    private CRSession session;
    private TransferPermissionDelegate transferPermissionDelegate;
    private ChangeUI runUpdate = new ChangeUI();

    public FileTransferClient getXfer() {
        return this.xfer;
    }

    @Inject
    protected void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    protected void initTransferPermissionDelegate(TransferPermissionDelegate transferPermissionDelegate) {
        this.transferPermissionDelegate = transferPermissionDelegate;
    }

    public TransferBean() {
        this.queryThread.setDaemon(true);
        this.queryThread.setIdleTime(60);
        this.header = new CTableHeader();
        this.model = new DefaultTableModel(COLUMN_NAMES, 0){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.files = new CTable();
        this.files.setAutoCreateColumnsFromModel(false);
        this.files.setTableHeader(this.header);
        this.files.setModel(this.model);
        this.files.setPreferredScrollableViewportSize(new Dimension(640, 250));
        this.files.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    TransferBean.this.updateButtonsEnabled();
                }
            }
        });
        this.model.addTableModelListener(this.files);
        this.cModel = this.files.getColumnModel();
        this.header.setColumnModel(this.cModel);
        this.header.setReorderingAllowed(false);
        this.cModel.addColumnModelListener(this.header);
        TableColumn col = new TableColumn(0, 200);
        col.setHeaderValue(COLUMN_NAMES[0]);
        col.setCellRenderer(new FileCellRenderer());
        this.cModel.addColumn(col);
        col = new TableColumn(1, 100);
        col.setHeaderValue(COLUMN_NAMES[1]);
        this.cModel.addColumn(col);
        col = new TableColumn(2, 100);
        col.setHeaderValue(COLUMN_NAMES[2]);
        col.setCellRenderer(new LengthCellRenderer());
        this.cModel.addColumn(col);
        col = new TableColumn(3, 100);
        col.setHeaderValue(COLUMN_NAMES[3]);
        col.setCellRenderer(new ServerCellRenderer());
        this.cModel.addColumn(col);
        col = new TableColumn(4, 100);
        col.setHeaderValue(COLUMN_NAMES[4]);
        col.setCellRenderer(new ProgressCellRenderer(COLORS));
        this.cModel.addColumn(col);
        col = new TableColumn(5, 20);
        col.setHeaderValue(COLUMN_NAMES[5]);
        col.setCellRenderer((TableCellRenderer)new VariableRenderer());
        col.setResizable(false);
        this.cModel.addColumn(col);
        this.files.setShowHorizontalLines(false);
        this.files.setShowVerticalLines(true);
        this.files.setGridColor(new Color(224, 224, 224));
        this.files.setIntercellSpacing(new Dimension(1, 1));
        this.files.setRowHeight(20);
        this.files.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TransferBean.this.files.requestFocus();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int row = TransferBean.this.files.rowAtPoint(e.getPoint());
                if (row == -1 || row >= TransferBean.this.model.getRowCount()) {
                    TransferBean.this.files.clearSelection();
                }
            }
        });
        FullSizeViewport vp = new FullSizeViewport();
        vp.setView(this.files);
        this.fileScroller.setViewport(vp);
        String removeFileAction = "remove-file";
        InputMap imap = this.files.getInputMap(0);
        imap.put(KeyStroke.getKeyStroke(127, 0), "remove-file");
        imap.put(KeyStroke.getKeyStroke(8, 0), "remove-file");
        this.files.getActionMap().put("remove-file", new AbstractAction("remove-file"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Chair chair = ChairProtocol.getChair((ClientList)TransferBean.this.clients);
                if (chair.isMe()) {
                    TransferBean.this.doDelete();
                }
            }
        });
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateTimer = new LightweightTimer(2, (Runnable)this.runUpdate);
    }

    @Inject
    public void initTransferPublisher(TransferPublisher pub) {
        this.msgPublisher = pub;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initTerminal(JinxTerminal terminal) {
        this.terminal = terminal;
    }

    @Inject
    public void initParentProvider(DialogParentProvider prov) {
        this.parentProv = prov;
    }

    public void setClient(Client c) {
        if (this.terminal.getClient() != null) {
            this.terminal.getClient().removeConnectionListener((ConnectionListener)this);
        }
        this.clients = this.terminal.getClientList();
        this.clients.addPropertyChangeListener("transfer.file.access", (byte)0, (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("chair", (byte)1, (PropertyChangeListener)this);
        boolean playback = this.terminal.isPlayback();
        boolean connected = this.terminal.getClient().isConnected();
        this.addFileButton.setEnabled(!playback && connected);
        this.addURLButton.setEnabled(!playback && connected);
        this.terminal.getClient().addConnectionListener((ConnectionListener)this);
        try {
            this.impl = (FileTransferClientAPI)this.imps.findBest(FileTransferClientAPI.class);
            this.xfer = this.impl.getInstance("file", (FileTransferListener)this);
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"configure", (Throwable)t, (boolean)true);
            throw new RuntimeException("Unable to load file transfer instance.");
        }
        if (this.transferPermissionDelegate != null) {
            this.transferPermissionDelegate.setClientProvider(this.clientProvider);
            this.transferPermissionDelegate.setSession(this.session);
            CRPermissionFactory permissionFactory = new CRPermissionFactory("TransferPermission", "TransferPermission", CRPermissionScope.PARTICIPANT, (CRPermissionDelegate)this.transferPermissionDelegate);
            this.session.registerPermission(permissionFactory);
            this.clients.addPropertyChangeListener(this.transferPermissionDelegate.getPropertyName(), (byte)0, (PropertyChangeListener)((Object)this.transferPermissionDelegate));
            this.clients.addDefaultPropertyChangeListener(this.transferPermissionDelegate.getPropertyName(), (byte)0, (PropertyChangeListener)((Object)this.transferPermissionDelegate));
        }
    }

    public void connectionStatusChanged(ConnectionEvent event) throws JinxConnectionException {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean playback = TransferBean.this.terminal.isPlayback();
                boolean connected = TransferBean.this.terminal.getClient() != null && TransferBean.this.terminal.getClient().isConnected();
                TransferBean.this.addFileButton.setEnabled(!playback && connected);
                TransferBean.this.addURLButton.setEnabled(!playback && connected);
            }
        });
    }

    public void setShowing(boolean visible) {
        if (visible) {
            SwingRunnerSupport.invokeLater((Runnable)this.runUpdate);
            this.updateTimer.scheduleEvery(2500L);
        } else {
            this.updateTimer.cancel();
        }
    }

    private void updateButtonsEnabled() {
        int[] rows = this.files.getSelectedRows();
        this.saveFileButton.setEnabled(rows != null && rows.length != 0);
        this.deleteFileButton.setEnabled(rows != null && rows.length != 0);
        this.promptButton.setEnabled(rows != null && rows.length != 0);
    }

    private void query(final FileTransferItem item) {
        Runnable query = new Runnable(){

            @Override
            public void run() {
                String routerMsg;
                String msg;
                boolean isMe = false;
                if (item.getOwner().equals(" ---")) {
                    msg = i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_SAVEPRELOADPROMPT, new Object[]{item.getName()});
                    routerMsg = i18n.getString((PropertiesEnum)StringsProperties.TRANSFERPUBLISHER_MESSAGING_SAVE_PRELOAD_PROMPT, new Object[]{item.getName()});
                } else {
                    ClientInfo ci = TransferBean.this.clients.get(item.getOwner());
                    String displayName = "";
                    if (ci != null) {
                        displayName = ci.getDisplayName();
                        isMe = ci.isMe();
                    }
                    msg = i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_SAVEPROMPT, new Object[]{displayName, item.getName()});
                    routerMsg = i18n.getString((PropertiesEnum)StringsProperties.TRANSFERPUBLISHER_MESSAGE_SAVE_PROMPT, new Object[]{displayName, item.getName()});
                }
                TransferBean.this.msgPublisher.sendReceiveFileMessage(routerMsg, isMe);
                int answer = ModalDialog.showConfirmDialog((Component)TransferBean.this.parentProv.getDialogParent(), (Object)msg, (String)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_PROMPTTITLE), (int)0);
                if (answer == 0) {
                    TransferBean.this.doSave(item);
                }
            }
        };
        this.queryThread.invokeLater(query);
    }

    public byte disconnectQuery() {
        if (this.xfer == null) {
            return 0;
        }
        ArrayList<String> downloads = new ArrayList<String>();
        ArrayList<String> uploads = new ArrayList<String>();
        for (FileTransferItem item : this.xfer) {
            if (item.isUploading()) {
                uploads.add(item.getName());
                continue;
            }
            if (!this.savingIDs.containsKey(new Integer(item.getUID()))) continue;
            downloads.add(item.getName());
        }
        if (downloads.isEmpty() && uploads.isEmpty()) {
            return 0;
        }
        StringBuffer dList = new StringBuffer();
        Iterator i = downloads.iterator();
        while (i.hasNext()) {
            dList.append("    ");
            dList.append((String)i.next());
            dList.append("\n");
        }
        StringBuffer uList = new StringBuffer();
        Iterator i2 = uploads.iterator();
        while (i2.hasNext()) {
            uList.append("    ");
            uList.append((String)i2.next());
            uList.append("\n");
        }
        String message = downloads.isEmpty() ? i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_ULDISCONNECTQUERY, new Object[]{uList.toString()}) : (uploads.isEmpty() ? i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_DLDISCONNECTQUERY, new Object[]{dList.toString()}) : i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_DISCONNECTQUERY, new Object[]{dList.toString(), uList.toString()}));
        int result = ModalDialog.showConfirmDialog((Component)this.parentProv.getDialogParent(), (Object)message, (String)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_DISCONNECTTITLE), (int)0);
        if (result == 0) {
            return 1;
        }
        return -1;
    }

    public void fileAdded(FileTransferItem item) {
        SwingRunnerSupport.invokeLater((Runnable)new UpdateUI(item));
    }

    public void fileRemoved(FileTransferItem item) {
        if (this.savingIDs.containsKey(new Integer(item.getUID()))) {
            ModalDialog.showMessageDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_SAVEABORTMSG, new Object[]{item.getName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_SAVEABORTTITLE), (int)2);
        }
        SwingRunnerSupport.invokeLater((Runnable)new UpdateUI(item.getUID()));
    }

    public void fileAttributeChanged(FileTransferItem item, String attr) {
        if (attr.equals("query") && item.getAttribute(attr).equals("true") && !item.getOwner().equals(this.clients.getMyName())) {
            this.query(item);
        }
    }

    public void fileChanged(FileTransferItem item) {
    }

    public void transferError(FileTransferException ftx) {
        this.showError(ftx);
    }

    public void notifyComplete(int req, int id) {
    }

    public void notifyException(int req, FileTransferException ftx) {
        this.showError(ftx);
    }

    private void showError(FileTransferException ftx) {
        ModalDialog.showMessageDialogAsync((int)-1, (Component)this, (Object)ftx.getMessage(), (String)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_ERRORTITLE), (int)0);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        AccessibleToolBar tb = new AccessibleToolBar();
        tb.setFloatable(false);
        this.add((Component)tb, "North");
        this.addFileButton.setIcon((Icon)i18n.getIcon("TransferBean.addFileIcon"));
        this.addFileButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_ADDFILEBUTTONTIP));
        this.addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferBean.this.doLoadFile();
            }
        });
        tb.add((Component)this.addFileButton);
        this.addURLButton.setIcon((Icon)i18n.getIcon("TransferBean.addURLIcon"));
        this.addURLButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_ADDURLBUTTONTIP));
        this.addURLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferBean.this.doLoadURL();
            }
        });
        tb.add((Component)this.addURLButton);
        tb.add(this.fileOperationSeparator);
        this.saveFileButton.setIcon((Icon)i18n.getIcon("TransferBean.saveFileIcon"));
        this.saveFileButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_SAVEFILEBUTTONTIP));
        this.saveFileButton.setEnabled(false);
        this.saveFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferBean.this.doSave();
            }
        });
        tb.add((Component)this.saveFileButton);
        this.deleteFileButton.setIcon((Icon)i18n.getIcon("TransferBean.deleteFileIcon"));
        this.deleteFileButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_DELETEFILEBUTTONTIP));
        this.deleteFileButton.setEnabled(false);
        this.deleteFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferBean.this.doDelete();
            }
        });
        tb.add((Component)this.deleteFileButton);
        tb.add(this.promptSeparator);
        this.promptButton.setIcon((Icon)i18n.getIcon("TransferBean.promptIcon"));
        this.promptButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_PROMPTBUTTONTIP));
        this.promptButton.setEnabled(false);
        this.promptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferBean.this.doPrompt();
            }
        });
        tb.add((Component)this.promptButton);
        this.fileScroller.setVerticalScrollBarPolicy(22);
        this.add((Component)this.fileScroller, "Center");
        this.fileScroller.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
        this.fileScroller.setViewportView(this.files);
    }

    public void shutdown() {
        this.xfer.dispose();
        this.xfer = null;
        this.impl = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String nm = e.getPropertyName();
        if (nm.equals("transfer.file.access")) {
            ClientInfo ci;
            short addr = this.clients.getPropertyOwner(e.getSource());
            if (addr == this.terminal.getClient().getAddress() && (ci = this.clients.getMyClient()) != null) {
                boolean canLoad = ci.getProperty("transfer.file.access", false);
                this.addFileButton.setVisible(canLoad);
                this.addURLButton.setVisible(canLoad);
                this.fileOperationSeparator.setVisible(canLoad);
                this.deleteFileButton.setVisible(canLoad);
                this.promptButton.setVisible(canLoad);
                this.promptSeparator.setVisible(canLoad);
            }
        } else if (nm.equals("chair")) {
            Chair chair = ChairProtocol.getChair((ClientList)this.clients);
            boolean was = this.amChair;
            this.amChair = chair.isMe();
            if (was != this.amChair) {
                SwingRunnerSupport.invokeLater((Runnable)this.runUpdate);
            }
        }
    }

    private void doDelete() {
        int[] rows = this.files.getSelectedRows();
        if (rows != null && rows.length != 0) {
            this.doDelete(rows);
        }
    }

    private void doDelete(int[] rows) {
        this.files.clearSelection();
        try {
            if (rows.length == 1) {
                int id = (Integer)this.model.getValueAt(rows[0], 6);
                FileTransferItem item = (FileTransferItem)this.model.getValueAt(rows[0], 0);
                int resp = ModalDialog.showConfirmDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_DELETECONFIRMMSG, new Object[]{item.getName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_DELETECONFIRMTITLE), (int)2);
                if (resp == 0) {
                    this.xfer.removeItem(id, (FileTransferRequestListener)this);
                }
            } else {
                int resp = ModalDialog.showConfirmDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_DELETEMULTIPLECONFIRMMSG), (String)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_DELETEMULTIPLECONFIRMTITLE), (int)2);
                if (resp == 0) {
                    for (int i = 0; i < rows.length; ++i) {
                        int id = (Integer)this.model.getValueAt(rows[i], 6);
                        this.xfer.removeItem(id, (FileTransferRequestListener)this);
                    }
                }
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"doDelete", (Throwable)t, (boolean)true);
        }
    }

    private void doSave() {
        int[] rows = this.files.getSelectedRows();
        if (rows != null && rows.length != 0) {
            this.doSave(rows);
        }
    }

    private void doSave(int[] rows) {
        Integer id;
        FileTransferItem item;
        for (int i = 0; i < rows.length && ((item = this.xfer.getItem((id = (Integer)this.model.getValueAt(rows[i], 6)).intValue())) == null || this.doSave(item)); ++i) {
        }
    }

    private boolean doSave(FileTransferItem item) {
        Integer id = new Integer(item.getUID());
        SaveRequest req = (SaveRequest)this.savingIDs.get(id);
        if (req != null) {
            req.cancel();
            return true;
        }
        if (this.saveWorkingDir == null) {
            this.saveWorkingDir = new File(System.getProperty("user.home"));
        }
        CFileChooser chooser = new CFileChooser(this.saveWorkingDir);
        chooser.setSelectedFile(new File(this.saveWorkingDir, Platform.filterFilename((String)item.getName())));
        int result = chooser.showSaveDialog(this.parentProv.getDialogParent());
        if (result != 0) {
            return false;
        }
        File file = chooser.getSelectedFile();
        if (file.exists()) {
            result = ModalDialog.showConfirmDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_FILEEXISTS, new Object[]{file}), (String)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_EXISTSTITLE), (int)2);
            if (result == 0) {
                file.delete();
            } else {
                return false;
            }
        }
        if (this.xfer.getItem(item.getUID()) == item) {
            req = new SaveRequest(item, file);
        } else {
            ModalDialog.showMessageDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_SAVEABORTMSG, new Object[]{item.getName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_SAVEABORTTITLE), (int)2);
        }
        this.saveWorkingDir = chooser.getCurrentDirectory();
        return true;
    }

    private void doPrompt() {
        int[] rows = this.files.getSelectedRows();
        if (rows != null && rows.length != 0) {
            this.doPrompt(rows);
        }
    }

    private void doPrompt(int[] rows) {
        try {
            for (int i = 0; i < rows.length; ++i) {
                int id = (Integer)this.model.getValueAt(rows[i], 6);
                this.prompt(id);
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"doPrompt", (Throwable)t, (boolean)true);
        }
    }

    void prompt(int id) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("query", "true");
        this.xfer.setItemAttributes(id, attrs, (FileTransferRequestListener)this);
    }

    FileTransferItem getFile(String fileName) {
        for (FileTransferItem item : this.xfer) {
            if (!item.getName().equalsIgnoreCase(fileName)) continue;
            return item;
        }
        return null;
    }

    private Object[] getRow(FileTransferItem item) {
        ClientInfo own;
        Object[] row = new Object[8];
        boolean delete = false;
        ImageIcon saved = null;
        Integer key = new Integer(item.getUID());
        if (this.clients != null) {
            boolean bl = delete = item.getOwner().equals(this.clients.getMyName()) || this.amChair;
        }
        if (this.savingIDs.containsKey(key)) {
            saved = savingIcon;
        } else if (this.savedIDs.contains(key)) {
            saved = savedIcon;
        }
        row[0] = item;
        if (this.clients != null && (own = this.clients.get(item.getOwner())) != null) {
            row[1] = own.getDisplayName();
        }
        row[2] = new long[]{item.getLength(), item.getPosition()};
        row[3] = new Percentage(item.getServerPercent());
        row[4] = item.getStatusHist();
        row[5] = saved;
        row[6] = new Integer(item.getUID());
        return row;
    }

    private void doUpdate() {
        short[] histItem = null;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            try {
                int pctDisp;
                int pctItem;
                long len;
                int serverDisp;
                int serverItem;
                Integer key = (Integer)this.model.getValueAt(i, 6);
                int id = key;
                FileTransferItem item = this.xfer.getItem(id);
                if (item == null) continue;
                if (histItem == null) {
                    histItem = item.getStatusHist();
                } else {
                    item.getStatusHist(histItem);
                }
                short[] histDisp = (short[])this.model.getValueAt(i, 4);
                if (!Arrays.equals(histItem, histDisp)) {
                    short[] newHist = new short[histItem.length];
                    System.arraycopy(histItem, 0, newHist, 0, histItem.length);
                    this.model.setValueAt(newHist, i, 4);
                }
                if ((serverItem = item.getServerPercent()) != (serverDisp = ((Percentage)this.model.getValueAt((int)i, (int)3)).value)) {
                    this.model.setValueAt(new Percentage(serverItem), i, 3);
                }
                if ((len = item.getLength()) > 0L) {
                    pctItem = (int)(item.getPosition() * 100L / len);
                    pctDisp = (int)(((long[])this.model.getValueAt(i, 2))[1] * 100L / len);
                } else {
                    pctItem = 100;
                    pctDisp = 100;
                }
                if (pctItem != pctDisp) {
                    this.model.setValueAt(new long[]{len, item.getPosition()}, i, 2);
                }
                ImageIcon saveDisp = (ImageIcon)this.model.getValueAt(i, 5);
                ImageIcon saveItem = null;
                if (this.savingIDs.containsKey(key)) {
                    saveItem = savingIcon;
                } else if (this.savedIDs.contains(key)) {
                    saveItem = savedIcon;
                }
                if (saveDisp == saveItem) continue;
                this.model.setValueAt(saveItem, i, 5);
                continue;
            }
            catch (Exception e) {
                if (!XferDebug.LOG.isEnabled()) continue;
                LogSupport.error((Object)this, (String)"doUpdate", (String)("Error while querying the table: " + e.getMessage()));
            }
        }
    }

    public void doLoadFile() {
        File wdir = this.loadWorkingDir;
        if (wdir == null) {
            wdir = new File(System.getProperty("user.home"));
        }
        CFileChooser chooser = new CFileChooser(wdir);
        chooser.setDialogTitle(i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_LOADFILETITLE));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        JPanel ap = new JPanel(new BorderLayout());
        chooser.setAccessory(ap);
        JCheckBox push = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.LOADDIALOG_PUSH));
        push.setSelected(this.lastPushSelected);
        ap.add((Component)push, "Center");
        int response = chooser.showOpenDialog(this.parentProv.getDialogParent());
        if (response != 0) {
            return;
        }
        wdir = chooser.getCurrentDirectory();
        File file = chooser.getSelectedFile();
        if (!file.exists()) {
            ModalDialog.showMessageDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.LOADDIALOG_FILENOTFOUND, new Object[]{file}), (String)i18n.getString((PropertiesEnum)StringsProperties.LOADDIALOG_ERRORTITLE), (int)0);
            return;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("query", push.isSelected() ? "true" : "false");
        this.xfer.addItem(file, options, (FileTransferRequestListener)this);
        this.files.clearSelection();
        this.loadWorkingDir = wdir;
        this.lastPushSelected = push.isSelected();
    }

    public void doLoadFile(File f) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("query", "true");
        this.xfer.addItem(f, options, (FileTransferRequestListener)this);
        this.files.clearSelection();
    }

    public void doLoadURL() {
        if (this.loadDialog == null) {
            this.loadDialog = new LoadDialog(this);
        }
        this.loadDialog.setSelectedURL(this.lastURL);
        this.loadDialog.setPushSelected(this.lastPushSelected);
        int response = this.loadDialog.showDialog();
        if (response != 0) {
            return;
        }
        URL url = this.loadDialog.getSelectedURL();
        this.addURL(url, this.loadDialog.isPushSelected());
        this.lastURL = url;
        this.lastPushSelected = this.loadDialog.isPushSelected();
    }

    void addURL(URL url, boolean prompt) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("query", prompt ? "true" : "false");
        this.xfer.addItem(url, options, (FileTransferRequestListener)this);
        this.files.clearSelection();
    }

    class ChangeUI
    implements Runnable {
        ChangeUI() {
        }

        @Override
        public void run() {
            TransferBean.this.doUpdate();
        }
    }

    private class FullSizeViewport
    extends JViewport {
        private FullSizeViewport() {
        }

        @Override
        public void setViewSize(Dimension newSize) {
            Dimension s = this.getSize();
            if (newSize != null && newSize.height < s.height) {
                newSize = new Dimension(newSize.width, s.height);
            }
            super.setViewSize(newSize);
        }
    }

    class SaveRequest
    implements FileTransferProgressListener {
        private FileTransferItem item;
        private int request;
        private File file;
        private boolean completionNotify;

        public SaveRequest(FileTransferItem item, File f) {
            this.item = item;
            this.file = f;
            TransferBean.this.savingIDs.put(new Integer(item.getUID()), this);
            item.setActive(TransferBean.this.terminal.getClient().getAddress(), true);
            this.request = item.write(f, (FileTransferProgressListener)this);
            if (item.getPosition() < item.getLength()) {
                this.completionNotify = true;
                ModalDialog.showMessageDialog((Component)TransferBean.this, (Object)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_SAVESTARTMSG, new Object[]{item.getName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_SAVESTARTTITLE), (int)1);
            }
        }

        public void exceptionNotify(int req, IOException iox) {
            TransferBean.this.savingIDs.remove(new Integer(this.item.getUID()));
            this.item.setActive(TransferBean.this.terminal.getClient().getAddress(), false);
            ModalDialog.showMessageDialogAsync((int)-1, (Component)TransferBean.this, (Object)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_WRITEEXCEPTION, new Object[]{this.file, iox.getMessage()}), (String)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_WRITEERRORTITLE), (int)0);
            SwingRunnerSupport.invokeLater((Runnable)TransferBean.this.runUpdate);
        }

        public void progressNotify(int req, int pct, boolean done) {
            if (done) {
                this.item.setActive(TransferBean.this.terminal.getClient().getAddress(), false);
                Integer key = new Integer(this.item.getUID());
                TransferBean.this.savedIDs.add(key);
                TransferBean.this.savingIDs.remove(key);
                SwingRunnerSupport.invokeLater((Runnable)TransferBean.this.runUpdate);
                if (this.completionNotify) {
                    ModalDialog.showMessageDialogAsync((int)10, (Component)TransferBean.this, (Object)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_SAVECOMPLETEMSG, new Object[]{this.item.getName(), this.file}), (String)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_SAVECOMPLETETITLE), (int)1);
                }
            }
        }

        public boolean cancel() {
            int answer = ModalDialog.showConfirmDialog((Component)TransferBean.this, (Object)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_CANCELQUERY, new Object[]{this.item.getName(), this.file}), (String)i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_CANCELQUERYTITLE), (int)0);
            if (answer == 0) {
                this.item.setActive(TransferBean.this.terminal.getClient().getAddress(), false);
                this.item.cancelWrite(this.request);
                TransferBean.this.savingIDs.remove(new Integer(this.item.getUID()));
                SwingRunnerSupport.invokeLater((Runnable)TransferBean.this.runUpdate);
                return true;
            }
            return false;
        }
    }

    class UpdateUI
    implements Runnable {
        FileTransferItem item;
        int id;

        public UpdateUI(FileTransferItem item) {
            this.item = item;
        }

        public UpdateUI(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            if (this.item != null) {
                int l = 0;
                int u = TransferBean.this.model.getRowCount() - 1;
                String name = this.item.getName();
                while (u >= l) {
                    int m = (l + u) / 2;
                    FileTransferItem item = (FileTransferItem)TransferBean.this.model.getValueAt(m, 0);
                    String test = item.getName();
                    if (name.compareTo(test) < 0) {
                        u = m - 1;
                        continue;
                    }
                    l = m + 1;
                }
                if (l >= TransferBean.this.model.getRowCount()) {
                    TransferBean.this.model.addRow(TransferBean.this.getRow(this.item));
                } else {
                    TransferBean.this.model.insertRow(l, TransferBean.this.getRow(this.item));
                }
                if ("true".equals(this.item.getAttribute("query")) && !this.item.getOwner().equals(TransferBean.this.clients.getMyName())) {
                    TransferBean.this.query(this.item);
                }
            } else {
                for (int i = 0; i < TransferBean.this.model.getRowCount(); ++i) {
                    Integer uid = (Integer)TransferBean.this.model.getValueAt(i, 6);
                    if (this.id != uid) continue;
                    TransferBean.this.model.removeRow(i);
                    return;
                }
            }
        }
    }
}

