/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer.module;

import com.elluminate.groupware.imps.filetransfer.FileTransferException;
import com.elluminate.groupware.imps.filetransfer.FileTransferItem;
import com.elluminate.groupware.imps.filetransfer.FileTransferRequestListener;
import com.elluminate.groupware.transfer.AbstractLoader;
import com.elluminate.groupware.transfer.FileLoader;
import com.elluminate.groupware.transfer.LoaderListener;
import com.elluminate.groupware.transfer.StreamCache;
import com.elluminate.groupware.transfer.StreamProxy;
import com.elluminate.groupware.transfer.TransferLibrary;
import com.elluminate.groupware.transfer.TransferLibraryEntry;
import com.elluminate.groupware.transfer.TransferProtocol;
import com.elluminate.groupware.transfer.Urgency;
import com.elluminate.groupware.transfer.module.FIDClient;
import com.elluminate.groupware.transfer.module.FIDEvent;
import com.elluminate.groupware.transfer.module.FIDListener;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.jinx.RecvWindow;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.jinx.TransmitStatusListener;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TooManyListenersException;

public class ClientTransferLibrary
extends TransferLibrary {
    private StreamProxy svrProxy = null;
    private LoaderListener loadListener = null;
    private LinkedList ftListeners = new LinkedList();
    private FIDClient idClient = null;
    private ClientList clients = null;

    public ClientTransferLibrary(Channel chnl, FIDClient fidc) {
        super(chnl);
        this.clients = chnl.getConnection().getClientList();
        this.idClient = fidc;
        try {
            chnl.addTransmitStatusListener((TransmitStatusListener)this);
        }
        catch (TooManyListenersException tmlx) {
            LogSupport.exception((Object)((Object)this), (String)"<init>", (Throwable)tmlx, (boolean)true);
        }
    }

    public int load(File f, Map attrs, FileTransferRequestListener lst) {
        Request req = new Request(f, attrs, lst);
        req.execute();
        return req.getRequestID();
    }

    public int load(URL u, Map attrs, FileTransferRequestListener lst) {
        Request req = new Request(u, attrs, lst);
        req.execute();
        return req.getRequestID();
    }

    protected void add(Request req, File file, int id, BigInteger auth, Map attrs) {
        if (this.svrProxy == null) {
            throw new IllegalStateException("Not connected.");
        }
        String name = file.getName();
        String type = Platform.getMimeType((String)name);
        FileLoader loader = new FileLoader(req.getRequestID(), file, id, attrs, this.getLock(), (LoaderListener)req, (TransferLibrary)this);
        loader.setAuth(auth);
        loader.start();
    }

    private boolean startLoad(AbstractLoader loader) {
        String name = loader.getName();
        String type = loader.getMimeType();
        BigInteger auth = loader.getAuth();
        StreamCache cache = loader.getCache();
        int id = cache.getStreamID();
        String owner = this.clients.getMyName();
        TransferLibraryEntry entry = null;
        entry = new TransferLibraryEntry(cache, auth, name, type, owner, loader.getAttributes(), this.windowListener, (Urgency)this);
        entry.setSource(this.channel.getConnection().getAddress());
        this.insert(id, entry);
        cache.setLock(this.getLock());
        this.svrProxy.connect(entry, loader.getRequestID());
        return true;
    }

    public int remove(int id, FileTransferRequestListener lst) {
        Request req = new Request(id, lst);
        req.execute();
        return req.getRequestID();
    }

    public int setAttributes(int id, Map attrs, FileTransferRequestListener lst) {
        Request req = new Request(id, attrs, lst);
        req.execute();
        return req.getRequestID();
    }

    protected void doSendAck(RecvWindow window, TransferLibraryEntry entry) {
        ChannelDataEvent resp = ChannelDataEvent.getInstance((Object)((Object)this), (short)0, (byte)7);
        try {
            DataOutputStream ostr = resp.write();
            ostr.writeInt(entry.getUID());
            ostr.writeInt(window.ack());
            ostr.close();
            if (this.channel.isUp()) {
                this.channel.onChannelData(resp, (byte)(2 - entry.getPriority()));
            }
        }
        catch (IOException iox) {
            LogSupport.exception((Object)((Object)this), (String)"doSendAck", (Throwable)iox, (boolean)true);
        }
    }

    public void onChannelData(ChannelDataEvent event) {
        if (this.svrProxy == null) {
            return;
        }
        if (event.getSourceAddress() != 0) {
            return;
        }
        try {
            DataInputStream istr = event.read();
            switch (event.getCommand()) {
                case 7: {
                    int id = istr.readInt();
                    int nBytes = istr.readInt();
                    this.svrProxy.ack(id, nBytes);
                    break;
                }
                case 6: {
                    ProtocolBuffer buf = event.getBuffer();
                    istr.close();
                    istr = buf.readHeader(4);
                    int id = istr.readInt();
                    istr.close();
                    istr = null;
                    TransferLibraryEntry entry = this.get(id);
                    if (entry == null) {
                        return;
                    }
                    entry.setPriority(event.getPriority());
                    entry.write(buf);
                    break;
                }
                case 4: {
                    int seq = istr.readInt();
                    int id = istr.readInt();
                    TransferLibraryEntry entry = this.get(id);
                    if (entry == null) {
                        return;
                    }
                    if (this.svrProxy.isConnected(entry)) {
                        this.svrProxy.disconnect(entry);
                    }
                    this.delete(id);
                    entry.dispose();
                    break;
                }
                case 15: {
                    int seq = istr.readInt();
                    I18nMessage err = new I18nMessage(istr);
                    this.sendError((short)-32767, seq, err);
                    break;
                }
                case 2: {
                    StreamCache cache;
                    int seq = istr.readInt();
                    int id = istr.readInt();
                    String name = istr.readUTF();
                    String type = istr.readUTF();
                    String owner = istr.readUTF();
                    long len = istr.readLong();
                    long posn = istr.readLong();
                    String auth = istr.readUTF();
                    Map attrs = TransferProtocol.readAttrs((DataInputStream)istr);
                    TransferLibraryEntry entry = this.get(id);
                    if (entry == null) {
                        cache = new StreamCache(id, len);
                        entry = new TransferLibraryEntry(cache, null, name, type, owner, attrs, this.windowListener, (Urgency)this);
                        this.insert(id, entry);
                    } else {
                        entry.reset();
                        cache = entry.getCache();
                        cache.setLocation(posn);
                    }
                    cache.setLock(this.getLock());
                    break;
                }
                case 3: {
                    int id = istr.readInt();
                    long posn = istr.readLong();
                    TransferLibraryEntry entry = this.get(id);
                    if (entry == null) break;
                    this.svrProxy.reconnect(entry, posn);
                    break;
                }
                case 10: {
                    int id = istr.readInt();
                    while (id > 0) {
                        TransferLibraryEntry entry = this.get(id);
                        if (entry != null) {
                            entry.decodeProgress(istr);
                            this.fireFileChanged((FileTransferItem)entry);
                        } else {
                            istr.skipBytes(1 + TransferProtocol.STATUS_PERCENT.length * 2);
                        }
                        id = istr.readInt();
                    }
                    break;
                }
                case 9: {
                    int seq = istr.readInt();
                    int id = istr.readInt();
                    Map attrs = TransferProtocol.readAttrs((DataInputStream)istr);
                    TransferLibraryEntry entry = this.get(id);
                    if (entry == null) {
                        return;
                    }
                    this.setAttributes(id, attrs);
                    break;
                }
                case 8: {
                    int id = istr.readInt();
                    byte urgency = istr.readByte();
                    istr.close();
                    istr = null;
                    if (this.svrProxy == null) {
                        return;
                    }
                    this.svrProxy.setUrgent(id, urgency);
                    break;
                }
                case 11: {
                    int seq = istr.readInt();
                    int id = istr.readInt();
                    this.sendOK((short)-32767, seq, id);
                    break;
                }
                default: {
                    this.sendError((short)-32767, -1, new I18nMessage((Object)this, "ClientMediaLibrary.unexpectedMessage", new String[]{"", Byte.toString(event.getCommand())}));
                }
            }
            if (istr != null) {
                istr.close();
            }
        }
        catch (IOException ex) {
            LogSupport.exception((Object)((Object)this), (String)"onChannelData", (Throwable)ex, (boolean)true);
        }
    }

    public void transmitStatusChange(TransmitStatusEvent e) {
        if (e.getSourceAddress() != 0) {
            return;
        }
        if (this.svrProxy == null) {
            return;
        }
        this.svrProxy.onTransmitStatusChanged(e);
    }

    public void setUrgent(int id, boolean isUrgent) {
        TransferLibraryEntry ent = this.get(id);
        if (ent == null) {
            return;
        }
        if (ent.getSource() == this.channel.getConnection().getAddress()) {
            return;
        }
        ChannelDataEvent evt = ChannelDataEvent.getInstance((Object)((Object)this), (short)0, (byte)8);
        try {
            DataOutputStream ostr = evt.write();
            ostr.writeInt(id);
            ostr.writeByte(isUrgent ? 1 : 0);
            ostr.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)((Object)this), (String)"sendUrgent", (Throwable)ex, (boolean)true);
            evt.dispose();
            return;
        }
        this.channel.onChannelData(evt);
    }

    public void addProxy(short addr) {
        if (addr != 0) {
            throw new IllegalArgumentException("Only the server may be a client proxy.");
        }
        if (this.channel == null) {
            throw new IllegalStateException("Cannot add proxy when not connected.");
        }
        if (this.svrProxy != null) {
            return;
        }
        this.svrProxy = new StreamProxy(this.channel, addr);
        ChannelDataEvent e = this.serverMsg((byte)5);
        try {
            DataOutputStream ostr = e.write();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                TransferLibraryEntry ent = (TransferLibraryEntry)i.next();
                ent.encodeStatus(ostr, this.getConnection().getAddress());
            }
            ostr.writeInt(0);
            ostr.close();
            this.channel.onChannelData(e);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)((Object)this), (String)"addProxy", (Throwable)ex, (boolean)true);
        }
    }

    public void removeProxy(short addr) {
        if (addr == 0 && this.svrProxy != null) {
            this.disconnectProxy(this.svrProxy);
            this.svrProxy = null;
        }
    }

    private ChannelDataEvent serverMsg(byte cmd) {
        return ChannelDataEvent.getInstance((Object)((Object)this), (short)0, (byte)cmd);
    }

    class Request
    implements FIDListener,
    FileTransferRequestListener,
    LoaderListener {
        int req;
        int id;
        File f;
        URL u;
        FileTransferRequestListener listener;
        BigInteger auth;
        Map attrs;
        volatile boolean done;
        volatile boolean failed;

        public Request(File f, Map attrs, FileTransferRequestListener lst) {
            this.req = ClientTransferLibrary.this.getNextRequestID();
            this.id = -1;
            this.f = null;
            this.u = null;
            this.listener = null;
            this.auth = null;
            this.attrs = null;
            this.done = false;
            this.failed = false;
            this.f = f;
            this.listener = lst;
            this.attrs = attrs == null ? new HashMap() : new HashMap(attrs);
            ClientTransferLibrary.this.idClient.addFIDListener(this);
        }

        public Request(URL u, Map attrs, FileTransferRequestListener lst) {
            this.req = ClientTransferLibrary.this.getNextRequestID();
            this.id = -1;
            this.f = null;
            this.u = null;
            this.listener = null;
            this.auth = null;
            this.attrs = null;
            this.done = false;
            this.failed = false;
            this.u = u;
            this.listener = lst;
            this.attrs = attrs == null ? new HashMap() : new HashMap(attrs);
        }

        public Request(int id, Map attrs, FileTransferRequestListener lst) {
            this.req = ClientTransferLibrary.this.getNextRequestID();
            this.id = -1;
            this.f = null;
            this.u = null;
            this.listener = null;
            this.auth = null;
            this.attrs = null;
            this.done = false;
            this.failed = false;
            this.id = id;
            this.listener = lst;
            this.attrs = attrs == null ? new HashMap() : new HashMap(attrs);
        }

        public Request(int id, FileTransferRequestListener lst) {
            this.req = ClientTransferLibrary.this.getNextRequestID();
            this.id = -1;
            this.f = null;
            this.u = null;
            this.listener = null;
            this.auth = null;
            this.attrs = null;
            this.done = false;
            this.failed = false;
            this.id = id;
            this.listener = lst;
        }

        public int getRequestID() {
            return this.req;
        }

        public void execute() {
            ClientTransferLibrary.this.beginRequest(this.req, this);
            if (this.f != null) {
                ClientTransferLibrary.this.idClient.requestFID(this.req);
            } else if (this.u != null) {
                ChannelDataEvent e = ClientTransferLibrary.this.serverMsg((byte)1);
                try {
                    DataOutputStream ostr = e.write();
                    ostr.writeInt(this.req);
                    ostr.writeUTF(this.u.toExternalForm());
                    TransferProtocol.writeAttrs((DataOutputStream)ostr, (Map)this.attrs);
                    ostr.close();
                    ClientTransferLibrary.this.channel.onChannelData(e);
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"add", (Throwable)ex, (boolean)true);
                }
            } else if (this.attrs != null) {
                ChannelDataEvent e = ClientTransferLibrary.this.serverMsg((byte)9);
                try {
                    DataOutputStream ostr = e.write();
                    ostr.writeInt(this.req);
                    ostr.writeInt(this.id);
                    TransferProtocol.writeAttrs((DataOutputStream)ostr, (Map)this.attrs);
                    ostr.close();
                    ClientTransferLibrary.this.channel.onChannelData(e);
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"attribute", (Throwable)ex, (boolean)true);
                }
            } else {
                ChannelDataEvent e = ClientTransferLibrary.this.serverMsg((byte)4);
                try {
                    DataOutputStream ostr = e.write();
                    ostr.writeInt(this.req);
                    ostr.writeInt(this.id);
                    ostr.close();
                    ClientTransferLibrary.this.channel.onChannelData(e);
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"remove", (Throwable)ex, (boolean)true);
                }
            }
        }

        @Override
        public void assignedFID(FIDEvent e) {
            if (e.getRequestID() == this.req) {
                this.id = e.getFID();
                this.auth = e.getAuthCode();
                ClientTransferLibrary.this.add(this, this.f, this.id, this.auth, this.attrs);
                ClientTransferLibrary.this.idClient.removeFIDListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyComplete(int seq, int uid) {
            if (this.listener != null) {
                this.listener.notifyComplete(seq, uid);
            }
            Request request = this;
            synchronized (request) {
                this.failed = false;
                this.done = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyException(int seq, FileTransferException ftx) {
            if (this.listener != null) {
                this.listener.notifyException(seq, ftx);
            }
            Request request = this;
            synchronized (request) {
                this.failed = true;
                this.done = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitFor() {
            Request request = this;
            synchronized (request) {
                while (!this.done) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ix) {
                        return false;
                    }
                }
            }
            return !this.failed;
        }

        public boolean startingLoad(AbstractLoader loader) {
            return ClientTransferLibrary.this.startLoad(loader);
        }

        public boolean mayTransmit(AbstractLoader loader) {
            boolean result = this.waitFor();
            if (!result) {
                ClientTransferLibrary.this.remove(this.getRequestID(), null);
            }
            return result;
        }

        public boolean quotaCheck(AbstractLoader loader) {
            return true;
        }
    }
}

