/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.client.app;

import com.elluminate.classroom.client.BrandingI18nProvider;
import com.elluminate.classroom.client.app.Application;
import com.elluminate.classroom.client.app.ClientCoreBindings;
import com.elluminate.util.Base64;
import com.elluminate.util.EncodingException;
import com.elluminate.util.I18n;
import com.elluminate.util.TuningParam;
import com.elluminate.util.VersionManager;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Main
implements Runnable {
    private static final String BRANDING_NAME_PREFIX = "-Xgbn:";
    private static final String[] BRANDING_KNOWN_NAMES = new String[]{"bcvss", "cccconfer", "classlive", "classlivepro", "full", "IBM", "k12inc", "lite", "meetingroom", "nydoe", "oulive"};
    private static final String BRANDING_OVERRIDE_PREFIX = "-XB:";
    private static final Map<String, String> BRANDING_OVERRIDABLE_ITEMS = new HashMap<String, String>();
    private I18n brandedI18n;
    private String[] args;
    private Class<?> brandingContext;

    public Main(String[] args) {
        ArrayList<String> arglist = new ArrayList<String>();
        String brandName = "full";
        for (String arg : args) {
            boolean append = true;
            if (arg.startsWith(BRANDING_OVERRIDE_PREFIX)) {
                String pair = arg.substring(BRANDING_OVERRIDE_PREFIX.length());
                int eq = pair.indexOf(61);
                if (eq > 0) {
                    String key = pair.substring(0, eq);
                    String val = pair.substring(eq + 1);
                    if ((key = BRANDING_OVERRIDABLE_ITEMS.get(key)) != null) {
                        this.brandedI18n.override(key, val);
                        append = false;
                    }
                }
            } else if (arg.startsWith(BRANDING_NAME_PREFIX)) {
                brandName = arg.substring(BRANDING_NAME_PREFIX.length());
                append = false;
            }
            if (!append) continue;
            arglist.add(arg);
        }
        this.args = arglist.toArray(new String[0]);
        this.brandingContext = this.getClassContextForBranding(brandName);
        this.brandedI18n = I18n.create(this.brandingContext);
    }

    @Override
    public void run() {
        TuningParam.setRole((int)1);
        TuningParam.addSearchPrefix((String)"com.elluminate");
        TuningParam.addSearchPrefix((String)"com.elluminate.groupware");
        ClientCoreBindings bindings = new ClientCoreBindings();
        Injector injector = Guice.createInjector((Module[])new Module[]{bindings});
        VersionManager verMgr = (VersionManager)injector.getInstance(VersionManager.class);
        verMgr.registerProduct(this.brandingContext);
        Application app = (Application)injector.getInstance(Application.class);
        app.init(this.args, this.brandedI18n);
        app.start();
    }

    public static void main(String[] args) {
        Main startingPoint = new Main(args);
        startingPoint.run();
    }

    private Class<?> getClassContextForBranding(String brandingArg) {
        if (brandingArg == null || brandingArg.trim().isEmpty()) {
            throw new IllegalArgumentException("No branding arg specified.");
        }
        String name = brandingArg;
        if (!Arrays.asList(BRANDING_KNOWN_NAMES).contains(name)) {
            throw new RuntimeException("Branding arg: '" + brandingArg + "' not known.");
        }
        try {
            return Class.forName("com.elluminate.classroom.client.branding." + name + ".I18nContext");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Problem loading branding context, check classpath", e);
        }
    }

    private String decodeBrandingArg(String name) {
        int nPad = name.length() % 4;
        for (int i = 0; i < nPad; ++i) {
            name = name + "=";
        }
        try {
            name = new String(Base64.decode((String)name));
        }
        catch (EncodingException e) {
            throw new RuntimeException("Bad branding arg", e);
        }
        return name;
    }

    static {
        BRANDING_OVERRIDABLE_ITEMS.put("moderatorEssentials", BrandingI18nProvider.Values.ESSENTIALS_MODERATOR_URL.propName());
        BRANDING_OVERRIDABLE_ITEMS.put("participantEssentials", BrandingI18nProvider.Values.ESSENTIALS_PARTICIPANTS_URL.propName());
        BRANDING_OVERRIDABLE_ITEMS.put("additionalDocs", BrandingI18nProvider.Values.ADDITIONAL_DOCUMENTATION_URL.propName());
    }
}

