/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video.module;

import com.elluminate.classroom.client.messaging.MessagePublisher;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.groupware.video.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

@Singleton
public class VideoPublisher {
    private final String UNIQUE_NAME = "VideoPublisher";
    private final String DISPLAY_NAME;
    private final Icon icon;
    public static final String VIDEO_ENABLED = "video-enabled";
    public static final String VIDEO_DISABLED = "video-disabled";
    public static final String VIDEO_ON = "video-on";
    public static final String VIDEO_OFF = "video-off";
    private final MessagePublisher publisher;
    private final MessagePublisherMetadata metadata;
    private final I18n i18n;
    private final MessageRouter router;
    private String modName;
    private String modDisplayName;
    private Map<String, MessageType> msgTypes = new HashMap<String, MessageType>();

    @Inject
    public VideoPublisher(MessagePublisher pub, MessagePublisherMetadata meta, MessageRouter rtr, I18n localization, ModulePublisherInfo mod) {
        this.publisher = pub;
        this.metadata = meta;
        this.router = rtr;
        this.i18n = localization;
        this.DISPLAY_NAME = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOPUBLISHER_DISPLAYNAME);
        this.icon = mod.getModuleIcon();
        this.modName = mod.getNameOfModule();
        this.modDisplayName = mod.getDisplayNameOfModule();
        this.initializePublisher();
    }

    public void sendVideoEnabledMessage() {
        String message = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOPUBLISHER_ENABLED_MESSAGE);
        this.publisher.sendTextMessage(message, this.msgTypes.get(VIDEO_ENABLED));
    }

    public void sendVideoDisabledMessage() {
        String message = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOPUBLISHER_DISABLED_MESSAGE);
        this.publisher.sendTextMessage(message, this.msgTypes.get(VIDEO_DISABLED));
    }

    public void sendVideoOnMessage(String message, boolean isMe) {
        this.publisher.sendTextMessage(message, this.msgTypes.get(VIDEO_ON), isMe);
    }

    public void sendVideoOffMessage(String message, boolean isMe) {
        this.publisher.sendTextMessage(message, this.msgTypes.get(VIDEO_OFF), isMe);
    }

    private void initializePublisher() {
        this.initMessageTypes();
        this.setMetadata();
        this.publisher.setPublisherMetadata(this.metadata);
        this.router.registerPublisher(this.publisher);
    }

    private void setMetadata() {
        this.metadata.setPublisherDisplayName(this.DISPLAY_NAME);
        this.metadata.setPublisherUniqueName("VideoPublisher");
        this.metadata.setPublisherIcon(this.icon);
        this.metadata.setModuleName(this.modName);
        this.metadata.setModuleDisplayName(this.modDisplayName);
        this.metadata.setPublisherSupportedMessageTypes(new ArrayList<MessageType>(this.msgTypes.values()));
    }

    private void initMessageTypes() {
        this.msgTypes.put(VIDEO_ENABLED, new MessageType(VIDEO_ENABLED, this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOPUBLISHER_TYPE_ENABLED), 4));
        this.msgTypes.put(VIDEO_DISABLED, new MessageType(VIDEO_DISABLED, this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOPUBLISHER_TYPE_DISABLED), 4));
        this.msgTypes.put(VIDEO_ON, new MessageType(VIDEO_ON, this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOPUBLISHER_TYPE_VIDEOON), 7));
        this.msgTypes.put(VIDEO_OFF, new MessageType(VIDEO_OFF, this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOPUBLISHER_TYPE_VIDEOOFF), 7));
    }
}

