/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video.module;

import com.elluminate.classroom.client.AudioVideoPrefsOwner;
import com.elluminate.groupware.video.module.StringsProperties;
import com.elluminate.groupware.video.module.VideoBean;
import com.elluminate.groupware.video.module.VideoModule;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.AccessibleTextSlider;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@Singleton
public class VideoCameraSettingsPrefsPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = 1L;
    private I18n i18n;
    private VideoModule module = null;
    private VideoBean bean = null;
    private JComboBox cameraMenu = null;
    private JSlider maximumFrameRateSlider = null;
    private JCheckBox displayFrameRateCheckbox = null;
    private JCheckBox displayUserNameCheckbox = null;
    private JCheckBox disconnectOnCloseCheckbox = null;
    private int lastMaximumFrameRate = -1;

    @Inject
    public VideoCameraSettingsPrefsPanel(AudioVideoPrefsOwner owner, I18n i18n, VideoModule module) {
        super((PreferencesPanelOwner)owner, i18n.getString((PropertiesEnum)StringsProperties.VIDEOCAMERASETTINGSPREFS_TITLE));
        this.i18n = i18n;
        this.module = module;
        this.bean = module.getBean();
        owner.mentionVideo();
    }

    protected void createContent() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new GridBagLayout());
        this.add(p, "North");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.insets.top = 0;
        gbc.insets.left = 0;
        MultilineLabel selectCameraLabel = new MultilineLabel(this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOCAMERASETTINGSPREFS_SELECTCAMERA_DESCRIPTION));
        selectCameraLabel.setLabelFor((Component)this.cameraMenu);
        p.add((Component)selectCameraLabel, gbc);
        gbc.insets.top = 0;
        gbc.insets.left = 24;
        String[] cameraList = this.bean.getCameraList();
        this.cameraMenu = new JComboBox<String>(cameraList);
        this.cameraMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoCameraSettingsPrefsPanel.this.setModified(true);
            }
        });
        p.add((Component)this.cameraMenu, gbc);
        gbc.insets.top = 24;
        gbc.insets.left = 0;
        MultilineLabel maximumFrameRateLabel = new MultilineLabel(this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOCAMERASETTINGSPREFS_MAXIMUMFRAMERATE_DESCRIPTION));
        maximumFrameRateLabel.setLabelFor((Component)this.maximumFrameRateSlider);
        p.add((Component)maximumFrameRateLabel, gbc);
        gbc.insets.top = 0;
        gbc.insets.left = 24;
        this.maximumFrameRateSlider = new AccessibleTextSlider(0, this.bean.getMaximumFrameRateLimit());
        this.maximumFrameRateSlider.setMajorTickSpacing(5);
        this.maximumFrameRateSlider.setMinorTickSpacing(1);
        this.maximumFrameRateSlider.setPaintLabels(true);
        this.maximumFrameRateSlider.setPaintTicks(true);
        this.maximumFrameRateSlider.setPaintTrack(true);
        this.maximumFrameRateSlider.setSnapToTicks(true);
        this.maximumFrameRateSlider.getAccessibleContext().setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.FRAMERATE_MAXFRAMERATESLIDERTIP));
        this.maximumFrameRateSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (VideoCameraSettingsPrefsPanel.this.maximumFrameRateSlider.getValue() == VideoCameraSettingsPrefsPanel.this.lastMaximumFrameRate) {
                    return;
                }
                if (VideoCameraSettingsPrefsPanel.this.maximumFrameRateSlider.getValue() == 0) {
                    VideoCameraSettingsPrefsPanel.this.maximumFrameRateSlider.setValue(1);
                    if (VideoCameraSettingsPrefsPanel.this.lastMaximumFrameRate == 1) {
                        return;
                    }
                }
                VideoCameraSettingsPrefsPanel.this.lastMaximumFrameRate = VideoCameraSettingsPrefsPanel.this.maximumFrameRateSlider.getValue();
                VideoCameraSettingsPrefsPanel.this.setModified(true);
            }
        });
        p.add((Component)this.maximumFrameRateSlider, gbc);
        gbc.insets.top = 0;
        gbc.insets.left = 24;
        this.displayFrameRateCheckbox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOCAMERASETTINGSPREFS_DISPLAYFRAMERATE_CHECKBOXTEXT));
        this.displayFrameRateCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoCameraSettingsPrefsPanel.this.setModified(true);
            }
        });
        p.add((Component)this.displayFrameRateCheckbox, gbc);
        gbc.insets.top = 24;
        gbc.insets.left = 0;
        MultilineLabel displayUserNameLabel = new MultilineLabel(this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOCAMERASETTINGSPREFS_DISPLAYUSERNAME_DESCRIPTION));
        displayUserNameLabel.setLabelFor((Component)this.displayUserNameCheckbox);
        p.add((Component)displayUserNameLabel, gbc);
        gbc.insets.top = 0;
        gbc.insets.left = 24;
        this.displayUserNameCheckbox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOCAMERASETTINGSPREFS_DISPLAYUSERNAME_CHECKBOXTEXT));
        this.displayUserNameCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoCameraSettingsPrefsPanel.this.setModified(true);
            }
        });
        p.add((Component)this.displayUserNameCheckbox, gbc);
        gbc.insets.top = 24;
        gbc.insets.left = 0;
        MultilineLabel disconnectOnCloseLabel = new MultilineLabel(this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOCAMERASETTINGSPREFS_DISCONNECTONCLOSE_DESCRIPTION));
        disconnectOnCloseLabel.setLabelFor((Component)this.disconnectOnCloseCheckbox);
        p.add((Component)disconnectOnCloseLabel, gbc);
        gbc.insets.top = 0;
        gbc.insets.left = 24;
        this.disconnectOnCloseCheckbox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOCAMERASETTINGSPREFS_DISCONNECTONCLOSE_CHECKBOXTEXT));
        this.disconnectOnCloseCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoCameraSettingsPrefsPanel.this.setModified(true);
            }
        });
        p.add((Component)this.disconnectOnCloseCheckbox, gbc);
    }

    protected void populate(Preferences preferences) {
        String prefix = this.module.getPrefix();
        String[] cameraList = this.bean.getCameraList();
        this.cameraMenu.removeAllItems();
        if (cameraList.length > 0) {
            for (int i = 0; i < cameraList.length; ++i) {
                this.cameraMenu.addItem(cameraList[i]);
            }
            this.cameraMenu.setSelectedIndex(this.bean.getPreferredCameraIndex(prefix, preferences));
        }
        this.maximumFrameRateSlider.setValue(this.bean.getPreferredMaximumFrameRate(prefix, preferences));
        this.displayFrameRateCheckbox.setSelected(this.bean.getPreferredDisplayFrameRate(prefix, preferences));
        this.displayUserNameCheckbox.setSelected(this.bean.getPreferredDisplayUserName(prefix, preferences));
        this.disconnectOnCloseCheckbox.setSelected(this.bean.getPreferredDisconnectOnClose(prefix, preferences));
    }

    protected void apply(Preferences preferences) {
        String prefix = this.module.getPrefix();
        if (this.cameraMenu.getSelectedIndex() >= 0) {
            this.bean.setPreferredCameraIndex(prefix, preferences, this.cameraMenu.getSelectedIndex());
        }
        this.bean.setPreferredMaximumFrameRate(prefix, preferences, this.maximumFrameRateSlider.getValue());
        this.bean.setPreferredDisplayFrameRate(prefix, preferences, this.displayFrameRateCheckbox.isSelected());
        this.bean.setPreferredDisplayUserName(prefix, preferences, this.displayUserNameCheckbox.isSelected());
        this.bean.setPreferredDisconnectOnClose(prefix, preferences, this.disconnectOnCloseCheckbox.isSelected());
    }

    protected void reset(Preferences preferences) {
        String prefix = this.module.getPrefix();
        this.bean.setPreferredCameraIndex(prefix, preferences, this.bean.getDefaultCameraIndex());
        this.bean.setPreferredMaximumFrameRate(prefix, preferences, this.bean.getDefaultMaximumFrameRate());
        this.bean.setPreferredDisplayFrameRate(prefix, preferences, this.bean.getDefaultDisplayFrameRate());
        this.bean.setPreferredDisplayUserName(prefix, preferences, this.bean.getDefaultDisplayUserName());
        this.bean.setPreferredDisconnectOnClose(prefix, preferences, this.bean.getDefaultDisconnectOnClose());
    }
}

