/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.starttime.module;

import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRParticipantAdapter;
import com.elluminate.framework.session.listener.CRParticipantListener;
import com.elluminate.framework.session.listener.event.CRParticipantEvent;
import com.elluminate.groupware.imps.SessionTimeAPI;
import com.elluminate.groupware.starttime.module.StartTimeView;
import com.elluminate.groupware.starttime.module.StringsProperties;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;

public class StartTimeController
implements SessionTimeAPI {
    private I18n i18n = I18n.create((Object)this);
    private volatile boolean online = false;
    private volatile boolean forceUpdate = false;
    private volatile LightweightTimer timer = null;
    private Runnable action = null;
    private StartTimeView startTimeView;
    private CRSession session;
    private ClientProvider clientProvider;

    @Inject
    protected void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    protected void initStartTimeView(StartTimeView view) {
        this.startTimeView = view;
    }

    private Client getClient() {
        return this.clientProvider.get();
    }

    void attach() {
        if (this.action != null) {
            return;
        }
        if (this.session != null) {
            this.session.addParticipantListener(this.createParticipantListener());
        }
        try {
            this.startTimeView.init();
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"StartTimeController", (Throwable)e, (boolean)true);
        }
        this.action = new Runnable(){
            long prev_h = -1L;
            long prev_m = -1L;

            @Override
            public void run() {
                Client client = StartTimeController.this.getClient();
                long delta = client.getSessionTime() - client.getSessionTimeBase();
                long m = Math.abs(delta / 60000L);
                long h = m / 60L;
                if (!StartTimeController.this.forceUpdate && h == this.prev_h && (m -= h * 60L) == this.prev_m) {
                    return;
                }
                StartTimeController.this.forceUpdate = false;
                String key = delta < 0L ? "StartTimeBean.beginsIn" : "StartTimeBean.inSessionFor";
                String value = StartTimeController.this.i18n.getStringLegacy(key, new Object[]{StartTimeController.this.showTime(h, m)});
                StartTimeController.this.startTimeView.update(value);
                this.prev_h = h;
                this.prev_m = m;
            }
        };
        this.timer = new LightweightTimer(2, this.action);
    }

    private CRParticipantListener createParticipantListener() {
        return new CRParticipantAdapter(){

            public void onMeRemoved(CRParticipantEvent event) {
                StartTimeController.this.online = false;
                if (StartTimeController.this.timer != null) {
                    StartTimeController.this.timer.cancel();
                }
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        StartTimeController.this.startTimeView.update(StartTimeController.this.i18n.getString((PropertiesEnum)StringsProperties.STARTTIMEBEAN_INSESSIONFOR, new Object[]{"\u2014"}));
                    }
                });
            }

            public void onParticipantJoinedRoom(CRParticipantEvent event) {
                if (event.getParticipant().isMe()) {
                    StartTimeController.this.online = true;
                    if (!StartTimeController.this.timer.isScheduled()) {
                        StartTimeController.this.timer.scheduleEvery(5000L);
                        StartTimeController.this.forceUpdate = true;
                        SwingRunnerSupport.invokeLater((Runnable)StartTimeController.this.action);
                    }
                }
            }
        };
    }

    private String showTime(long h, long m) {
        String time;
        Integer hrs = new Integer((int)h);
        Integer min = new Integer((int)m);
        if (h > 1L) {
            switch ((int)m) {
                case 0: {
                    time = this.i18n.getString((PropertiesEnum)StringsProperties.STARTTIMEBEAN_HOURS, new Object[]{hrs});
                    break;
                }
                case 1: {
                    time = this.i18n.getString((PropertiesEnum)StringsProperties.STARTTIMEBEAN_HOURSMINUTE, new Object[]{hrs});
                    break;
                }
                default: {
                    time = this.i18n.getString((PropertiesEnum)StringsProperties.STARTTIMEBEAN_HOURSMINUTES, new Object[]{hrs, min});
                    break;
                }
            }
        } else if (h > 0L) {
            switch ((int)m) {
                case 0: {
                    time = this.i18n.getString((PropertiesEnum)StringsProperties.STARTTIMEBEAN_HOUR);
                    break;
                }
                case 1: {
                    time = this.i18n.getString((PropertiesEnum)StringsProperties.STARTTIMEBEAN_HOURMINUTE);
                    break;
                }
                default: {
                    time = this.i18n.getString((PropertiesEnum)StringsProperties.STARTTIMEBEAN_HOURMINUTES, new Object[]{min});
                    break;
                }
            }
        } else {
            time = m > 1L ? this.i18n.getString((PropertiesEnum)StringsProperties.STARTTIMEBEAN_MINUTES, new Object[]{min}) : (m > 0L ? this.i18n.getString((PropertiesEnum)StringsProperties.STARTTIMEBEAN_MINUTE) : this.i18n.getString((PropertiesEnum)StringsProperties.STARTTIMEBEAN_SUBMINUTE));
        }
        return time;
    }

    void reset() {
        this.online = false;
    }

    public long getSessionTime() {
        if (this.online) {
            return this.getClient().getSessionTime() - this.getClient().getSessionTimeBase();
        }
        return Long.MIN_VALUE;
    }

    public long getSessionTimeBase() {
        if (this.online) {
            return this.getClient().getSessionTimeBase();
        }
        return Long.MIN_VALUE;
    }

    public boolean isSessionTimeValid() {
        return this.online;
    }

    public String getProvider() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.STARTTIMEBEAN_SESSIONTIMEAPI_PROVIDERSTARTTIMEMODULE);
    }

    public byte getTier() {
        return 32;
    }
}

