/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.groupware.quiz.QuizEvent;
import com.elluminate.groupware.quiz.QuizListener;
import com.elluminate.groupware.quiz.QuizPart;
import com.elluminate.groupware.quiz.module.QuestionPanel;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicProgressBarUI;

abstract class QuizLine
implements ActionListener,
ItemListener,
DocumentListener,
QuizListener {
    protected static final Color LTGREY = new Color(229, 229, 229);
    protected static final Color LTBLUE = new Color(221, 231, 246);
    protected static final Color LTYELLOW = new Color(255, 243, 183);
    protected static final Color GREEN = new Color(40, 169, 64);
    protected static final Color RED = new Color(255, 40, 0);
    private static final String[] HTML_PREFIX = new String[]{"<html>\n", "<head></head>\n", "<body>\n"};
    private static final String[] TABLE_PREFIX = new String[]{"<table width=100% cols=2 cellspacing=2>\n", "<tr>\n", "<td bgcolor=#999999 width=50%>", "<font color=#ffffff><b>", QuestionPanel.yourAnswer + "</b></font></td>\n", "<td bgcolor=#999999 width=50%>", "<font color=#ffffff><b>", QuestionPanel.correctAnswer + "</b></font></td>\n", "</tr>\n", "<tr>\n", "<td bgcolor=#fff3b7 width=50%>"};
    private static final String[] TABLE_SEPARATOR = new String[]{"</td>\n", "<td bgcolor=#c2e2b0 width=50%>"};
    private static final String[] TABLE_SUFFIX = new String[]{"</td>\n", "</tr>\n", "</table>\n"};
    private static final String[] EMPTY = new String[]{"<table width=100% cols=1>\n", "<tr>\n", "<td bgcolor=#ffffff color=#ffffff>empty</td>\n", "</tr>\n", "</table>\n"};
    private static final String[] HTML_SUFFIX = new String[]{"</body>\n", "</html>\n"};
    private static final int NE = 12;
    private static final int NW = 18;
    private static final int BOTH = 1;
    private static final int NONE = 0;
    private static final int WIDTH = 2;
    private QuestionPanel panel = null;
    private int row = -1;
    private int leading = 0;
    protected int mode = 0;
    protected JLabel icon = null;
    protected JCheckBox box = null;
    protected JProgressBar bar = null;
    protected JLabel counts = null;
    protected JPanel editor = null;
    private QuizPart part = null;
    private String pre = null;
    private String post = null;
    private Color textViewColor = LTGREY;
    private Color textEditColor = LTBLUE;
    private JEditorPane textEdit = null;
    private JEditorPane textView = null;
    private String[] prev = new String[]{"", ""};
    private boolean created = false;
    private int lastCount = -1;
    private int lastTotal = -1;

    public QuizLine(QuestionPanel panel, int row, QuizPart part) {
        this.panel = panel;
        this.row = row;
        this.part = part;
    }

    public abstract void setMode(int var1);

    public abstract void readData();

    public abstract void writeData();

    public void dispose() {
        if (this.textEdit != null) {
            this.textEdit.getDocument().removeDocumentListener(this);
        }
    }

    public QuizPart getPart() {
        return this.part;
    }

    public void setPart(QuizPart p) {
        this.part = p;
    }

    protected void setHtmlFormatting(String pre, String post) {
        this.pre = pre;
        this.post = post;
    }

    protected void addComponents(int leading) {
        this.leading = leading;
        this.addComponents();
    }

    private void addComponents() {
        this.addComponent(this.icon, 0, 1, 0.0, 12, 0, this.leading);
        if (this.box != null) {
            this.addComponent(this.box, 1, 1, 0.0, 12, 0, this.leading);
            this.addComponent(this.textEdit, 2, 1, 1.0, 18, 1, this.leading);
            this.addComponent(this.textView, 2, 1, 1.0, 18, 1, this.leading);
        } else {
            this.addComponent(this.textEdit, 1, 2, 1.0, 18, 1, this.leading);
            this.addComponent(this.textView, 1, 2, 1.0, 18, 1, this.leading);
        }
        this.addComponent(this.bar, 3, 1, 0.0, 18, 2, this.leading);
        this.addComponent(this.counts, 4, 1, 0.0, 18, 2, this.leading);
        this.addComponent(this.editor, 3, 2, 0.0, 18, 0, this.leading);
        this.created = true;
    }

    private void addComponent(Component c, int col, int nCol, double wt, int anchor, int fill, int above) {
        if (c == null) {
            return;
        }
        this.panel.add(c, new GridBagConstraints(col, this.row, nCol, 1, wt, 1.0, anchor, fill, new Insets(2 + above, 2, 2, 2), 0, 0));
    }

    protected void removeComponents() {
        if (this.icon != null) {
            this.panel.remove(this.icon);
        }
        if (this.box != null) {
            this.panel.remove(this.box);
        }
        if (this.textEdit != null) {
            this.panel.remove(this.textEdit);
        }
        if (this.textView != null) {
            this.panel.remove(this.textView);
        }
        if (this.bar != null) {
            this.panel.remove(this.bar);
        }
        if (this.counts != null) {
            this.panel.remove(this.counts);
        }
        if (this.editor != null) {
            this.panel.remove(this.editor);
        }
    }

    public void setRow(int newRow) {
        this.removeComponents();
        this.row = newRow;
        this.addComponents();
    }

    protected void addTextComponent(boolean editable) {
        JEditorPane c = null;
        if (editable) {
            if (this.textEdit != null) {
                return;
            }
            this.textEdit = new JEditorPane("text/plain", "");
            this.textEdit.setEditable(true);
            this.textEdit.setMargin(new Insets(2, 4, 2, 4));
            this.textEdit.setBackground(this.textEditColor);
            this.textEdit.getDocument().addDocumentListener(this);
            c = this.textEdit;
        } else {
            if (this.textView != null) {
                return;
            }
            this.textView = new JEditorPane("text/html", "");
            this.textView.setMargin(new Insets(0, 0, 0, 0));
            this.textView.setEditable(false);
            this.textView.setBackground(this.textViewColor);
            c = this.textView;
        }
        if (this.created) {
            if (this.box == null) {
                this.addComponent(c, 1, 2, 1.0, 18, 1, this.leading);
            } else {
                this.addComponent(c, 2, 1, 1.0, 18, 1, this.leading);
            }
        }
    }

    public void setFocus() {
        if (this.textEdit != null && this.textEdit.isVisible()) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    QuizLine.this.textEdit.grabFocus();
                    QuizLine.this.textEdit.selectAll();
                }
            });
        }
    }

    protected void setTextColors(Color view, Color edit) {
        this.textEditColor = edit;
        this.textViewColor = view;
        if (this.textEdit != null) {
            this.textEdit.setBackground(edit);
        }
        if (this.textView != null) {
            this.textView.setBackground(view);
        }
    }

    protected void setTextEditable(boolean editable, boolean visible) {
        this.addTextComponent(editable);
        if (editable) {
            if (this.textView != null) {
                this.textView.setVisible(false);
            }
            this.textEdit.setVisible(visible);
        } else {
            if (this.textEdit != null) {
                this.textEdit.setVisible(false);
            }
            this.textView.setVisible(visible);
        }
    }

    protected void updateText(String left, String right) {
        boolean update = false;
        update |= this.isDifferent(0, left);
        if (!(update |= this.isDifferent(1, right))) {
            return;
        }
        try {
            if (this.textEdit != null) {
                this.textEdit.getDocument().removeDocumentListener(this);
                this.textEdit.setText(left);
                this.textEdit.getDocument().addDocumentListener(this);
            }
            if (this.textView != null) {
                this.textView.setText(this.getHTML(left, right));
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"updateTest", (Throwable)t, (boolean)true);
        }
    }

    protected String getText() {
        return this.prev[0];
    }

    private String getHTML(String left, String right) {
        StringBuffer buf = new StringBuffer();
        boolean table = left != null && right != null;
        boolean empty = !(left != null && !left.equals("") || right != null && !right.equals(""));
        this.append(buf, HTML_PREFIX);
        if (table) {
            this.append(buf, TABLE_PREFIX);
        }
        if (this.pre != null) {
            buf.append(this.pre);
        }
        if (left != null) {
            QuizPart.textToHtml((StringBuffer)buf, (String)left, (String)"");
        }
        if (this.post != null) {
            buf.append(this.post);
        }
        if (table) {
            this.append(buf, TABLE_SEPARATOR);
        }
        if (this.pre != null) {
            buf.append(this.pre);
        }
        if (right != null) {
            QuizPart.textToHtml((StringBuffer)buf, (String)right, (String)"");
        }
        if (this.post != null) {
            buf.append(this.post);
        }
        if (table) {
            this.append(buf, TABLE_SUFFIX);
        }
        if (empty) {
            this.append(buf, EMPTY);
        }
        this.append(buf, HTML_SUFFIX);
        return buf.toString();
    }

    private void append(StringBuffer buf, String[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            buf.append(lines[i]);
        }
    }

    protected void createStatsComponents() {
        this.bar = new JProgressBar(0);
        this.bar.setUI(new BasicProgressBarUI());
        this.bar.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        this.bar.setForeground(Color.darkGray);
        this.bar.setBackground(Color.lightGray);
        this.bar.setPreferredSize(new Dimension(100, 15));
        this.bar.setMinimumSize(new Dimension(100, 15));
        this.bar.setMaximumSize(new Dimension(100, 15));
        this.counts = new JLabel("");
        this.updateStats(-1, -1);
    }

    protected void updateStats(int count, int total) {
        if (count == this.lastCount && total == this.lastTotal) {
            return;
        }
        this.lastCount = count;
        this.lastTotal = total;
        if (total > 0) {
            this.bar.setMaximum(total);
            this.bar.setValue(count);
            int percent = count * 100 / total;
            Object[] args = new Object[]{new Integer(percent), new Integer(count), new Integer(total)};
            this.counts.setText(MessageFormat.format(QuestionPanel.statsFmt, args));
        } else {
            this.bar.setMaximum(1);
            this.bar.setValue(0);
            this.counts.setText("");
        }
    }

    private boolean isDifferent(int idx, String value) {
        if (value == null && this.prev[idx] != null) {
            this.prev[idx] = idx > 0 ? null : "";
            return true;
        }
        if (value != null && this.prev[idx] == null) {
            this.prev[idx] = value;
            return true;
        }
        if (value == null) {
            return false;
        }
        if (this.prev[idx].equals(value)) {
            return false;
        }
        this.prev[idx] = value;
        return true;
    }

    protected boolean isDifferent(String value) {
        if (value == null) {
            value = "";
        }
        return !this.prev[0].equals(value);
    }

    protected void hideAll() {
        if (this.icon != null) {
            this.icon.setVisible(false);
        }
        if (this.box != null) {
            this.box.setVisible(false);
        }
        if (this.textEdit != null) {
            this.textEdit.setVisible(false);
        }
        if (this.textView != null) {
            this.textView.setVisible(false);
        }
        if (this.bar != null) {
            this.bar.setVisible(false);
        }
        if (this.counts != null) {
            this.counts.setVisible(false);
        }
        if (this.editor != null) {
            this.editor.setVisible(false);
        }
    }

    public void onQuizChange(QuizEvent e) {
        throw new UnsupportedOperationException("onQuizChange not overridden");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        throw new UnsupportedOperationException("actionPerformed not overridden");
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        throw new UnsupportedOperationException("itemStateChanged not overridden");
    }

    public void textChanged(DocumentEvent e) {
        throw new UnsupportedOperationException("textChanged not overridden");
    }

    private void textModified(DocumentEvent e) {
        this.prev[0] = this.textEdit.getText();
        if (this.prev[0] == null) {
            this.prev[0] = "";
        }
        if (this.textView != null) {
            this.textView.setText(this.getHTML(this.prev[0], null));
        }
        this.textChanged(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textModified(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textModified(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.textModified(e);
    }

    public void updated() {
    }
}

