/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.groupware.quiz.Quiz;
import com.elluminate.groupware.quiz.QuizException;
import com.elluminate.groupware.quiz.QuizInvalidException;
import com.elluminate.groupware.quiz.QuizLib;
import com.elluminate.groupware.quiz.QuizLibEvent;
import com.elluminate.groupware.quiz.QuizLibListener;
import com.elluminate.groupware.quiz.module.QuizLibrary_delBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizLibrary_editBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizLibrary_newBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizLibrary_openBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizLibrary_saveBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizLibrary_viewBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizManager;
import com.elluminate.groupware.quiz.module.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.AccessibleToolBar;
import com.elluminate.gui.component.CToolBarButton;
import com.elluminate.gui.swing.CTable;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.io.IOUtilities;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class QuizLibrary
extends JPanel
implements ListSelectionListener,
QuizLibListener {
    private static I18n i18n = I18n.create(QuizLibrary.class);
    public static final Object[] COLUMN_NAMES = new Object[]{i18n.getString((PropertiesEnum)StringsProperties.QUIZLIBRARY_LISTTITLE)};
    private Color alternateRowColor;
    private File last = null;
    private QuizLib lib = null;
    private DefaultTableModel model = null;
    private QuizManager mgr = null;
    private Quiz updating = null;
    ImageIcon newIcon = i18n.getIcon("QuizLibrary.newIcon");
    ImageIcon openIcon = i18n.getIcon("QuizLibrary.openIcon");
    ImageIcon saveIcon = i18n.getIcon("QuizLibrary.saveIcon");
    ImageIcon delIcon = i18n.getIcon("QuizLibrary.delIcon");
    ImageIcon editIcon = i18n.getIcon("QuizLibrary.editIcon");
    ImageIcon viewIcon = i18n.getIcon("QuizLibrary.viewIcon");
    BorderLayout libraryLayout = new BorderLayout();
    JToolBar toolBar = new AccessibleToolBar();
    CToolBarButton editBtn = new CToolBarButton();
    CToolBarButton delBtn = new CToolBarButton();
    CToolBarButton viewBtn = new CToolBarButton();
    CToolBarButton newBtn = new CToolBarButton();
    CToolBarButton openBtn = new CToolBarButton();
    CToolBarButton saveBtn = new CToolBarButton();
    JScrollPane libraryScroller = new JScrollPane();
    JTable library = new CTable();

    public QuizLibrary() {
        this(new QuizLib(-1L));
    }

    public QuizLibrary(QuizLib library) {
        this.lib = library;
        this.lib.addQuizLibListener((QuizLibListener)this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"QuizLibrary", (Throwable)e, (boolean)true);
        }
    }

    private void libAdd(Quiz q) {
        String title = q.toString();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            String other = ((Quiz)this.model.getValueAt(i, 0)).toString();
            if (title.compareTo(other) >= 0) continue;
            this.model.insertRow(i, new Object[]{q});
            return;
        }
        this.model.addRow(new Object[]{q});
    }

    private void libDel(Quiz q) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Quiz other = (Quiz)this.model.getValueAt(i, 0);
            if (q.getID() != other.getID()) continue;
            this.model.removeRow(i);
            return;
        }
    }

    private void libMod(Quiz q) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Quiz other = (Quiz)this.model.getValueAt(i, 0);
            if (q.getID() != other.getID()) continue;
            this.libDel(other);
            this.libAdd(q);
            return;
        }
        this.libAdd(q);
    }

    public void setManager(QuizManager manager) {
        this.mgr = manager;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.libraryLayout);
        this.editBtn.setEnabled(false);
        this.editBtn.setIcon((Icon)this.editIcon);
        this.editBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZLIBRARY_EDITTIP));
        this.editBtn.addActionListener((ActionListener)new QuizLibrary_editBtn_actionAdapter(this));
        this.delBtn.setEnabled(false);
        this.delBtn.setIcon((Icon)this.delIcon);
        this.delBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZLIBRARY_DELTIP));
        this.delBtn.addActionListener((ActionListener)new QuizLibrary_delBtn_actionAdapter(this));
        this.viewBtn.setEnabled(false);
        this.viewBtn.setIcon((Icon)this.viewIcon);
        this.viewBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZLIBRARY_VIEWTIP));
        this.viewBtn.addActionListener((ActionListener)new QuizLibrary_viewBtn_actionAdapter(this));
        this.toolBar.setFloatable(false);
        this.newBtn.setIcon((Icon)this.newIcon);
        this.newBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZLIBRARY_NEWTIP));
        this.newBtn.addActionListener((ActionListener)new QuizLibrary_newBtn_actionAdapter(this));
        this.saveBtn.setIcon((Icon)this.saveIcon);
        this.saveBtn.setEnabled(false);
        this.saveBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZLIBRARY_SAVETIP));
        this.saveBtn.addActionListener((ActionListener)new QuizLibrary_saveBtn_actionAdapter(this));
        this.openBtn.setIcon((Icon)this.openIcon);
        this.openBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZLIBRARY_OPENTIP));
        this.openBtn.addActionListener((ActionListener)new QuizLibrary_openBtn_actionAdapter(this));
        this.model = new DefaultTableModel(COLUMN_NAMES, 0){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.library.setModel(this.model);
        this.library.getColumnModel().getColumn(0).setResizable(false);
        this.library.getSelectionModel().addListSelectionListener(this);
        this.library.getTableHeader().setReorderingAllowed(false);
        this.library.setIntercellSpacing(new Dimension(0, 1));
        this.library.setGridColor(Color.white);
        this.library.setSelectionMode(2);
        this.library.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = QuizLibrary.this.library.rowAtPoint(e.getPoint());
                if (row != -1 && e.getClickCount() == 2) {
                    if (QuizLibrary.this.viewBtn.isVisible()) {
                        if (QuizLibrary.this.viewBtn.isEnabled()) {
                            QuizLibrary.this.viewBtn_actionPerformed();
                        }
                    } else if (QuizLibrary.this.editBtn.isVisible() && QuizLibrary.this.editBtn.isEnabled()) {
                        QuizLibrary.this.editBtn_actionPerformed();
                    }
                }
            }
        });
        QuizRenderer r = new QuizRenderer();
        this.library.setDefaultRenderer(Object.class, r);
        this.library.setRowHeight(r.getPreferredHeight());
        this.add((Component)this.toolBar, "North");
        this.toolBar.add((Component)this.newBtn);
        this.toolBar.add((Component)this.openBtn);
        this.toolBar.add((Component)this.saveBtn);
        this.toolBar.add((Component)this.delBtn);
        this.toolBar.add((Component)this.editBtn);
        this.toolBar.add((Component)this.viewBtn);
        this.libraryScroller.setVerticalScrollBarPolicy(22);
        this.libraryScroller.setHorizontalScrollBarPolicy(31);
        JViewport vp = new JViewport(){

            @Override
            protected void paintComponent(Graphics g) {
                QuizLibrary.this.updateColors();
                super.paintComponent(g);
                g.setColor(QuizLibrary.this.alternateRowColor);
                Dimension s = this.getSize();
                int rh = QuizLibrary.this.library.getRowHeight();
                for (int y = 0; y < s.height; y += 2 * rh) {
                    g.fillRect(0, y, s.width, rh);
                }
            }
        };
        vp.setView(this.library);
        this.libraryScroller.setViewport(vp);
        this.libraryScroller.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
        this.add((Component)this.libraryScroller, "Center");
        String removeQuizAction = "remove-quiz";
        InputMap imap = this.library.getInputMap(0);
        imap.put(KeyStroke.getKeyStroke(127, 0), "remove-quiz");
        imap.put(KeyStroke.getKeyStroke(8, 0), "remove-quiz");
        this.library.getActionMap().put("remove-quiz", new AbstractAction("remove-quiz"){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuizLibrary.this.delBtn_actionPerformed();
            }
        });
    }

    private void updateColors() {
        int b;
        int g;
        Color c = UIManager.getColor("Table.background");
        int r = c.getRed();
        int brightness = r * 299 + (g = c.getGreen()) * 587 + (b = c.getBlue()) * 114;
        this.alternateRowColor = brightness < 127000 ? new Color(Math.min(255, r + 18), Math.min(255, g + 12), Math.min(255, b + 1)) : new Color(Math.max(0, r - 18), Math.max(0, g - 12), Math.max(0, b - 1));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.enableUI();
    }

    public void enableUI() {
        int[] sel = this.library.getSelectedRows();
        boolean selected = sel.length > 0;
        boolean multiple = sel.length > 1;
        this.saveBtn.setEnabled(this.lib.size() > 0);
        this.editBtn.setEnabled(selected && !multiple);
        this.viewBtn.setEnabled(selected && !multiple);
        this.delBtn.setEnabled(selected);
    }

    public void libraryChanged(QuizLibEvent e) {
        switch (e.getAction()) {
            case 1: {
                this.libAdd(e.getQuiz());
                break;
            }
            case 2: {
                this.libDel(e.getQuiz());
                break;
            }
            case 3: {
                this.libMod(e.getQuiz());
            }
        }
        this.library.repaint();
        this.enableUI();
    }

    void editBtn_actionPerformed() {
        int[] sel = this.library.getSelectedRows();
        if (sel.length == 0) {
            this.enableUI();
            return;
        }
        this.updating = (Quiz)this.model.getValueAt(sel[0], 0);
        if (this.updating != null) {
            this.mgr.edit(this.updating);
        }
    }

    void newBtn_actionPerformed(ActionEvent e) {
        this.mgr.create();
    }

    void viewBtn_actionPerformed() {
        int[] sel = this.library.getSelectedRows();
        if (sel.length == 0) {
            this.enableUI();
            return;
        }
        this.updating = (Quiz)this.model.getValueAt(sel[0], 0);
        if (this.updating != null) {
            this.mgr.view(this.updating);
        }
    }

    void delBtn_actionPerformed() {
        int[] sel = this.library.getSelectedRows();
        ArrayList<Quiz> qs = new ArrayList<Quiz>();
        for (int i = 0; i < sel.length; ++i) {
            Quiz q = (Quiz)this.model.getValueAt(sel[i], 0);
            if (q == null) continue;
            qs.add(q);
        }
        if (qs.size() == 0) {
            this.enableUI();
            return;
        }
        String msg = qs.size() > 1 ? i18n.getString((PropertiesEnum)StringsProperties.QUIZLIBRARY_DELMULTIPLEWARNING) : i18n.getString((PropertiesEnum)StringsProperties.QUIZLIBRARY_DELWARNING);
        int result = ModalDialog.showConfirmDialog((Component)this, (Object)msg, (String)i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_CONFIRMEXIT), (int)0, (int)3);
        switch (result) {
            case 0: {
                break;
            }
            case 1: {
                return;
            }
        }
        Iterator i$ = qs.iterator();
        while (i$.hasNext()) {
            Quiz q;
            this.updating = q = (Quiz)i$.next();
            this.mgr.delete(this.updating);
        }
    }

    public void save(ArrayList sel, File file) {
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        Element root = new Element("quizzes");
        Document doc = new Document(root);
        for (Quiz q : sel) {
            Element e = new Element("quiz");
            q.writeXML(e);
            root.addContent((Content)e);
        }
        try {
            OutputStreamWriter writer = IOUtilities.generateUTF8WriterFromFile((File)file);
            out.output(doc, (Writer)writer);
            writer.close();
        }
        catch (IOException ex) {
            ModalDialog.showMessageDialog((Component)this.mgr.getAppFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.QUIZLIBRARY_WRITEFAILED, new Object[]{ex.getMessage(), file}), (String)i18n.getString((PropertiesEnum)StringsProperties.QUIZLIBRARY_WRITEFAILTITLE), (int)0);
        }
    }

    public boolean load(File file) {
        Document doc;
        this.last = new File(file.getParent());
        SAXBuilder in = new SAXBuilder();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            doc = in.build((InputStream)fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (Exception ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.QUIZLIBRARY_READFAILED, new Object[]{ex.getMessage(), file}), (String)i18n.getString((PropertiesEnum)StringsProperties.QUIZLIBRARY_READFAILTITLE), (int)0);
            return false;
        }
        try {
            Element root = doc.getRootElement();
            if (!root.getName().equals("quizzes")) {
                throw new QuizInvalidException("unknownContainer", root.getName());
            }
            for (Element e : root.getChildren("quiz")) {
                Quiz q = new Quiz();
                q.readXML(file.toString(), e);
                q.validate();
                this.mgr.update(q);
                if (q.getDateGiven() == null) continue;
                q.computeStats();
            }
        }
        catch (QuizException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)ex.toString(), (String)i18n.getString((PropertiesEnum)StringsProperties.QUIZLIBRARY_IMPORTERROR), (int)0);
            return false;
        }
        return true;
    }

    void openBtn_actionPerformed(ActionEvent e) {
        this.mgr.load();
    }

    void saveBtn_actionPerformed(ActionEvent e) {
        this.mgr.save();
    }

    private class QuizRenderer
    extends DefaultTableCellRenderer {
        public QuizRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 0));
        }

        public int getPreferredHeight() {
            this.setText("Some text");
            this.setIcon(i18n.getIcon("QuizLibrary.vcqDocumentIcon32"));
            return this.getPreferredSize().height;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            this.setComponentOrientation(table.getComponentOrientation());
            if (selected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                if (row % 2 == 0) {
                    this.setBackground(QuizLibrary.this.alternateRowColor);
                } else {
                    this.setBackground(table.getBackground());
                }
                this.setForeground(table.getForeground());
            }
            if (value instanceof Quiz) {
                Quiz q = (Quiz)value;
                this.setText(q.toString());
                this.setIcon(i18n.getIcon("QuizLibrary.vcqDocumentIcon32"));
            } else {
                this.setText(value == null ? "" : value.toString());
                this.setIcon(null);
            }
            this.setEnabled(table.isEnabled());
            this.setFont(table.getFont());
            return this;
        }
    }
}

