/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.groupware.quiz.Question;
import com.elluminate.groupware.quiz.QuizEvent;
import com.elluminate.groupware.quiz.QuizListener;
import com.elluminate.groupware.quiz.QuizPart;
import com.elluminate.groupware.quiz.module.QuestionPanel;
import com.elluminate.groupware.quiz.module.QuizLine;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

class NoAnswerLine
extends QuizLine {
    Question question;

    public NoAnswerLine(QuestionPanel panel, int row, int mode) {
        super(panel, row, null);
        this.box = new JCheckBox();
        this.box.setOpaque(false);
        this.box.setVisible(false);
        this.icon = new JLabel(QuestionPanel.blankIcon);
        this.icon.setOpaque(false);
        this.addTextComponent(false);
        this.updateText(QuestionPanel.noAnswer, null);
        this.createStatsComponents();
        this.bar.setForeground(RED);
        this.addComponents(0);
        this.setMode(mode);
    }

    @Override
    public void dispose() {
        this.question.removeQuizListener((QuizListener)this);
        this.removeComponents();
    }

    public void setQuestion(Question q) {
        if (this.question != null) {
            this.question.removeQuizListener((QuizListener)this);
        }
        this.question = q;
        super.setPart((QuizPart)q);
        if (this.question != null) {
            this.question.addQuizListener((QuizListener)this);
        }
        this.setMode(this.mode);
    }

    @Override
    public void setMode(int newMode) {
        this.mode = newMode;
        boolean enable = this.mode == 5 || this.mode == 2;
        this.icon.setVisible(enable &= this.question != null);
        this.setTextEditable(false, enable);
        this.bar.setVisible(enable);
        this.counts.setVisible(enable);
        this.readData();
    }

    @Override
    public void readData() {
        if (this.question == null) {
            return;
        }
        if (this.mode == 5) {
            if (this.question.getResponse() == null) {
                this.icon.setIcon(QuestionPanel.wrongIcon);
            } else {
                this.icon.setIcon(QuestionPanel.blankIcon);
            }
            short t = this.question.getStatsTotal();
            short c = this.question.getStatsCount();
            this.updateStats(t - c, t);
        } else {
            this.icon.setIcon(QuestionPanel.blankIcon);
            short t = this.question.getStatsTotal();
            short c = this.question.getStatsCount();
            this.updateStats(t - c, t);
        }
    }

    @Override
    public void writeData() {
    }

    @Override
    public void onQuizChange(QuizEvent e) {
        if (e.getAction() == 2 || e.getAction() == 1) {
            this.readData();
        }
    }
}

