/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.LoadQuizCommand;
import com.elluminate.groupware.quiz.module.QuizBean;
import com.elluminate.groupware.quiz.module.QuizModule;
import com.elluminate.groupware.quiz.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

public class LoadQuizCmd
extends AbstractCommand
implements LoadQuizCommand {
    private String fileURL = null;
    private I18n i18n = I18n.create((Object)((Object)this));
    private QuizModule module;

    @Inject
    public LoadQuizCmd(QuizModule module) {
        this.module = module;
    }

    public void setFile(String fileURL) {
        this.fileURL = fileURL;
    }

    protected void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        if (this.fileURL == null || this.fileURL.length() == 0) {
            throw new CommandParameterException("The file reference must be set", this.i18n.getString((PropertiesEnum)StringsProperties.LOADQUIZCMD_BADPARAMFILENOTSET));
        }
        try {
            URL u = new URL(this.fileURL);
            String proto = u.getProtocol().toLowerCase(Locale.ENGLISH);
            if (!(proto.equals("agenda") || proto.equals("http") || proto.equals("ftp") || proto.equals("https"))) {
                throw new CommandParameterException("Disallowed URL: " + this.fileURL, this.i18n.getString((PropertiesEnum)StringsProperties.LOADQUIZCMD_BADPARAMURLNOTSUPPORTED, new Object[]{this.fileURL}));
            }
        }
        catch (MalformedURLException ex) {
            throw new CommandParameterException("Invalid URL: " + this.fileURL, this.i18n.getString((PropertiesEnum)StringsProperties.LOADQUIZCMD_BADPARAMINVALIDURL, new Object[]{this.fileURL}));
        }
        QuizBean bean = this.module.getQuizBean();
        bean.loadRemotely(this.fileURL);
    }
}

