/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia;

import com.elluminate.groupware.multimedia.AbstractLoader;
import com.elluminate.groupware.multimedia.LoaderListener;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.platform.Platform;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class FileLoader
extends AbstractLoader {
    private File file;
    private DataInputStream istr;

    public FileLoader(File f, int id, Object lock, LoaderListener lst, Component parent) {
        super(f.getName(), id, lock, lst, parent);
        this.file = f;
    }

    @Override
    protected boolean open() throws IOException {
        this.istr = new DataInputStream(new BufferedInputStream(new FileInputStream(this.file)));
        this.setLength(this.file.length());
        this.setMimeType(Platform.getMimeType((File)this.file));
        return true;
    }

    @Override
    protected void close() {
        if (this.istr != null) {
            try {
                this.istr.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.istr = null;
        }
    }

    @Override
    protected boolean read(ProtocolBuffer buf, int nBytes) {
        try {
            buf.readFrom((DataInput)this.istr, 0, nBytes);
            return true;
        }
        catch (IOException ex) {
            this.reportError("FileLoader.readError", ex.toString());
            return false;
        }
    }
}

