/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia;

import com.elluminate.groupware.multimedia.LoaderListener;
import com.elluminate.groupware.multimedia.StreamCache;
import com.elluminate.groupware.multimedia.StreamEvent;
import com.elluminate.groupware.multimedia.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public abstract class AbstractLoader {
    private Object lock;
    private String name;
    private int id;
    private StreamCache cache = null;
    private Thread thread;
    private Channel chnl = null;
    private short notify = (short)-32767;
    private Component parent = null;
    private I18n i18n = I18n.create((Object)this);
    private long length = -1L;
    private String mime = "application/octet-stream";
    private LoaderListener listener = null;
    private BigInteger auth;

    protected AbstractLoader(String nm, int id, Object lock, LoaderListener listener, Channel chnl, short notify) {
        this.name = nm;
        this.id = id;
        this.lock = lock;
        this.listener = listener;
        this.chnl = chnl;
        this.notify = notify;
    }

    protected AbstractLoader(String nm, int id, Object lock, LoaderListener listener, Component parent) {
        this.name = nm;
        this.id = id;
        this.lock = lock;
        this.listener = listener;
        this.parent = parent;
    }

    protected abstract boolean open() throws IOException;

    protected abstract void close();

    protected abstract boolean read(ProtocolBuffer var1, int var2);

    public void reportError(String msg, String details) {
        if (this.chnl != null) {
            ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)this.notify, (byte)25);
            DataOutputStream str = e.write();
            try {
                str.writeUTF(msg);
                str.writeUTF(this.name);
                str.writeUTF(details);
                str.close();
            }
            catch (IOException ex) {
                LogSupport.exception((Object)this, (String)"reportError", (Throwable)ex, (boolean)true);
                return;
            }
            this.chnl.onChannelData(e);
        } else if (this.parent != null) {
            ModalDialog.showMessageDialog((Component)this.parent, (Object)this.i18n.getStringLegacy(msg, new Object[]{this.name, details}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.ABSTRACTLOADER_ERRORTITLE), (int)0);
        } else {
            LogSupport.error((Object)this, (String)"reportError", (String)this.i18n.getStringLegacy(msg, new Object[]{this.name, details}));
        }
        if (this.cache != null) {
            this.cache.streamAbort(StreamEvent.getInstance(this, this.id, null));
        }
    }

    public String getName() {
        return this.name;
    }

    protected void setLength(long len) {
        this.length = len;
    }

    public long getLength() {
        return this.length;
    }

    protected void setMimeType(String type) {
        this.mime = type;
    }

    public String getMimeType() {
        return this.mime;
    }

    public void setAuth(BigInteger auth) {
        this.auth = auth;
    }

    public BigInteger getAuth() {
        return this.auth;
    }

    public short getNotifyAddress() {
        return this.notify;
    }

    public void start() throws IOException {
        class Loader
        implements Runnable {
            Loader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean abort;
                    long length;
                    if (!AbstractLoader.this.open()) {
                        return;
                    }
                    try {
                        length = AbstractLoader.this.getLength();
                        AbstractLoader.this.cache = new StreamCache(AbstractLoader.this.id, length);
                    }
                    catch (IOException ex) {
                        String msg = ex.getMessage();
                        if (msg == null) {
                            msg = ex.toString();
                        }
                        AbstractLoader.this.reportError("Multimedia.cantConnect", msg);
                        AbstractLoader.this.close();
                        return;
                    }
                    Object msg = AbstractLoader.this.lock;
                    synchronized (msg) {
                        abort = !AbstractLoader.this.listener.startingLoad(AbstractLoader.this);
                    }
                    if (abort) {
                        AbstractLoader.this.close();
                        return;
                    }
                    while (length > 0L) {
                        ProtocolBuffer buf = ProtocolBuffer.getInstance();
                        int nBytes = 500;
                        if (length < 500L) {
                            nBytes = (int)length;
                        }
                        if (AbstractLoader.this.read(buf, nBytes)) {
                            length -= (long)nBytes;
                            Object object = AbstractLoader.this.lock;
                            synchronized (object) {
                                AbstractLoader.this.cache.streamingData(StreamEvent.getInstance(this, AbstractLoader.this.id, buf));
                                continue;
                            }
                        }
                        length = 0L;
                    }
                }
                finally {
                    AbstractLoader.this.close();
                }
            }
        }
        this.thread = new WorkerThread((Runnable)new Loader(), "MM Loader " + this.id);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public StreamCache getCache() {
        return this.cache;
    }
}

