/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.x11;

import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.HotKey;
import com.elluminate.util.Debug;
import com.elluminate.util.SerializerThread;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class X11HotKey
implements HotKey {
    private static final SerializerThread actionThread = new SerializerThread("X11HotKey Action Thread");
    private static Thread xEventThread = null;
    private static boolean loadedOK = false;
    private int keyCode = 0;
    private int modifiers = 0;
    private Runnable action = null;
    private boolean enabled = true;
    private boolean valid = false;
    private boolean needsDispose = true;

    static boolean isSupported() {
        return loadedOK;
    }

    public static void shutdown() {
        if (xEventThread != null && xEventThread.isAlive()) {
            X11HotKey.shutdownNative();
        }
    }

    public X11HotKey(int keyCode, int modifiers, Runnable action) {
        this.keyCode = keyCode;
        this.modifiers = modifiers;
        this.action = action;
        this.register();
    }

    public String toString() {
        return this.getClass().getName() + ": " + "key=" + KeyEvent.getKeyText(this.keyCode) + " mod=" + KeyEvent.getKeyModifiersText(this.modifiers) + " valid=" + this.valid + " enabled=" + this.enabled + " action=" + this.action;
    }

    @Override
    public int getKeyCode() {
        return this.keyCode;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getKeyDesc() {
        return GuiUtils.getKeystrokeText(this.keyCode, this.modifiers);
    }

    @Override
    public boolean hasAction() {
        return this.action != null;
    }

    @Override
    public void setAction(Runnable action) {
        this.action = action;
    }

    @Override
    public void runAction() {
        if (this.enabled && this.action != null) {
            if (GUIDebug.HOT_KEYS.show()) {
                LogSupport.message((Object)this, (String)"runAction", (String)("firing hot key: " + this.toString()));
            }
            actionThread.invokeLater(this.action);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void dispose() {
        if (this.needsDispose) {
            if (this.valid) {
                this.unregister();
            }
            this.needsDispose = false;
        }
    }

    @Override
    public boolean isDisposed() {
        return !this.needsDispose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register() {
        if (this.valid) {
            return;
        }
        if (xEventThread == null || !xEventThread.isAlive()) {
            throw new RuntimeException("X11 Event Processor is not running.");
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.registerNative(this.keyCode, this.modifiers)) {
                this.valid = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister() {
        if (!this.valid) {
            return;
        }
        if (xEventThread == null || !xEventThread.isAlive()) {
            throw new RuntimeException("X11 Event Processor is not running.");
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.valid = false;
            this.unregisterNative();
        }
    }

    static void setDebugMode(boolean flag) {
        block2: {
            try {
                X11HotKey.setDebugModeNative(flag);
            }
            catch (Throwable t) {
                if (!GUIDebug.HOT_KEYS.show()) break block2;
                LogSupport.message(X11HotKey.class, (String)"setDebugMode", (String)Debug.getStackTrace((Throwable)t));
            }
        }
    }

    private static native void setDebugModeNative(boolean var0);

    private native boolean registerNative(int var1, int var2);

    private native void unregisterNative();

    private static native void processEventsNative();

    private static native void shutdownNative();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            PropertyChangeListener flagListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent ev) {
                    X11HotKey.setDebugMode(GUIDebug.HOT_KEYS.show());
                }
            };
            GUIDebug.HOT_KEYS.addPropertyChangeListener(flagListener);
            X11HotKey.setDebugModeNative(GUIDebug.HOT_KEYS.show());
            Thread thread = xEventThread = new WorkerThread("X11 HotKey Event Thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (GUIDebug.HOT_KEYS.show()) {
                        LogSupport.message((Object)((Object)this), (String)"run", (String)"X11 HotKey event thread starting");
                    }
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        ((Object)((Object)this)).notify();
                    }
                    X11HotKey.processEventsNative();
                    if (GUIDebug.HOT_KEYS.show()) {
                        LogSupport.message((Object)((Object)this), (String)"run", (String)"X11 HotKey event thread exiting");
                    }
                }
            };
            synchronized (thread) {
                xEventThread.setDaemon(true);
                xEventThread.start();
                try {
                    xEventThread.wait(1000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            loadedOK = true;
        }
        catch (Throwable t) {
            LogSupport.message(X11HotKey.class, (String)"<clinit>", (String)("Failed to initialize Hot Keys event thread: " + Debug.getStackTrace((Throwable)t)));
        }
    }
}

