/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.swing;

import com.elluminate.gui.swing.CTableHeader;
import com.elluminate.gui.swing.TableSorter;
import com.elluminate.platform.Platform;
import com.elluminate.util.ShortList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CTable
extends JTable
implements SwingConstants,
Autoscroll {
    public static final int ALIGN_NONE = -1;
    private static final Integer CENTER_KEY = new Integer(0);
    private static final Integer LEFT_KEY = new Integer(2);
    private static final Integer RIGHT_KEY = new Integer(4);
    private static final Integer LEADING_KEY = new Integer(10);
    private static final Integer TRAILING_KEY = new Integer(11);
    private TreeMap columnAlignments = new TreeMap();
    private HashMap rendererCache = new HashMap();
    private Insets autoscrollInsets = null;

    public static CTable createSortedTable(TableModel dm) {
        TableSorter sorter = new TableSorter(dm);
        CTable table = new CTable(sorter);
        sorter.setTableHeader(table.getTableHeader());
        return table;
    }

    public static CTable createSortedTable(TableModel dm, TableColumnModel cm) {
        TableSorter sorter = new TableSorter(dm);
        CTable table = new CTable(sorter, cm);
        sorter.setTableHeader(table.getTableHeader());
        return table;
    }

    public static CTable createSortedTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        TableSorter sorter = new TableSorter(dm);
        CTable table = new CTable(sorter, cm, sm);
        sorter.setTableHeader(table.getTableHeader());
        return table;
    }

    public CTable() {
        this.init();
    }

    public CTable(int nRows, int nCols) {
        super(nRows, nCols);
        this.init();
    }

    public CTable(Object[][] rowData, Object[] colNames) {
        super(rowData, colNames);
        this.init();
    }

    public CTable(TableModel dm) {
        super(dm);
        this.init();
    }

    public CTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.init();
    }

    public CTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.init();
    }

    public CTable(Vector rowData, Vector colNames) {
        super(rowData, colNames);
        this.init();
    }

    @Override
    public void autoscroll(Point pt) {
        if (pt != null && this.autoscrollInsets != null && this.getAutoscrolls()) {
            Rectangle rect;
            if (this.getParent() instanceof JViewport) {
                rect = ((JViewport)this.getParent()).getViewRect();
            } else {
                rect = new Rectangle(this.getParent().getSize()).intersection(this.getBounds());
                rect.translate(-this.getX(), -this.getY());
            }
            int row = this.rowAtPoint(pt);
            int col = this.columnAtPoint(pt);
            if (row < 0 || col < 0) {
                return;
            }
            if (pt.x < rect.x + this.autoscrollInsets.left) {
                --col;
            } else if (pt.x > rect.x + rect.width - this.autoscrollInsets.right) {
                ++col;
            }
            if (pt.y < rect.y + this.autoscrollInsets.top) {
                --row;
            } else if (pt.y > rect.y + rect.height - this.autoscrollInsets.bottom) {
                ++row;
            }
            if (row < 0 || col < 0) {
                return;
            }
            if (row >= this.getRowCount() || col >= this.getColumnCount()) {
                return;
            }
            rect = this.getCellRect(row, col, true);
            if (!rect.isEmpty()) {
                this.scrollRectToVisible(rect);
            }
        }
    }

    @Override
    public Insets getAutoscrollInsets() {
        Insets result = new Insets(0, 0, 0, 0);
        if (this.autoscrollInsets != null && this.getAutoscrolls()) {
            Rectangle rect;
            if (result.equals(this.autoscrollInsets)) {
                return result;
            }
            if (this.getParent() instanceof JViewport) {
                rect = ((JViewport)this.getParent()).getViewRect();
            } else {
                rect = new Rectangle(this.getParent().getSize()).intersection(this.getBounds());
                rect.translate(-this.getX(), -this.getY());
            }
            rect.x += this.autoscrollInsets.left;
            rect.y += this.autoscrollInsets.top;
            rect.width -= this.autoscrollInsets.left + this.autoscrollInsets.right;
            rect.height -= this.autoscrollInsets.top + this.autoscrollInsets.bottom;
            result.left = rect.x;
            result.top = rect.y;
            result.right = this.getWidth() - rect.x - rect.width;
            result.bottom = this.getHeight() - rect.y - rect.height;
        }
        return result;
    }

    public void setAutoscrollInsets(Insets insets) {
        this.autoscrollInsets = insets;
    }

    public int getColumnAlignment(int colIdx) {
        Number alignment = (Number)this.columnAlignments.get(ShortList.get((short)((short)colIdx)));
        if (alignment != null) {
            return alignment.intValue();
        }
        return -1;
    }

    public void setColumnAlignment(int colIdx, int alignment) {
        if (colIdx < 0 || colIdx > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid column index: " + colIdx);
        }
        Integer value = null;
        switch (alignment) {
            case 0: {
                value = CENTER_KEY;
                break;
            }
            case 2: {
                value = LEFT_KEY;
                break;
            }
            case 4: {
                value = RIGHT_KEY;
                break;
            }
            case 10: {
                value = LEADING_KEY;
                break;
            }
            case 11: {
                value = TRAILING_KEY;
                break;
            }
            case -1: {
                value = null;
            }
            default: {
                throw new IllegalArgumentException("Invalid alignment: " + alignment);
            }
        }
        if (value != null) {
            this.columnAlignments.put(ShortList.get((short)((short)colIdx)), value);
        } else {
            this.columnAlignments.remove(ShortList.get((short)((short)colIdx)));
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int col) {
        TableCellRenderer result;
        TableCellRenderer renderer = super.getCellRenderer(row, col);
        if (renderer == null) {
            renderer = super.getDefaultRenderer(JTable.class);
        }
        if ((result = (TableCellRenderer)this.rendererCache.get(renderer)) == null) {
            result = new CTableCellRendererProxy(renderer);
            this.rendererCache.put(renderer, result);
        }
        return result;
    }

    public void getColumnWidthRange(int colIdx, Dimension min, Dimension max) {
        TableColumn col = this.getColumnModel().getColumn(colIdx);
        TableModel model = this.getModel();
        TableCellRenderer renderer = col.getCellRenderer();
        Dimension cellSpacing = this.getIntercellSpacing();
        if (min != null) {
            min.width = Integer.MAX_VALUE;
            min.height = Integer.MAX_VALUE;
        }
        if (max != null) {
            max.width = -1;
            max.height = -1;
        }
        for (int ix = 0; ix < this.getRowCount(); ++ix) {
            Component cmp;
            Object val;
            renderer = this.getCellRenderer(ix, colIdx);
            if (renderer == null || (val = model.getValueAt(ix, colIdx)) == null || (cmp = renderer.getTableCellRendererComponent(this, val, false, false, ix, colIdx)) == null) continue;
            Dimension size = null;
            size = cmp instanceof JComponent ? ((JComponent)cmp).getPreferredSize() : cmp.getSize();
            if (size == null) continue;
            size.width += cellSpacing.width;
            size.height += cellSpacing.height;
            if (min != null) {
                if (size.width < min.width) {
                    min.width = size.width;
                }
                if (size.height < min.height) {
                    min.width = size.height;
                }
            }
            if (max == null) continue;
            if (size.width > max.width) {
                max.width = size.width;
            }
            if (size.height <= max.height) continue;
            max.height = size.height;
        }
    }

    public Dimension getColumnHeaderPreferredSize(int colIdx) {
        TableSorter sorter;
        Object heading;
        Component cmp;
        Dimension result = null;
        TableColumn col = this.getColumnModel().getColumn(colIdx);
        TableCellRenderer headerRenderer = col.getHeaderRenderer();
        if (headerRenderer == null) {
            headerRenderer = this.getTableHeader().getDefaultRenderer();
        }
        result = (cmp = headerRenderer.getTableCellRendererComponent(this, heading = col.getHeaderValue(), false, false, 0, colIdx)) instanceof JComponent ? ((JComponent)cmp).getPreferredSize() : cmp.getSize();
        int calcWidth = 0;
        FontMetrics fm = cmp.getFontMetrics(cmp.getFont());
        String colTitle = this.getModel().getColumnName(colIdx);
        if (colTitle != null) {
            calcWidth += Math.max(1, fm.stringWidth(colTitle));
        }
        Icon colIcon = null;
        int colGap = 0;
        if (cmp instanceof JLabel) {
            colIcon = ((JLabel)cmp).getIcon();
            colGap = ((JLabel)cmp).getIconTextGap();
        }
        if (colIcon != null) {
            calcWidth += Math.max(1, colIcon.getIconWidth());
            if (colTitle != null) {
                calcWidth += Math.max(1, colGap);
            }
        }
        if (calcWidth > result.width) {
            result.width = calcWidth;
        }
        if ((sorter = TableSorter.getSorter(this)) != null && sorter.isColumnAllowed(colIdx)) {
            Dimension iconSize = sorter.getHeaderIconSize();
            result.width += iconSize.width + 2;
            if (result.height < iconSize.height) {
                result.height = iconSize.height;
            }
        }
        Dimension cellSpacing = this.getIntercellSpacing();
        result.width += Math.max(0, cellSpacing.width) + 2;
        result.height += Math.max(0, cellSpacing.height);
        return result;
    }

    private void init() {
        this.setTableHeader(new CTableHeader(this.columnModel));
        this.setIntercellSpacing(new Dimension(0, 1));
        this.setShowGrid(false);
        this.setFocusTraversalKeys(0, null);
        this.setFocusTraversalKeys(1, null);
        InputMap imap = this.getInputMap(1);
        imap.put(KeyStroke.getKeyStroke(10, 0), "null");
        imap.put(KeyStroke.getKeyStroke(47, 2), "null");
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.paintComponent(g, true);
    }

    protected void paintComponent(Graphics g, boolean paintExtended) {
        super.paintComponent(g);
        if (paintExtended) {
            this.paintExtendedGridLines(g);
        }
    }

    protected void paintExtendedGridLines(Graphics g) {
        Dimension s = this.getSize();
        int rh = this.getRowHeight();
        int n = this.getRowCount();
        int th = n * rh;
        if (th < s.height && this.getShowVerticalLines()) {
            g.setColor(this.getGridColor());
            TableColumnModel cm = this.getColumnModel();
            n = cm.getColumnCount();
            int y = th;
            int x = 0;
            for (int i = 0; i < n; ++i) {
                TableColumn col = cm.getColumn(i);
                g.drawLine((x += col.getWidth()) - 1, y, x - 1, s.height);
            }
        }
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container gp;
        super.configureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            Border brdr;
            JViewport vprt;
            Color bg;
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            if (scrollPane.getCorner("UPPER_RIGHT_CORNER") == null) {
                scrollPane.setCorner("UPPER_RIGHT_CORNER", this.createCorner());
            }
            if ((bg = (vprt = scrollPane.getViewport()).getBackground()) == null || bg instanceof UIResource) {
                vprt.setBackground(this.getBackground());
            }
            vprt.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent ev) {
                    CTable.this.requestFocus();
                }

                @Override
                public void mouseReleased(MouseEvent ev) {
                    CTable.this.clearSelection();
                    TableCellEditor ed = CTable.this.getCellEditor();
                    if (ed != null) {
                        ed.cancelCellEditing();
                    }
                }
            });
            if (Platform.getLAF() == 502 && (brdr = scrollPane.getBorder()) instanceof UIResource) {
                scrollPane.setBackground(null);
                scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), brdr));
            }
        }
    }

    protected Component createCorner() {
        return new Corner();
    }

    private static class CTableCellRendererProxy
    implements TableCellRenderer {
        TableCellRenderer origRenderer;

        CTableCellRendererProxy(TableCellRenderer origRenderer) {
            this.origRenderer = origRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object val, boolean sel, boolean focus, int row, int col) {
            Component cmp = this.origRenderer.getTableCellRendererComponent(table, val, sel, focus, row, col);
            if (table instanceof CTable) {
                int alignment = ((CTable)table).getColumnAlignment(col);
                if (alignment == -1) {
                    alignment = val instanceof Number ? 4 : (val instanceof Icon ? 0 : 2);
                }
                if (cmp instanceof JLabel) {
                    ((JLabel)cmp).setHorizontalAlignment(alignment);
                } else if (cmp instanceof AbstractButton) {
                    ((AbstractButton)cmp).setHorizontalAlignment(alignment);
                }
            }
            return cmp;
        }

        public String toString() {
            return super.toString() + " orig=" + this.origRenderer;
        }
    }

    private class Corner
    extends JComponent {
        public Corner() {
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
            this.setFont(UIManager.getFont("TableHeader.font"));
            if (Platform.getLAF() != 503 || Platform.getOS() != 405) {
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            }
        }
    }
}

