/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.swing;

import com.elluminate.platform.Platform;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.text.JTextComponent;

public class CTabbedPane
extends JTabbedPane {
    private ContainerListener containerListener;

    public CTabbedPane() {
        this.init();
    }

    public CTabbedPane(int tabPlacement) {
        super(tabPlacement);
        this.init();
    }

    public CTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.init();
    }

    private void init() {
        this.containerListener = new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                CTabbedPane.this.prepareComponent(e.getContainer());
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                CTabbedPane.this.releaseComponent(e.getContainer());
            }
        };
        if (Platform.getLAF() == 502 && Platform.checkOSVersion((int)202, (String)"10.3+") && Platform.checkJavaVersion((String)"1.4+")) {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(-3, -6, -8, -6), this.getBorder()));
        }
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        if (component != null) {
            this.prepareComponent(component);
        }
        super.insertTab(title, icon, component, tip, index);
    }

    @Override
    public void removeTabAt(int index) {
        try {
            this.releaseComponent(this.getComponentAt(index));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.removeTabAt(index);
    }

    @Override
    public void setComponentAt(int index, Component component) {
        this.prepareComponent(component);
        super.setComponentAt(index, component);
    }

    private void prepareComponent(Component component) {
        if (component instanceof JTextComponent || component instanceof JScrollPane) {
            return;
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(false);
        }
        if (component instanceof Container) {
            ((Container)component).addContainerListener(this.containerListener);
            Component[] comps = ((Container)component).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.prepareComponent(comps[i]);
            }
        }
    }

    private void releaseComponent(Component component) {
        if (component instanceof Container) {
            ((Container)component).removeContainerListener(this.containerListener);
        }
    }
}

