/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.swing;

import com.elluminate.gui.ModalDialog;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class CDialog
extends JDialog {
    private static final String WINDOW_MODIFIED_PROP = "windowModified";
    private static Window remapFrom = null;
    private static Window remapTo = null;
    private boolean hasBeenShown = false;
    private CDialog remappedClone = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setParentRemapping(Window from, Window to) {
        Class<ModalDialog> clazz = ModalDialog.class;
        synchronized (ModalDialog.class) {
            remapFrom = from;
            remapTo = to;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public CDialog() {
    }

    public CDialog(Frame owner) {
        super(owner);
    }

    public CDialog(Frame owner, boolean modal) {
        super(owner, modal);
    }

    public CDialog(Frame owner, String title) {
        super(owner, title);
    }

    public CDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public CDialog(Dialog owner) {
        super(owner);
    }

    public CDialog(Dialog owner, boolean modal) {
        super(owner, modal);
    }

    public CDialog(Dialog owner, String title) {
        super(owner, title);
    }

    public CDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public CDialog createReparentedClone(Container parent) {
        return this.createReparentedClone(parent, true);
    }

    private CDialog createReparentedClone(Container parent, boolean stripOriginal) {
        int ix;
        CDialog clone = null;
        if (parent == null) {
            clone = new CDialog();
            clone.setModal(this.isModal());
        } else if (parent instanceof Frame) {
            clone = new CDialog((Frame)parent, this.isModal());
        } else if (parent instanceof Dialog) {
            clone = new CDialog((Dialog)parent, this.isModal());
        } else {
            throw new IllegalArgumentException("Parent of clone must be Frame or Dialog, not " + parent.getClass().getName());
        }
        Component focalPoint = this.getFocusOwner();
        WindowListener[] winListeners = this.getWindowListeners();
        WindowFocusListener[] winFocusListeners = this.getWindowFocusListeners();
        WindowStateListener[] winStateListeners = this.getWindowStateListeners();
        ContainerListener[] contListeners = this.getContainerListeners();
        ComponentListener[] compListeners = this.getComponentListeners();
        if (stripOriginal) {
            int ix2;
            for (ix2 = 0; ix2 < winListeners.length; ++ix2) {
                this.removeWindowListener(winListeners[ix2]);
            }
            for (ix2 = 0; ix2 < winFocusListeners.length; ++ix2) {
                this.removeWindowFocusListener(winFocusListeners[ix2]);
            }
            for (ix2 = 0; ix2 < winStateListeners.length; ++ix2) {
                this.removeWindowStateListener(winStateListeners[ix2]);
            }
            for (ix2 = 0; ix2 < contListeners.length; ++ix2) {
                this.removeContainerListener(contListeners[ix2]);
            }
            for (ix2 = 0; ix2 < compListeners.length; ++ix2) {
                this.removeComponentListener(compListeners[ix2]);
            }
        }
        clone.setDefaultCloseOperation(this.getDefaultCloseOperation());
        clone.setResizable(this.isResizable());
        clone.setTitle(this.getTitle());
        clone.setUndecorated(this.isUndecorated());
        clone.setFocusableWindowState(this.getFocusableWindowState());
        clone.setBackground(this.getBackground());
        clone.setBounds(this.getBounds());
        clone.setEnabled(this.isEnabled());
        clone.setFocusable(this.isFocusable());
        clone.setForeground(this.getForeground());
        clone.setName(this.getName());
        if (stripOriginal) {
            this.setTitle(this.getClass().getName() + " # " + this.hashCode());
        }
        if (this.isVisible()) {
            clone.setVisible(true);
        }
        JButton dftBtn = this.getRootPane().getDefaultButton();
        this.getRootPane().setDefaultButton(null);
        Container content = this.getContentPane();
        this.setContentPane(new DummyPanel());
        clone.setContentPane(content);
        if (dftBtn != null) {
            clone.getRootPane().setDefaultButton(dftBtn);
        }
        clone.setRootPaneCheckingEnabled(this.isRootPaneCheckingEnabled());
        if (clone.isVisible() && focalPoint != null) {
            focalPoint.requestFocusInWindow();
        }
        for (ix = 0; ix < winListeners.length; ++ix) {
            clone.removeWindowListener(winListeners[ix]);
            clone.addWindowListener(winListeners[ix]);
        }
        for (ix = 0; ix < winFocusListeners.length; ++ix) {
            clone.removeWindowFocusListener(winFocusListeners[ix]);
            clone.addWindowFocusListener(winFocusListeners[ix]);
        }
        for (ix = 0; ix < winStateListeners.length; ++ix) {
            clone.removeWindowStateListener(winStateListeners[ix]);
            clone.addWindowStateListener(winStateListeners[ix]);
        }
        for (ix = 0; ix < contListeners.length; ++ix) {
            clone.removeContainerListener(contListeners[ix]);
            clone.addContainerListener(contListeners[ix]);
        }
        for (ix = 0; ix < compListeners.length; ++ix) {
            clone.removeComponentListener(compListeners[ix]);
            clone.addComponentListener(compListeners[ix]);
        }
        return clone;
    }

    @Override
    public void setLocationRelativeTo(Component parent) {
        ModalDialog.positionWindow(this, parent);
    }

    protected Frame getParentFrame() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Frame)) continue;
            return (Frame)parent;
        }
        return null;
    }

    @Override
    public boolean isShowing() {
        Frame frame = this.getParentFrame();
        if (frame != null && (frame.getExtendedState() & 1) != 0) {
            return false;
        }
        return super.isShowing();
    }

    @Override
    public void show() {
        Window realOwner;
        if (!this.hasBeenShown) {
            this.hasBeenShown = true;
        }
        if (this.isVisible()) {
            this.toFront();
            return;
        }
        final Frame frame = this.getParentFrame();
        if (frame != null && (frame.getExtendedState() & 1) != 0) {
            try {
                SwingRunnerSupport.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        frame.setExtendedState(frame.getExtendedState() & 0xFFFFFFFE);
                    }
                });
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
        }
        if ((realOwner = this.getOwner()) != null && realOwner == remapFrom && remapTo != null) {
            if (this.remappedClone != null) {
                throw new RuntimeException("Already have a remapped clone!");
            }
            this.remappedClone = this.createReparentedClone(remapTo, false);
            this.remappedClone.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent ev) {
                    final CDialog clone = (CDialog)ev.getComponent();
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){
                        long t0 = 0L;

                        @Override
                        public void run() {
                            if (this.t0 == 0L) {
                                this.t0 = System.currentTimeMillis();
                            }
                            if (clone.isVisible()) {
                                if (System.currentTimeMillis() - this.t0 < 2000L) {
                                    SwingRunnerSupport.invokeLater((Runnable)this);
                                    return;
                                }
                                clone.setVisible(false);
                            }
                            JButton dftBtn = clone.getRootPane().getDefaultButton();
                            clone.getRootPane().setDefaultButton(null);
                            Container content = clone.getContentPane();
                            clone.setContentPane(new DummyPanel());
                            if (CDialog.this.remappedClone == clone) {
                                CDialog.this.remappedClone = null;
                            }
                            if (CDialog.this.getContentPane() instanceof DummyPanel && !(content instanceof DummyPanel)) {
                                CDialog.this.setContentPane(content);
                                CDialog.this.getRootPane().setDefaultButton(dftBtn);
                            }
                        }
                    });
                }
            });
            this.remappedClone.setVisible(true);
            return;
        }
        super.show();
    }

    @Override
    public void hide() {
        CDialog clone = this.remappedClone;
        if (clone != null) {
            clone.setVisible(false);
            return;
        }
        super.hide();
    }

    @Override
    public boolean isVisible() {
        CDialog clone = this.remappedClone;
        if (clone != null) {
            return clone.isVisible();
        }
        return super.isVisible();
    }

    @Override
    public void setDefaultCloseOperation(int operation) {
        if (operation != 0 && operation != 1 && operation != 2) {
            throw new IllegalArgumentException("defaultCloseOperation must be one of: DO_NOTHING_ON_CLOSE, HIDE_ON_CLOSE or DISPOSE_ON_CLOSE");
        }
        super.setDefaultCloseOperation(operation);
    }

    public void setModified(boolean modified) {
        this.getRootPane().putClientProperty(WINDOW_MODIFIED_PROP, modified ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isModified() {
        Object val = this.getRootPane().getClientProperty(WINDOW_MODIFIED_PROP);
        return val instanceof Boolean ? (Boolean)val : false;
    }

    private class DummyPanel
    extends JPanel {
    }
}

