/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.swing;

import com.elluminate.gui.Mnemonic;
import com.elluminate.platform.Platform;
import com.sun.java.swing.plaf.windows.WindowsCheckBoxMenuItemUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class CCheckBoxMenuItem
extends JCheckBoxMenuItem {
    public CCheckBoxMenuItem() {
    }

    public CCheckBoxMenuItem(Icon icon) {
        super(icon);
    }

    public CCheckBoxMenuItem(String text) {
        super(Mnemonic.getText(text));
        Mnemonic.setMnemonic(this, text);
    }

    public CCheckBoxMenuItem(String text, Icon icon) {
        super(Mnemonic.getText(text), icon);
        Mnemonic.setMnemonic(this, text);
    }

    public CCheckBoxMenuItem(String text, boolean b) {
        super(Mnemonic.getText(text), b);
        Mnemonic.setMnemonic(this, text);
    }

    public CCheckBoxMenuItem(String text, Icon icon, boolean b) {
        super(Mnemonic.getText(text), icon, b);
        Mnemonic.setMnemonic(this, text);
    }

    @Override
    public void setText(String text) {
        super.setText(Mnemonic.getText(text));
        Mnemonic.setMnemonic(this, text);
    }

    @Override
    public void setMnemonic(int mnemonic) {
        if (Platform.getPlatform() != 2) {
            super.setMnemonic(mnemonic);
        }
    }

    @Override
    public void setMnemonic(char mnemonic) {
        int vk = mnemonic;
        if (vk >= 97 && vk <= 122) {
            vk -= 32;
        }
        this.setMnemonic(vk);
    }

    static {
        if (Platform.getPlatform() == 1 && Platform.getVersion() < 6) {
            UIManager.put("CheckBoxMenuItemUI", WindowsCCheckboxMenuItemUI.class.getName());
        }
    }

    public static class WindowsCCheckboxMenuItemUI
    extends WindowsCheckBoxMenuItemUI {
        public static ComponentUI createUI(JComponent component) {
            return new WindowsCCheckboxMenuItemUI();
        }

        protected void installDefaults() {
            super.installDefaults();
            if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
                this.checkIcon = new CCheckBoxMenuItemIcon();
            }
        }

        private class CCheckBoxMenuItemIcon
        implements Icon,
        UIResource,
        Serializable {
            private CCheckBoxMenuItemIcon() {
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                AbstractButton b = (AbstractButton)c;
                ButtonModel model = b.getModel();
                Color origColor = g.getColor();
                if (!model.isEnabled()) {
                    g.setColor(UIManager.getColor("Button.disabledForeground"));
                }
                if (model.isSelected()) {
                    g.drawLine(x + 7, y + 1, x + 7, y + 3);
                    g.drawLine(x + 6, y + 2, x + 6, y + 4);
                    g.drawLine(x + 5, y + 3, x + 5, y + 5);
                    g.drawLine(x + 4, y + 4, x + 4, y + 6);
                    g.drawLine(x + 3, y + 5, x + 3, y + 7);
                    g.drawLine(x + 2, y + 4, x + 2, y + 6);
                    g.drawLine(x + 1, y + 3, x + 1, y + 5);
                }
                g.setColor(origColor);
            }

            @Override
            public int getIconWidth() {
                return 9;
            }

            @Override
            public int getIconHeight() {
                return 9;
            }
        }
    }
}

