/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.print;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.View;

public class DocumentPrintable
implements Printable {
    private JEditorPane editorPane = new JEditorPane();
    private boolean scaleToFit = false;
    private volatile int currentPage = -1;
    private volatile int top = 0;
    private volatile int bottom = 0;

    public DocumentPrintable(Document document, String contentType) {
        this.editorPane.setContentType(contentType);
        this.editorPane.setDocument(document);
    }

    public void setScaleToFit(boolean scaleToFit) {
        this.scaleToFit = scaleToFit;
    }

    public boolean isScaleToFit() {
        return this.scaleToFit;
    }

    public void reset() {
        this.currentPage = -1;
        this.top = 0;
        this.bottom = 0;
    }

    protected void setPageBounds(int pageIndex, Rectangle b) {
        this.currentPage = pageIndex;
        this.top = b.y;
        this.bottom = b.height;
    }

    protected int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        int pageX = (int)pageFormat.getImageableX();
        int pageY = (int)pageFormat.getImageableY();
        int pageWidth = (int)pageFormat.getImageableWidth();
        int pageHeight = (int)pageFormat.getImageableHeight();
        int wrapWidth = pageWidth;
        Graphics2D g2 = (Graphics2D)graphics;
        double scale = 1.0;
        int minWidth = (int)this.editorPane.getMinimumSize().getWidth();
        if (this.scaleToFit && minWidth > pageWidth) {
            wrapWidth = minWidth;
            scale = (double)pageWidth / (double)minWidth;
            g2.scale(scale, scale);
        }
        this.editorPane.setSize(wrapWidth, Integer.MAX_VALUE);
        this.editorPane.validate();
        g2.setClip((int)((double)pageX / scale), (int)((double)pageY / scale), (int)((double)pageWidth / scale), (int)((double)pageHeight / scale));
        g2.translate(g2.getClipBounds().getX(), g2.getClipBounds().getY());
        if (pageIndex > this.currentPage) {
            this.currentPage = pageIndex;
            this.top += this.bottom;
            this.bottom = (int)g2.getClipBounds().getHeight();
        }
        int prefHeight = (int)this.editorPane.getPreferredSize().getHeight();
        Rectangle allocation = new Rectangle(0, -this.top, minWidth, prefHeight);
        View view = this.editorPane.getUI().getRootView(this.editorPane);
        if (this.printView(g2, view, allocation)) {
            return 0;
        }
        this.reset();
        return 1;
    }

    protected JEditorPane getEditorPane() {
        return this.editorPane;
    }

    protected boolean printView(Graphics2D g2, View view, Shape allocation) {
        boolean pageExists = false;
        if (view.getViewCount() > 0 && !view.getElement().getName().equalsIgnoreCase("td")) {
            for (int i = 0; i < view.getViewCount(); ++i) {
                View childView;
                Shape childAllocation = view.getChildAllocation(i, allocation);
                if (childAllocation == null || !this.printView(g2, childView = view.getView(i), childAllocation)) continue;
                pageExists = true;
            }
        } else {
            Rectangle clip = g2.getClipBounds();
            if (allocation.getBounds().getMaxY() >= clip.getY()) {
                pageExists = true;
                if (allocation.getBounds().getHeight() > clip.getHeight() && allocation.intersects(clip)) {
                    view.paint(g2, allocation);
                } else if (allocation.getBounds().getY() >= clip.getY()) {
                    if (allocation.getBounds().getMaxY() <= clip.getMaxY()) {
                        view.paint(g2, allocation);
                    } else if (allocation.getBounds().getY() < (double)this.bottom) {
                        this.bottom = (int)allocation.getBounds().getY();
                    }
                }
            }
        }
        return pageExists;
    }
}

