/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.net;

import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.net.StringsProperties;
import com.elluminate.net.CertPrincipals;
import com.elluminate.net.SSLTargetQuery;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Component;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;

public class SSLTargetQueryDlg
implements SSLTargetQuery {
    private static I18n i18n = I18n.create(SSLTargetQueryDlg.class);
    private Component parent = null;
    private Map<History, Boolean> history = new HashMap<History, Boolean>();

    public SSLTargetQueryDlg() {
        this(null);
    }

    public SSLTargetQueryDlg(Component parent) {
        this.parent = parent;
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowConnection(String targetName, InetAddress targetAddr, String certNames, CertPrincipals[] certChain) {
        History h = new History(targetName, targetAddr, certNames, certChain);
        int result = 2;
        String query = null;
        Map<History, Boolean> map = this.history;
        synchronized (map) {
            if (this.history.containsKey(h)) {
                return this.history.get(h);
            }
            query = certNames.equals("") ? i18n.getString((PropertiesEnum)StringsProperties.SSLTARGETQUERYDLG_NOCERTNAME, new Object[]{targetName, certChain[0].subject.getName(), certChain[0].issuer.getName()}) : i18n.getString((PropertiesEnum)StringsProperties.SSLTARGETQUERYDLG_TARGETMISMATCH, new Object[]{targetName, certNames, certChain[0].subject.getName(), certChain[0].issuer.getName()});
            result = ModalDialog.showConfirmDialog(this.parent, query, i18n.getString((PropertiesEnum)StringsProperties.SSLTARGETQUERYDLG_TITLE), 2, 2);
            boolean accepted = result == 0;
            this.history.put(h, accepted);
            return accepted;
        }
    }

    class History {
        String target;
        InetAddress addr;
        String name;
        CertPrincipals[] chain;

        public History(String t, InetAddress a, String n, CertPrincipals[] c) {
            this.target = t;
            this.addr = a;
            this.name = n;
            this.chain = c;
        }

        public boolean equals(Object o) {
            if (!(o instanceof History)) {
                return false;
            }
            History other = (History)o;
            if (!this.target.equals(other.target)) {
                return false;
            }
            if (!this.addr.equals(other.addr)) {
                return false;
            }
            if (!this.name.equals(other.name)) {
                return false;
            }
            if (this.chain.length != other.chain.length) {
                return false;
            }
            for (int i = 0; i < this.chain.length; ++i) {
                if (this.chain[i].equals((Object)other.chain[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int code = this.target.hashCode();
            code ^= this.addr.hashCode();
            code ^= this.name.hashCode();
            for (int i = 0; i < this.chain.length; ++i) {
                code ^= this.chain[i].hashCode();
            }
            return code;
        }
    }
}

