/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.macosx;

import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.HotKey;
import com.elluminate.gui.StringsProperties;
import com.elluminate.gui.macosx.CarbonHotKey;
import com.elluminate.platform.Platform;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JFileChooser;

public class MacGuiSupport
extends GuiUtils.PlatformGuiSupport {
    private boolean HAS_GLYPHS = Platform.checkOSVersion((int)202, (String)"10.5+");
    private JFileChooser fChooser = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Icon getFileIcon(File f) {
        if (f == null) {
            return null;
        }
        if (!f.exists()) {
            return null;
        }
        Object result = null;
        try {
            MacGuiSupport macGuiSupport = this;
            synchronized (macGuiSupport) {
                if (this.fChooser == null) {
                    this.fChooser = new JFileChooser();
                }
                return this.fChooser.getIcon(f);
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"getFileIcon", (Throwable)t, (boolean)true, (String)f.getAbsolutePath());
            return super.getFileIcon(f);
        }
    }

    @Override
    public boolean checkKeyCode(int keyCode) {
        switch (keyCode) {
            case 12: {
                return true;
            }
            case 61440: {
                return true;
            }
            case 61441: {
                return true;
            }
            case 61442: {
                return true;
            }
            case 156: {
                return true;
            }
            case 157: {
                return true;
            }
        }
        return super.checkKeyCode(keyCode);
    }

    @Override
    public String getKeystrokeText(int keyCode, int keyMod) {
        return this.getKeyModifierString(keyMod) + this.getKeyName(keyCode);
    }

    private String getKeyModifierString(int javaKeyMod) {
        if (javaKeyMod == 0) {
            return "";
        }
        if (this.HAS_GLYPHS) {
            return KeyEvent.getKeyModifiersText(javaKeyMod);
        }
        StringBuilder result = new StringBuilder();
        if ((javaKeyMod & 4) != 0) {
            result.append(this.i18n.getString((PropertiesEnum)StringsProperties.GUISUPPORT_MACMETAMODKEY));
        }
        if ((javaKeyMod & 2) != 0) {
            result.append(this.i18n.getString((PropertiesEnum)StringsProperties.GUISUPPORT_MACCTRLMODKEY));
        }
        if ((javaKeyMod & 8) != 0) {
            result.append(this.i18n.getString((PropertiesEnum)StringsProperties.GUISUPPORT_MACALTMODKEY));
        }
        if ((javaKeyMod & 1) != 0) {
            result.append(this.i18n.getString((PropertiesEnum)StringsProperties.GUISUPPORT_MACSHIFTMODKEY));
        }
        return result.toString();
    }

    @Override
    public String getKeyName(int keyCode) {
        try {
            return this.i18n.getStringLegacy("MacGuiSupport.macKeyName" + keyCode);
        }
        catch (Throwable throwable) {
            return super.getKeyName(keyCode);
        }
    }

    @Override
    public boolean hasHotKeys() {
        return CarbonHotKey.isLoadedOK();
    }

    @Override
    public HotKey createHotKey(int keyCode, int keyModifiers, Runnable action) {
        if (!CarbonHotKey.isLoadedOK()) {
            return null;
        }
        try {
            return new CarbonHotKey(keyCode, keyModifiers, action);
        }
        catch (Throwable t) {
            if (GUIDebug.HOT_KEYS.show()) {
                LogSupport.message((Object)this, (String)"createHotKey", (String)("Failed to create hot key " + keyCode + "/" + keyModifiers + ":\n" + t));
            }
            return null;
        }
    }

    public static int translateKeyCode(int javaKeyCode) {
        switch (javaKeyCode) {
            case 18: {
                return 58;
            }
            case 8: {
                return 51;
            }
            case 20: {
                return 57;
            }
            case 17: {
                return 59;
            }
            case 127: {
                return 117;
            }
            case 40: {
                return 125;
            }
            case 35: {
                return 119;
            }
            case 10: {
                return 36;
            }
            case 27: {
                return 53;
            }
            case 112: {
                return 122;
            }
            case 113: {
                return 120;
            }
            case 114: {
                return 99;
            }
            case 115: {
                return 118;
            }
            case 116: {
                return 96;
            }
            case 117: {
                return 97;
            }
            case 118: {
                return 98;
            }
            case 119: {
                return 100;
            }
            case 120: {
                return 101;
            }
            case 121: {
                return 109;
            }
            case 122: {
                return 103;
            }
            case 123: {
                return 111;
            }
            case 61440: {
                return 105;
            }
            case 61441: {
                return 107;
            }
            case 61442: {
                return 113;
            }
            case 61443: {
                return 106;
            }
            case 61444: {
                return 64;
            }
            case 61445: {
                return 79;
            }
            case 61446: {
                return 80;
            }
            case 61447: {
                return 90;
            }
            case 156: {
                return 114;
            }
            case 36: {
                return 115;
            }
            case 37: {
                return 123;
            }
            case 157: {
                return 55;
            }
            case 34: {
                return 121;
            }
            case 33: {
                return 116;
            }
            case 39: {
                return 124;
            }
            case 16: {
                return 56;
            }
            case 32: {
                return 49;
            }
            case 9: {
                return 48;
            }
            case 38: {
                return 126;
            }
            case 48: {
                return 29;
            }
            case 49: {
                return 18;
            }
            case 50: {
                return 19;
            }
            case 51: {
                return 20;
            }
            case 52: {
                return 21;
            }
            case 53: {
                return 23;
            }
            case 54: {
                return 22;
            }
            case 55: {
                return 26;
            }
            case 56: {
                return 28;
            }
            case 57: {
                return 25;
            }
            case 65: {
                return 0;
            }
            case 66: {
                return 11;
            }
            case 67: {
                return 8;
            }
            case 68: {
                return 2;
            }
            case 69: {
                return 14;
            }
            case 70: {
                return 3;
            }
            case 71: {
                return 5;
            }
            case 72: {
                return 4;
            }
            case 73: {
                return 34;
            }
            case 74: {
                return 38;
            }
            case 75: {
                return 40;
            }
            case 76: {
                return 37;
            }
            case 77: {
                return 46;
            }
            case 78: {
                return 45;
            }
            case 79: {
                return 31;
            }
            case 80: {
                return 35;
            }
            case 81: {
                return 12;
            }
            case 82: {
                return 15;
            }
            case 83: {
                return 1;
            }
            case 84: {
                return 17;
            }
            case 85: {
                return 32;
            }
            case 86: {
                return 9;
            }
            case 87: {
                return 13;
            }
            case 88: {
                return 7;
            }
            case 89: {
                return 16;
            }
            case 90: {
                return 6;
            }
            case 107: {
                return 69;
            }
            case 192: {
                return 50;
            }
            case 92: {
                return 42;
            }
            case 12: {
                return 71;
            }
            case 93: {
                return 30;
            }
            case 44: {
                return 43;
            }
            case 110: {
                return 65;
            }
            case 111: {
                return 75;
            }
            case 61: {
                return 24;
            }
            case 45: {
                return 27;
            }
            case 106: {
                return 67;
            }
            case 96: {
                return 82;
            }
            case 97: {
                return 83;
            }
            case 98: {
                return 84;
            }
            case 99: {
                return 85;
            }
            case 100: {
                return 86;
            }
            case 101: {
                return 87;
            }
            case 102: {
                return 88;
            }
            case 103: {
                return 89;
            }
            case 104: {
                return 91;
            }
            case 105: {
                return 92;
            }
            case 91: {
                return 33;
            }
            case 46: {
                return 47;
            }
            case 222: {
                return 39;
            }
            case 59: {
                return 41;
            }
            case 47: {
                return 44;
            }
            case 109: {
                return 78;
            }
            case 21: {
                return 104;
            }
        }
        return -1;
    }

    public static int translateModifier(int javaKeyMod) {
        int result = 0;
        if ((javaKeyMod & 4) != 0) {
            result |= 0x100;
        }
        if ((javaKeyMod & 1) != 0) {
            result |= 0x200;
        }
        if ((javaKeyMod & 8) != 0) {
            result |= 0x800;
        }
        if ((javaKeyMod & 2) != 0) {
            result |= 0x1000;
        }
        if (result == 0) {
            return -1;
        }
        return result;
    }
}

