/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.dnd;

import com.elluminate.platform.Platform;
import com.elluminate.util.image.ImageMimeUtilities;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class XJavaSerializedObjectDataFlavor
extends DataFlavor {
    private static final File DOWNLOAD_DIR = new File(Platform.getTempDir(), "ElluminateDragDir");

    public XJavaSerializedObjectDataFlavor() throws ClassNotFoundException {
        super("application/x-java-serialized-object;class=java.lang.String");
    }

    public List getTransferFiles(Transferable transferable) throws UnsupportedFlavorException, IOException {
        File f;
        boolean dereferenceURIs = false;
        try {
            DataFlavor mozImage = new DataFlavor("application/x-moz-nativeimage");
            dereferenceURIs = transferable.isDataFlavorSupported(mozImage);
        }
        catch (Throwable ignored) {
            dereferenceURIs = false;
        }
        ArrayList<Object> files = new ArrayList<Object>();
        String list = (String)transferable.getTransferData(this);
        StringTokenizer st = new StringTokenizer(list, "\r\n\u0000");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("#")) continue;
            try {
                if (new File(token).isFile()) {
                    files.add(token);
                    continue;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!dereferenceURIs) continue;
            try {
                URL url = new URL(token);
                URLConnection con = url.openConnection();
                String type = con.getContentType();
                if (ImageMimeUtilities.isValidImageMimeType((String)type)) {
                    File f2 = this.createTempFile(url);
                    this.copy(con, f2);
                    if (!f2.isFile() || f2.length() <= 0L) continue;
                    files.add(f2);
                    continue;
                }
                LogSupport.message((Object)this, (String)"getTransferFiles", (String)("Ignoring " + type + " URL: " + url));
            }
            catch (IOException iox) {}
        }
        if (files.isEmpty() && (f = new File(list)).isFile()) {
            files.add(f);
        }
        return files;
    }

    private File createTempFile(URL url) throws IOException {
        String ext = "." + FileSysUtils.getExtensionString((String)url.getPath());
        if (!DOWNLOAD_DIR.isDirectory()) {
            DOWNLOAD_DIR.mkdirs();
        }
        File f = File.createTempFile("eDrag_", ext, DOWNLOAD_DIR);
        try {
            f.deleteOnExit();
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(URLConnection con, File f) throws IOException {
        block22: {
            InputStream is = null;
            FileOutputStream fos = null;
            try {
                is = con.getInputStream();
                fos = new FileOutputStream(f);
                byte[] buf = new byte[4096];
                long ioTime = System.currentTimeMillis();
                while (true) {
                    int n;
                    if ((n = is.read(buf)) < 0) {
                        break block22;
                    }
                    if (n > 0) {
                        fos.write(buf, 0, n);
                        ioTime = System.currentTimeMillis();
                        continue;
                    }
                    if (System.currentTimeMillis() - ioTime > 5000L) break;
                }
                LogSupport.message((Object)this, (String)"copy", (String)("I/O stalled: " + con.getURL()));
            }
            catch (EOFException eofx) {
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable ignored) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable ignored) {}
                }
            }
        }
    }
}

