/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.component.OverlayPane;
import com.elluminate.util.LightweightTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class StatusBarPane
extends OverlayPane {
    public static final int MODE_SHOW = 0;
    public static final int MODE_HIDE = 1;
    public static final int MODE_AUTO = 2;
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_BOTTOM = 3;
    private static final long SHOW_DELAY = 250L;
    private static final long DFT_HIDE_DELAY = 1000L;
    private static final int DFT_THRESHOLD = 48;
    private static final int STATUS_HIDDEN = 0;
    private static final int STATUS_SHOWING = 1;
    private static final int STATUS_SHOWN = 2;
    private static final int STATUS_HIDING = 3;
    private static final long FRAME_INTERVAL = 50L;
    private static final int FRAME_COUNT = 5;
    private static final int INVALID_AXIS;
    private Tracker tracker = new Tracker();
    private JComponent content = null;
    private JComponent statusBar = null;
    private int align = 3;
    private int showMode = 2;
    private int threshold = 48;
    private long hideDelay = 1000L;

    public StatusBarPane(JComponent contentPane) {
        this(contentPane, new StatusBar(3), 3);
    }

    public StatusBarPane(JComponent contentPane, int alignment) {
        this(contentPane, new StatusBar(alignment), alignment);
    }

    public StatusBarPane(JComponent contentPane, JComponent statusBarPane) {
        this(contentPane, statusBarPane, 3);
    }

    public StatusBarPane(JComponent contentPane, JComponent statusBarPane, int alignment) {
        if (alignment != 0 && alignment != 1 && alignment != 2 && alignment != 3) {
            throw new RuntimeException("Invalid alignment: " + alignment);
        }
        this.align = alignment;
        this.setContentPane(contentPane);
        this.setStatusBarPane(statusBarPane);
        this.tracker.hook(this);
        this.setOverlayLayout(new StatusBarLayout());
    }

    public JComponent getContentPane() {
        return this.content;
    }

    public void setContentPane(JComponent contentPane) {
        if (this.content != null) {
            super.remove(this.content);
        }
        this.content = contentPane;
        if (this.content != null) {
            super.add((Component)this.content, -1);
        }
    }

    public JComponent getStatusBarPane() {
        return this.statusBar;
    }

    public void setStatusBarPane(JComponent statusBarPane) {
        if (this.statusBar != null) {
            super.remove(this.statusBar);
        }
        this.statusBar = statusBarPane;
        if (this.statusBar != null) {
            super.add((Component)this.statusBar, 0);
        }
        this.tracker.target = this.statusBar;
    }

    @Override
    public Component add(Component c) {
        this.add(c, null, -1);
        return c;
    }

    @Override
    public Component add(Component c, int pos) {
        this.add(c, null, pos);
        return c;
    }

    @Override
    public void add(Component c, Object o) {
        this.add(c, null, -1);
    }

    @Override
    public void add(Component c, Object o, int pos) {
        throw new RuntimeException("Unimplemented method 'add', use getContentPane().add().");
    }

    @Override
    public void remove(int idx) {
    }

    @Override
    public void remove(Component cmp) {
    }

    @Override
    public void removeAll() {
    }

    public int getShowMode() {
        return this.showMode;
    }

    public void setShowMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Invalid show mode: " + mode);
        }
        this.showMode = mode;
        if (this.showMode != 2) {
            this.tracker.cancelPending();
            if (this.statusBar != null) {
                this.statusBar.setVisible(this.showMode == 0);
            }
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public int getShowDistance() {
        return this.threshold;
    }

    public void setShowDistance(int dist) {
        this.threshold = dist;
    }

    public long getHideDelay() {
        return this.hideDelay;
    }

    public void setHideDelay(long millis) {
        this.hideDelay = millis;
    }

    static {
        int val = -1;
        for (int ix = 1; ix < 256; ++ix) {
            if (0 + ix == 1) continue;
            val = 0 + ix;
        }
        INVALID_AXIS = val;
    }

    public static class StatusBar
    extends JPanel {
        private int sep = 0;
        private int axis = StatusBarPane.access$400();
        private int alpha = 1;
        private int status = this.isVisible() ? 2 : 0;
        private volatile int depth = this.isVisible() ? 5 : 0;
        private LightweightTimer timer = new LightweightTimer(2, new Runnable(){

            @Override
            public void run() {
                StatusBar.this.animate();
            }
        });

        public StatusBar() {
            super(null);
            super.setLayout(new BoxLayout(this, 0));
            this.axis = 0;
        }

        public StatusBar(int alignment) {
            this(alignment, 0);
        }

        public StatusBar(int alignment, int separation) {
            super(null);
            if (alignment != 0 && alignment != 1 && alignment != 2 && alignment != 3) {
                throw new RuntimeException("Invalid alignment: " + alignment);
            }
            this.axis = alignment == 1 || alignment == 2 ? 1 : 0;
            this.sep = separation;
            super.setLayout(new BoxLayout(this, this.axis));
        }

        public StatusBar(LayoutManager layout) {
            super(layout);
        }

        @Override
        public void setLayout(LayoutManager laymgr) {
            super.setLayout(laymgr);
            this.axis = INVALID_AXIS;
            this.sep = 0;
        }

        @Override
        public Component add(Component cmp) {
            if (this.sep > 0 && !(cmp instanceof Box.Filler) && super.getComponentCount() > 0) {
                if (this.axis == 0) {
                    super.add(Box.createHorizontalStrut(this.sep));
                } else if (this.axis == 1) {
                    super.add(Box.createVerticalStrut(this.sep));
                }
            }
            return super.add(cmp);
        }

        public int getAlpha() {
            return this.alpha;
        }

        public void setAlpha(int a) {
            if (this.alpha == a) {
                return;
            }
            Color c = this.getBackground();
            this.alpha = a;
            super.setOpaque(this.alpha == 1);
            if (c != null) {
                Color bg = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
                super.setBackground(bg);
            }
        }

        @Override
        public void setOpaque(boolean opq) {
            this.setAlpha(opq ? 1 : 0);
        }

        @Override
        public void setBackground(Color c) {
            Color bg = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
            super.setBackground(bg);
        }

        @Override
        public void setVisible(boolean vis) {
            Container p = this.getParent();
            if (p == null || !p.isVisible()) {
                super.setVisible(vis);
                this.status = vis ? 2 : 0;
                return;
            }
            if (vis && (this.status == 2 || this.status == 1)) {
                return;
            }
            if (!(vis || this.status != 0 && this.status != 3)) {
                return;
            }
            this.status = vis ? 1 : 3;
            super.setVisible(true);
            this.timer.scheduleIn(50L);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!this.isOpaque() && this.alpha > 0) {
                Insets in = this.getInsets();
                int w = this.getWidth() - in.left - in.right;
                int h = this.getHeight() - in.top - in.bottom;
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(this.getBackground());
                g2.fillRect(in.left, in.top, w, h);
            }
        }

        private void animate() {
            if (this.status == 1) {
                ++this.depth;
            } else if (this.status == 3) {
                --this.depth;
            }
            if (this.depth >= 5) {
                this.depth = 5;
                this.status = 2;
            }
            if (this.depth <= 0) {
                this.depth = 0;
                this.status = 0;
                super.setVisible(false);
            }
            if (this.status == 1 || this.status == 3) {
                this.timer.scheduleIn(50L);
            }
            this.revalidate();
            this.repaint();
        }
    }

    private class StatusBarLayout
    implements LayoutManager {
        private StatusBarLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            Dimension result = new Dimension(0, 0);
            Component[] cmp = target.getComponents();
            for (int ix = 0; ix < cmp.length; ++ix) {
                Dimension dim = cmp[ix].getMinimumSize();
                if (dim.width > result.width) {
                    result.width = dim.width;
                }
                if (dim.height <= result.height) continue;
                result.height = dim.height;
            }
            return result;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension result = new Dimension(0, 0);
            Component[] cmp = parent.getComponents();
            for (int ix = 0; ix < cmp.length; ++ix) {
                Dimension dim = cmp[ix].getPreferredSize();
                if (dim.width > result.width) {
                    result.width = dim.width;
                }
                if (dim.height <= result.height) continue;
                result.height = dim.height;
            }
            Insets in = parent.getInsets();
            result.width += in.left + in.right;
            result.height += in.top + in.bottom;
            return result;
        }

        @Override
        public void layoutContainer(Container c) {
            int h;
            int w;
            int y;
            int x;
            if (StatusBarPane.this.content != null) {
                Dimension dim = c.getSize();
                Insets in = c.getInsets();
                StatusBarPane.this.content.setBounds(in.left, in.top, dim.width - in.left - in.right, dim.height - in.top - in.bottom);
            }
            if (StatusBarPane.this.statusBar == null) {
                return;
            }
            if (!StatusBarPane.this.statusBar.isVisible()) {
                return;
            }
            Container target = null;
            if (StatusBarPane.this.content == null) {
                target = c;
            } else if (StatusBarPane.this.content instanceof JScrollPane) {
                target = ((JScrollPane)StatusBarPane.this.content).getViewport();
            } else {
                Component[] cmp = StatusBarPane.this.content.getComponents();
                for (int ix = 0; ix < cmp.length; ++ix) {
                    if (!(cmp[ix] instanceof JScrollPane)) continue;
                    target = ((JScrollPane)cmp[ix]).getViewport();
                    break;
                }
            }
            if (target == null) {
                target = StatusBarPane.this.content;
            }
            if (target == null) {
                target = c;
            }
            Rectangle bounds = SwingUtilities.convertRectangle(target, target.getBounds(), c);
            Dimension pref = StatusBarPane.this.statusBar.getPreferredSize();
            Insets in = target.getInsets();
            bounds.x += in.left;
            bounds.y += in.top;
            bounds.width -= in.left + in.right;
            bounds.height -= in.top + in.bottom;
            if (bounds.width < 0) {
                bounds.width = 0;
            }
            if (bounds.height < 0) {
                bounds.height = 0;
            }
            if (pref.width < 0) {
                pref.width = 0;
            }
            if (pref.height < 0) {
                pref.height = 0;
            }
            int depth = -1;
            if (StatusBarPane.this.statusBar instanceof StatusBar) {
                depth = ((StatusBar)StatusBarPane.this.statusBar).depth;
                pref.width = (pref.width * depth + 2) / 5;
                pref.height = (pref.height * depth + 2) / 5;
            }
            switch (StatusBarPane.this.align) {
                case 0: {
                    x = bounds.x;
                    y = bounds.y;
                    w = bounds.width;
                    h = pref.height;
                    break;
                }
                case 1: {
                    x = bounds.x;
                    y = bounds.y;
                    w = pref.width;
                    h = bounds.height;
                    break;
                }
                case 2: {
                    x = bounds.x + bounds.width - pref.width;
                    y = bounds.y;
                    w = pref.width;
                    h = bounds.height;
                    break;
                }
                default: {
                    x = bounds.x;
                    y = bounds.y + bounds.height - pref.height;
                    w = bounds.width;
                    h = pref.height;
                }
            }
            if (w > bounds.width) {
                w = bounds.width;
            }
            if (w < 0) {
                w = 0;
            }
            if (h > bounds.height) {
                h = bounds.height;
            }
            if (h < 0) {
                h = 0;
            }
            if (x + w > bounds.x + bounds.width) {
                x = bounds.x + bounds.width - w;
            }
            if (x < bounds.x) {
                x = bounds.x;
            }
            if (y + h > bounds.y + bounds.height) {
                y = bounds.y + bounds.height - h;
            }
            if (y < bounds.y) {
                y = bounds.y;
            }
            StatusBarPane.this.statusBar.setBounds(x, y, w, h);
        }
    }

    protected class Tracker
    extends MouseAdapter
    implements MouseMotionListener,
    ContainerListener {
        private boolean pending = false;
        private boolean toValue = false;
        private JComponent target;
        private LightweightTimer timer = new LightweightTimer(2, new Runnable(){

            @Override
            public void run() {
                Tracker.this.executePending();
            }
        });

        protected Tracker() {
        }

        private void hook(Component cmp) {
            cmp.addMouseListener(this);
            cmp.addMouseMotionListener(this);
            if (cmp instanceof Container) {
                Container cnt = (Container)cmp;
                cnt.addContainerListener(this);
                Component[] children = cnt.getComponents();
                for (int ix = 0; ix < children.length; ++ix) {
                    this.hook(children[ix]);
                }
            }
        }

        private void unhook(Component cmp) {
            cmp.removeMouseListener(this);
            cmp.removeMouseMotionListener(this);
            if (cmp instanceof Container) {
                Container cnt = (Container)cmp;
                cnt.removeContainerListener(this);
                Component[] children = cnt.getComponents();
                for (int ix = 0; ix < children.length; ++ix) {
                    this.unhook(children[ix]);
                }
            }
        }

        @Override
        public void componentAdded(ContainerEvent ev) {
            Component c = ev.getChild();
            if (c != null) {
                this.hook(c);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent ev) {
            Component c = ev.getChild();
            if (c != null) {
                this.unhook(c);
            }
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            if (StatusBarPane.this.showMode != 2) {
                return;
            }
            this.checkPosition(ev.getComponent(), ev.getX(), ev.getY());
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            if (StatusBarPane.this.showMode != 2) {
                return;
            }
            if (this.isDrag(ev)) {
                this.queueVisibilityChange(false);
                return;
            }
            this.cancelPending();
            this.checkPosition(ev.getComponent(), ev.getX(), ev.getY());
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            if (StatusBarPane.this.showMode != 2) {
                return;
            }
            this.queueVisibilityChange(false);
        }

        private boolean isDrag(MouseEvent ev) {
            return (ev.getModifiersEx() & 0x400) != 0;
        }

        private void checkPosition(Component c, int x, int y) {
            Point p = SwingUtilities.convertPoint(c, x, y, this.target);
            boolean vis = false;
            int width = 0;
            int height = 0;
            if (this.target.isVisible()) {
                width = this.target.getWidth();
                height = this.target.getHeight();
                vis |= p.x >= 0 && p.x < width && p.y >= 0 && p.y < height;
            }
            switch (StatusBarPane.this.align) {
                case 1: 
                case 2: {
                    vis |= p.x < width + StatusBarPane.this.threshold && p.x >= -StatusBarPane.this.threshold;
                    break;
                }
                default: {
                    vis |= p.y < height + StatusBarPane.this.threshold && p.y >= -StatusBarPane.this.threshold;
                }
            }
            this.queueVisibilityChange(vis);
        }

        private void queueVisibilityChange(boolean vis) {
            if (this.pending && this.toValue == vis) {
                return;
            }
            this.timer.scheduleIn(vis ? 250L : StatusBarPane.this.hideDelay);
            this.toValue = vis;
            this.pending = true;
        }

        private void cancelPending() {
            this.pending = false;
            this.timer.cancel();
        }

        private void executePending() {
            if (!this.pending) {
                return;
            }
            this.pending = false;
            try {
                this.target.setVisible(this.toValue);
                Component root = SwingUtilities.getRoot(this.target);
                Rectangle r = SwingUtilities.convertRectangle(this.target, this.target.getBounds(), root);
                root.repaint(r.x, r.y, r.width, r.height);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

