/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.component.StringsProperties;
import com.elluminate.gui.event.PopupGestureHandler;
import com.elluminate.gui.swing.CLabel;
import com.elluminate.gui.swing.CPopupMenu;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;

public class SearchTextField
extends JTextField {
    private static final boolean HAS_MAC_CLIENT_PROPS = Platform.checkOSVersion((int)202, (String)"10.5+");
    private static final int PADDING = 3;
    private I18n i18n = I18n.create((Object)this);
    private boolean isEditing = false;
    private boolean textMarginsSet = false;
    private Insets origTextMargin = null;
    private Color bkgColor = Color.GRAY;
    private Icon icon = this.i18n.getIcon("SearchTextField.defaultIcon");
    private String bkgText = this.i18n.getString((PropertiesEnum)StringsProperties.SEARCHTEXTFIELD_BACKGROUNDTEXT);
    private JLabel label = new CLabel(this.icon);
    private JButton closeBtn = new JButton(this.i18n.getIcon("SearchTextField.searchCancelIcon"));
    private JButton historyBtn = new JButton(this.i18n.getIcon("SearchTextField.searchHistoryIcon"));
    private JPopupMenu historyMenu = new CPopupMenu();
    private CompoundBorder uberBorder = null;
    private Border textBorder = null;
    private Border marginBorder = null;
    private long typingDelayInterval = 500L;
    private Runnable timerAction;
    private LightweightTimer typingDelayTimer;
    private String prevText = null;
    private ArrayList listeners = null;
    private Object listenerLock = new Object();
    private int maxHistoryLen = 10;
    private int minHistoryStringLen = 3;
    private ArrayList history = new ArrayList(this.maxHistoryLen);
    private Action cancelSearch = null;
    private Action execSearch = null;
    private Action showHistory = null;

    public SearchTextField() {
        this.initialize();
    }

    public SearchTextField(int columns) {
        super(columns);
        this.initialize();
    }

    public SearchTextField(String text) {
        super(text);
        this.initialize();
    }

    public SearchTextField(String text, int columns) {
        super(text, columns);
        this.initialize();
    }

    public SearchTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.initialize();
    }

    private void initialize() {
        this.timerAction = new Runnable(){

            @Override
            public void run() {
                String text = SearchTextField.this.getText();
                SearchTextField.this.addToHistory(text);
                SearchTextField.this.fireTextChangeListeners();
            }
        };
        this.typingDelayTimer = new LightweightTimer(2, this.timerAction);
        this.showHistory = new AbstractAction("show-search-history"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (SearchTextField.this.historyMenu.isVisible()) {
                    return;
                }
                if (!SearchTextField.this.prepareHistoryMenu()) {
                    return;
                }
                Point pt = SearchTextField.this.getHistoryPopupLocation();
                SearchTextField.this.historyMenu.show(SearchTextField.this, pt.x, pt.y);
            }
        };
        this.execSearch = new AbstractAction("execute-search"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SearchTextField.this.timerAction.run();
            }
        };
        this.cancelSearch = new AbstractAction("cancel-search"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SearchTextField.this.setText("");
            }
        };
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent de) {
                SearchTextField.this.typingDelayTimer.scheduleIn(SearchTextField.this.typingDelayInterval);
                SearchTextField.this.closeBtn.setVisible(SearchTextField.this.hasText());
                SearchTextField.this.repaint();
            }

            @Override
            public void insertUpdate(DocumentEvent de) {
                SearchTextField.this.typingDelayTimer.scheduleIn(SearchTextField.this.typingDelayInterval);
                SearchTextField.this.closeBtn.setVisible(SearchTextField.this.hasText());
                SearchTextField.this.repaint();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                SearchTextField.this.typingDelayTimer.scheduleIn(SearchTextField.this.typingDelayInterval);
                SearchTextField.this.closeBtn.setVisible(SearchTextField.this.hasText());
                SearchTextField.this.repaint();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
                if (SearchTextField.this.typingDelayTimer.isScheduled()) {
                    SearchTextField.this.typingDelayTimer.scheduleIn(SearchTextField.this.typingDelayInterval);
                }
                SearchTextField.this.isEditing = true;
                SearchTextField.this.closeBtn.setVisible(true);
                SearchTextField.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent fe) {
                if (!fe.isTemporary()) {
                    SearchTextField.this.isEditing = false;
                    SearchTextField.this.closeBtn.setVisible(SearchTextField.this.hasText());
                }
                if (SearchTextField.this.typingDelayTimer.isScheduled()) {
                    SearchTextField.this.typingDelayTimer.cancel();
                    SearchTextField.this.timerAction.run();
                }
                SearchTextField.this.repaint();
            }
        });
        if (HAS_MAC_CLIENT_PROPS) {
            this.configureMac();
        } else {
            this.configure();
        }
        this.bindKeystroke(KeyStroke.getKeyStroke(10, 0), this.execSearch);
        this.bindKeystroke(KeyStroke.getKeyStroke(27, 0), this.cancelSearch);
        this.bindKeystroke(KeyStroke.getKeyStroke(3, 0), this.cancelSearch);
        this.bindKeystroke(KeyStroke.getKeyStroke(12, 0), this.cancelSearch);
        this.bindKeystroke(KeyStroke.getKeyStroke(40, 0), this.showHistory);
        this.bindKeystroke(KeyStroke.getKeyStroke(65488, 0), this.showHistory);
        this.bindKeystroke(KeyStroke.getKeyStroke(155, 0), this.showHistory);
        this.bindKeystroke(KeyStroke.getKeyStroke(34, 0), this.showHistory);
    }

    public void configure() {
        this.closeBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.SEARCHTEXTFIELD_SEARCHCANCELTIP));
        this.closeBtn.setBorderPainted(false);
        this.closeBtn.setContentAreaFilled(false);
        this.closeBtn.setMargin(new Insets(0, 0, 0, 0));
        this.closeBtn.setCursor(Cursor.getDefaultCursor());
        this.closeBtn.setFocusable(false);
        this.closeBtn.setVisible(false);
        this.historyBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.SEARCHTEXTFIELD_SEARCHHISTORYTIP));
        this.historyBtn.setBorderPainted(false);
        this.historyBtn.setContentAreaFilled(false);
        this.historyBtn.setMargin(new Insets(0, 2, 0, 1));
        this.historyBtn.setCursor(Cursor.getDefaultCursor());
        this.historyBtn.setFocusable(false);
        this.historyBtn.setEnabled(false);
        this.add(this.label);
        this.add(this.historyBtn);
        this.add(this.closeBtn);
        this.setupMargin();
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SearchTextField.this.setText("");
                SearchTextField.this.transferFocus();
            }
        });
        PopupGestureHandler popupHandler = new PopupGestureHandler(this.historyMenu, 1){

            @Override
            protected Point determineInitialPosition(MouseEvent me, Component c) {
                Point pt = SearchTextField.this.getHistoryPopupLocation();
                return SwingUtilities.convertPoint(SearchTextField.this, pt, c);
            }

            @Override
            protected boolean prepareToShow(MouseEvent me) {
                return SearchTextField.this.prepareHistoryMenu();
            }
        };
        this.label.addMouseListener(popupHandler);
        this.historyBtn.addMouseListener(popupHandler);
        this.addMouseListener(new PopupGestureHandler(this.historyMenu){

            @Override
            protected Point determineInitialPosition(MouseEvent me, Component c) {
                Point pt = SearchTextField.this.getHistoryPopupLocation();
                return SwingUtilities.convertPoint(SearchTextField.this, pt, c);
            }

            @Override
            protected boolean prepareToShow(MouseEvent me) {
                return SearchTextField.this.prepareHistoryMenu();
            }
        });
    }

    private void configureMac() {
        this.putClientProperty("JTextField.variant", "search");
        this.putClientProperty("JTextField.Search.FindPopup", this.historyMenu);
        this.putClientProperty("JTextField.Search.FindAction", this.execSearch);
        this.putClientProperty("JTextField.Search.CancelAction", this.cancelSearch);
        PopupMenuListener historyMenuListener = new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent ev) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent ev) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent ev) {
                SearchTextField.this.prepareHistoryMenu();
            }
        };
        this.historyMenu.addPopupMenuListener(historyMenuListener);
    }

    private void bindKeystroke(KeyStroke key, Action act) {
        String name = (String)act.getValue("Name");
        InputMap imap = this.getInputMap(1);
        ActionMap amap = this.getActionMap();
        imap.put(key, name);
        amap.put(name, act);
    }

    public long getTypingDelayInterval() {
        return this.typingDelayInterval;
    }

    public void setTypingDelayInterval(long millis) {
        this.typingDelayInterval = Math.max(100L, millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTextChangeListener(TextListener tl) {
        if (tl == null) {
            return;
        }
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<TextListener> doppleganger = null;
            if (this.listeners == null) {
                doppleganger = new ArrayList<TextListener>(1);
                doppleganger.add(tl);
                this.listeners = doppleganger;
            } else if (!this.listeners.contains(tl)) {
                doppleganger = new ArrayList(this.listeners.size() + 1);
                doppleganger.addAll(this.listeners);
                doppleganger.add(tl);
                this.listeners = doppleganger;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTextChangeListener(TextListener tl) {
        if (tl == null) {
            return;
        }
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.listeners != null && this.listeners.contains(tl)) {
                ArrayList doppleganger = new ArrayList(this.listeners.size());
                Iterator it = this.listeners.iterator();
                doppleganger.addAll(this.listeners);
                doppleganger.remove(tl);
                this.listeners = doppleganger;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTextChangeListeners() {
        String s = this.getText();
        if (s == this.prevText) {
            return;
        }
        if (s != null && this.prevText != null && s.equals(this.prevText)) {
            return;
        }
        this.prevText = s;
        Iterator it = null;
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.listeners == null) {
                return;
            }
            it = this.listeners.iterator();
        }
        TextEvent ev = null;
        while (it.hasNext()) {
            Object cur = it.next();
            try {
                TextListener tl = (TextListener)cur;
                if (ev == null) {
                    ev = new TextEvent(this, 900);
                }
                tl.textValueChanged(ev);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireTextChangeListeners", (Throwable)t, (boolean)true, (String)("Processing " + ev + " with " + cur));
            }
        }
    }

    public String getBackgroundText() {
        return this.bkgText;
    }

    public void setBackgroundText(String txt) {
        this.bkgText = txt;
        this.invalidate();
        this.repaint();
    }

    public Color getBackgroundTextColor() {
        return this.bkgColor;
    }

    public void setBackgroundTextColor(Color c) {
        this.bkgColor = c;
        this.repaint();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.label.setIcon(icon);
        this.label.setVisible(icon != null);
        this.invalidate();
        this.setupMargin();
        this.repaint();
    }

    public int getMaximumHistoryLength() {
        return this.maxHistoryLen;
    }

    public void setMaximumHistoryLength(int len) {
        boolean hadHistory = this.maxHistoryLen > 0;
        this.maxHistoryLen = Math.max(0, len);
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SearchTextField.this.historyBtn.setVisible(SearchTextField.this.maxHistoryLen > 0);
            }
        });
        if (HAS_MAC_CLIENT_PROPS) {
            if (this.maxHistoryLen > 0) {
                this.putClientProperty("JTextField.Search.FindPopup", this.historyMenu);
            } else {
                this.putClientProperty("JTextField.Search.FindPopup", null);
            }
        }
    }

    public int getMinimumHistoryStringLength() {
        return this.minHistoryStringLen;
    }

    public void setMinimumHistoryStringLength(int len) {
        this.minHistoryStringLen = len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHistory() {
        ArrayList arrayList = this.history;
        synchronized (arrayList) {
            return this.history.toArray(new String[this.history.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistory(String[] h) {
        if (h.length > this.maxHistoryLen) {
            this.setMaximumHistoryLength(h.length);
        }
        ArrayList arrayList = this.history;
        synchronized (arrayList) {
            this.history.clear();
            this.history.ensureCapacity(h.length);
            for (int ix = 0; ix < h.length; ++ix) {
                if (h[ix] == null) continue;
                this.history.add(h[ix]);
            }
        }
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SearchTextField.this.historyBtn.setVisible(SearchTextField.this.maxHistoryLen > 0);
                SearchTextField.this.historyBtn.setEnabled(SearchTextField.this.history.size() > 0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearHistory() {
        ArrayList arrayList = this.history;
        synchronized (arrayList) {
            this.history.clear();
        }
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SearchTextField.this.historyBtn.setVisible(SearchTextField.this.maxHistoryLen > 0);
                SearchTextField.this.historyBtn.setEnabled(SearchTextField.this.history.size() > 0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToHistory(String toAdd) {
        if (toAdd == null) {
            return;
        }
        if (this.maxHistoryLen <= 0) {
            return;
        }
        if (toAdd.length() < this.minHistoryStringLen) {
            return;
        }
        ArrayList arrayList = this.history;
        synchronized (arrayList) {
            for (int ix = 0; ix < this.history.size(); ++ix) {
                String s = (String)this.history.get(ix);
                if (!toAdd.startsWith(s)) continue;
                this.history.remove(ix);
                break;
            }
            while (this.history.size() > this.maxHistoryLen - 1) {
                this.history.remove(this.maxHistoryLen - 1);
            }
            this.history.add(0, toAdd);
        }
        this.historyBtn.setEnabled(true);
    }

    protected Point getHistoryPopupLocation() {
        int x = this.historyBtn.getX() + this.historyBtn.getWidth();
        int y = this.getHeight() - this.getInsets().bottom;
        return new Point(x, y);
    }

    protected boolean prepareHistoryMenu() {
        this.historyMenu.removeAll();
        if (this.maxHistoryLen < 1) {
            return false;
        }
        String[] itemList = this.getHistory();
        if (itemList == null || itemList.length == 0) {
            return false;
        }
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String s = ((JMenuItem)ev.getSource()).getText();
                SearchTextField.this.setText(s);
            }
        };
        for (int ix = 0; ix < itemList.length; ++ix) {
            JMenuItem item = this.historyMenu.add(itemList[ix]);
            item.addActionListener(l);
        }
        return true;
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        super.setText(text);
        this.addToHistory(text);
        this.closeBtn.setVisible(this.hasText());
        this.repaint();
        this.fireTextChangeListeners();
    }

    public boolean hasText() {
        String text = super.getText();
        return text != null && text.length() > 0;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension baseSize = super.getPreferredSize();
        Dimension closeSize = this.closeBtn.getPreferredSize();
        Dimension histSize = this.historyBtn.getPreferredSize();
        Dimension labelSize = this.label.getPreferredSize();
        int h = Math.max(baseSize.height, closeSize.height);
        h = Math.max(h, histSize.height);
        if (this.label.isVisible()) {
            h = Math.max(h, labelSize.height + insets.top + insets.bottom);
        }
        return new Dimension(baseSize.width, h);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        Insets insets = this.getInsets();
        Dimension dim = this.getSize();
        int width = dim.width - insets.left - insets.right;
        int height = dim.height - insets.top - insets.bottom;
        Dimension closeSize = this.closeBtn.getPreferredSize();
        Dimension histSize = this.historyBtn.getPreferredSize();
        int iconWidth = this.icon == null ? 0 : this.label.getPreferredSize().width;
        int iconHeight = this.icon == null ? 0 : this.label.getPreferredSize().height;
        int w = histSize.width;
        int h = Math.min(height, histSize.height);
        int x = insets.left - w - 2;
        int y = insets.top + Math.max(0, height - h) / 2;
        this.historyBtn.setBounds(x, y, w, h);
        w = iconWidth;
        h = Math.min(height, iconHeight);
        x = x - w - 3;
        y = insets.top + Math.max(0, height - h) / 2;
        this.label.setBounds(x, y, w, h);
        w = closeSize.width;
        h = Math.min(height, closeSize.height);
        x = dim.width - insets.right + 1;
        y = insets.top + Math.max(0, height - h) / 2;
        this.closeBtn.setBounds(x, y, w, h);
    }

    @Override
    public void setBorder(Border b) {
        if (this.uberBorder == null) {
            this.textBorder = b;
            super.setBorder(b);
            return;
        }
        this.textBorder = b == null ? BorderFactory.createEmptyBorder() : b;
        this.uberBorder = BorderFactory.createCompoundBorder(this.textBorder, this.marginBorder);
        super.setBorder(this.uberBorder);
    }

    @Override
    public Border getBorder() {
        if (this.textBorder != null) {
            return this.textBorder;
        }
        return super.getBorder();
    }

    private void setupMargin() {
        Dimension histSize = this.historyBtn.getPreferredSize();
        Dimension closeSize = this.closeBtn.getPreferredSize();
        int left = histSize.width + 3;
        int right = closeSize.width + 3;
        if (this.icon != null) {
            left += this.icon.getIconWidth() + 3;
        }
        this.marginBorder = BorderFactory.createEmptyBorder(0, left, 0, right);
        if (this.textBorder == null) {
            this.textBorder = super.getBorder();
        }
        if (this.textBorder == null) {
            this.textBorder = BorderFactory.createEmptyBorder();
        }
        this.uberBorder = BorderFactory.createCompoundBorder(this.textBorder, this.marginBorder);
        super.setBorder(this.uberBorder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isEditing && !this.hasText() && this.bkgText != null) {
            Graphics gc = null;
            try {
                Insets insets = this.getInsets();
                Dimension dim = this.getSize();
                Dimension histSize = this.historyBtn.getSize();
                int textHeight = dim.height - insets.bottom - insets.top;
                gc = g.create();
                gc.setFont(this.getFont());
                gc.setColor(this.bkgColor);
                FontMetrics fm = gc.getFontMetrics();
                int vPad = Math.max(0, textHeight - fm.getAscent() - fm.getDescent()) / 2;
                gc.drawString(this.bkgText, insets.left, insets.top + fm.getAscent() + vPad);
            }
            finally {
                if (gc != null) {
                    gc.dispose();
                }
            }
        }
    }
}

