/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.AbstractBorder;

public class RoundRectBorder
extends AbstractBorder {
    private Color colour;
    private Color fillColour;
    private boolean filled;
    private int thickness;
    private int diameter;
    private int inset;

    public RoundRectBorder(int diameter) {
        this(null, 0, diameter, true, false);
    }

    public RoundRectBorder(Color colour, int diameter) {
        this(colour, 1, diameter, true, false);
    }

    public RoundRectBorder(Color colour, int diameter, boolean filled) {
        this(colour, 1, diameter, filled, false);
    }

    public RoundRectBorder(Color colour, int thickness, int diameter) {
        this(colour, thickness, diameter, true, false);
    }

    public RoundRectBorder(Color colour, int thickness, int diameter, boolean filled) {
        this(colour, thickness, diameter, filled, false);
    }

    public RoundRectBorder(Color colour, int thickness, int diameter, boolean filled, boolean flush) {
        if (thickness < 0) {
            throw new IllegalArgumentException("Negative thickness not allowed: " + thickness);
        }
        if (diameter <= 0) {
            throw new IllegalArgumentException("Negative or zero diameter not allowed: " + diameter);
        }
        this.colour = colour;
        this.filled = filled;
        this.thickness = thickness;
        this.diameter = diameter;
        this.inset = thickness;
        if (!flush) {
            this.inset += (int)Math.round(Math.ceil((double)diameter * 0.15));
        }
    }

    public Color getColor() {
        return this.colour;
    }

    public void setColor(Color c) {
        this.colour = c;
    }

    public Color getFillColor() {
        return this.fillColour;
    }

    public void setFillColor(Color c) {
        this.fillColour = c;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean f) {
        this.filled = f;
    }

    public int getThickness() {
        return this.thickness;
    }

    public int getDiameter() {
        return this.diameter;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets ins) {
        ins.set(this.inset, this.inset, this.inset, this.inset);
        return ins;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.inset, this.inset, this.inset, this.inset);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Graphics2D g2 = null;
        try {
            g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.filled) {
                Color col;
                Color color = col = this.fillColour != null ? this.fillColour : c.getBackground();
                if (col != null) {
                    g2.setColor(col);
                    g2.fillRoundRect(x, y, w, h, this.diameter, this.diameter);
                }
            }
            if (this.colour != null && this.thickness > 0) {
                g2.setStroke(new BasicStroke((float)this.thickness + 0.5f));
                g2.setColor(this.colour);
                g2.drawRoundRect(x + this.thickness / 2, y + this.thickness / 2, w - this.thickness - 1, h - this.thickness - 1, this.diameter, this.diameter);
            }
        }
        finally {
            if (g2 != null) {
                g2.dispose();
            }
        }
    }
}

