/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.FontUtils;
import com.elluminate.gui.Mnemonic;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.InvalidPreferenceSettingException;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.component.StringsProperties;
import com.elluminate.gui.swing.CMenuItem;
import com.elluminate.gui.swing.CPopupMenu;
import com.elluminate.gui.swing.CTree;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

@Singleton
public class PreferencesDialog
extends EasyDialog {
    private static final int SCOPE_PANEL = 1;
    private static final int SCOPE_MODULE = 2;
    private static final int SCOPE_ALL = 3;
    private I18n i18n = I18n.create((Object)this);
    private CTree panelTree;
    private ContentPane content;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton okButton;
    private JToggleButton restoreButton;
    private CPopupMenu restoreMenu;
    private CMenuItem restorePanelItem;
    private CMenuItem restoreModuleItem;
    private CMenuItem restoreAllItem;
    private SortableTreeNode panelRootNode = new SortableTreeNode();
    private Comparator panelComparator;
    private PropertyChangeListener panelChangeListener;
    private Preferences preferences;
    private Preferences copiedPreferences;
    private HashMap<AbstractPreferencesPanel, Object> copiedStores = new HashMap();
    private boolean modified = false;
    private boolean shown = false;

    @Inject
    public PreferencesDialog(DialogParentProvider parentProvider, Preferences preferences) {
        super((Component)parentProvider.getDialogParent(), "");
        this.preferences = preferences;
        this.setTitle(this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_TITLE));
        this.setResizable(true);
        this.setSize(700, 500);
        JSplitPane split = new JSplitPane();
        split.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        split.setDividerSize(10);
        split.setContinuousLayout(true);
        split.setDividerLocation(200);
        this.setContent(split);
        this.panelTree = new CTree(this.panelRootNode);
        this.panelTree.setRootVisible(false);
        this.panelTree.setShowsRootHandles(true);
        this.panelTree.setRowHeight(18);
        this.panelTree.setCellRenderer(new TreeItemRenderer());
        this.panelTree.getSelectionModel().setSelectionMode(1);
        JScrollPane sp = new JScrollPane(this.panelTree, 22, 31);
        split.setLeftComponent(sp);
        this.content = new ContentPane(new BorderLayout());
        sp = new JScrollPane(this.content, 20, 30);
        Color c = UIManager.getColor("Panel.background");
        if (Platform.getOS() == 300) {
            c = new Color(c.getRed(), c.getGreen(), c.getBlue());
        }
        sp.getViewport().setBackground(c);
        split.setRightComponent(sp);
        this.panelTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PreferencesDialog.this.doListSelection();
            }
        });
        this.applyButton = new JButton(this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_APPLY));
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.doApplyButton();
            }
        });
        this.addAlternateActionButton(this.applyButton);
        this.cancelButton = new JButton(this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_CANCEL));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.doCancelButton();
            }
        });
        this.addCancelButton(this.cancelButton);
        this.okButton = new JButton(this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_OK));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.doOKButton();
            }
        });
        this.addActionButton(this.okButton, true);
        this.restoreButton = new JToggleButton(this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_RESTORE));
        this.restoreButton.setIcon(this.i18n.getIcon((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_REVERTICON));
        this.restoreButton.setHorizontalTextPosition(2);
        if (Platform.getLAF() == 502) {
            boolean leopard15 = Platform.checkJavaVersion((String)"1.5+") && Platform.checkOSVersion((int)202, (String)"10.5+");
            this.restoreButton.putClientProperty("JButton.buttonType", leopard15 ? "square" : "toolbar");
            Font f = UIManager.getFont("Button.font");
            this.restoreButton.setFont(FontUtils.setFontStyleAndSize(f, f.getStyle(), f.getSize()));
            Insets m = this.restoreButton.getMargin();
            this.restoreButton.setMargin(leopard15 ? new Insets(m.top + 2, m.left + 4, m.bottom + 2, m.right + 4) : new Insets(m.top, m.left + 4, m.bottom, m.right + 4));
        }
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.doRestoreButton();
            }
        });
        this.addPassiveComponent(this.restoreButton);
        this.panelChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (prop.equals("settingsModified")) {
                    PreferencesDialog.this.modified = PreferencesDialog.this.checkModified();
                    PreferencesDialog.this.enableButtons();
                }
            }
        };
        this.panelComparator = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                if (obj1 instanceof SortableTreeNode) {
                    Object val1 = ((SortableTreeNode)obj1).getUserObject();
                    Object val2 = ((SortableTreeNode)obj2).getUserObject();
                    if (val1 instanceof PreferencesPanelOwner && val2 instanceof PreferencesPanelOwner) {
                        String title2;
                        String title1 = ((PreferencesPanelOwner)val1).getTitle();
                        if (title1 == (title2 = ((PreferencesPanelOwner)val2).getTitle())) {
                            return 0;
                        }
                        if (title1 == null) {
                            return -1;
                        }
                        if (title2 == null) {
                            return 1;
                        }
                        return title1.compareTo(title2);
                    }
                    if (val1 instanceof AbstractPreferencesPanel && val2 instanceof AbstractPreferencesPanel) {
                        String title2;
                        String title1 = ((AbstractPreferencesPanel)val1).getTitle();
                        if (title1 == (title2 = ((AbstractPreferencesPanel)val2).getTitle())) {
                            return 0;
                        }
                        if (title1 == null) {
                            return -1;
                        }
                        if (title2 == null) {
                            return 1;
                        }
                        return title1.compareTo(title2);
                    }
                }
                throw new ClassCastException("Unknown class: " + obj1.getClass().getName());
            }
        };
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!PreferencesDialog.this.modified) {
                    PreferencesDialog.this.setVisible(false);
                } else {
                    int which = ModalDialog.showConfirmDialog(PreferencesDialog.this, PreferencesDialog.this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_CLOSECONFIRMATIONMESSAGE));
                    switch (which) {
                        case 1: {
                            PreferencesDialog.this.setVisible(false);
                            break;
                        }
                        case 0: {
                            try {
                                PreferencesDialog.this.applyChanges();
                                PreferencesDialog.this.setVisible(false);
                            }
                            catch (InvalidPreferenceSettingException ex) {
                                AbstractPreferencesPanel p = ex.getPanel();
                                ModalDialog.showMessageDialog(PreferencesDialog.this, PreferencesDialog.this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_INVALIDSETTINGMESSAGE, new Object[]{p.getTitle()}), PreferencesDialog.this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_INVALIDSETTINGTITLE), 0);
                            }
                            break;
                        }
                    }
                }
            }
        });
        this.enableButtons();
    }

    private void doListSelection() {
        Object obj;
        AbstractPreferencesPanel p = null;
        SortableTreeNode node = (SortableTreeNode)this.panelTree.getLastSelectedPathComponent();
        Object object = obj = node != null ? node.getUserObject() : null;
        if (obj instanceof PreferencesPanelOwner) {
            if (node.getChildCount() > 0) {
                node = (SortableTreeNode)node.getChildAt(0);
                p = (AbstractPreferencesPanel)node.getUserObject();
            }
        } else if (obj instanceof AbstractPreferencesPanel) {
            p = (AbstractPreferencesPanel)obj;
        }
        AbstractPreferencesPanel cp = null;
        if (this.content.getComponentCount() > 0) {
            cp = (AbstractPreferencesPanel)this.content.getComponent(0);
        }
        if (cp != null) {
            if (p == cp) {
                return;
            }
            try {
                this.applyPanel(cp, false);
            }
            catch (InvalidPreferenceSettingException ex) {
                ModalDialog.showMessageDialog(this, this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_INVALIDSETTINGMESSAGE, new Object[]{cp.getTitle()}), this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_INVALIDSETTINGTITLE), 0);
                this.showPanel(cp);
                return;
            }
            this.content.removeAll();
        }
        if (p != null) {
            boolean modified = p.isModified();
            this.populatePanel(p);
            p.setModified(modified);
            this.content.add((Component)p, "North");
        }
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PreferencesDialog.this.content.revalidate();
                PreferencesDialog.this.content.repaint();
            }
        });
    }

    private void doOKButton() {
        try {
            this.applyChanges();
            this.setVisible(false);
        }
        catch (InvalidPreferenceSettingException ex) {
            AbstractPreferencesPanel p = ex.getPanel();
            ModalDialog.showMessageDialog(this, this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_INVALIDSETTINGMESSAGE, new Object[]{p.getTitle()}), this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_INVALIDSETTINGTITLE), 0);
        }
    }

    private void doApplyButton() {
        try {
            this.applyChanges();
        }
        catch (InvalidPreferenceSettingException ex) {
            AbstractPreferencesPanel p = ex.getPanel();
            ModalDialog.showMessageDialog(this, this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_INVALIDSETTINGMESSAGE, new Object[]{p.getTitle()}), this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_INVALIDSETTINGTITLE), 0);
        }
    }

    private void doCancelButton() {
        this.setVisible(false);
    }

    private void doRestoreButton() {
        if (this.restoreMenu == null) {
            this.restoreMenu = new CPopupMenu();
            this.restoreMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    PreferencesDialog.this.restoreButton.setSelected(false);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    PreferencesDialog.this.restoreButton.setSelected(false);
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }
            });
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object src = e.getSource();
                    if (src == PreferencesDialog.this.restorePanelItem) {
                        PreferencesDialog.this.restoreSettings(1);
                    } else if (src == PreferencesDialog.this.restoreModuleItem) {
                        PreferencesDialog.this.restoreSettings(2);
                    } else if (src == PreferencesDialog.this.restoreAllItem) {
                        PreferencesDialog.this.restoreSettings(3);
                    }
                }
            };
            this.restorePanelItem = new CMenuItem();
            this.restorePanelItem.addActionListener(al);
            this.restoreModuleItem = new CMenuItem();
            this.restoreModuleItem.addActionListener(al);
            this.restoreAllItem = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_RESTOREALL));
            this.restoreAllItem.addActionListener(al);
        }
        this.restoreMenu.removeAll();
        Selection sel = this.getSelection();
        if (sel.panel != null) {
            this.restorePanelItem.setText(this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_RESTOREPANEL, new Object[]{sel.panel.getTitle()}));
            this.restoreMenu.add(this.restorePanelItem);
        }
        if (sel.owner != null) {
            this.restoreModuleItem.setText(this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_RESTOREMODULE, new Object[]{sel.owner.getTitle()}));
            this.restoreMenu.add(this.restoreModuleItem);
        }
        this.restoreMenu.add(this.restoreAllItem);
        this.restoreMenu.show(this.restoreButton, 0, this.restoreButton.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkModified() {
        SortableTreeNode sortableTreeNode = this.panelRootNode;
        synchronized (sortableTreeNode) {
            for (int i = 0; i < this.panelRootNode.getChildCount(); ++i) {
                SortableTreeNode modNode = (SortableTreeNode)this.panelRootNode.getChildAt(i);
                for (int j = 0; j < modNode.getChildCount(); ++j) {
                    SortableTreeNode panelNode = (SortableTreeNode)modNode.getChildAt(j);
                    AbstractPreferencesPanel p = (AbstractPreferencesPanel)panelNode.getUserObject();
                    if (!p.isModified()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private Selection getSelection() {
        Selection sel = new Selection();
        if (this.content.getComponentCount() > 0) {
            sel.panel = (AbstractPreferencesPanel)this.content.getComponent(0);
            sel.owner = sel.panel.getOwner();
        }
        return sel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPanel(AbstractPreferencesPanel panel) {
        DefaultTreeModel model = (DefaultTreeModel)this.panelTree.getModel();
        SortableTreeNode moduleNode = null;
        SortableTreeNode sortableTreeNode = this.panelRootNode;
        synchronized (sortableTreeNode) {
            PreferencesPanelOwner owner = panel.getOwner();
            for (int i = 0; i < this.panelRootNode.getChildCount(); ++i) {
                SortableTreeNode modNode = (SortableTreeNode)this.panelRootNode.getChildAt(i);
                PreferencesPanelOwner o = (PreferencesPanelOwner)modNode.getUserObject();
                if (o != owner) continue;
                moduleNode = modNode;
                break;
            }
            if (moduleNode == null) {
                moduleNode = new SortableTreeNode(owner);
                model.insertNodeInto(moduleNode, this.panelRootNode, this.panelRootNode.getChildCount());
                if (this.panelRootNode.getChildCount() == 1) {
                    this.panelTree.expandPath(new TreePath(this.panelRootNode.getPath()));
                }
            }
        }
        SortableTreeNode panelNode = new SortableTreeNode(panel);
        model.insertNodeInto(panelNode, moduleNode, moduleNode.getChildCount());
        panel.addPropertyChangeListener(this.panelChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePanel(AbstractPreferencesPanel panel) {
        SortableTreeNode sortableTreeNode = this.panelRootNode;
        synchronized (sortableTreeNode) {
            block3: for (int i = 0; i < this.panelRootNode.getChildCount(); ++i) {
                SortableTreeNode modNode = (SortableTreeNode)this.panelRootNode.getChildAt(i);
                for (int j = 0; j < modNode.getChildCount(); ++j) {
                    SortableTreeNode panelNode = (SortableTreeNode)modNode.getChildAt(j);
                    AbstractPreferencesPanel p = (AbstractPreferencesPanel)panelNode.getUserObject();
                    if (p != panel) continue;
                    this.copiedStores.remove(p);
                    p.removePropertyChangeListener(this.panelChangeListener);
                    this.content.remove(p);
                    DefaultTreeModel model = (DefaultTreeModel)this.panelTree.getModel();
                    model.removeNodeFromParent(panelNode);
                    if (modNode.getChildCount() != 0) continue block3;
                    model.removeNodeFromParent(modNode);
                    continue block3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPanel(AbstractPreferencesPanel panel) {
        if (!this.isVisible()) {
            this.prepareShow();
        }
        SortableTreeNode sortableTreeNode = this.panelRootNode;
        synchronized (sortableTreeNode) {
            block3: for (int i = 0; i < this.panelRootNode.getChildCount(); ++i) {
                SortableTreeNode modNode = (SortableTreeNode)this.panelRootNode.getChildAt(i);
                for (int j = 0; j < modNode.getChildCount(); ++j) {
                    SortableTreeNode panelNode = (SortableTreeNode)modNode.getChildAt(j);
                    AbstractPreferencesPanel p = (AbstractPreferencesPanel)panelNode.getUserObject();
                    if (p != panel) continue;
                    this.panelTree.setSelectionPath(new TreePath(panelNode.getPath()));
                    continue block3;
                }
            }
        }
    }

    private void populatePanel(AbstractPreferencesPanel panel) {
        if (panel.hasStore()) {
            Object copiedStore = this.copiedStores.get(panel);
            if (copiedStore == null && (copiedStore = panel.getStore(true)) != null) {
                this.copiedStores.put(panel, copiedStore);
            }
            if (copiedStore != null) {
                panel.populateSettings(copiedStore);
            }
        } else if (this.copiedPreferences != null) {
            panel.populateSettings(this.copiedPreferences);
        }
    }

    private void applyPanel(AbstractPreferencesPanel panel, boolean permanently) throws InvalidPreferenceSettingException {
        if (panel.hasStore()) {
            Object store = permanently ? panel.getStore(false) : this.copiedStores.get(panel);
            if (store != null) {
                panel.applySettings(store);
            }
            if (permanently) {
                panel.setStore(store);
            }
        } else if (this.copiedPreferences != null) {
            panel.applySettings(this.copiedPreferences);
        }
    }

    private void restorePanel(AbstractPreferencesPanel panel) {
        if (panel.hasStore()) {
            Object copiedStore = this.copiedStores.get(panel);
            if (copiedStore == null && (copiedStore = panel.getStore(true)) != null) {
                this.copiedStores.put(panel, copiedStore);
            }
            if (copiedStore != null) {
                panel.resetSettings(copiedStore);
            }
        } else if (this.copiedPreferences != null) {
            panel.resetSettings(this.copiedPreferences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyChanges() throws InvalidPreferenceSettingException {
        AbstractPreferencesPanel cp = null;
        if (this.content.getComponentCount() > 0) {
            cp = (AbstractPreferencesPanel)this.content.getComponent(0);
        }
        SortableTreeNode sortableTreeNode = this.panelRootNode;
        synchronized (sortableTreeNode) {
            for (int i = 0; i < this.panelRootNode.getChildCount(); ++i) {
                SortableTreeNode modNode = (SortableTreeNode)this.panelRootNode.getChildAt(i);
                for (int j = 0; j < modNode.getChildCount(); ++j) {
                    SortableTreeNode panelNode = (SortableTreeNode)modNode.getChildAt(j);
                    AbstractPreferencesPanel p = (AbstractPreferencesPanel)panelNode.getUserObject();
                    if (!p.isModified()) continue;
                    if (p.hasStore() || p == cp) {
                        this.applyPanel(p, true);
                    }
                    p.setModified(false);
                }
            }
        }
        this.preferences.setSettings(this.copiedPreferences);
    }

    private synchronized void restoreSettings(int scope) {
        Selection sel = this.getSelection();
        switch (scope) {
            case 3: {
                for (int i = 0; i < this.panelRootNode.getChildCount(); ++i) {
                    SortableTreeNode modNode = (SortableTreeNode)this.panelRootNode.getChildAt(i);
                    for (int j = 0; j < modNode.getChildCount(); ++j) {
                        SortableTreeNode panelNode = (SortableTreeNode)modNode.getChildAt(j);
                        AbstractPreferencesPanel p = (AbstractPreferencesPanel)panelNode.getUserObject();
                        this.restorePanel(p);
                        p.setModified(true);
                    }
                }
                break;
            }
            case 2: {
                SortableTreeNode modNode = null;
                SortableTreeNode node = (SortableTreeNode)this.panelTree.getLastSelectedPathComponent();
                Object obj = node.getUserObject();
                if (obj instanceof PreferencesPanelOwner) {
                    modNode = node;
                } else if (obj instanceof AbstractPreferencesPanel) {
                    modNode = (SortableTreeNode)node.getParent();
                }
                if (modNode == null) break;
                for (int i = 0; i < modNode.getChildCount(); ++i) {
                    SortableTreeNode panelNode = (SortableTreeNode)modNode.getChildAt(i);
                    AbstractPreferencesPanel p = (AbstractPreferencesPanel)panelNode.getUserObject();
                    this.restorePanel(p);
                    p.setModified(true);
                }
                break;
            }
            case 1: {
                if (sel.panel == null || sel.owner == null) break;
                this.restorePanel(sel.panel);
                sel.panel.setModified(true);
            }
        }
        if (sel.panel != null && sel.owner != null) {
            this.populatePanel(sel.panel);
        }
    }

    private void enableButtons() {
        this.okButton.setEnabled(this.modified);
        this.applyButton.setEnabled(this.modified);
        this.cancelButton.setText(this.modified ? this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_CANCEL) : this.i18n.getString((PropertiesEnum)StringsProperties.PREFERENCESDIALOG_CLOSE));
    }

    @Override
    public void show() {
        if (!this.isVisible()) {
            Object obj;
            this.prepareShow();
            this.copiedPreferences = new Preferences(this.preferences);
            AbstractPreferencesPanel p = null;
            SortableTreeNode node = (SortableTreeNode)this.panelTree.getLastSelectedPathComponent();
            Object object = obj = node != null ? node.getUserObject() : null;
            if (obj instanceof PreferencesPanelOwner) {
                if (node.getChildCount() > 0) {
                    node = (SortableTreeNode)node.getChildAt(0);
                    p = (AbstractPreferencesPanel)node.getUserObject();
                }
            } else if (obj instanceof AbstractPreferencesPanel) {
                p = (AbstractPreferencesPanel)obj;
            }
            if (p != null) {
                this.populatePanel(p);
                p.setModified(false);
            }
            for (int i = 0; i < this.panelRootNode.getChildCount(); ++i) {
                SortableTreeNode modNode = (SortableTreeNode)this.panelRootNode.getChildAt(i);
                for (int j = 0; j < modNode.getChildCount(); ++j) {
                    SortableTreeNode panelNode = (SortableTreeNode)modNode.getChildAt(j);
                    p = (AbstractPreferencesPanel)panelNode.getUserObject();
                    p.setModified(false);
                }
            }
            this.setInitialFocus(this.panelTree);
        }
        super.show();
    }

    private void prepareShow() {
        if (!this.shown) {
            this.shown = true;
            this.panelRootNode.sortChildren(this.panelComparator, true);
            ((DefaultTreeModel)this.panelTree.getModel()).reload();
            for (int i = 0; i < this.panelRootNode.getChildCount(); ++i) {
                TreeNode modNode = this.panelRootNode.getChildAt(i);
                TreePath modPath = new TreePath(((SortableTreeNode)modNode).getPath());
                this.panelTree.expandPath(modPath);
            }
        }
    }

    @Override
    public void hide() {
        super.hide();
        this.copiedPreferences = null;
        this.copiedStores.clear();
    }

    private static class ContentPane
    extends JPanel
    implements Scrollable {
        private Dimension preferredViewportSize;

        public ContentPane(LayoutManager l) {
            super(l);
        }

        public void setPreferredScrollableViewportSize(Dimension size) {
            this.preferredViewportSize = size;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.preferredViewportSize != null ? this.preferredViewportSize : this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 1) {
                return 16;
            }
            return 100;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 1) {
                int unit = this.getScrollableUnitIncrement(visibleRect, orientation, direction);
                return unit > 0 ? Math.max(unit, visibleRect.height / unit) * unit : visibleRect.height;
            }
            return visibleRect.width;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private static class Selection {
        public PreferencesPanelOwner owner;
        public AbstractPreferencesPanel panel;

        private Selection() {
        }
    }

    private static class SortableTreeNode
    extends DefaultMutableTreeNode {
        public SortableTreeNode() {
        }

        public SortableTreeNode(Object userObject) {
            super(userObject);
        }

        public void sortChildren(Comparator comparator, boolean recursive) {
            if (this.children == null) {
                return;
            }
            Collections.sort(this.children, comparator);
            if (recursive) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    TreeNode node = this.getChildAt(i);
                    if (!(node instanceof SortableTreeNode)) continue;
                    ((SortableTreeNode)node).sortChildren(comparator, recursive);
                }
            }
        }
    }

    private static class TreeItemRenderer
    extends DefaultTreeCellRenderer {
        private TreeItemRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focused) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, focused);
            SortableTreeNode node = (SortableTreeNode)value;
            Object obj = node.getUserObject();
            if (obj instanceof PreferencesPanelOwner) {
                PreferencesPanelOwner owner = (PreferencesPanelOwner)obj;
                this.setText(owner.getTitle());
                this.setIcon(owner.getIcon());
            } else if (obj instanceof AbstractPreferencesPanel) {
                AbstractPreferencesPanel p = (AbstractPreferencesPanel)obj;
                this.setText(p != null ? p.getTitle() : "<Unknown>");
                this.setIcon(null);
            }
            return this;
        }

        @Override
        public void setText(String text) {
            super.setText(Mnemonic.getText(text));
            Mnemonic.setMnemonic(this, text);
        }

        @Override
        public void setDisplayedMnemonic(int mnemonic) {
            if (Platform.getPlatform() != 2) {
                super.setDisplayedMnemonic(mnemonic);
            }
        }

        @Override
        public void setDisplayedMnemonic(char mnemonic) {
            int vk = mnemonic;
            if (vk >= 97 && vk <= 122) {
                vk -= 32;
            }
            this.setDisplayedMnemonic(vk);
        }
    }
}

