/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.extra.ExTRA;
import com.elluminate.gui.component.StringsProperties;
import com.elluminate.gui.swing.CDialog;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class EasyDialog
extends CDialog {
    public static final int CANCEL = 0;
    public static final int OK = 1;
    public static final int YES = 2;
    public static final int NO = 3;
    public static final int DONE = 4;
    private static final int MIN_BUTTON_WIDTH = 65;
    private I18n i18n = I18n.create((Object)this);
    private JPanel contentPanel;
    private JPanel bottomPanel;
    private JPanel passivePanel;
    private JPanel dismissPanel;
    private BorderLayout dialogLayout;
    private int componentSpace;
    private Insets insets;
    private Component owner;
    private JButton actionButton;
    private JButton cancelButton;
    private ArrayList alternateActionButtons = new ArrayList();
    private ArrayList passiveComponents = new ArrayList();
    private JButton defaultButton;
    private Component initialFocusComponent;
    private boolean canceled = false;
    private ActionListener cancelButtonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            EasyDialog.this.canceled = true;
            if (!EasyDialog.this.isModal()) {
                EasyDialog.this.performDefaultCloseOperation();
            }
        }
    };
    private PropertyChangeListener buttonTextListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Object src;
            if (e.getPropertyName().equals("text") && (src = e.getSource()) instanceof JButton) {
                EasyDialog.normalizeButtonWidth((JButton)src);
            }
        }
    };
    private boolean initialShowDone = false;
    private boolean initialFocusSet = false;
    private boolean placedManually = false;
    private boolean sizedManually = false;

    public EasyDialog(Component owner, String title) {
        this(owner, title, true);
    }

    public EasyDialog(Component owner, String title, boolean modal) {
        super(EasyDialog.getParentFrame(owner), title, modal);
        this.owner = owner;
        this.setResizable(false);
        JPanel c = (JPanel)this.getContentPane();
        this.dialogLayout = new BorderLayout(0, 0);
        c.setLayout(this.dialogLayout);
        this.contentPanel = new JPanel(new BorderLayout(0, 0));
        c.add((Component)this.contentPanel, "Center");
        this.bottomPanel = new JPanel(new BorderLayout(0, 0));
        c.add((Component)this.bottomPanel, "South");
        this.passivePanel = new JPanel(new GridBagLayout());
        this.bottomPanel.add((Component)this.passivePanel, "West");
        this.dismissPanel = new JPanel(new GridBagLayout());
        this.bottomPanel.add((Component)this.dismissPanel, "East");
        int laf = Platform.getLAF();
        this.setInsets(EasyDialog.getStandardInsets(laf));
        this.setPanelGap(EasyDialog.getStandardPanelGap(laf));
        this.setComponentSpace(EasyDialog.getStandardComponentSpace(laf));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                if (!EasyDialog.this.initialFocusSet && EasyDialog.this.initialFocusComponent != null) {
                    EasyDialog.this.initialFocusSet = true;
                    EasyDialog.this.initialFocusComponent.requestFocus();
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                EasyDialog.this.canceled = true;
            }
        });
        AbstractAction escAction = new AbstractAction("cancel-dialog"){

            @Override
            public void actionPerformed(ActionEvent e) {
                EasyDialog.this.canceled = true;
                if (EasyDialog.this.cancelButton != null) {
                    EasyDialog.this.cancelButton.doClick();
                } else {
                    EasyDialog.this.performDefaultCloseOperation();
                }
            }
        };
        this.setEscapeAction(escAction);
    }

    public void setEscapeAction(Action escAction) {
        KeyStroke escKey = KeyStroke.getKeyStroke(27, 0);
        String name = (String)escAction.getValue("Name");
        InputMap imap = this.getRootPane().getInputMap(1);
        ActionMap amap = this.getRootPane().getActionMap();
        imap.put(escKey, name);
        amap.put(name, escAction);
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    private void assignInsets() {
        int right = 0;
        int bottom = 0;
        int left = 0;
        int top = 0;
        if (this.insets != null) {
            top = this.insets.top;
            left = this.insets.left;
            bottom = this.insets.bottom;
            right = this.insets.right;
        }
        if (this.bottomPanel.isVisible()) {
            this.contentPanel.setBorder(BorderFactory.createEmptyBorder(top, left, 0, right));
            if (this.insets != null) {
                this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, left, bottom, right));
            } else {
                int gap = this.dialogLayout.getVgap();
                this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, gap, gap, gap));
            }
        } else {
            this.contentPanel.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
        }
    }

    public static Insets getStandardInsets() {
        return EasyDialog.getStandardInsets(Platform.getLAF());
    }

    protected static Insets getStandardInsets(int laf) {
        switch (laf) {
            case 502: {
                return new Insets(14, 20, 20, 20);
            }
            case 503: {
                return new Insets(14, 14, 14, 14);
            }
        }
        return new Insets(12, 12, 12, 12);
    }

    public void setPanelGap(int space) {
        this.dialogLayout.setVgap(space);
    }

    public static int getStandardPanelGap() {
        return EasyDialog.getStandardPanelGap(Platform.getLAF());
    }

    protected static int getStandardPanelGap(int laf) {
        switch (laf) {
            case 502: {
                return 10;
            }
            case 503: {
                return 14;
            }
        }
        return 17;
    }

    public void setComponentSpace(int space) {
        this.componentSpace = space;
    }

    public static int getStandardComponentSpace() {
        return EasyDialog.getStandardPanelGap(Platform.getLAF());
    }

    protected static int getStandardComponentSpace(int laf) {
        return 6;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (!this.initialShowDone) {
            Point pt = this.getLocation();
            if (x != pt.x || y != pt.y) {
                this.placedManually = true;
            }
            Dimension s = this.getSize();
            if (width != s.width || height != s.height) {
                this.sizedManually = true;
            }
        }
        super.setBounds(x, y, width, height);
    }

    public void setContent(Component component) {
        this.contentPanel.add(component, "Center");
    }

    public void addPassiveComponent(Component component) {
        this.passiveComponents.add(component);
    }

    public void addCancelButton(JButton button) {
        this.addCancelButton(button, false);
    }

    public void addCancelButton(JButton button, boolean isDefault) {
        if (this.cancelButton != null) {
            this.cancelButton.removeActionListener(this.cancelButtonListener);
            this.cancelButton.removePropertyChangeListener(this.buttonTextListener);
        }
        this.cancelButton = button;
        if (this.cancelButton != null) {
            this.cancelButton.addActionListener(this.cancelButtonListener);
            this.cancelButton.addPropertyChangeListener(this.buttonTextListener);
        }
        if (isDefault) {
            this.defaultButton = button;
        }
    }

    public void addActionButton(JButton button) {
        this.addActionButton(button, false);
    }

    public void addActionButton(JButton button, boolean isDefault) {
        if (this.actionButton != null) {
            this.actionButton.removePropertyChangeListener(this.buttonTextListener);
        }
        this.actionButton = button;
        if (this.actionButton != null) {
            this.actionButton.addPropertyChangeListener(this.buttonTextListener);
        }
        if (isDefault) {
            this.defaultButton = button;
        }
    }

    public void addAlternateActionButton(JButton button) {
        this.addAlternateActionButton(button, false);
    }

    public void addAlternateActionButton(JButton button, boolean isDefault) {
        this.alternateActionButtons.add(button);
        button.addPropertyChangeListener(this.buttonTextListener);
        if (isDefault) {
            this.defaultButton = button;
        }
    }

    @Override
    public Dimension getMinimumSize() {
        this.layoutBottomPanel();
        this.assignInsets();
        return super.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        this.layoutBottomPanel();
        this.assignInsets();
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        this.layoutBottomPanel();
        this.assignInsets();
        return super.getMaximumSize();
    }

    public void setInitialFocus(Component component) {
        this.initialFocusComponent = component;
    }

    @Override
    public void show() {
        if (!this.initialShowDone) {
            this.initialShowDone = true;
            this.layoutBottomPanel();
            this.assignInsets();
            if (!this.sizedManually) {
                this.pack();
            }
            if (!this.placedManually) {
                this.setLocationRelativeTo(this.owner);
            }
        }
        this.initialFocusSet = false;
        super.show();
    }

    @Override
    public void dispose() {
        if (this.actionButton != null) {
            this.actionButton.removePropertyChangeListener(this.buttonTextListener);
        }
        if (this.cancelButton != null) {
            this.cancelButton.removePropertyChangeListener(this.buttonTextListener);
        }
        int n = this.alternateActionButtons.size();
        for (int i = 0; i < n; ++i) {
            JButton b = (JButton)this.alternateActionButtons.get(i);
            b.removePropertyChangeListener(this.buttonTextListener);
        }
        super.dispose();
    }

    public void programmaticCancel() {
        this.canceled = true;
        this.setVisible(false);
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    private void layoutBottomPanel() {
        JButton b;
        int i;
        int n = this.alternateActionButtons.size();
        for (int i2 = 0; i2 < n; ++i2) {
            JButton b2 = (JButton)this.alternateActionButtons.get(i2);
            EasyDialog.normalizeButtonWidth(b2);
        }
        if (this.cancelButton != null) {
            EasyDialog.normalizeButtonWidth(this.cancelButton);
        }
        if (this.actionButton != null) {
            EasyDialog.normalizeButtonWidth(this.actionButton);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.right = this.componentSpace;
        n = this.passiveComponents.size();
        for (i = 0; i < n; ++i) {
            Component comp = (Component)this.passiveComponents.get(i);
            this.passivePanel.add(comp, gbc);
        }
        if (this.passivePanel.getComponentCount() == 0) {
            this.passivePanel.setVisible(false);
        }
        gbc = new GridBagConstraints();
        gbc.insets.left = this.componentSpace;
        if (Platform.getLAF() == 502) {
            n = this.alternateActionButtons.size();
            for (i = 0; i < n; ++i) {
                b = (JButton)this.alternateActionButtons.get(i);
                this.dismissPanel.add((Component)b, gbc);
            }
            if (this.cancelButton != null) {
                this.dismissPanel.add((Component)this.cancelButton, gbc);
            }
            if (this.actionButton != null) {
                this.dismissPanel.add((Component)this.actionButton, gbc);
            }
        } else {
            if (this.actionButton != null) {
                this.dismissPanel.add((Component)this.actionButton, gbc);
            }
            n = this.alternateActionButtons.size();
            for (i = 0; i < n; ++i) {
                b = (JButton)this.alternateActionButtons.get(i);
                this.dismissPanel.add((Component)b, gbc);
            }
            if (this.cancelButton != null) {
                this.dismissPanel.add((Component)this.cancelButton, gbc);
            }
        }
        if (this.dismissPanel.getComponentCount() == 0) {
            this.dismissPanel.setVisible(false);
        }
        if (!this.passivePanel.isVisible() && !this.dismissPanel.isVisible()) {
            this.bottomPanel.setVisible(false);
        }
        if (this.defaultButton != null) {
            this.getRootPane().setDefaultButton(this.defaultButton);
        }
    }

    private static Frame getParentFrame(Component component) {
        return JOptionPane.getFrameForComponent(component);
    }

    private static void normalizeButtonWidth(JButton button) {
        button.setPreferredSize(null);
        Dimension s = button.getPreferredSize();
        if (s.width < 65) {
            button.setPreferredSize(new Dimension(65, s.height));
        }
    }

    public JButton makeButton(int type) {
        String text = null;
        switch (type) {
            case 0: {
                text = this.i18n.getString((PropertiesEnum)StringsProperties.EASYDIALOG_CANCELBTN);
                break;
            }
            case 1: {
                text = this.i18n.getString((PropertiesEnum)StringsProperties.EASYDIALOG_OKBTN);
                break;
            }
            case 2: {
                text = this.i18n.getString((PropertiesEnum)StringsProperties.EASYDIALOG_YESBTN);
                break;
            }
            case 3: {
                text = this.i18n.getString((PropertiesEnum)StringsProperties.EASYDIALOG_NOBTN);
                break;
            }
            case 4: {
                text = this.i18n.getString((PropertiesEnum)StringsProperties.EASYDIALOG_DONEBTN);
                break;
            }
            default: {
                return null;
            }
        }
        return this.makeButton(text);
    }

    public JButton makeButton(String text) {
        JButton b = new JButton(text);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EasyDialog.this.performDefaultCloseOperation();
            }
        });
        return b;
    }

    protected void performDefaultCloseOperation() {
        switch (this.getDefaultCloseOperation()) {
            case 1: {
                this.setVisible(false);
                break;
            }
            case 2: {
                this.setVisible(false);
                this.dispose();
                break;
            }
            case 3: {
                ExTRA.exit((int)0);
                break;
            }
        }
    }
}

