/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.swing.CMenu;
import com.elluminate.util.StringComparator;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenuItem;

public class CSortedMenu
extends CMenu
implements PropertyChangeListener {
    int topUnsorted = 0;
    private StringComparator cmp = new StringComparator(true, 1);

    private void incTopUnsorted() {
        if (this.topUnsorted + 1 < 0) {
            return;
        }
        ++this.topUnsorted;
    }

    private void decTopUnsorted() {
        if (this.topUnsorted - 1 < 0) {
            return;
        }
        --this.topUnsorted;
    }

    private boolean itemInTopUnsorted(JMenuItem item) {
        for (int i = 0; i < this.topUnsorted; ++i) {
            JMenuItem curr = super.getItem(i);
            if (curr != item) continue;
            return true;
        }
        return false;
    }

    public CSortedMenu() {
    }

    public CSortedMenu(String s) {
        super(s);
    }

    public CSortedMenu(String s, boolean b) {
        super(s, b);
    }

    @Override
    public Component add(Component c) {
        throw new RuntimeException("Unsupported operation: CSortedMenu.add(Component)");
    }

    @Override
    public Component add(Component c, int index) {
        throw new RuntimeException("Unsupported operation: CSortedMenu.add(Component, int)");
    }

    @Override
    public JMenuItem add(JMenuItem i) {
        i.addPropertyChangeListener("text", this);
        this.insertSorted(i);
        return i;
    }

    public JMenuItem addToTop(JMenuItem item) {
        this.insertNormally(item, this.topUnsorted);
        this.incTopUnsorted();
        return item;
    }

    protected JMenuItem addNormally(JMenuItem i) {
        return super.add(i);
    }

    @Override
    public void remove(JMenuItem i) {
        i.removePropertyChangeListener("text", this);
        if (this.itemInTopUnsorted(i)) {
            this.decTopUnsorted();
        }
        super.remove(i);
    }

    @Override
    public void remove(int idx) {
        throw new RuntimeException("Unsupported operation: CSortedMenu.remove(int)");
    }

    @Override
    public JMenuItem insert(JMenuItem i, int index) {
        throw new RuntimeException("Unsupported operation: CSortedMenu.insert(JMenuItem, int)");
    }

    protected JMenuItem insertNormally(JMenuItem i, int index) {
        return super.insert(i, index);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean resort = false;
        for (int i = this.topUnsorted; i < super.getItemCount() - 1; ++i) {
            JMenuItem curr = super.getItem(i);
            JMenuItem next = super.getItem(i + 1);
            if (this.cmp.compare(curr.getText(), next.getText()) <= 0) continue;
            resort = true;
            break;
        }
        if (!resort) {
            return;
        }
        JMenuItem item = (JMenuItem)e.getSource();
        super.remove(item);
        this.insertSorted(item);
    }

    protected void insertSorted(JMenuItem item) {
        int itemCount = super.getItemCount();
        for (int i = this.topUnsorted; i < itemCount; ++i) {
            JMenuItem comp = super.getItem(i);
            if (comp == null || !this.isAfter(item.getText(), comp.getText())) continue;
            this.insertNormally(item, i);
            return;
        }
        this.addNormally(item);
    }

    protected boolean isAfter(String newItem, String existingItem) {
        return this.cmp.compare(newItem, existingItem) < 0;
    }
}

