/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.platform.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.SwingUtilities;

public class CColorPicker
extends JButton {
    public static final String COLOR_PROPERTY = "color";
    private static final Color DEFAULT_COLOR = Color.GRAY;
    private Color color;
    private Dimension swatchSize;

    public CColorPicker() {
        this(DEFAULT_COLOR);
    }

    public CColorPicker(Color color) {
        this(color, new Dimension(42, 14));
    }

    public CColorPicker(Color color, Dimension swatchSize) {
        int vpad;
        this.setIcon(new Swatch());
        this.color = color;
        this.swatchSize = swatchSize;
        if (Platform.getLAF() == 502) {
            boolean leopard15;
            boolean bl = leopard15 = Platform.checkJavaVersion((String)"1.5+") && Platform.checkOSVersion((int)202, (String)"10.5+");
            if (leopard15) {
                this.putClientProperty("JButton.buttonType", "square");
                this.setMargin(new Insets(4, 4, 4, 4));
            } else {
                this.putClientProperty("JButton.buttonType", "toolbar");
            }
        }
        Dimension s = super.getPreferredSize();
        Icon ic = this.getIcon();
        int hpad = s.width - ic.getIconWidth();
        if (hpad != (vpad = s.height - ic.getIconHeight())) {
            int pad = Math.min(hpad, vpad);
            s.width = ic.getIconWidth() + pad;
            s.height = ic.getIconHeight() + pad;
        }
        this.setPreferredSize(s);
        this.setMaximumSize(s);
        this.setMinimumSize(s);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CColorPicker.this.showColorChooser();
            }
        });
    }

    public void setColor(Color color) {
        Color oldColor = this.color;
        this.color = color;
        this.repaint();
        this.firePropertyChange(COLOR_PROPERTY, oldColor, color);
    }

    public Color getColor() {
        return this.color;
    }

    protected void showColorChooser() {
        Color c = JColorChooser.showDialog(SwingUtilities.getWindowAncestor(this), null, this.color != null ? this.color : DEFAULT_COLOR);
        if (c != null) {
            this.setColor(c);
        }
    }

    private class Swatch
    implements Icon {
        private Swatch() {
        }

        @Override
        public int getIconWidth() {
            return ((CColorPicker)CColorPicker.this).swatchSize.width;
        }

        @Override
        public int getIconHeight() {
            return ((CColorPicker)CColorPicker.this).swatchSize.height;
        }

        @Override
        public void paintIcon(Component component, Graphics g, int x, int y) {
            if (CColorPicker.this.color != null) {
                g.setColor(CColorPicker.this.color);
                g.fillRect(x, y, ((CColorPicker)CColorPicker.this).swatchSize.width, ((CColorPicker)CColorPicker.this).swatchSize.height);
            }
        }
    }
}

