/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.component.RollOverBehavior;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class ButtonMetrics {
    public static final ButtonMetrics TOOLBAR;
    private int hPad = 0;
    private int vPad = 0;

    public ButtonMetrics(int h, int v) {
        this.hPad = h;
        this.vPad = v;
    }

    public ButtonMetrics(AbstractButton btn, boolean normalize) {
        this.initialize(btn, normalize);
    }

    public ButtonMetrics(Class btnClass, boolean normalize) {
        AbstractButton btn;
        if (!AbstractButton.class.isAssignableFrom(btnClass)) {
            throw new IllegalArgumentException("Not derived from AbstractButton: " + btnClass.getName());
        }
        try {
            btn = (AbstractButton)btnClass.newInstance();
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause == null) {
                cause = t;
            }
            throw new RuntimeException("Failed to instantiate: " + btnClass.getName(), cause);
        }
        this.initialize(btn, normalize);
    }

    public int getHorizontalPadding() {
        return this.hPad;
    }

    public int getVerticalPadding() {
        return this.vPad;
    }

    private void initialize(AbstractButton btn, boolean normalize) {
        btn.setText(null);
        Icon icon = btn.getIcon();
        if (icon == null) {
            icon = new DummyIcon(24, 24);
            btn.setIcon(icon);
        }
        Dimension dim = btn.getPreferredSize();
        this.hPad = dim.width - icon.getIconWidth();
        this.vPad = dim.height - icon.getIconHeight();
        if (this.hPad != this.vPad && normalize) {
            this.hPad = this.vPad = (this.hPad + this.vPad) / 2;
        }
    }

    public Dimension computePreferredSize(AbstractButton btn) {
        int textHeight;
        if (btn == null) {
            throw new NullPointerException();
        }
        Dimension dim = new Dimension(0, 0);
        Icon icon = btn.getIcon();
        String text = btn.getText();
        boolean hasText = text != null && text.length() > 0;
        FontMetrics fm = hasText ? btn.getFontMetrics(btn.getFont()) : null;
        int textWidth = fm != null ? fm.stringWidth(text) : 0;
        textWidth += fm != null ? fm.getAscent() : 0;
        int n = textHeight = fm != null ? fm.getHeight() : 0;
        if (hasText && icon != null) {
            int gap = btn.getIconTextGap();
            switch (btn.getVerticalTextPosition()) {
                case 1: 
                case 3: {
                    dim.height = icon.getIconHeight() + textHeight + gap;
                    break;
                }
                case 0: {
                    dim.height = Math.max(icon.getIconHeight(), textHeight);
                }
            }
            switch (btn.getHorizontalTextPosition()) {
                case 2: 
                case 4: 
                case 10: 
                case 11: {
                    dim.width = icon.getIconWidth() + textWidth + gap;
                    break;
                }
                case 0: {
                    dim.width = Math.max(icon.getIconWidth(), textWidth);
                }
            }
        } else if (hasText) {
            dim.width = textWidth;
            dim.height = textHeight;
        } else if (icon != null) {
            dim.width = icon.getIconWidth();
            dim.height = icon.getIconHeight();
        }
        dim.width += this.hPad;
        dim.height += this.vPad;
        return dim;
    }

    static {
        JButton btn = new JButton();
        RollOverBehavior.install(btn);
        JToolBar bar = new JToolBar();
        bar.add(btn);
        TOOLBAR = new ButtonMetrics(btn, true);
    }

    private static class DummyIcon
    implements Icon {
        private int width;
        private int height;

        private DummyIcon(int w, int h) {
            this.width = w;
            this.height = h;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }
}

