/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;

public class ToggleGroup
extends ButtonGroup {
    ArrayList buttons = new ArrayList();
    ButtonModel selection = null;

    @Override
    public void add(AbstractButton b) {
        if (b == null) {
            return;
        }
        this.buttons.add(b);
        if (b.isSelected()) {
            if (this.selection == null) {
                this.selection = b.getModel();
            } else {
                b.setSelected(false);
            }
        }
        b.getModel().setGroup(this);
    }

    @Override
    public void remove(AbstractButton b) {
        if (b == null) {
            return;
        }
        this.buttons.remove(b);
        if (b.getModel() == this.selection) {
            this.selection = null;
        }
        b.getModel().setGroup(null);
    }

    public Enumeration getElements() {
        return new Enumeration(){
            final Iterator iter;
            {
                this.iter = ToggleGroup.this.buttons.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            public Object nextElement() {
                return this.iter.next();
            }
        };
    }

    @Override
    public int getButtonCount() {
        if (this.buttons == null) {
            return 0;
        }
        return this.buttons.size();
    }

    @Override
    public ButtonModel getSelection() {
        return this.selection;
    }

    @Override
    public void setSelected(ButtonModel m, boolean b) {
        if (m == null) {
            return;
        }
        ButtonModel oldSelection = this.selection;
        if (!b && m == this.selection) {
            this.selection = null;
            if (oldSelection != null) {
                oldSelection.setSelected(false);
            }
            m.setSelected(false);
        } else if (b && m != this.selection) {
            this.selection = m;
            if (oldSelection != null) {
                oldSelection.setSelected(false);
            }
            m.setSelected(true);
        }
    }

    @Override
    public boolean isSelected(ButtonModel m) {
        return m == this.selection;
    }

    public void deselectAll() {
        for (AbstractButton btn : this.buttons) {
            if (!btn.isSelected()) continue;
            btn.setSelected(false);
        }
    }
}

