/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui;

import com.elluminate.gui.GUIDebug;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class ThreadCheckingRepaintManager
extends RepaintManager {
    private int tabCount = 0;

    public static void install() {
        RepaintManager.setCurrentManager(new ThreadCheckingRepaintManager());
    }

    @Override
    public synchronized void addInvalidComponent(JComponent jComponent) {
        this.checkThread(jComponent);
        super.addInvalidComponent(jComponent);
    }

    private void checkThread(JComponent c) {
        if (!SwingUtilities.isEventDispatchThread() && this.checkIsShowing(c)) {
            LogSupport.message((String)"----------Wrong Thread START");
            LogSupport.message((String)Debug.getStackTrace((Throwable)new Exception()));
            this.dumpComponentTree(c);
            LogSupport.message((String)"----------Wrong Thread END");
            LogSupport.message((String)"");
        }
    }

    private boolean checkIsShowing(JComponent c) {
        if (GUIDebug.REPAINT_SHOW.show()) {
            return true;
        }
        return c.isShowing();
    }

    @Override
    public synchronized void addDirtyRegion(JComponent jComponent, int i, int i1, int i2, int i3) {
        if (GUIDebug.REPAINT_THREAD.show()) {
            this.checkThread(jComponent);
        }
        super.addDirtyRegion(jComponent, i, i1, i2, i3);
    }

    private void dumpComponentTree(Component c) {
        LogSupport.message((String)"----------Component Tree");
        this.resetTabCount();
        while (c != null) {
            LogSupport.message((String)(this.getTabIndent() + c));
            LogSupport.message((String)(this.getTabIndent() + "Showing:" + c.isShowing() + " Visible: " + c.isVisible()));
            this.incrementTabCount();
            c = c.getParent();
        }
    }

    private void resetTabCount() {
        this.tabCount = 0;
    }

    private void incrementTabCount() {
        ++this.tabCount;
    }

    private String getTabIndent() {
        StringBuffer buf = new StringBuffer(this.tabCount);
        for (int i = 0; i < this.tabCount; ++i) {
            buf.append("\t");
        }
        return buf.toString();
    }
}

