/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui;

import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.Mnemonic;
import com.elluminate.platform.Platform;
import java.awt.Component;
import java.awt.Label;
import java.awt.TextComponent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleSelection;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;

public class AccessibilityUtils {
    private static final String NAME_FOR_HELPER_PROP = "com.elluminate.AccessibilityUtils.nameForHelper";
    private static final boolean OSX_VOICE_OVER = Platform.checkOSVersion((int)202, (String)"10.4+");
    protected static final Class[] _sType = new Class[]{String.class};
    protected static final Class[] _iType = new Class[]{Integer.TYPE};

    public static void setComponentHelperInfo(JComponent item, String text) {
        if (OSX_VOICE_OVER) {
            item.putClientProperty(NAME_FOR_HELPER_PROP, text);
        }
    }

    public static void copyAccessibleInfo(Accessible src, Accessible[] dest) {
        if (src == null || dest == null || src.getAccessibleContext() == null) {
            return;
        }
        AccessibleContext ctx = src.getAccessibleContext();
        for (int i = 0; i < dest.length; ++i) {
            dest[i].getAccessibleContext().setAccessibleName(ctx.getAccessibleName());
            dest[i].getAccessibleContext().setAccessibleDescription(ctx.getAccessibleDescription());
        }
    }

    public static void copyAccessibleInfo(Accessible src, Accessible dest) {
        AccessibilityUtils.copyAccessibleInfo(src, new Accessible[]{dest});
    }

    public static void initComponent(JComponent item) {
        if (OSX_VOICE_OVER && !(item instanceof JSeparator) && !(item instanceof JMenuItem)) {
            AccessibleContext ac = item.getAccessibleContext();
            String axInfo = ac.getAccessibleName();
            if (axInfo == null || "".equals(axInfo)) {
                Icon icon;
                Component lbl;
                Object prop = item.getClientProperty(NAME_FOR_HELPER_PROP);
                if (prop != null) {
                    axInfo = prop.toString();
                }
                if ((axInfo == null || "".equals(axInfo)) && (lbl = GuiUtils.getLabelOf(item)) != null) {
                    axInfo = lbl instanceof JLabel ? ((JLabel)lbl).getText() : (lbl instanceof JTextComponent ? ((JTextComponent)lbl).getText() : (lbl instanceof Label ? ((Label)lbl).getText() : (lbl instanceof TextComponent ? ((TextComponent)lbl).getText() : lbl.getName())));
                }
                if ((axInfo == null || "".equals(axInfo)) && item instanceof AbstractButton) {
                    axInfo = ((AbstractButton)item).getText();
                }
                if (axInfo == null || "".equals(axInfo)) {
                    axInfo = item.getToolTipText();
                }
                if ((axInfo == null || "".equals(axInfo)) && item instanceof AbstractButton && (icon = ((AbstractButton)item).getIcon()) != null && icon instanceof ImageIcon) {
                    axInfo = ((ImageIcon)icon).getDescription();
                }
                if (axInfo != null && !"".equals(axInfo)) {
                    ac.setAccessibleName(axInfo);
                }
            }
            if (((axInfo = ac.getAccessibleDescription()) == null || "".equals(axInfo)) && (axInfo = item.getToolTipText()) != null && !"".equals(axInfo)) {
                ac.setAccessibleDescription(axInfo);
            }
        }
    }

    public static String getComponentInfo(JComponent item) {
        AccessibleSelection as;
        StringBuffer result = new StringBuffer(1024);
        AccessibleContext ac = item.getAccessibleContext();
        result.append("name=" + ac.getAccessibleName());
        result.append(",role=" + ac.getAccessibleRole());
        result.append(",help='" + ac.getAccessibleDescription() + "'");
        AccessibleIcon[] ai = ac.getAccessibleIcon();
        if (ai != null && ai.length > 0) {
            result.append(",icon=[");
            for (int ix = 0; ix < ai.length; ++ix) {
                if (ix > 0) {
                    result.append(',');
                }
                if (ai[ix] == null) {
                    result.append(ai[ix]);
                    continue;
                }
                result.append(ai[ix].getAccessibleIconWidth() + "x" + ai[ix].getAccessibleIconHeight() + ":" + ai[ix].getAccessibleIconDescription());
            }
        }
        if ((as = ac.getAccessibleSelection()) != null) {
            int nSel = as.getAccessibleSelectionCount();
            result.append(",selected=" + nSel + "/" + ac.getAccessibleChildrenCount());
            if (nSel > 0) {
                result.append('[');
                for (int ix = 0; ix < nSel; ++ix) {
                    try {
                        if (ix > 0) {
                            result.append(",");
                        }
                        result.append(as.getAccessibleSelection(ix).getAccessibleContext().getAccessibleName());
                        continue;
                    }
                    catch (Throwable t) {
                        System.err.println("Exception processing selected child " + ix + " of " + item);
                        t.printStackTrace();
                    }
                }
                result.append(']');
            }
        }
        return result.toString();
    }

    public static void setAccessibleInfo(Object accessibleObj, String accessibleName, String accessibleDescription) {
        AccessibilityUtils.setAccessibleInfo(new Object[]{accessibleObj}, accessibleName, accessibleDescription);
    }

    public static void setAccessibleName(Object accessibleObj, String accessibleName) {
        AccessibilityUtils.setAccessibleName(new Object[]{accessibleObj}, accessibleName);
    }

    public static void setAccessibleDescription(Object accessibleObj, String accessibleDescription) {
        AccessibilityUtils.setAccessibleDescription(new Object[]{accessibleObj}, accessibleDescription);
    }

    public static void setAccessibleInfo(Object[] accessibleObj, String accessibleName, String accessibleDescription) {
        AccessibilityUtils.setAccessibleName(accessibleObj, accessibleName);
        AccessibilityUtils.setAccessibleDescription(accessibleObj, accessibleDescription);
    }

    public static void setAccessibleName(Object[] accessibleObj, String accessibleName) {
        if (accessibleObj != null && accessibleObj.length > 0) {
            for (int i = 0; i < accessibleObj.length; ++i) {
                if (accessibleObj[i] == null || !(accessibleObj[i] instanceof Accessible)) continue;
                accessibleName = Mnemonic.getText(accessibleName);
                AccessibleContext ctx = ((Accessible)accessibleObj[i]).getAccessibleContext();
                ctx.setAccessibleName(accessibleName);
            }
        }
    }

    public static void setAccessibleDescription(Object[] accessibleObj, String accessibleDescription) {
        if (accessibleObj != null && accessibleObj.length > 0) {
            for (int i = 0; i < accessibleObj.length; ++i) {
                if (accessibleObj[i] == null || !(accessibleObj[i] instanceof Accessible)) continue;
                AccessibleContext ctx = ((Accessible)accessibleObj[i]).getAccessibleContext();
                ctx.setAccessibleDescription(accessibleDescription);
            }
        }
    }

    public static Method resolveMethod(Class c, String name, Class[] argSigs) {
        Method result = null;
        try {
            result = c.getMethod(name, argSigs);
        }
        catch (NoSuchMethodException nsme) {
            // empty catch block
        }
        return result;
    }

    public static Method resolveMethod(Class c, String name) {
        return AccessibilityUtils.resolveMethod(c, name, null);
    }

    public static Method resolveMethod(Object o, String name, Class[] argSigs) {
        return AccessibilityUtils.resolveMethod(o.getClass(), name, argSigs);
    }

    public static Method resolveMethod(Object o, String name) {
        return AccessibilityUtils.resolveMethod(o.getClass(), name, null);
    }

    public static Object invokeMethod(Object o, Method method, Object[] args) throws Exception {
        return method.invoke(o, args);
    }

    public static Object invokeMethod(Object o, Method method) throws Exception {
        return AccessibilityUtils.invokeMethod(o, method, null);
    }

    public static void setAccessibleValues(Accessible accessibleObject, AccessibleValues values) {
        AccessibleContext ac;
        Method m;
        if (values.name != null) {
            if (accessibleObject instanceof Component) {
                ((Component)((Object)accessibleObject)).setName(values.name);
            }
        } else {
            throw new NullPointerException("accessible components require a name");
        }
        if (values.text != null) {
            m = AccessibilityUtils.resolveMethod(accessibleObject, "setText", _sType);
            if (m != null) {
                try {
                    AccessibilityUtils.invokeMethod(accessibleObject, m, new String[]{values.text});
                }
                catch (Exception e) {
                    throw new AccessibleException("cannot invoke method setText(String text) - " + accessibleObject, e);
                }
            } else {
                throw new AccessibleException("cannot find method setText(String text) - " + accessibleObject);
            }
        }
        if (values.borderText != null) {
            JComponent c = (JComponent)((Object)accessibleObject);
            Border b = c.getBorder();
            TitledBorder tb = new TitledBorder(values.borderText);
            c.setBorder(b != null ? new CompoundBorder(b, tb) : tb);
        }
        if (values.toolTip != null) {
            String text;
            String string = text = values.toolTip.equalsIgnoreCase("=ld") ? values.longDescription : values.toolTip;
            if (accessibleObject instanceof JComponent && !(accessibleObject instanceof JMenuItem)) {
                ((JComponent)((Object)accessibleObject)).setToolTipText(text);
            } else if (accessibleObject instanceof ImageIcon) {
                ((ImageIcon)accessibleObject).setDescription(text);
            }
        }
        if (values.mnemonic >= 0) {
            m = AccessibilityUtils.resolveMethod(accessibleObject, "setMnemonic", _iType);
            if (m == null) {
                m = AccessibilityUtils.resolveMethod(accessibleObject, "setDisplayedMnemonic", _iType);
            }
            if (m != null) {
                try {
                    AccessibilityUtils.invokeMethod(accessibleObject, m, new Integer[]{new Integer(values.mnemonic)});
                }
                catch (Exception e) {
                    throw new AccessibleException("cannot invoke method set{Displayed}Mnemonic(int key) - " + accessibleObject, e);
                }
            } else {
                throw new AccessibleException("cannot find method set{Displayed}Mnemonic(int key) - " + accessibleObject);
            }
        }
        if (values.shortDescription == null) {
            throw new NullPointerException("accessible components require a shortDescription");
        }
        if (values.shortDescription.equalsIgnoreCase("=tt")) {
            values.shortDescription = values.toolTip;
        }
        if (values.shortDescription.equalsIgnoreCase("=ld")) {
            values.shortDescription = values.longDescription;
        }
        if (values.shortDescription.length() == 0) {
            values.shortDescription = null;
        }
        if (values.shortDescription != null && accessibleObject instanceof ImageIcon) {
            ((ImageIcon)accessibleObject).setDescription(values.shortDescription);
        }
        if ((ac = accessibleObject.getAccessibleContext()) == null) {
            throw new NullPointerException("AccessibleContext cannot be null on an Accessible object " + AccessibilityUtils.formatClassToken(accessibleObject));
        }
        if (values.shortDescription != null) {
            ac.setAccessibleName(values.shortDescription);
        }
        if (values.longDescription != null) {
            ac.setAccessibleDescription(values.longDescription.equalsIgnoreCase("=tt") ? values.toolTip : values.longDescription);
        }
    }

    public static Accessible setLabelRelationship(Accessible label, Accessible target) {
        if (label instanceof JLabel) {
            ((JLabel)label).setLabelFor((Component)((Object)target));
            AccessibleContext ac2 = target.getAccessibleContext();
            if (ac2 == null) {
                throw new NullPointerException("AccessibleContext cannot be null on an Accessible object " + AccessibilityUtils.formatClassToken(target));
            }
            AccessibleRelationSet ars2 = ac2.getAccessibleRelationSet();
            AccessibleRelation ar2 = new AccessibleRelation(AccessibleRelation.LABELED_BY, label);
            ars2.add(ar2);
        }
        return label;
    }

    public static Accessible setMemberRelationship(Accessible group, Accessible member) {
        return AccessibilityUtils.setMemberRelationship(group, new Accessible[]{member});
    }

    public static Accessible setMemberRelationship(Accessible group, Accessible[] members) {
        return AccessibilityUtils.setMemberRelationship(group, Arrays.asList(members));
    }

    public static Accessible setMemberRelationship(Accessible group, Collection members) {
        for (Accessible a : members) {
            AccessibleContext ac = a.getAccessibleContext();
            if (ac == null) {
                throw new NullPointerException("AccessibleContext cannot be null on an Accessible object " + AccessibilityUtils.formatClassToken(a));
            }
            AccessibleRelationSet ars = ac.getAccessibleRelationSet();
            AccessibleRelation ar = new AccessibleRelation(AccessibleRelation.MEMBER_OF, group);
            ars.add(ar);
        }
        return group;
    }

    public static String formatClassToken(Object o) {
        if (o == null) {
            return "null";
        }
        String name = o instanceof Component ? ((Component)o).getName() : "?";
        return o.getClass().getName() + ":" + Integer.toHexString(o.hashCode()).toUpperCase() + "-" + name;
    }

    public static class AccessibleException
    extends RuntimeException {
        Exception _exception;

        public Exception getWrappedException() {
            return this._exception;
        }

        public AccessibleException() {
        }

        public AccessibleException(String message) {
            super(message);
        }

        public AccessibleException(String message, Exception e) {
            super(message);
            this._exception = e;
        }

        @Override
        public String toString() {
            return this.getClass().getName() + ": " + this.getMessage() + "; " + this._exception;
        }
    }

    public static class AccessibleValues {
        private String name;
        private String shortDescription;
        private String longDescription;
        private String toolTip;
        private String text;
        private String borderText;
        private int mnemonic;

        public AccessibleValues(String name, String text, String shortDesc, String longDesc, String toolTip, int mnemonic, String borderText) {
            this.name = name;
            this.text = text;
            this.shortDescription = shortDesc;
            this.longDescription = longDesc;
            this.toolTip = toolTip;
            this.mnemonic = mnemonic;
            this.borderText = borderText;
        }

        public AccessibleValues(String name, String text, String shortDesc, String longDesc, String toolTip, int mnemonic) {
            this(name, text, shortDesc, longDesc, toolTip, mnemonic, null);
        }

        public AccessibleValues(String name, String text, String shortDesc, String longDesc, String toolTip) {
            this(name, text, shortDesc, longDesc, toolTip, -1);
        }

        public AccessibleValues(String name, String text, String shortDesc, String longDesc, int mnemonic) {
            this(name, text, shortDesc, longDesc, null, mnemonic);
        }

        public AccessibleValues(String name, String text, String shortDesc, String longDesc) {
            this(name, text, shortDesc, longDesc, null, -1);
        }

        public AccessibleValues(String name, String text, String shortDesc) {
            this(name, text, shortDesc, null);
        }

        public String toString() {
            return this.getClass().getName() + '[' + "name=" + this.name + ",text=" + this.text + ",short=" + this.shortDescription + ",long=" + this.longDescription + ",toolTip=" + this.toolTip + ",mnemonic=" + this.mnemonic + ",borderText=" + this.borderText + ']';
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getShortDescription() {
            return this.shortDescription;
        }

        public void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        public String getLongDescription() {
            return this.longDescription;
        }

        public void setLongDescription(String longDescription) {
            this.longDescription = longDescription;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public void setToolTip(String toolTip) {
            this.toolTip = toolTip;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getBorderText() {
            return this.borderText;
        }

        public void setBorderText(String borderText) {
            this.borderText = borderText;
        }

        public int getMnemonic() {
            return this.mnemonic;
        }

        public void setMnemonic(int mnemonic) {
            this.mnemonic = mnemonic;
        }
    }
}

