/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.recorder;

import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.util.DebugFlag;
import java.io.DataInputStream;

public class RecorderProtocol
extends JinxProtocolAdapter {
    public static final String ENABLED_PROPERTY = "recorder.enabled";
    public static final String FORCED_PROPERTY = "recorder.forced";
    public static final DebugFlag DEBUG = DebugFlag.get((String)"recorder");
    public static final DebugFlag INDEX = DebugFlag.get((String)"recorder.index");
    public static final DebugFlag VCR_FILE = DebugFlag.get((String)"recorder.vcrfile");
    public static final DebugFlag WATCHDOG = DebugFlag.get((String)"recorder.watchdog");
    public static final DebugFlag WATCHDOG_STATUS = DebugFlag.get((String)"recorder.watchdogStatus");
    public static final String CHANNEL = "recorder";
    public static final byte PRIORITY = 2;
    public static final byte CLEAR_RECORDING = 1;
    public static final byte CLEAR_ERROR = 2;
    public static final byte ADD_INDEX = 3;

    public RecorderProtocol() {
        this(false, false);
    }

    public RecorderProtocol(boolean force, boolean enabled) {
        this.defineChannel(CHANNEL, (byte)2);
        this.defineProperty(ENABLED_PROPERTY, (byte)1, enabled ? Boolean.TRUE : Boolean.FALSE);
        this.defineProperty(FORCED_PROPERTY, (byte)1, force ? Boolean.TRUE : Boolean.FALSE);
    }

    public String commandToString(byte cmd) {
        switch (cmd) {
            case 1: {
                return "ClearRecording#" + cmd;
            }
            case 2: {
                return "ClearError#" + cmd;
            }
            case 3: {
                return "AddIndex#" + cmd;
            }
        }
        return super.commandToString(cmd);
    }

    public String messageToString(byte cmd, DataInputStream strm) {
        if (cmd == 3) {
            String text = null;
            try {
                text = strm.readUTF();
            }
            catch (Throwable t) {
                text = "N/A (" + t + ")";
            }
            return "cmd=" + this.commandToString(cmd) + ", text=" + text;
        }
        return super.messageToString(cmd, strm);
    }
}

