/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.activity.module;

import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.groupware.activity.module.StringsProperties;
import com.elluminate.groupware.activity.module.model.ActivityDisplayStateModel;
import com.elluminate.groupware.activity.module.model.ActivityTypeConfig;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.Mnemonic;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.InvalidPreferenceSettingException;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.swing.CTable;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

@Singleton
public class MessageFilterPrefsPanel
extends AbstractPreferencesPanel {
    private CTable table;
    private DefaultTableModel tableModel;
    private ActivityDisplayStateModel uiModel;
    private static I18n i18n = I18n.create(MessageFilterPrefsPanel.class);
    private final String NONE = i18n.getString((PropertiesEnum)StringsProperties.MESSAGEFILTERPREFS_UNCHANGED);
    private final String ALWAYS = i18n.getString((PropertiesEnum)StringsProperties.MESSAGEFILTERPREFS_ALWAYS);
    private final String NEVER = i18n.getString((PropertiesEnum)StringsProperties.MESSAGEFILTERPREFS_NEVER);

    @Inject
    public MessageFilterPrefsPanel(PreferencesPanelOwner owner) {
        super(owner, i18n.getString((PropertiesEnum)StringsProperties.MESSAGEFILTERPREFS_TITLE));
    }

    @Inject
    public void initActivityDisplayStateModel(ActivityDisplayStateModel model) {
        this.uiModel = model;
    }

    protected void createContent() {
        this.setLayout(new BorderLayout(0, 6));
        MultilineLabel tableLabel = new MultilineLabel(i18n.getString((PropertiesEnum)StringsProperties.MESSAGEFILTERPREFS_EXPLANATION));
        tableLabel.setLabelFor((Component)tableLabel);
        this.add((Component)tableLabel, "North");
        DefaultTableColumnModel cm = new DefaultTableColumnModel();
        TableColumn col = new TableColumn(0);
        col.setHeaderValue(i18n.getString((PropertiesEnum)StringsProperties.MESSAGEFILTERPREFS_EVENTCOLUMN));
        cm.addColumn(col);
        col = new TableColumn(1);
        col.setHeaderValue(i18n.getString((PropertiesEnum)StringsProperties.MESSAGEFILTERPREFS_DISPLAYCOLUMN));
        col.setMinWidth(130);
        col.setMaxWidth(200);
        JComboBox<String> cb = new JComboBox<String>();
        cb.putClientProperty("JComponent.sizeVariant", "small");
        cb.addItem(this.NONE);
        cb.addItem(this.ALWAYS);
        cb.addItem(this.NEVER);
        cb.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent e) {
                e.getComponent().requestFocusInWindow();
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent e) {
            }
        });
        cb.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                MessageFilterPrefsPanel.this.table.requestFocusInWindow();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }
        });
        col.setCellEditor(new DefaultCellEditor(cb));
        cm.addColumn(col);
        this.tableModel = new DefaultTableModel(0, 2){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1 && this.getValueAt(row, column) != null;
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                if (value != this.getValueAt(row, column)) {
                    super.setValueAt(value, row, column);
                    MessageFilterPrefsPanel.this.setModified(true);
                }
            }
        };
        this.table = new CTable(this.tableModel, cm){

            public void updateUI() {
                super.updateUI();
                GuiUtils.removeKeyBinding((KeyStroke)KeyStroke.getKeyStroke(32, 0), (JComponent)((Object)this));
            }
        };
        this.table.setPreferredScrollableViewportSize(new Dimension(1, 300));
        CellRenderer r = new CellRenderer();
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)r);
        this.table.setRowHeight(r.getPreferredHeight());
        JScrollPane sp = new JScrollPane((Component)this.table, 22, 31);
        this.add(sp);
    }

    protected void populate(Preferences preferences) {
        this.tableModel.setRowCount(0);
        String prefix = this.getOwnerPrefix();
        List<String> incs = ActivityTypeConfig.getIncludedMessages(prefix, preferences);
        List<String> excs = ActivityTypeConfig.getExcludedMessages(prefix, preferences);
        List<MessagePublisherMetadata> pubs = this.uiModel.getAllPublishers();
        MessagePublisherMetadata[] sortedPubs = pubs.toArray(new MessagePublisherMetadata[0]);
        Arrays.sort(sortedPubs, new Comparator<MessagePublisherMetadata>(){

            @Override
            public int compare(MessagePublisherMetadata pub1, MessagePublisherMetadata pub2) {
                String name1 = pub1.getModuleDisplayName().replaceAll("&", "");
                String name2 = pub2.getModuleDisplayName().replaceAll("&", "");
                return name1.compareTo(name2);
            }

            @Override
            public boolean equals(Object object) {
                return object == this;
            }
        });
        for (MessagePublisherMetadata pub : sortedPubs) {
            this.tableModel.addRow(new Object[]{pub, null});
            ArrayList types = new ArrayList(pub.getMessageTypes());
            MessageType[] sortedTypes = types.toArray(new MessageType[0]);
            Arrays.sort(sortedTypes, new Comparator<MessageType>(){

                @Override
                public int compare(MessageType type1, MessageType type2) {
                    return type1.getDisplayName().compareTo(type2.getDisplayName());
                }

                @Override
                public boolean equals(Object object) {
                    return object == this;
                }
            });
            for (MessageType type : sortedTypes) {
                String state = this.NONE;
                String name = type.getUniqueName();
                if (incs.contains(name)) {
                    state = this.ALWAYS;
                } else if (excs.contains(name)) {
                    state = this.NEVER;
                }
                this.tableModel.addRow(new Object[]{type, state});
            }
        }
    }

    protected void apply(Preferences preferences) throws InvalidPreferenceSettingException {
        ArrayList<String> incs = new ArrayList<String>();
        ArrayList<String> excs = new ArrayList<String>();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Object val = this.tableModel.getValueAt(i, 0);
            if (!(val instanceof MessageType)) continue;
            MessageType type = (MessageType)val;
            String state = (String)this.tableModel.getValueAt(i, 1);
            if (state == this.ALWAYS) {
                incs.add(type.getUniqueName());
                continue;
            }
            if (state != this.NEVER) continue;
            excs.add(type.getUniqueName());
        }
        String prefix = this.getOwnerPrefix();
        ActivityTypeConfig.setIncludedMessages(prefix, preferences, incs);
        ActivityTypeConfig.setExcludedMessages(prefix, preferences, excs);
    }

    protected void reset(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        ActivityTypeConfig.setIncludedMessages(prefix, preferences, null);
        ActivityTypeConfig.setExcludedMessages(prefix, preferences, null);
    }

    private static class CellRenderer
    implements TableCellRenderer {
        private final ThreadLocal<EventRenderer> eventRendererStore = new ThreadLocal<EventRenderer>(){

            @Override
            protected synchronized EventRenderer initialValue() {
                return new EventRenderer();
            }
        };
        private final ThreadLocal<DisplayRenderer> displayRendererStore = new ThreadLocal<DisplayRenderer>(){

            @Override
            protected synchronized DisplayRenderer initialValue() {
                return new DisplayRenderer();
            }
        };

        private CellRenderer() {
        }

        public int getPreferredHeight() {
            DisplayRenderer displayRenderer = this.displayRendererStore.get();
            int h = displayRenderer.getPreferredSize().height;
            if (Platform.getLAF() == 502) {
                h -= 6;
            }
            return h;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            if (value instanceof String) {
                DisplayRenderer displayRenderer = this.displayRendererStore.get();
                return displayRenderer.getTableCellRendererComponent(table, value, selected, focused, row, column);
            }
            EventRenderer eventRenderer = this.eventRendererStore.get();
            return eventRenderer.getTableCellRendererComponent(table, value, selected, focused, row, column);
        }
    }

    private static class DisplayRenderer
    extends JComboBox
    implements TableCellRenderer {
        private Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        public DisplayRenderer() {
            this.setBorder(this.noFocusBorder);
            this.putClientProperty("JComponent.sizeVariant", "small");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            Border b = null;
            if (focused) {
                if (selected) {
                    b = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (b == null) {
                    b = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
            }
            if (b == null) {
                b = this.noFocusBorder;
            }
            this.setBorder(b);
            this.removeAllItems();
            if (value != null) {
                this.addItem(value);
            }
            this.getAccessibleContext().setAccessibleName(String.valueOf(value));
            return this;
        }
    }

    private static class EventRenderer
    extends DefaultTableCellRenderer {
        private EventRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            this.setIcon(null);
            if (value == null || value instanceof MessagePublisherMetadata) {
                MessagePublisherMetadata pub = (MessagePublisherMetadata)value;
                if (pub != null) {
                    this.setText(pub.getModuleDisplayName());
                    this.setIcon(pub.getPublisherIcon());
                }
                this.setBackground(UIManager.getColor("Panel.background"));
                this.setForeground(UIManager.getColor("Panel.foreground"));
            } else if (value instanceof MessageType) {
                this.setText(((MessageType)value).getDisplayName());
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }

        @Override
        public void setText(String text) {
            super.setText(Mnemonic.getText((String)text));
            Mnemonic.setMnemonic((JLabel)this, (String)text);
        }

        @Override
        public void setDisplayedMnemonic(int mnemonic) {
            if (Platform.getPlatform() != 2) {
                super.setDisplayedMnemonic(mnemonic);
            }
        }

        @Override
        public void setDisplayedMnemonic(char mnemonic) {
            int vk = mnemonic;
            if (vk >= 97 && vk <= 122) {
                vk -= 32;
            }
            this.setDisplayedMnemonic(vk);
        }
    }
}

