/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.activity.module;

import com.elluminate.classroom.client.messaging.MessagePublisher;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.activity.module.StringsProperties;
import com.elluminate.groupware.imps.SessionTimeAPI;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

@Singleton
public class ActivityPublisher {
    private final String UNIQUE_NAME = "ActivityPublisher";
    private final String DISPLAY_NAME;
    private final Icon icon;
    public static final String COMMAND_ERROR = "command-error";
    private final MessagePublisher publisher;
    private final MessagePublisherMetadata metadata;
    private final I18n i18n;
    private final MessageRouter router;
    private String modName;
    private String modDisplayName;
    private Imps impls;
    private SessionTimeAPI sessionTime;
    private Map<String, MessageType> msgTypes = new HashMap<String, MessageType>();

    @Inject
    public ActivityPublisher(MessagePublisher pub, MessagePublisherMetadata meta, MessageRouter rtr, I18n localization, ModulePublisherInfo mod) {
        this.publisher = pub;
        this.metadata = meta;
        this.router = rtr;
        this.i18n = localization;
        this.DISPLAY_NAME = this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYPUBLISHER_DISPLAYNAME);
        this.icon = mod.getModuleIcon();
        this.modName = mod.getNameOfModule();
        this.modDisplayName = mod.getDisplayNameOfModule();
        this.initializePublisher();
    }

    @Inject
    public void initImpls(Imps i) {
        this.impls = i;
        this.sessionTime = (SessionTimeAPI)this.impls.findBest(SessionTimeAPI.class);
    }

    public void sendCommandErrorMessage(String message) {
        this.sendRouterMsg(message, this.msgTypes.get(COMMAND_ERROR));
    }

    private void sendRouterMsg(String message, MessageType type, boolean isMe) {
        this.publisher.sendTextMessage(message, type, this.sessionTime.getSessionTime(), isMe);
    }

    private void sendRouterMsg(String message, MessageType type) {
        this.sendRouterMsg(message, type, false);
    }

    private void initializePublisher() {
        this.initMessageTypes();
        this.setMetadata();
        this.publisher.setPublisherMetadata(this.metadata);
        this.router.registerPublisher(this.publisher);
    }

    private void setMetadata() {
        this.metadata.setPublisherDisplayName(this.DISPLAY_NAME);
        this.metadata.setPublisherUniqueName("ActivityPublisher");
        this.metadata.setPublisherIcon(this.icon);
        this.metadata.setModuleName(this.modName);
        this.metadata.setModuleDisplayName(this.modDisplayName);
        this.metadata.setPublisherSupportedMessageTypes(new ArrayList<MessageType>(this.msgTypes.values()));
    }

    private void initMessageTypes() {
        this.msgTypes.put(COMMAND_ERROR, new MessageType(COMMAND_ERROR, this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYPUBLISHER_TYPE_COMMANDERROR), 8));
    }
}

